from twilio.base import deserialize as deserialize, serialize as serialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from typing import Any, Optional

class SupportingDocumentList(ListResource):
    def __init__(self, version: Any) -> None: ...
    def create(self, friendly_name: Any, type: Any, attributes: Any = ...): ...
    def stream(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class SupportingDocumentPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class SupportingDocumentContext(InstanceContext):
    def __init__(self, version: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def update(self, friendly_name: Any = ..., attributes: Any = ...): ...
    def delete(self): ...

class SupportingDocumentInstance(InstanceResource):
    class Status:
        DRAFT: str = ...
        PENDING_REVIEW: str = ...
        REJECTED: str = ...
        APPROVED: str = ...
        EXPIRED: str = ...
        PROVISIONALLY_APPROVED: str = ...
    def __init__(self, version: Any, payload: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def sid(self): ...
    @property
    def account_sid(self): ...
    @property
    def friendly_name(self): ...
    @property
    def mime_type(self): ...
    @property
    def status(self): ...
    @property
    def type(self): ...
    @property
    def attributes(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def url(self): ...
    def fetch(self): ...
    def update(self, friendly_name: Any = ..., attributes: Any = ...): ...
    def delete(self): ...
