from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.notify.v1.service.binding import BindingList as BindingList
from twilio.rest.notify.v1.service.notification import NotificationList as NotificationList
from typing import Any, Optional

class ServiceList(ListResource):
    def __init__(self, version: Any) -> None: ...
    def create(self, friendly_name: Any = ..., apn_credential_sid: Any = ..., gcm_credential_sid: Any = ..., messaging_service_sid: Any = ..., facebook_messenger_page_id: Any = ..., default_apn_notification_protocol_version: Any = ..., default_gcm_notification_protocol_version: Any = ..., fcm_credential_sid: Any = ..., default_fcm_notification_protocol_version: Any = ..., log_enabled: Any = ..., alexa_skill_id: Any = ..., default_alexa_notification_protocol_version: Any = ..., delivery_callback_url: Any = ..., delivery_callback_enabled: Any = ...): ...
    def stream(self, friendly_name: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, friendly_name: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, friendly_name: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class ServicePage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class ServiceContext(InstanceContext):
    def __init__(self, version: Any, sid: Any) -> None: ...
    def delete(self): ...
    def fetch(self): ...
    def update(self, friendly_name: Any = ..., apn_credential_sid: Any = ..., gcm_credential_sid: Any = ..., messaging_service_sid: Any = ..., facebook_messenger_page_id: Any = ..., default_apn_notification_protocol_version: Any = ..., default_gcm_notification_protocol_version: Any = ..., fcm_credential_sid: Any = ..., default_fcm_notification_protocol_version: Any = ..., log_enabled: Any = ..., alexa_skill_id: Any = ..., default_alexa_notification_protocol_version: Any = ..., delivery_callback_url: Any = ..., delivery_callback_enabled: Any = ...): ...
    @property
    def bindings(self): ...
    @property
    def notifications(self): ...

class ServiceInstance(InstanceResource):
    def __init__(self, version: Any, payload: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def sid(self): ...
    @property
    def account_sid(self): ...
    @property
    def friendly_name(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def apn_credential_sid(self): ...
    @property
    def gcm_credential_sid(self): ...
    @property
    def fcm_credential_sid(self): ...
    @property
    def messaging_service_sid(self): ...
    @property
    def facebook_messenger_page_id(self): ...
    @property
    def default_apn_notification_protocol_version(self): ...
    @property
    def default_gcm_notification_protocol_version(self): ...
    @property
    def default_fcm_notification_protocol_version(self): ...
    @property
    def log_enabled(self): ...
    @property
    def url(self): ...
    @property
    def links(self): ...
    @property
    def alexa_skill_id(self): ...
    @property
    def default_alexa_notification_protocol_version(self): ...
    @property
    def delivery_callback_url(self): ...
    @property
    def delivery_callback_enabled(self): ...
    def delete(self): ...
    def fetch(self): ...
    def update(self, friendly_name: Any = ..., apn_credential_sid: Any = ..., gcm_credential_sid: Any = ..., messaging_service_sid: Any = ..., facebook_messenger_page_id: Any = ..., default_apn_notification_protocol_version: Any = ..., default_gcm_notification_protocol_version: Any = ..., fcm_credential_sid: Any = ..., default_fcm_notification_protocol_version: Any = ..., log_enabled: Any = ..., alexa_skill_id: Any = ..., default_alexa_notification_protocol_version: Any = ..., delivery_callback_url: Any = ..., delivery_callback_enabled: Any = ...): ...
    @property
    def bindings(self): ...
    @property
    def notifications(self): ...
