from twilio.base import deserialize as deserialize, serialize as serialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from typing import Any, Optional

class MemberList(ListResource):
    def __init__(self, version: Any, service_sid: Any, channel_sid: Any) -> None: ...
    def create(self, identity: Any, role_sid: Any = ..., last_consumed_message_index: Any = ..., last_consumption_timestamp: Any = ..., date_created: Any = ..., date_updated: Any = ..., attributes: Any = ..., x_twilio_webhook_enabled: Any = ...): ...
    def stream(self, identity: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, identity: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, identity: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class MemberPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class MemberContext(InstanceContext):
    def __init__(self, version: Any, service_sid: Any, channel_sid: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def delete(self, x_twilio_webhook_enabled: Any = ...): ...
    def update(self, role_sid: Any = ..., last_consumed_message_index: Any = ..., last_consumption_timestamp: Any = ..., date_created: Any = ..., date_updated: Any = ..., attributes: Any = ..., x_twilio_webhook_enabled: Any = ...): ...

class MemberInstance(InstanceResource):
    class WebhookEnabledType:
        TRUE: str = ...
        FALSE: str = ...
    def __init__(self, version: Any, payload: Any, service_sid: Any, channel_sid: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def sid(self): ...
    @property
    def account_sid(self): ...
    @property
    def channel_sid(self): ...
    @property
    def service_sid(self): ...
    @property
    def identity(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def role_sid(self): ...
    @property
    def last_consumed_message_index(self): ...
    @property
    def last_consumption_timestamp(self): ...
    @property
    def url(self): ...
    @property
    def attributes(self): ...
    def fetch(self): ...
    def delete(self, x_twilio_webhook_enabled: Any = ...): ...
    def update(self, role_sid: Any = ..., last_consumed_message_index: Any = ..., last_consumption_timestamp: Any = ..., date_created: Any = ..., date_updated: Any = ..., attributes: Any = ..., x_twilio_webhook_enabled: Any = ...): ...
