from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from typing import Any, Optional

class ParticipantList(ListResource):
    def __init__(self, version: Any, room_sid: Any) -> None: ...
    def stream(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, participant_sid: Any): ...
    def __call__(self, participant_sid: Any): ...

class ParticipantPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class ParticipantContext(InstanceContext):
    def __init__(self, version: Any, room_sid: Any, participant_sid: Any) -> None: ...
    def fetch(self): ...

class ParticipantInstance(InstanceResource):
    class RoomStatus:
        IN_PROGRESS: str = ...
        COMPLETED: str = ...
    class Codec:
        VP8: str = ...
        H264: str = ...
        VP9: str = ...
    class EndReason:
        DISCONNECTED_VIA_API: str = ...
        SIGNALING_CONNECTION_ERROR: str = ...
        SIGNALING_CONNECTION_DISCONNECTED: str = ...
        SIGNALING_CONNECTION_TIMED_OUT: str = ...
        CLIENT_RECEIVED_AN_INVALID_SIGNALING_MESSAGE: str = ...
        CLIENT_SENT_AN_INVALID_SIGNALING_MESSAGE: str = ...
        ROOM_NAME_IS_INVALID: str = ...
        ROOM_NAME_IS_TOO_LONG: str = ...
        ROOM_NAME_CONTAINS_INVALID_CHARACTERS: str = ...
        UNABLE_TO_CREATE_ROOM: str = ...
        UNABLE_TO_CONNECT_TO_ROOM: str = ...
        ROOM_CONTAINS_TOO_MANY_PARTICIPANTS: str = ...
        ROOM_NOT_FOUND: str = ...
        MAX_PARTICIPANTS_IS_OUT_OF_RANGE: str = ...
        ROOM_TYPE_IS_NOT_VALID: str = ...
        TIMEOUT_IS_OUT_OF_RANGE: str = ...
        STATUS_CALLBACK_METHOD_IS_INVALID: str = ...
        STATUS_CALLBACK_IS_INVALID: str = ...
        STATUS_IS_INVALID: str = ...
        ROOM_CREATION_FAILED: str = ...
        ROOM_COMPLETED_ERROR: str = ...
        THE_ROOM_ACCOUNT_LIMIT_WAS_EXCEEDED: str = ...
        INVALID_RECORDING_RULE: str = ...
        APPROACHING_ROOM_OR_PARTICIPANT_CONCURRENCY_LIMITS: str = ...
        RECORDING_OPERATION_REQUESTED_IS_NOT_SUPPORTED_FOR_THE_ROOM_TYPE: str = ...
        PARTICIPANT_IDENTITY_IS_INVALID: str = ...
        PARTICIPANT_IDENTITY_IS_TOO_LONG: str = ...
        PARTICIPANT_IDENTITY_CONTAINS_INVALID_CHARACTERS: str = ...
        PARTICIPANT_HAS_TOO_MANY_TRACKS: str = ...
        PARTICIPANT_NOT_FOUND: str = ...
        PARTICIPANT_DISCONNECTED_BECAUSE_OF_DUPLICATE_IDENTITY: str = ...
        PARTICIPANT_ACCOUNT_LIMIT_WAS_EXCEEDED: str = ...
        INVALID_SUBSCRIBE_RULE: str = ...
        TRACK_IS_INVALID: str = ...
        TRACK_NAME_IS_INVALID: str = ...
        TRACK_NAME_IS_TOO_LONG: str = ...
        TRACK_NAME_CONTAINS_INVALID_CHARACTERS: str = ...
        TRACK_NAME_IS_DUPLICATED: str = ...
        CLIENT_IS_UNABLE_TO_CREATE_OR_APPLY_A_LOCAL_MEDIA_DESCRIPTION: str = ...
        SERVER_IS_UNABLE_TO_CREATE_OR_APPLY_A_LOCAL_MEDIA_DESCRIPTION: str = ...
        CLIENT_IS_UNABLE_TO_APPLY_A_REMOTE_MEDIA_DESCRIPTION: str = ...
        SERVER_IS_UNABLE_TO_APPLY_A_REMOTE_MEDIA_DESCRIPTION: str = ...
        NO_SUPPORTED_CODEC: str = ...
        MEDIA_CONNECTION_FAILED_OR_MEDIA_ACTIVITY_CEASED: str = ...
        UNABLE_TO_ACQUIRE_CONFIGURATION: str = ...
        UNABLE_TO_ACQUIRE_TURN_CREDENTIALS: str = ...
    class TwilioRealm:
        US1: str = ...
        US2: str = ...
        AU1: str = ...
        BR1: str = ...
        IE1: str = ...
        JP1: str = ...
        SG1: str = ...
        IN1: str = ...
        DE1: str = ...
        GLL: str = ...
        OUTSIDE: str = ...
        STAGE_US1: str = ...
        STAGE_US2: str = ...
        STAGE_AU1: str = ...
        STAGE_BR1: str = ...
        STAGE_IE1: str = ...
        STAGE_JP1: str = ...
        STAGE_SG1: str = ...
        STAGE_IN1: str = ...
        STAGE_DE1: str = ...
        DEV_US1: str = ...
        DEV_US2: str = ...
    class EdgeLocation:
        ASHBURN: str = ...
        DUBLIN: str = ...
        FRANKFURT: str = ...
        SINGAPORE: str = ...
        SYDNEY: str = ...
        SAO_PAULO: str = ...
        ROAMING: str = ...
        UMATILLA: str = ...
        TOKYO: str = ...
    def __init__(self, version: Any, payload: Any, room_sid: Any, participant_sid: Optional[Any] = ...) -> None: ...
    @property
    def participant_sid(self): ...
    @property
    def participant_identity(self): ...
    @property
    def join_time(self): ...
    @property
    def leave_time(self): ...
    @property
    def duration_sec(self): ...
    @property
    def call_sid(self): ...
    @property
    def account_sid(self): ...
    @property
    def room_sid(self): ...
    @property
    def status(self): ...
    @property
    def codecs(self): ...
    @property
    def end_reason(self): ...
    @property
    def error_code(self): ...
    @property
    def error_code_url(self): ...
    @property
    def media_region(self): ...
    @property
    def properties(self): ...
    @property
    def edge_location(self): ...
    @property
    def publisher_info(self): ...
    @property
    def url(self): ...
    def fetch(self): ...
