from twilio.base import deserialize as deserialize, serialize as serialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.events.v1.sink.sink_test import SinkTestList as SinkTestList
from twilio.rest.events.v1.sink.sink_validate import SinkValidateList as SinkValidateList
from typing import Any, Optional

class SinkList(ListResource):
    def __init__(self, version: Any) -> None: ...
    def create(self, description: Any, sink_configuration: Any, sink_type: Any): ...
    def stream(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class SinkPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class SinkContext(InstanceContext):
    def __init__(self, version: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def delete(self): ...
    @property
    def sink_test(self): ...
    @property
    def sink_validate(self): ...

class SinkInstance(InstanceResource):
    class Status:
        INITIALIZED: str = ...
        VALIDATING: str = ...
        ACTIVE: str = ...
        FAILED: str = ...
    class SinkType:
        KINESIS: str = ...
    def __init__(self, version: Any, payload: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def description(self): ...
    @property
    def sid(self): ...
    @property
    def sink_configuration(self): ...
    @property
    def sink_type(self): ...
    @property
    def status(self): ...
    @property
    def url(self): ...
    @property
    def links(self): ...
    def fetch(self): ...
    def delete(self): ...
    @property
    def sink_test(self): ...
    @property
    def sink_validate(self): ...
