from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from typing import Any, Optional

class DeliveryReceiptList(ListResource):
    def __init__(self, version: Any, chat_service_sid: Any, conversation_sid: Any, message_sid: Any) -> None: ...
    def stream(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class DeliveryReceiptPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class DeliveryReceiptContext(InstanceContext):
    def __init__(self, version: Any, chat_service_sid: Any, conversation_sid: Any, message_sid: Any, sid: Any) -> None: ...
    def fetch(self): ...

class DeliveryReceiptInstance(InstanceResource):
    class DeliveryStatus:
        READ: str = ...
        FAILED: str = ...
        DELIVERED: str = ...
        UNDELIVERED: str = ...
        SENT: str = ...
    def __init__(self, version: Any, payload: Any, chat_service_sid: Any, conversation_sid: Any, message_sid: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def account_sid(self): ...
    @property
    def chat_service_sid(self): ...
    @property
    def conversation_sid(self): ...
    @property
    def message_sid(self): ...
    @property
    def sid(self): ...
    @property
    def channel_message_sid(self): ...
    @property
    def participant_sid(self): ...
    @property
    def status(self): ...
    @property
    def error_code(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def url(self): ...
    def fetch(self): ...
