from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.conversations.v1.service.binding import BindingList as BindingList
from twilio.rest.conversations.v1.service.configuration import ConfigurationList as ConfigurationList
from twilio.rest.conversations.v1.service.conversation import ConversationList as ConversationList
from twilio.rest.conversations.v1.service.role import RoleList as RoleList
from twilio.rest.conversations.v1.service.user import UserList as UserList
from typing import Any, Optional

class ServiceList(ListResource):
    def __init__(self, version: Any) -> None: ...
    def create(self, friendly_name: Any): ...
    def stream(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class ServicePage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class ServiceContext(InstanceContext):
    def __init__(self, version: Any, sid: Any) -> None: ...
    def delete(self): ...
    def fetch(self): ...
    @property
    def conversations(self): ...
    @property
    def bindings(self): ...
    @property
    def users(self): ...
    @property
    def roles(self): ...
    @property
    def configuration(self): ...

class ServiceInstance(InstanceResource):
    def __init__(self, version: Any, payload: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def account_sid(self): ...
    @property
    def sid(self): ...
    @property
    def friendly_name(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def url(self): ...
    @property
    def links(self): ...
    def delete(self): ...
    def fetch(self): ...
    @property
    def conversations(self): ...
    @property
    def bindings(self): ...
    @property
    def users(self): ...
    @property
    def roles(self): ...
    @property
    def configuration(self): ...
