from twilio.base import deserialize as deserialize, serialize as serialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.conversations.v1.conversation.message.delivery_receipt import DeliveryReceiptList as DeliveryReceiptList
from typing import Any, Optional

class MessageList(ListResource):
    def __init__(self, version: Any, conversation_sid: Any) -> None: ...
    def create(self, author: Any = ..., body: Any = ..., date_created: Any = ..., date_updated: Any = ..., attributes: Any = ..., media_sid: Any = ..., x_twilio_webhook_enabled: Any = ...): ...
    def stream(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class MessagePage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class MessageContext(InstanceContext):
    def __init__(self, version: Any, conversation_sid: Any, sid: Any) -> None: ...
    def update(self, author: Any = ..., body: Any = ..., date_created: Any = ..., date_updated: Any = ..., attributes: Any = ..., x_twilio_webhook_enabled: Any = ...): ...
    def delete(self, x_twilio_webhook_enabled: Any = ...): ...
    def fetch(self): ...
    @property
    def delivery_receipts(self): ...

class MessageInstance(InstanceResource):
    class WebhookEnabledType:
        TRUE: str = ...
        FALSE: str = ...
    def __init__(self, version: Any, payload: Any, conversation_sid: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def account_sid(self): ...
    @property
    def conversation_sid(self): ...
    @property
    def sid(self): ...
    @property
    def index(self): ...
    @property
    def author(self): ...
    @property
    def body(self): ...
    @property
    def media(self): ...
    @property
    def attributes(self): ...
    @property
    def participant_sid(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def url(self): ...
    @property
    def delivery(self): ...
    @property
    def links(self): ...
    def update(self, author: Any = ..., body: Any = ..., date_created: Any = ..., date_updated: Any = ..., attributes: Any = ..., x_twilio_webhook_enabled: Any = ...): ...
    def delete(self, x_twilio_webhook_enabled: Any = ...): ...
    def fetch(self): ...
    @property
    def delivery_receipts(self): ...
