from twilio.base import deserialize as deserialize, serialize as serialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.conversations.v1.conversation.message import MessageList as MessageList
from twilio.rest.conversations.v1.conversation.participant import ParticipantList as ParticipantList
from twilio.rest.conversations.v1.conversation.webhook import WebhookList as WebhookList
from typing import Any, Optional

class ConversationList(ListResource):
    def __init__(self, version: Any) -> None: ...
    def create(self, friendly_name: Any = ..., unique_name: Any = ..., date_created: Any = ..., date_updated: Any = ..., messaging_service_sid: Any = ..., attributes: Any = ..., state: Any = ..., timers_inactive: Any = ..., timers_closed: Any = ..., x_twilio_webhook_enabled: Any = ...): ...
    def stream(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class ConversationPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class ConversationContext(InstanceContext):
    def __init__(self, version: Any, sid: Any) -> None: ...
    def update(self, friendly_name: Any = ..., date_created: Any = ..., date_updated: Any = ..., attributes: Any = ..., messaging_service_sid: Any = ..., state: Any = ..., timers_inactive: Any = ..., timers_closed: Any = ..., unique_name: Any = ..., x_twilio_webhook_enabled: Any = ...): ...
    def delete(self, x_twilio_webhook_enabled: Any = ...): ...
    def fetch(self): ...
    @property
    def participants(self): ...
    @property
    def messages(self): ...
    @property
    def webhooks(self): ...

class ConversationInstance(InstanceResource):
    class WebhookEnabledType:
        TRUE: str = ...
        FALSE: str = ...
    class State:
        INACTIVE: str = ...
        ACTIVE: str = ...
        CLOSED: str = ...
    def __init__(self, version: Any, payload: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def account_sid(self): ...
    @property
    def chat_service_sid(self): ...
    @property
    def messaging_service_sid(self): ...
    @property
    def sid(self): ...
    @property
    def friendly_name(self): ...
    @property
    def unique_name(self): ...
    @property
    def attributes(self): ...
    @property
    def state(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def timers(self): ...
    @property
    def url(self): ...
    @property
    def links(self): ...
    def update(self, friendly_name: Any = ..., date_created: Any = ..., date_updated: Any = ..., attributes: Any = ..., messaging_service_sid: Any = ..., state: Any = ..., timers_inactive: Any = ..., timers_closed: Any = ..., unique_name: Any = ..., x_twilio_webhook_enabled: Any = ...): ...
    def delete(self, x_twilio_webhook_enabled: Any = ...): ...
    def fetch(self): ...
    @property
    def participants(self): ...
    @property
    def messages(self): ...
    @property
    def webhooks(self): ...
