from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.chat.v1.service.user.user_channel import UserChannelList as UserChannelList
from typing import Any, Optional

class UserList(ListResource):
    def __init__(self, version: Any, service_sid: Any) -> None: ...
    def create(self, identity: Any, role_sid: Any = ..., attributes: Any = ..., friendly_name: Any = ...): ...
    def stream(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class UserPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class UserContext(InstanceContext):
    def __init__(self, version: Any, service_sid: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def delete(self): ...
    def update(self, role_sid: Any = ..., attributes: Any = ..., friendly_name: Any = ...): ...
    @property
    def user_channels(self): ...

class UserInstance(InstanceResource):
    def __init__(self, version: Any, payload: Any, service_sid: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def sid(self): ...
    @property
    def account_sid(self): ...
    @property
    def service_sid(self): ...
    @property
    def attributes(self): ...
    @property
    def friendly_name(self): ...
    @property
    def role_sid(self): ...
    @property
    def identity(self): ...
    @property
    def is_online(self): ...
    @property
    def is_notifiable(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def joined_channels_count(self): ...
    @property
    def links(self): ...
    @property
    def url(self): ...
    def fetch(self): ...
    def delete(self): ...
    def update(self, role_sid: Any = ..., attributes: Any = ..., friendly_name: Any = ...): ...
    @property
    def user_channels(self): ...
