/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.util;

import com.android.dx.util.MutabilityControl;
import com.android.dx.util.ToHuman;
import java.util.Arrays;

public class FixedSizeList
extends MutabilityControl
implements ToHuman {
    private Object[] arr;

    public FixedSizeList(int n) {
        super(n != 0);
        try {
            this.arr = new Object[n];
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            throw new IllegalArgumentException("size < 0");
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FixedSizeList fixedSizeList = (FixedSizeList)object;
        return Arrays.equals(this.arr, fixedSizeList.arr);
    }

    public int hashCode() {
        return Arrays.hashCode(this.arr);
    }

    public String toString() {
        String string = this.getClass().getName();
        return this.toString0(string.substring(string.lastIndexOf(46) + 1) + '{', ", ", "}", false);
    }

    @Override
    public String toHuman() {
        String string = this.getClass().getName();
        return this.toString0(string.substring(string.lastIndexOf(46) + 1) + '{', ", ", "}", true);
    }

    public String toString(String string, String string2, String string3) {
        return this.toString0(string, string2, string3, false);
    }

    public String toHuman(String string, String string2, String string3) {
        return this.toString0(string, string2, string3, true);
    }

    public final int size() {
        return this.arr.length;
    }

    public void shrinkToFit() {
        int n = this.arr.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (this.arr[i] == null) continue;
            ++n2;
        }
        if (n == n2) {
            return;
        }
        this.throwIfImmutable();
        Object[] objectArray = new Object[n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            Object object = this.arr[i];
            if (object == null) continue;
            objectArray[n3] = object;
            ++n3;
        }
        this.arr = objectArray;
        if (n2 == 0) {
            this.setImmutable();
        }
    }

    protected final Object get0(int n) {
        try {
            Object object = this.arr[n];
            if (object == null) {
                throw new NullPointerException("unset: " + n);
            }
            return object;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return this.throwIndex(n);
        }
    }

    protected final Object getOrNull0(int n) {
        return this.arr[n];
    }

    protected final void set0(int n, Object object) {
        this.throwIfImmutable();
        try {
            this.arr[n] = object;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.throwIndex(n);
        }
    }

    private Object throwIndex(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("n < 0");
        }
        throw new IndexOutOfBoundsException("n >= size()");
    }

    private String toString0(String string, String string2, String string3, boolean bl) {
        int n = this.arr.length;
        StringBuffer stringBuffer = new StringBuffer(n * 10 + 10);
        if (string != null) {
            stringBuffer.append(string);
        }
        for (int i = 0; i < n; ++i) {
            if (i != 0 && string2 != null) {
                stringBuffer.append(string2);
            }
            if (bl) {
                stringBuffer.append(((ToHuman)this.arr[i]).toHuman());
                continue;
            }
            stringBuffer.append(this.arr[i]);
        }
        if (string3 != null) {
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }
}

