/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.code;

import com.android.dx.util.Hex;

public final class AccessFlags {
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SYNCHRONIZED = 32;
    public static final int ACC_SUPER = 32;
    public static final int ACC_VOLATILE = 64;
    public static final int ACC_BRIDGE = 64;
    public static final int ACC_TRANSIENT = 128;
    public static final int ACC_VARARGS = 128;
    public static final int ACC_NATIVE = 256;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;
    public static final int ACC_STRICT = 2048;
    public static final int ACC_SYNTHETIC = 4096;
    public static final int ACC_ANNOTATION = 8192;
    public static final int ACC_ENUM = 16384;
    public static final int ACC_CONSTRUCTOR = 65536;
    public static final int ACC_DECLARED_SYNCHRONIZED = 131072;
    public static final int CLASS_FLAGS = 30257;
    public static final int INNER_CLASS_FLAGS = 30239;
    public static final int FIELD_FLAGS = 20703;
    public static final int METHOD_FLAGS = 204287;
    private static final int CONV_CLASS = 1;
    private static final int CONV_FIELD = 2;
    private static final int CONV_METHOD = 3;

    private AccessFlags() {
    }

    public static String classString(int n) {
        return AccessFlags.humanHelper(n, 30257, 1);
    }

    public static String innerClassString(int n) {
        return AccessFlags.humanHelper(n, 30239, 1);
    }

    public static String fieldString(int n) {
        return AccessFlags.humanHelper(n, 20703, 2);
    }

    public static String methodString(int n) {
        return AccessFlags.humanHelper(n, 204287, 3);
    }

    public static boolean isPublic(int n) {
        return (n & 1) != 0;
    }

    public static boolean isProtected(int n) {
        return (n & 4) != 0;
    }

    public static boolean isPrivate(int n) {
        return (n & 2) != 0;
    }

    public static boolean isStatic(int n) {
        return (n & 8) != 0;
    }

    public static boolean isConstructor(int n) {
        return (n & 0x10000) != 0;
    }

    public static boolean isInterface(int n) {
        return (n & 0x200) != 0;
    }

    public static boolean isSynchronized(int n) {
        return (n & 0x20) != 0;
    }

    public static boolean isAbstract(int n) {
        return (n & 0x400) != 0;
    }

    public static boolean isNative(int n) {
        return (n & 0x100) != 0;
    }

    public static boolean isAnnotation(int n) {
        return (n & 0x2000) != 0;
    }

    public static boolean isDeclaredSynchronized(int n) {
        return (n & 0x20000) != 0;
    }

    public static boolean isEnum(int n) {
        return (n & 0x4000) != 0;
    }

    private static String humanHelper(int n, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer(80);
        int n4 = n & ~n2;
        if (((n &= n2) & 1) != 0) {
            stringBuffer.append("|public");
        }
        if ((n & 2) != 0) {
            stringBuffer.append("|private");
        }
        if ((n & 4) != 0) {
            stringBuffer.append("|protected");
        }
        if ((n & 8) != 0) {
            stringBuffer.append("|static");
        }
        if ((n & 0x10) != 0) {
            stringBuffer.append("|final");
        }
        if ((n & 0x20) != 0) {
            if (n3 == 1) {
                stringBuffer.append("|super");
            } else {
                stringBuffer.append("|synchronized");
            }
        }
        if ((n & 0x40) != 0) {
            if (n3 == 3) {
                stringBuffer.append("|bridge");
            } else {
                stringBuffer.append("|volatile");
            }
        }
        if ((n & 0x80) != 0) {
            if (n3 == 3) {
                stringBuffer.append("|varargs");
            } else {
                stringBuffer.append("|transient");
            }
        }
        if ((n & 0x100) != 0) {
            stringBuffer.append("|native");
        }
        if ((n & 0x200) != 0) {
            stringBuffer.append("|interface");
        }
        if ((n & 0x400) != 0) {
            stringBuffer.append("|abstract");
        }
        if ((n & 0x800) != 0) {
            stringBuffer.append("|strictfp");
        }
        if ((n & 0x1000) != 0) {
            stringBuffer.append("|synthetic");
        }
        if ((n & 0x2000) != 0) {
            stringBuffer.append("|annotation");
        }
        if ((n & 0x4000) != 0) {
            stringBuffer.append("|enum");
        }
        if ((n & 0x10000) != 0) {
            stringBuffer.append("|constructor");
        }
        if ((n & 0x20000) != 0) {
            stringBuffer.append("|declared_synchronized");
        }
        if (n4 != 0 || stringBuffer.length() == 0) {
            stringBuffer.append('|');
            stringBuffer.append(Hex.u2(n4));
        }
        return stringBuffer.substring(1);
    }
}

