/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dex.Leb128;
import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.ItemType;
import com.android.dx.dex.file.OffsettedItem;
import com.android.dx.rop.cst.CstString;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.ByteArray;
import com.android.dx.util.Hex;

public final class StringDataItem
extends OffsettedItem {
    private final CstString value;

    public StringDataItem(CstString cstString) {
        super(1, StringDataItem.writeSize(cstString));
        this.value = cstString;
    }

    private static int writeSize(CstString cstString) {
        int n = cstString.getUtf16Size();
        return Leb128.unsignedLeb128Size(n) + cstString.getUtf8Size() + 1;
    }

    @Override
    public ItemType itemType() {
        return ItemType.TYPE_STRING_DATA_ITEM;
    }

    @Override
    public void addContents(DexFile dexFile) {
    }

    @Override
    public void writeTo0(DexFile dexFile, AnnotatedOutput annotatedOutput) {
        ByteArray byteArray = this.value.getBytes();
        int n = this.value.getUtf16Size();
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(Leb128.unsignedLeb128Size(n), "utf16_size: " + Hex.u4(n));
            annotatedOutput.annotate(byteArray.size() + 1, this.value.toQuoted());
        }
        annotatedOutput.writeUleb128(n);
        annotatedOutput.write(byteArray);
        annotatedOutput.writeByte(0);
    }

    @Override
    public String toHuman() {
        return this.value.toQuoted();
    }

    @Override
    protected int compareTo0(OffsettedItem offsettedItem) {
        StringDataItem stringDataItem = (StringDataItem)offsettedItem;
        return this.value.compareTo(stringDataItem.value);
    }
}

