/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.IndexedItem;
import com.android.dx.dex.file.ItemType;
import com.android.dx.dex.file.MixedItemSection;
import com.android.dx.dex.file.OffsettedItem;
import com.android.dx.dex.file.StringIdsSection;
import com.android.dx.dex.file.TypeIdsSection;
import com.android.dx.dex.file.TypeListItem;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.type.Prototype;
import com.android.dx.rop.type.StdTypeList;
import com.android.dx.rop.type.Type;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.Hex;

public final class ProtoIdItem
extends IndexedItem {
    private final Prototype prototype;
    private final CstString shortForm;
    private TypeListItem parameterTypes;

    public ProtoIdItem(Prototype prototype) {
        if (prototype == null) {
            throw new NullPointerException("prototype == null");
        }
        this.prototype = prototype;
        this.shortForm = ProtoIdItem.makeShortForm(prototype);
        StdTypeList stdTypeList = prototype.getParameterTypes();
        this.parameterTypes = stdTypeList.size() == 0 ? null : new TypeListItem(stdTypeList);
    }

    private static CstString makeShortForm(Prototype prototype) {
        StdTypeList stdTypeList = prototype.getParameterTypes();
        int n = stdTypeList.size();
        StringBuilder stringBuilder = new StringBuilder(n + 1);
        stringBuilder.append(ProtoIdItem.shortFormCharFor(prototype.getReturnType()));
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(ProtoIdItem.shortFormCharFor(stdTypeList.getType(i)));
        }
        return new CstString(stringBuilder.toString());
    }

    private static char shortFormCharFor(Type type) {
        char c = type.getDescriptor().charAt(0);
        if (c == '[') {
            return 'L';
        }
        return c;
    }

    @Override
    public ItemType itemType() {
        return ItemType.TYPE_PROTO_ID_ITEM;
    }

    @Override
    public int writeSize() {
        return 12;
    }

    @Override
    public void addContents(DexFile dexFile) {
        StringIdsSection stringIdsSection = dexFile.getStringIds();
        TypeIdsSection typeIdsSection = dexFile.getTypeIds();
        MixedItemSection mixedItemSection = dexFile.getTypeLists();
        typeIdsSection.intern(this.prototype.getReturnType());
        stringIdsSection.intern(this.shortForm);
        if (this.parameterTypes != null) {
            this.parameterTypes = mixedItemSection.intern(this.parameterTypes);
        }
    }

    @Override
    public void writeTo(DexFile dexFile, AnnotatedOutput annotatedOutput) {
        int n = dexFile.getStringIds().indexOf(this.shortForm);
        int n2 = dexFile.getTypeIds().indexOf(this.prototype.getReturnType());
        int n3 = OffsettedItem.getAbsoluteOffsetOr0(this.parameterTypes);
        if (annotatedOutput.annotates()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.prototype.getReturnType().toHuman());
            stringBuilder.append(" proto(");
            StdTypeList stdTypeList = this.prototype.getParameterTypes();
            int n4 = stdTypeList.size();
            for (int i = 0; i < n4; ++i) {
                if (i != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(stdTypeList.getType(i).toHuman());
            }
            stringBuilder.append(")");
            annotatedOutput.annotate(0, this.indexString() + ' ' + stringBuilder.toString());
            annotatedOutput.annotate(4, "  shorty_idx:      " + Hex.u4(n) + " // " + this.shortForm.toQuoted());
            annotatedOutput.annotate(4, "  return_type_idx: " + Hex.u4(n2) + " // " + this.prototype.getReturnType().toHuman());
            annotatedOutput.annotate(4, "  parameters_off:  " + Hex.u4(n3));
        }
        annotatedOutput.writeInt(n);
        annotatedOutput.writeInt(n2);
        annotatedOutput.writeInt(n3);
    }
}

