/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.command.dump;

import com.android.dex.util.FileUtils;
import com.android.dx.cf.iface.ParseException;
import com.android.dx.command.dump.Args;
import com.android.dx.command.dump.BlockDumper;
import com.android.dx.command.dump.ClassDumper;
import com.android.dx.command.dump.DotDumper;
import com.android.dx.command.dump.SsaDumper;
import com.android.dx.util.HexParser;
import java.io.UnsupportedEncodingException;

public class Main {
    static Args parsedArgs = new Args();

    private Main() {
    }

    public static void main(String[] stringArray) {
        String string;
        int n;
        for (n = 0; n < stringArray.length && !(string = stringArray[n]).equals("--") && string.startsWith("--"); ++n) {
            if (string.equals("--bytes")) {
                Main.parsedArgs.rawBytes = true;
                continue;
            }
            if (string.equals("--basic-blocks")) {
                Main.parsedArgs.basicBlocks = true;
                continue;
            }
            if (string.equals("--rop-blocks")) {
                Main.parsedArgs.ropBlocks = true;
                continue;
            }
            if (string.equals("--optimize")) {
                Main.parsedArgs.optimize = true;
                continue;
            }
            if (string.equals("--ssa-blocks")) {
                Main.parsedArgs.ssaBlocks = true;
                continue;
            }
            if (string.startsWith("--ssa-step=")) {
                Main.parsedArgs.ssaStep = string.substring(string.indexOf(61) + 1);
                continue;
            }
            if (string.equals("--debug")) {
                Main.parsedArgs.debug = true;
                continue;
            }
            if (string.equals("--dot")) {
                Main.parsedArgs.dotDump = true;
                continue;
            }
            if (string.equals("--strict")) {
                Main.parsedArgs.strictParse = true;
                continue;
            }
            if (string.startsWith("--width=")) {
                string = string.substring(string.indexOf(61) + 1);
                Main.parsedArgs.width = Integer.parseInt(string);
                continue;
            }
            if (string.startsWith("--method=")) {
                Main.parsedArgs.method = string = string.substring(string.indexOf(61) + 1);
                continue;
            }
            System.err.println("unknown option: " + string);
            throw new RuntimeException("usage");
        }
        if (n == stringArray.length) {
            System.err.println("no input files specified");
            throw new RuntimeException("usage");
        }
        while (n < stringArray.length) {
            try {
                string = stringArray[n];
                System.out.println("reading " + string + "...");
                byte[] byArray = FileUtils.readFile(string);
                if (!string.endsWith(".class")) {
                    String string2;
                    try {
                        string2 = new String(byArray, "utf-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new RuntimeException("shouldn't happen", unsupportedEncodingException);
                    }
                    byArray = HexParser.parse(string2);
                }
                Main.processOne(string, byArray);
            }
            catch (ParseException parseException) {
                System.err.println("\ntrouble parsing:");
                if (Main.parsedArgs.debug) {
                    parseException.printStackTrace();
                }
                parseException.printContext(System.err);
            }
            ++n;
        }
    }

    private static void processOne(String string, byte[] byArray) {
        if (Main.parsedArgs.dotDump) {
            DotDumper.dump(byArray, string, parsedArgs);
        } else if (Main.parsedArgs.basicBlocks) {
            BlockDumper.dump(byArray, System.out, string, false, parsedArgs);
        } else if (Main.parsedArgs.ropBlocks) {
            BlockDumper.dump(byArray, System.out, string, true, parsedArgs);
        } else if (Main.parsedArgs.ssaBlocks) {
            Main.parsedArgs.optimize = false;
            SsaDumper.dump(byArray, System.out, string, parsedArgs);
        } else {
            ClassDumper.dump(byArray, System.out, string, parsedArgs);
        }
    }
}

