"""
Dumps out the current configuration
"""

import argparse
import os
from trustgraph.api import Api
import json

default_url = os.getenv("TRUSTGRAPH_URL", 'http://localhost:8088/')

def show_config(url):

    api = Api(url).config()

    config, version = api.all()

    print("Version:", version)
    print(json.dumps(config, indent=4))

def main():

    parser = argparse.ArgumentParser(
        prog='tg-show-config',
        description=__doc__,
    )

    parser.add_argument(
        '-u', '--api-url',
        default=default_url,
        help=f'API URL (default: {default_url})',
    )

    args = parser.parse_args()

    try:

        show_config(
            url=args.api_url,
        )

    except Exception as e:

        print("Exception:", e, flush=True)

if __name__ == "__main__":
    main()