"""
Uses the DocumentRAG service to answer a question
"""

import argparse
import os
from trustgraph.api import Api

default_url = os.getenv("TRUSTGRAPH_URL", 'http://localhost:8088/')
default_user = 'trustgraph'
default_collection = 'default'
default_doc_limit = 10

def question(url, flow_id, question, user, collection, doc_limit):

    api = Api(url).flow().id(flow_id)

    resp = api.document_rag(
        question=question, user=user, collection=collection,
        doc_limit=doc_limit,
    )

    print(resp)

def main():

    parser = argparse.ArgumentParser(
        prog='tg-invoke-document-rag',
        description=__doc__,
    )

    parser.add_argument(
        '-u', '--url',
        default=default_url,
        help=f'API URL (default: {default_url})',
    )

    parser.add_argument(
        '-f', '--flow-id',
        default="default",
        help=f'Flow ID (default: default)'
    )

    parser.add_argument(
        '-q', '--question',
        required=True,
        help=f'Question to answer',
    )

    parser.add_argument(
        '-U', '--user',
        default=default_user,
        help=f'User ID (default: {default_user})'
    )

    parser.add_argument(
        '-C', '--collection',
        default=default_collection,
        help=f'Collection ID (default: {default_collection})'
    )

    parser.add_argument(
        '-d', '--doc-limit',
        default=default_doc_limit,
        help=f'Document limit (default: {default_doc_limit})'
    )

    args = parser.parse_args()

    try:

        question(
            url=args.url,
            flow_id = args.flow_id,
            question=args.question,
            user=args.user,
            collection=args.collection,
            doc_limit=args.doc_limit,
        )

    except Exception as e:

        print("Exception:", e, flush=True)

if __name__ == "__main__":
    main()