"""
Deletes a flow class
"""

import argparse
import os
import tabulate
from trustgraph.api import Api
import json

default_url = os.getenv("TRUSTGRAPH_URL", 'http://localhost:8088/')

def delete_flow_class(url, class_name):

    api = Api(url).flow()

    class_names = api.delete_class(class_name)

def main():

    parser = argparse.ArgumentParser(
        prog='tg-delete-flow-class',
        description=__doc__,
    )

    parser.add_argument(
        '-u', '--api-url',
        default=default_url,
        help=f'API URL (default: {default_url})',
    )

    parser.add_argument(
        '-n', '--class-name',
        help=f'Flow class name',
    )

    args = parser.parse_args()

    try:

        delete_flow_class(
            url=args.api_url,
            class_name=args.class_name,
        )

    except Exception as e:

        print("Exception:", e, flush=True)

if __name__ == "__main__":
    main()