from wallet import utils
from Crypto.PublicKey import RSA
from colorama import Fore
import base58

class wallet:
    def __init__(self):
        self.private_key = None
        self.public_key = None
        self.address = None
        self.initialize_keys()

    """
    Private key: used to encrypt my transaction 
    Public key:  used to decrypt my transaction (if the transaction if decrypted succsesfully 
                                                    it means that the transaction was encrypted
                                                    by the corresponding private key)
    address: unique address for the wallet      (generated by calculating the md160 of the sha256 of the public key)
                                                    address = md160(sha256(public_key))
    """
    def initialize_keys(self):
        self.private_key = RSA.generate(2048)
        self.public_key = self.private_key.publickey().exportKey()
        hash_1 = utils.calculate_hash(self.public_key, hash_function="sha256")
        hash_2 = utils.calculate_hash(hash_1, hash_function="ripemd160")
        self.address = base58.b58encode(hash_2)
        self.address = b"RVx"+self.address

    def get_privateKey(self):
        return self.private_key.exportKey()

    def get_publicKey(self):
        return self.public_key

    def get_address(self):
        return self.address

if __name__ == "__main__":
    wallet = wallet()
    print(Fore.GREEN+"private key: {0}".format(wallet.get_privateKey()))
    print(Fore.BLUE+"public key: {0}".format(wallet.get_publicKey()))
    print(Fore.GREEN+"address: {0}".format(wallet.get_address()))
    print(Fore.WHITE)