# SpectroscPy 0.2.0
# SpectroscPy is a script package developed by and containing contributions from

    # Karen Oda Hjorth Minde Dundas
    # Magnus Ringholm
    # Yann Cornation
    # Benedicte Ofstad

# The package is released under a LGPL licence.
# For questions, please contact on karen.o.dundas@uit.no

from spectroscpy import get_sorted, get_zero_padded_intensities, get_plot_values, get_x_fit
import numpy as np

a = [[1.15, 4, 6.1, 2.3, 9.8], [1.13, 4.15, 6.5, 2.4, 10], [1, 4.13, 6.11, 2.25, 10.1], \
     [1.1, 4.25, 6.2, 2.18, 10.05], [1.2, 4.16, 6.21, 2.32, 10.12]]
b = [[10, 3, 4, 2, 7], [11, 4, 5, 1, 8], [9, 2, 5, 1, 8], [10, 2, 5, 3, 6], [11, 2, 3, 3, 8]]

all_a = [ 1.15,  4.  ,  6.1 ,  2.3 ,  9.8 ,  1.13,  4.15,  6.5 ,  2.4 , 10.  ,  1.  ,  4.13,  6.11,  \
          2.25, 10.1 ,  1.1 , 4.25,  6.2 ,  2.18, 10.05,  1.2 ,  4.16,  6.21,  2.32, 10.12]
all_b = [10.,  3.,  4.,  2.,  7., 11.,  4.,  5.,  1.,  8.,  9.,  2.,  5., 1.,  8., 10.,  2.,  5.,  3.,  \
          6., 11.,  2.,  3.,  3.,  8.]

all_c = [0.02499999999999991, 0.015000000000000124, 0.04999999999999982, 0.03499999999999992, \
         0.04999999999999982, 0.02499999999999991, 0.015000000000000124, 0.04999999999999982, \
         0.03499999999999992, 0.04999999999999982, 0.02499999999999991, 0.015000000000000124, \
         0.04999999999999982, 0.03499999999999992, 0.04999999999999982, 0.02499999999999991, \
         0.015000000000000124, 0.04999999999999982, 0.03499999999999992, 0.04999999999999982, \
         0.02499999999999991, 0.015000000000000124, 0.04999999999999982, 0.03499999999999992, \
         0.04999999999999982]

s_a = [ 1.  ,  1.1 ,  1.13,  1.15,  1.2 ,  2.18,  2.25,  2.3 ,  2.32, 2.4 ,  4.  ,  4.13,  4.15,  4.16, \
        4.25, 6.1 ,  6.11,  6.2 , 6.21,  6.5 ,  9.8 , 10.  , 10.05, 10.1 , 10.12]
s_b = [ 9., 10., 11., 10., 11.,  3.,  1.,  2.,  3.,  1.,  3.,  2.,  4., 2.,  2.,  4.,  5.,  5.,  3.,  \
        5.,  7., 8.,  6.,  8.,  8.]
s_c = [0.02499999999999991, 0.02499999999999991, 0.02499999999999991, 0.02499999999999991, \
       0.02499999999999991, 0.03499999999999992, 0.03499999999999992, 0.03499999999999992, \
       0.03499999999999992, 0.03499999999999992, 0.015000000000000124, 0.015000000000000124, \
       0.015000000000000124, 0.015000000000000124, \
       0.015000000000000124,  0.04999999999999982 , 0.04999999999999982 , 0.04999999999999982 , \
       0.04999999999999982 , 0.04999999999999982 , 0.04999999999999982 , 0.04999999999999982 , \
       0.04999999999999982 , 0.04999999999999982 , 0.04999999999999982 ]

def test_get_zero_padded_intensities():

    s_x = [ 1.13,  1.15,  2.3 ,  2.4 ,  4.  ,  4.15,  6.1 ,  6.5 ,  9.8 , 10.  ]
    s_y = [11., 10.,  2.,  1.,  3.,  4.,  4.,  5.,  7.,  8.]
    s_g = [0.025, 0.025, 0.035, 0.035, 0.015, 0.015, 0.05 , 0.05 , 0.05 , 0.05 ]

    x_fit = [ 1.13      ,  1.21959596,  1.30919192,  1.39878788,  1.48838384,
        1.5779798 ,  1.66757576,  1.75717172,  1.84676768,  1.93636364,
        2.0259596 ,  2.11555556,  2.20515152,  2.29474747,  2.38434343,
        2.47393939,  2.56353535,  2.65313131,  2.74272727,  2.83232323,
        2.92191919,  3.01151515,  3.10111111,  3.19070707,  3.28030303,
        3.36989899,  3.45949495,  3.54909091,  3.63868687,  3.72828283,
        3.81787879,  3.90747475,  3.99707071,  4.08666667,  4.17626263,
        4.26585859,  4.35545455,  4.44505051,  4.53464646,  4.62424242,
        4.71383838,  4.80343434,  4.8930303 ,  4.98262626,  5.07222222,
        5.16181818,  5.25141414,  5.3410101 ,  5.43060606,  5.52020202,
        5.60979798,  5.69939394,  5.7889899 ,  5.87858586,  5.96818182,
        6.05777778,  6.14737374,  6.2369697 ,  6.32656566,  6.41616162,
        6.50575758,  6.59535354,  6.68494949,  6.77454545,  6.86414141,
        6.95373737,  7.04333333,  7.13292929,  7.22252525,  7.31212121,
        7.40171717,  7.49131313,  7.58090909,  7.67050505,  7.76010101,
        7.84969697,  7.93929293,  8.02888889,  8.11848485,  8.20808081,
        8.29767677,  8.38727273,  8.47686869,  8.56646465,  8.65606061,
        8.74565657,  8.83525253,  8.92484848,  9.01444444,  9.1040404 ,
        9.19363636,  9.28323232,  9.37282828,  9.46242424,  9.5520202 ,
        9.64161616,  9.73121212,  9.82080808,  9.91040404, 10.        ]

    ref_p_x = [ 1.13      ,  1.15      ,  1.21959596,  1.30919192,  1.39878788,
        1.48838384,  1.5779798 ,  1.66757576,  1.75717172,  1.84676768,
        1.93636364,  2.0259596 ,  2.11555556,  2.20515152,  2.29474747,
        2.3       ,  2.38434343,  2.4       ,  2.47393939,  2.56353535,
        2.65313131,  2.74272727,  2.83232323,  2.92191919,  3.01151515,
        3.10111111,  3.19070707,  3.28030303,  3.36989899,  3.45949495,
        3.54909091,  3.63868687,  3.72828283,  3.81787879,  3.90747475,
        3.99707071,  4.        ,  4.08666667,  4.15      ,  4.17626263,
        4.26585859,  4.35545455,  4.44505051,  4.53464646,  4.62424242,
        4.71383838,  4.80343434,  4.8930303 ,  4.98262626,  5.07222222,
        5.16181818,  5.25141414,  5.3410101 ,  5.43060606,  5.52020202,
        5.60979798,  5.69939394,  5.7889899 ,  5.87858586,  5.96818182,
        6.05777778,  6.1       ,  6.14737374,  6.2369697 ,  6.32656566,
        6.41616162,  6.5       ,  6.50575758,  6.59535354,  6.68494949,
        6.77454545,  6.86414141,  6.95373737,  7.04333333,  7.13292929,
        7.22252525,  7.31212121,  7.40171717,  7.49131313,  7.58090909,
        7.67050505,  7.76010101,  7.84969697,  7.93929293,  8.02888889,
        8.11848485,  8.20808081,  8.29767677,  8.38727273,  8.47686869,
        8.56646465,  8.65606061,  8.74565657,  8.83525253,  8.92484848,
        9.01444444,  9.1040404 ,  9.19363636,  9.28323232,  9.37282828,
        9.46242424,  9.5520202 ,  9.64161616,  9.73121212,  9.8       ,
        9.82080808,  9.91040404, 10.        ]

    ref_p_y = [11., 10.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,
        0.,  0.,  2.,  0.,  1.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,
        0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  3.,  0.,  4.,
        0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,
        0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  4.,  0.,  0.,  0.,
        0.,  5.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,
        0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,
        0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.,
        7.,  0.,  0.,  8.]

    ref_p_g = [0.025, 0.025, 0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   ,
       0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.035, 0.   , 0.035,
       0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   ,
       0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   ,
       0.015, 0.   , 0.015, 0.   , 0.   , 0.   , 0.   , 0.   , 0.   ,
       0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   ,
       0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.05 , 0.   ,
       0.   , 0.   , 0.   , 0.05 , 0.   , 0.   , 0.   , 0.   , 0.   ,
       0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   ,
       0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   ,
       0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   , 0.   ,
       0.   , 0.   , 0.   , 0.   , 0.   , 0.05 , 0.   , 0.   , 0.05 ]

    p_x, p_y, p_g = get_zero_padded_intensities(s_x, s_y, s_g, x_fit)

    assert np.allclose(ref_p_x, p_x)
    assert np.allclose(ref_p_y, p_y)
    assert np.allclose(ref_p_g, p_g)


def test_get_x_fit():

    # WS or GS work the same here
    cauchy_type = 'WS'
    x = [[1.15, 4, 6.1, 2.3, 9.8], [1.13, 4.15, 6.5, 2.4, 10]]
    s_x = [ 1.13,  1.15,  2.3 ,  2.4 ,  4.  ,  4.15,  6.1 ,  6.5 ,  9.8 , 10.  ]

    ref_x_fit = [ 0.9526,      1.0457798,   1.1389596,   1.23213939,  1.32531919,  1.41849899,
  1.51167879,  1.60485859,  1.69803838,  1.79121818,  1.88439798,  1.97757778,
  2.07075758,  2.16393737,  2.25711717,  2.35029697,  2.44347677,  2.53665657,
  2.62983636,  2.72301616,  2.81619596,  2.90937576,  3.00255556,  3.09573535,
  3.18891515,  3.28209495,  3.37527475,  3.46845455,  3.56163434,  3.65481414,
  3.74799394,  3.84117374,  3.93435354,  4.02753333,  4.12071313,  4.21389293,
  4.30707273,  4.40025253,  4.49343232,  4.58661212,  4.67979192,  4.77297172,
  4.86615152,  4.95933131,  5.05251111,  5.14569091,  5.23887071,  5.33205051,
  5.4252303 ,  5.5184101 ,  5.6115899 ,  5.7047697 ,  5.79794949,  5.89112929,
  5.98430909,  6.07748889,  6.17066869,  6.26384848,  6.35702828,  6.45020808,
  6.54338788,  6.63656768,  6.72974747,  6.82292727,  6.91610707,  7.00928687,
  7.10246667,  7.19564646,  7.28882626,  7.38200606,  7.47518586,  7.56836566,
  7.66154545,  7.75472525,  7.84790505,  7.94108485,  8.03426465,  8.12744444,
  8.22062424,  8.31380404,  8.40698384,  8.50016364,  8.59334343,  8.68652323,
  8.77970303,  8.87288283 , 8.96606263,  9.05924242,  9.15242222,  9.24560202,
  9.33878182,  9.43196162,  9.52514141,  9.61832121,  9.71150101,  9.80468081,
  9.89786061,  9.9910404,  10.0842202 , 10.1774    ]

    x_fit = get_x_fit(cauchy_type, x, s_x)

    assert np.allclose(ref_x_fit, x_fit)

    # Case for only one snapshot
    cauchy_type = 'This is the case for only one snapshot'
    x = [[1.15, 4, 6.1, 2.3, 9.8]]
    s_x = [1.15, 2.3 , 4.  , 6.1 , 9.8 ]

    ref_x_fit = [0.977,      1.24158824, 1.50617647, 1.77076471, 2.03535294, 2.29994118,
 2.56452941, 2.82911765, 3.09370588, 3.35829412, 3.62288235, 3.88747059,
 4.15205882, 4.41664706, 4.68123529, 4.94582353, 5.21041176, 5.475,
 5.73958824, 6.00417647, 6.26876471, 6.53335294, 6.79794118, 7.06252941,
 7.32711765, 7.59170588, 7.85629412, 8.12088235, 8.38547059, 8.65005882,
 8.91464706, 9.17923529, 9.44382353, 9.70841176, 9.973     ]


    x_fit = get_x_fit(cauchy_type, x, s_x)

    assert np.allclose(ref_x_fit, x_fit)


def test_get_sorted():

    sorted_a, sorted_b, sorted_c = get_sorted(all_a, all_b, all_c)

    assert np.allclose(s_a, sorted_a)
    assert np.allclose(s_b, sorted_b)
    assert np.allclose(s_c, sorted_c)

    c = [0.01]

    sorted_a, sorted_b, sorted_c = get_sorted(all_a, all_b, c)

    assert np.allclose(s_a, sorted_a)
    assert np.allclose(s_b, sorted_b)
    assert 1 == len(c)
    assert 0.01 == sorted_c[0]
