# Python interface to MIMIQ Circuits (`mimiqcircuits`)

*A library to handle quantum circuits for **QPerfect**'s MIMIQ Emulator.*

| **Documentation**                                                               | **Build Status**                                                                                |
|:-------------------------------------------------------------------------------:|:-----------------------------------------------------------------------------------------------:|
| [![][docs-stable-img]][docs-stable-url] [![][docs-dev-img]][docs-dev-url] | [![][GHA-img]][GHA-url] |

## Installation

```
pip install "mimiqcircuits @ git+https://github.com/qperfect-io/mimiqcircuits-python.git
````

## Documentation

- [**STABLE**][docs-stable-url] &mdash; **documentation of the most recently version.**

## Project Status

The package is tested against, and being developed for, Python 3.8 and above
on Linux, MacOS, and Windows.

*MIMIQ Circuits* is currently in the alpha stage and open to test for early
adopters. We are continuously refining and enhance our tools so we value any
feedback you may have to ensure that MIMIQ Circuits meets and exceeds your
expectations. If you want access to MIMIQ Circuits, we encourage you register
on [our website](https://qperfect.io/index.php/mimiq-circuits).

## Related projects

* [MimiqCircuits.jl](https://github.com/qperfect-io/MimiqCircuits.jl) the Julia version of this library.

## COPYRIGHT

Copyright © 2022-2023 University of Strasbourg. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

[docs-stable-img]: https://img.shields.io/badge/docs-stable-blue.svg
[docs-stable-url]: https://qperfect-io.github.io/mimiqcircuits-python/

[GHA-img]: https://github.com/qperfect-io/mimiqcircuits-python/workflows/test/badge.svg
[GHA-url]: https://github.com/qperfect-io/mimiqcircuits-python/actions?query=workflows/test
