# Generated by Django 4.1.6 on 2023-02-13 19:41

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):
    dependencies = [
        ("sites", "0002_alter_domain_unique"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("blogorama", "0001_initial"),
    ]

    operations = [
        migrations.AddField(
            model_name="comment",
            name="active",
            field=models.BooleanField(
                default=False,
                help_text="Auto managed field based on state criteria when saved.",
                verbose_name="Active",
            ),
        ),
        migrations.AddField(
            model_name="comment",
            name="post",
            field=models.ForeignKey(
                default=1,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="comments",
                to="blogorama.post",
                verbose_name="Post",
            ),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name="ban",
            name="created",
            field=models.DateTimeField(auto_now_add=True, verbose_name="Created"),
        ),
        migrations.AlterField(
            model_name="ban",
            name="expiration",
            field=models.DateTimeField(blank=True, null=True, verbose_name="Expiration"),
        ),
        migrations.AlterField(
            model_name="comment",
            name="content",
            field=models.TextField(verbose_name="Comment"),
        ),
        migrations.AlterField(
            model_name="comment",
            name="created",
            field=models.DateTimeField(auto_now_add=True, verbose_name="Created"),
        ),
        migrations.AlterField(
            model_name="comment",
            name="solution",
            field=models.BooleanField(
                default=False,
                help_text="This will tag a comment as an accepted solution if used.",
                verbose_name="Solution",
            ),
        ),
        migrations.AlterField(
            model_name="comment",
            name="state",
            field=models.IntegerField(
                choices=[(0, "Published"), (1, "Draft"), (2, "Archived")],
                default=1,
                help_text="What state is the writing in?",
                verbose_name="State",
            ),
        ),
        migrations.AlterField(
            model_name="comment",
            name="updated",
            field=models.DateTimeField(auto_now=True, verbose_name="Updated"),
        ),
        migrations.AlterField(
            model_name="flag",
            name="created",
            field=models.DateTimeField(auto_now_add=True, verbose_name="Created"),
        ),
        migrations.AlterField(
            model_name="flag",
            name="updated",
            field=models.DateTimeField(auto_now=True, verbose_name="Updated"),
        ),
        migrations.AlterField(
            model_name="post",
            name="active",
            field=models.BooleanField(
                default=False,
                help_text="Auto managed field based on state criteria when saved.",
                verbose_name="Active",
            ),
        ),
        migrations.AlterField(
            model_name="post",
            name="created",
            field=models.DateTimeField(auto_now_add=True, verbose_name="Created"),
        ),
        migrations.AlterField(
            model_name="post",
            name="hide_responses",
            field=models.BooleanField(
                default=False, help_text="Hide responses in display.", verbose_name="Hide Responses"
            ),
        ),
        migrations.AlterField(
            model_name="post",
            name="locked",
            field=models.BooleanField(
                default=False, help_text="Users can not add Comments or Replies.", verbose_name="Locked"
            ),
        ),
        migrations.AlterField(
            model_name="post",
            name="release_date",
            field=models.DateTimeField(auto_now_add=True, verbose_name="Updated"),
        ),
        migrations.AlterField(
            model_name="post",
            name="updated",
            field=models.DateTimeField(auto_now=True, verbose_name="Updated"),
        ),
        migrations.AlterField(
            model_name="postflag",
            name="created",
            field=models.DateTimeField(auto_now_add=True, verbose_name="Created"),
        ),
        migrations.AlterField(
            model_name="postflag",
            name="updated",
            field=models.DateTimeField(auto_now=True, verbose_name="Updated"),
        ),
        migrations.AlterField(
            model_name="rating",
            name="created",
            field=models.DateTimeField(auto_now_add=True, verbose_name="Created"),
        ),
        migrations.AlterField(
            model_name="rating",
            name="updated",
            field=models.DateTimeField(auto_now=True, verbose_name="Updated"),
        ),
        migrations.AlterField(
            model_name="save",
            name="created",
            field=models.DateTimeField(auto_now_add=True, verbose_name="Created"),
        ),
        migrations.AlterField(
            model_name="vote",
            name="updated",
            field=models.DateTimeField(auto_now=True, verbose_name="Updated"),
        ),
        migrations.CreateModel(
            name="Topic",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("created", models.DateTimeField(auto_now_add=True, verbose_name="Created")),
                ("updated", models.DateTimeField(auto_now=True, verbose_name="Updated")),
                ("title", models.CharField(help_text="Headline for the post.", max_length=120, verbose_name="Title")),
                ("slug", models.SlugField(blank=True, verbose_name="Slug")),
                ("active", models.BooleanField(verbose_name="Active")),
                (
                    "author",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="post_topics",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="User",
                    ),
                ),
                ("posts", models.ManyToManyField(to="blogorama.post", verbose_name="Posts")),
                (
                    "site",
                    models.ForeignKey(
                        help_text="Set which sites this Topic is available on",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="sites.site",
                    ),
                ),
            ],
        ),
    ]
