[![Build Status](https://dev.azure.com/Lumispy/lumispy/_apis/build/status/LumiSpy.lumispy?branchName=master)](https://dev.azure.com/Lumispy/lumispy/_build/latest?definitionId=3&branchName=master)
![Tests](https://github.com/lumispy/lumispy/workflows/Tests/badge.svg)
[![Codecov Status](https://codecov.io/gh/lumispy/lumispy/branch/master/graph/badge.svg?token=8ZFX8X4Z1I)](https://codecov.io/gh/lumispy/lumispy)

[![License: GPL v3](https://img.shields.io/badge/License-GPLv3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)
[![Python Version](https://img.shields.io/pypi/pyversions/lumispy.svg?style=flat)](https://pypi.python.org/pypi/lumispy)
[![PyPi Version](http://img.shields.io/pypi/v/lumispy.svg?style=flat)](https://pypi.python.org/pypi/lumispy)
[![DOI](https://zenodo.org/badge/222482347.svg)](https://zenodo.org/badge/latestdoi/222482347)

<img src="./doc/media/logo_rec_april21.svg" width="300" alt="LumiSpy">

LumiSpy is an extension Python package for multi-dimensional data analysis 
provided by the [HyperSpy](http://hyperspy.org) library. It is aimed at helping 
with the analysis of luminescence spectroscopy data (cathodoluminescence, 
photoluminescence, electroluminescence, Raman, SNOM).

If analysis using LumiSpy forms a part of published work please consider 
recognising the code development by citing the project using the [Zenodo-DOI](https://zenodo.org/badge/latestdoi/222482347).

Instructions on how to install LumiSpy and get started: [installation guide](INSTALLATION.md).

[Tutorials and example workflows](https://github.com/lumispy/lumispy-demos)
have been curated as a series of Jupyter notebooks that you can work through 
and modify to perform many common analyses. Simply:

1. Download the `lumispy_demos` repository in your desired folder
2. Load lumispy (as shown above)
3. In Jupyter lab, navigate to the folder and start using the notebook

Everyone is welcome to contribute. Please read our
[contributing guidelines](.github/CONTRIBUTING.md) and get started!
