# Developer Howto Guide

# Setup Machine

_Scripts Assumption: Bash Cli being used, for window developers install git-bash or wsl2_

- Install python 3.7+
- _recommended:_ Install vscode

# Build and Test

## Install Dependencies Locally

```bash
make install
```

## Install Eze CLI locally

build and install cli locally

```bash
make cli
```

### (or) Install Eze Source CLI locally

This will directly install the eze source locally

This is better for local development, as any development changes will immediately be reflected in the eze cli

```bash
pip install -e .
```

## Run Unit Tests

```bash
make lint
make test
```

## Snapshot Test Fixtures

For those unfamilar with snapshot testing, it's basically just a fixture framework for testing output against text blob
on the filesystem, with a easy mechanism to automatically update the blobs when the output changes

It's popular in the js react world when dealing with large html output that's being generated by layered systems.

Due to the emergent and brittle nature of cli output, eze uses snapshot testing for integration testing between multiple
components

uses pytest's plugin, which runs as part of the pytest runner

https://pypi.org/project/pytest-snapshot/

small assessment of snapshot testing

Advantages:

- fast to setup
- easy to update when things change
- excellent at testing emergent output with large inputs and human readable string outputs

Disadvantages:

- brittle
- smoke test

  _aka : fails don't mean something is broken, just something somewhere has changed_
- requires a human to review snapshot changes
- poor/inefficent at testing small pure functions with small inputs and small or non-string typed outputs

### Snapshot fixture location

All files will be stored in here

```
tests/__snapshots__
```

### Update pytest snapshot tests

out the box pytest's snapshot plugin is very easy to update, run this command to regenerate the fixtures after changes.

```bash
make test-snapshot-update
```

_ps remember to always manually check the diff before committing updated snapshots!_

## Bump Versiom

Version is stored in ``eze/__init__.py``, and we bump and tag the version when merging from "develop" to "main"

We use https://semver.org/ explaination:

Given a version number MAJOR.MINOR.PATCH

increment the:

- *MAJOR* version when you make incompatible API changes,
- *MINOR* version when you add functionality in a backwards compatible manner, and
- *PATCH* version when you make backwards compatible bug fixes.

## Build Local Development Docker Image

You can create a local docker image for development purposes, this can also be used to tailor/slim* the image to only contain the tools needed for your .ezerc.toml

_*Some tools for example semgrep are upto 200mb by themselves, tailoring the image will save signifact amounts of space_

```bash
make docker

# or create offline docker for air gapped testing
docker build . -f eze-cli.tar

# Run eze in docker (cmd)
docker run --rm -v %cd%:/data eze-cli --version

# Run eze in docker (powershell)
docker run --rm -v ${PWD}:/data eze-cli --version

# Run eze in docker (git bash)
docker run --rm -v $(pwd -W):/data eze-cli --version
```

## Build Release Docker Image
These steps are for building and releasing a offical eze image

```bash
# build pip release tar.gz
make cli

# create docker image
docker build . -t riversafe/eze-cli:`python eze/version.py` -t riversafe/eze-cli:latest

# release docker image to "riversafe/eze-cli"
docker push riversafe/eze-cli:`python eze/version.py`
docker push riversafe/eze-cli:latest
```

## Testing PyPi via Test

build wheel and upload via twine

_Warning: requires a unique version each upload_

```bash
make cli
twine upload --repository testpypi dist/*
```

can test via venv

```bash
python -m venv ~/.virtualenvs/eze-pip-test
source ~/.virtualenvs/eze-pip-test/Scripts/activate
pip install --index-url https://test.pypi.org/simple/ --extra-index-url https://pypi.org/simple eze-cli
```

## Tips and Tricks

### venv helpers

worth creating a dedicated env for eze so you don't pollute your globally install pip repos

create a specific env for eze

```bash
start-eze-env: python -m venv ~/.virtualenvs/eze-core
```

change to eze env

```bash
source ~/.virtualenvs/eze-core/Scripts/activate
```

stop eze env

```bash
deactivate
```

# Contribute Guide

See [CONTRIBUTING GUIDE](CONTRIBUTING.md)