import * as s3_assets from 'aws-cdk-lib/aws-s3-assets';
import { ProductStack } from './product-stack';
import { Construct } from 'constructs';
/**
 * (experimental) Represents the Product Provisioning Artifact Template.
 *
 * @experimental
 */
export declare abstract class CloudFormationTemplate {
    /**
     * (experimental) Template from URL.
     *
     * @param url The url that points to the provisioning artifacts template.
     * @experimental
     */
    static fromUrl(url: string): CloudFormationTemplate;
    /**
     * (experimental) Loads the provisioning artifacts template from a local disk path.
     *
     * @param path A file containing the provisioning artifacts.
     * @experimental
     */
    static fromAsset(path: string, options?: s3_assets.AssetOptions): CloudFormationTemplate;
    /**
     * (experimental) Creates a product with the resources defined in the given product stack.
     *
     * @experimental
     */
    static fromProductStack(productStack: ProductStack): CloudFormationTemplate;
    /**
     * (experimental) Called when the product is initialized to allow this object to bind to the stack, add resources and have fun.
     *
     * @param scope The binding scope.
     * @experimental
     */
    abstract bind(scope: Construct): CloudFormationTemplateConfig;
}
/**
 * (experimental) Result of binding `Template` into a `Product`.
 *
 * @experimental
 */
export interface CloudFormationTemplateConfig {
    /**
     * (experimental) The http url of the template in S3.
     *
     * @experimental
     */
    readonly httpUrl: string;
}
