# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/time_transform.ipynb.

# %% auto 0
__all__ = ['CalendarTimeTransform', 'PeriodicTimeTransform', 'make_time_transform', 'get_time_ft_columns']

# %% ../nbs/time_transform.ipynb 3
import numpy as np
import pandas as pd
from sklearn.preprocessing import OneHotEncoder
import holidays

from . import defaults as dflt

# %% ../nbs/time_transform.ipynb 5
class CalendarTimeTransform ():
    
    default_time_ft_columns = [f'day_{x}' for x in range(7)] + ['holidays']
    
    def __init__ (self, country_holidays=dflt.country_holidays):
        self.one_hot_encoder = OneHotEncoder (categories=[list(range(7))], sparse_output=False)
        if country_holidays is not None:
            self.country_holidays = holidays.country_holidays(country_holidays)
        else:
            self.country_holidays = None
    def transform (self, df):
        day_of_week = df.index.to_series().dt.dayofweek.values.reshape(-1,1)
        df_day_of_week = pd.DataFrame (self.one_hot_encoder.fit_transform (day_of_week), 
                                       columns=[f'day_{x}' for x in range(7)],
                                       index=df.index)
            
        if self.country_holidays is not None:
            df_holidays = pd.DataFrame ([int(day in self.country_holidays) for day in df.index],
                            columns=['holidays'],
                            index=df.index)
            df = pd.concat ([df, df_day_of_week, df_holidays], axis=1)
        else:
            df = pd.concat ([df, df_day_of_week], axis=1)
        return df

# %% ../nbs/time_transform.ipynb 10
class PeriodicTimeTransform ():
    default_time_ft_columns = [f'{k}_sin' for k in dflt.periods] + [f'{k}_cos' for k in dflt.periods]
    def __init__ (self, periods=dflt.periods):
        self.periods = periods
        self.time_ft_columns = [f'{k}_sin' for k in periods] + [f'{k}_cos' for k in periods]
    def transform (self, df):
        timestamp_s = df.index.map(pd.Timestamp.timestamp)
        for k, v in self.periods.items():
            df[f'{k}_sin'] = np.sin(timestamp_s * (2 * np.pi / v))
            df[f'{k}_cos'] = np.cos(timestamp_s * (2 * np.pi / v))
        return df

# %% ../nbs/time_transform.ipynb 17
def make_time_transform (time_transform=dflt.time_transform, **kwargs):
    TimeTransform = eval (time_transform)
    return TimeTransform (**kwargs)

# %% ../nbs/time_transform.ipynb 19
def get_time_ft_columns (time_transform=dflt.time_transform, **kwargs):
    TimeTransform = eval (time_transform)
    return getattr (TimeTransform, 'default_time_ft_columns', None)
