# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/defaults.ipynb.

# %% auto 0
__all__ = ['test_path', 'data_url', 'target_col', 'save_path', 'time_transform', 'country_holidays', 'day', 'periods',
           'input_width', 'target_width', 'shift', 'target_columns', 'time_ft_columns', 'batch_size', 'model_class',
           'patience', 'epochs', 'learning_rate', 'verbose', 'units', 'out_steps', 'dropout', 'recurrent_dropout',
           'lstm_regularizer_type', 'lstm_regularizer_magnitude', 'dense_regularizer_type',
           'dense_regularizer_magnitude', 'dataset', 'split_ratios', 'freq', 'freq_name', 'freq_units',
           'path_experiments']

# %% ../nbs/defaults.ipynb 3
from pathlib import Path

# %% ../nbs/defaults.ipynb 5
# Test data
test_path = Path('test_data') if Path('test_data').exists() else Path('../test_data')

# %% ../nbs/defaults.ipynb 7
# DataSet
data_url = 'https://archive.ics.uci.edu/ml/machine-learning-databases/00352/Online%20Retail.xlsx'
target_col = 'TotalPrice'
save_path = 'uci_retail_dataset/dataset.parquet'

# %% ../nbs/defaults.ipynb 9
# TimeTransform
time_transform = 'PeriodicTimeTransform'

# %% ../nbs/defaults.ipynb 11
# CalendarTimeTransform
country_holidays = 'UK'

# %% ../nbs/defaults.ipynb 13
# PeriodicTimeTransform
day = 24*60*60
periods = dict (week = 7 * day,
                half_week = 3.5*day,
                two_days_approx = 2.2*day)

# %% ../nbs/defaults.ipynb 15
# WindowGenerator
input_width = 28
target_width = 28
shift = target_width
target_columns = [target_col]
time_ft_columns = [f'{k}_sin' for k in periods] + [f'{k}_cos' for k in periods]
batch_size = 32

# %% ../nbs/defaults.ipynb 17
# Model 
model_class = 'FeedBackWithTimeFeatures'
patience = 2
epochs = 20
learning_rate = 1e-3
verbose = 0

# %% ../nbs/defaults.ipynb 19
# FeedBackWithTimeFeatures
units = 32
out_steps = target_width
dropout = 0.0
recurrent_dropout = 0.0
lstm_regularizer_type=None
lstm_regularizer_magnitude=0.0
dense_regularizer_type=None
dense_regularizer_magnitude=0.0

# %% ../nbs/defaults.ipynb 21
# ForecastingPipeline
dataset = 'UCIRetailDataSet'
split_ratios = dict (training=0.7,
                     validation=0.15,
                     test=0.15)
freq = 'D'
freq_name = 'days'
freq_units = 1

# %% ../nbs/defaults.ipynb 23
# Hyper-parameter search
path_experiments = 'hp_search/val_test_evaluation'
