# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/dataset.ipynb.

# %% auto 0
__all__ = ['UCIRetailDataSet']

# %% ../nbs/dataset.ipynb 3
from pathlib import Path

import numpy as np
import pandas as pd
import tensorflow as tf

from . import defaults as dflt

# %% ../nbs/dataset.ipynb 4
class UCIRetailDataSet ():
    """Class for loading the dataset and put it in required format.
    
    It also performs dataset-specific tasks such as cleaning the data or reformating it.
    """
    def __init__ (self, 
                  url=dflt.data_url,
                  target_col=dflt.target_col,
                  save_path=dflt.save_path,
                  save_flag=True):
        self.url = url
        self.fname = str(Path(url).name)
        self.target_col = target_col
        self.save_path = Path(save_path)
        self.save_flag = save_flag
    
    def load (self):
        if not self.save_path.exists():
            file_path = tf.keras.utils.get_file(
                origin=self.url,
                fname=self.fname,
                extract=False)
            df = pd.read_excel (file_path, 
                                dtype=dict(InvoiceNo=str,
                                           StockCode=str,
                                           Description=str,
                                           Country=str))
            if self.save_flag:
                self.save_path.parent.mkdir (parents=True, exist_ok=True)
                df.to_parquet (self.save_path)
        else:
            df = pd.read_parquet (self.save_path)
        return df
    
    def clean_and_format (self, df):
        # TODO: convert british pounds to euros
        df[self.target_col] = df['Quantity'] * df['UnitPrice']
        df = df[(df[self.target_col] >= 0) | (df.Description == 'Discount')]
        df = df.set_index('InvoiceDate')
        df = df.resample('1D').agg({self.target_col:'sum'})
        return df
