"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The Datasets API is still in alpha, and we're updating it often to add new functionality, iron out bugs and enhance usability. For some larger downloads, you may want to download a [dehydrated bag](https://www.ncbi.nlm.nih.gov/datasets/docs/v1/how-tos/genomes/large-download/), and retrieve the individual data files at a later time.   # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from ncbi.datasets.openapi.api_client import ApiClient, Endpoint as _Endpoint
from ncbi.datasets.openapi.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from ncbi.datasets.openapi.model.rpc_status import RpcStatus
from ncbi.datasets.openapi.model.v1_download_summary import V1DownloadSummary
from ncbi.datasets.openapi.model.v1_fasta import V1Fasta
from ncbi.datasets.openapi.model.v1_gene_dataset_request import V1GeneDatasetRequest
from ncbi.datasets.openapi.model.v1_gene_dataset_request_content_type import V1GeneDatasetRequestContentType
from ncbi.datasets.openapi.model.v1_gene_dataset_request_sort_field import V1GeneDatasetRequestSortField
from ncbi.datasets.openapi.model.v1_gene_match import V1GeneMatch
from ncbi.datasets.openapi.model.v1_gene_metadata import V1GeneMetadata
from ncbi.datasets.openapi.model.v1_organism import V1Organism
from ncbi.datasets.openapi.model.v1_organism_query_request_tax_rank_filter import V1OrganismQueryRequestTaxRankFilter
from ncbi.datasets.openapi.model.v1_ortholog_request_content_type import V1OrthologRequestContentType
from ncbi.datasets.openapi.model.v1_ortholog_set import V1OrthologSet
from ncbi.datasets.openapi.model.v1_sci_name_and_ids import V1SciNameAndIds
from ncbi.datasets.openapi.model.v1_sort_direction import V1SortDirection


class GeneApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.download_gene_package_endpoint = _Endpoint(
            settings={
                'response_type': (file_type,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/gene/id/{gene_ids}/download',
                'operation_id': 'download_gene_package',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'gene_ids',
                    'include_annotation_type',
                    'fasta_filter',
                    'filename',
                ],
                'required': [
                    'gene_ids',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'gene_ids':
                        ([int],),
                    'include_annotation_type':
                        ([V1Fasta],),
                    'fasta_filter':
                        ([str],),
                    'filename':
                        (str,),
                },
                'attribute_map': {
                    'gene_ids': 'gene_ids',
                    'include_annotation_type': 'include_annotation_type',
                    'fasta_filter': 'fasta_filter',
                    'filename': 'filename',
                },
                'location_map': {
                    'gene_ids': 'path',
                    'include_annotation_type': 'query',
                    'fasta_filter': 'query',
                    'filename': 'query',
                },
                'collection_format_map': {
                    'gene_ids': 'csv',
                    'include_annotation_type': 'multi',
                    'fasta_filter': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/zip',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.download_gene_package_post_endpoint = _Endpoint(
            settings={
                'response_type': (file_type,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/gene/download',
                'operation_id': 'download_gene_package_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'v1_gene_dataset_request',
                    'filename',
                ],
                'required': [
                    'v1_gene_dataset_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'v1_gene_dataset_request':
                        (V1GeneDatasetRequest,),
                    'filename':
                        (str,),
                },
                'attribute_map': {
                    'filename': 'filename',
                },
                'location_map': {
                    'v1_gene_dataset_request': 'body',
                    'filename': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/zip',
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.gene_download_summary_by_accession_endpoint = _Endpoint(
            settings={
                'response_type': (V1DownloadSummary,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/gene/accession/{accessions}/download_summary',
                'operation_id': 'gene_download_summary_by_accession',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'accessions',
                    'fasta_filter',
                ],
                'required': [
                    'accessions',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'accessions':
                        ([str],),
                    'fasta_filter':
                        ([str],),
                },
                'attribute_map': {
                    'accessions': 'accessions',
                    'fasta_filter': 'fasta_filter',
                },
                'location_map': {
                    'accessions': 'path',
                    'fasta_filter': 'query',
                },
                'collection_format_map': {
                    'accessions': 'csv',
                    'fasta_filter': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.gene_download_summary_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (V1DownloadSummary,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/gene/id/{gene_ids}/download_summary',
                'operation_id': 'gene_download_summary_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'gene_ids',
                    'fasta_filter',
                ],
                'required': [
                    'gene_ids',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'gene_ids':
                        ([int],),
                    'fasta_filter':
                        ([str],),
                },
                'attribute_map': {
                    'gene_ids': 'gene_ids',
                    'fasta_filter': 'fasta_filter',
                },
                'location_map': {
                    'gene_ids': 'path',
                    'fasta_filter': 'query',
                },
                'collection_format_map': {
                    'gene_ids': 'csv',
                    'fasta_filter': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.gene_download_summary_by_post_endpoint = _Endpoint(
            settings={
                'response_type': (V1DownloadSummary,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/gene/download_summary',
                'operation_id': 'gene_download_summary_by_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'v1_gene_dataset_request',
                ],
                'required': [
                    'v1_gene_dataset_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'v1_gene_dataset_request':
                        (V1GeneDatasetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'v1_gene_dataset_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.gene_download_summary_by_tax_and_symbol_endpoint = _Endpoint(
            settings={
                'response_type': (V1DownloadSummary,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/gene/symbol/{symbols}/taxon/{taxon}/download_summary',
                'operation_id': 'gene_download_summary_by_tax_and_symbol',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'symbols',
                    'taxon',
                    'fasta_filter',
                ],
                'required': [
                    'symbols',
                    'taxon',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'symbols':
                        ([str],),
                    'taxon':
                        (str,),
                    'fasta_filter':
                        ([str],),
                },
                'attribute_map': {
                    'symbols': 'symbols',
                    'taxon': 'taxon',
                    'fasta_filter': 'fasta_filter',
                },
                'location_map': {
                    'symbols': 'path',
                    'taxon': 'path',
                    'fasta_filter': 'query',
                },
                'collection_format_map': {
                    'symbols': 'csv',
                    'fasta_filter': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.gene_metadata_by_accession_endpoint = _Endpoint(
            settings={
                'response_type': (V1GeneMetadata,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/gene/accession/{accessions}',
                'operation_id': 'gene_metadata_by_accession',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'accessions',
                    'returned_content',
                    'sort_schema_field',
                    'sort_schema_direction',
                    'limit',
                ],
                'required': [
                    'accessions',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'accessions':
                        ([str],),
                    'returned_content':
                        (V1GeneDatasetRequestContentType,),
                    'sort_schema_field':
                        (V1GeneDatasetRequestSortField,),
                    'sort_schema_direction':
                        (V1SortDirection,),
                    'limit':
                        (str,),
                },
                'attribute_map': {
                    'accessions': 'accessions',
                    'returned_content': 'returned_content',
                    'sort_schema_field': 'sort_schema.field',
                    'sort_schema_direction': 'sort_schema.direction',
                    'limit': 'limit',
                },
                'location_map': {
                    'accessions': 'path',
                    'returned_content': 'query',
                    'sort_schema_field': 'query',
                    'sort_schema_direction': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                    'accessions': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.gene_metadata_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (V1GeneMetadata,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/gene/id/{gene_ids}',
                'operation_id': 'gene_metadata_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'gene_ids',
                    'returned_content',
                    'sort_schema_field',
                    'sort_schema_direction',
                    'limit',
                ],
                'required': [
                    'gene_ids',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'gene_ids':
                        ([int],),
                    'returned_content':
                        (V1GeneDatasetRequestContentType,),
                    'sort_schema_field':
                        (V1GeneDatasetRequestSortField,),
                    'sort_schema_direction':
                        (V1SortDirection,),
                    'limit':
                        (str,),
                },
                'attribute_map': {
                    'gene_ids': 'gene_ids',
                    'returned_content': 'returned_content',
                    'sort_schema_field': 'sort_schema.field',
                    'sort_schema_direction': 'sort_schema.direction',
                    'limit': 'limit',
                },
                'location_map': {
                    'gene_ids': 'path',
                    'returned_content': 'query',
                    'sort_schema_field': 'query',
                    'sort_schema_direction': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                    'gene_ids': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.gene_metadata_by_post_endpoint = _Endpoint(
            settings={
                'response_type': (V1GeneMetadata,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/gene',
                'operation_id': 'gene_metadata_by_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'v1_gene_dataset_request',
                ],
                'required': [
                    'v1_gene_dataset_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'v1_gene_dataset_request':
                        (V1GeneDatasetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'v1_gene_dataset_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.gene_metadata_by_tax_and_symbol_endpoint = _Endpoint(
            settings={
                'response_type': (V1GeneMetadata,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/gene/symbol/{symbols}/taxon/{taxon}',
                'operation_id': 'gene_metadata_by_tax_and_symbol',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'symbols',
                    'taxon',
                    'accessions',
                    'returned_content',
                    'sort_schema_field',
                    'sort_schema_direction',
                    'limit',
                ],
                'required': [
                    'symbols',
                    'taxon',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'symbols':
                        ([str],),
                    'taxon':
                        (str,),
                    'accessions':
                        ([str],),
                    'returned_content':
                        (V1GeneDatasetRequestContentType,),
                    'sort_schema_field':
                        (V1GeneDatasetRequestSortField,),
                    'sort_schema_direction':
                        (V1SortDirection,),
                    'limit':
                        (str,),
                },
                'attribute_map': {
                    'symbols': 'symbols',
                    'taxon': 'taxon',
                    'accessions': 'accessions',
                    'returned_content': 'returned_content',
                    'sort_schema_field': 'sort_schema.field',
                    'sort_schema_direction': 'sort_schema.direction',
                    'limit': 'limit',
                },
                'location_map': {
                    'symbols': 'path',
                    'taxon': 'path',
                    'accessions': 'query',
                    'returned_content': 'query',
                    'sort_schema_field': 'query',
                    'sort_schema_direction': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                    'symbols': 'csv',
                    'accessions': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.gene_metadata_stream_by_post_endpoint = _Endpoint(
            settings={
                'response_type': (V1GeneMatch,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/gene/stream',
                'operation_id': 'gene_metadata_stream_by_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'v1_gene_dataset_request',
                ],
                'required': [
                    'v1_gene_dataset_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'v1_gene_dataset_request':
                        (V1GeneDatasetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'v1_gene_dataset_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/x-ndjson',
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.gene_orthologs_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (V1OrthologSet,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/gene/id/{gene_id}/orthologs',
                'operation_id': 'gene_orthologs_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'gene_id',
                    'returned_content',
                    'taxon_filter',
                ],
                'required': [
                    'gene_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'gene_id':
                        (int,),
                    'returned_content':
                        (V1OrthologRequestContentType,),
                    'taxon_filter':
                        ([str],),
                },
                'attribute_map': {
                    'gene_id': 'gene_id',
                    'returned_content': 'returned_content',
                    'taxon_filter': 'taxon_filter',
                },
                'location_map': {
                    'gene_id': 'path',
                    'returned_content': 'query',
                    'taxon_filter': 'query',
                },
                'collection_format_map': {
                    'taxon_filter': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.gene_tax_name_query_endpoint = _Endpoint(
            settings={
                'response_type': (V1SciNameAndIds,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/gene/taxon_suggest/{taxon_query}',
                'operation_id': 'gene_tax_name_query',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'taxon_query',
                    'tax_rank_filter',
                ],
                'required': [
                    'taxon_query',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'taxon_query':
                        (str,),
                    'tax_rank_filter':
                        (V1OrganismQueryRequestTaxRankFilter,),
                },
                'attribute_map': {
                    'taxon_query': 'taxon_query',
                    'tax_rank_filter': 'tax_rank_filter',
                },
                'location_map': {
                    'taxon_query': 'path',
                    'tax_rank_filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.gene_tax_tree_endpoint = _Endpoint(
            settings={
                'response_type': (V1Organism,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/gene/taxon/{taxon}/tree',
                'operation_id': 'gene_tax_tree',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'taxon',
                    'children_only',
                ],
                'required': [
                    'taxon',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'taxon':
                        (str,),
                    'children_only':
                        (bool,),
                },
                'attribute_map': {
                    'taxon': 'taxon',
                    'children_only': 'children_only',
                },
                'location_map': {
                    'taxon': 'path',
                    'children_only': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def download_gene_package(
        self,
        gene_ids,
        **kwargs
    ):
        """Get a gene dataset by gene ID  # noqa: E501

        Get a gene dataset including gene, transcript and protein fasta sequence, annotation and metadata by gene ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.download_gene_package(gene_ids, async_req=True)
        >>> result = thread.get()

        Args:
            gene_ids ([int]): NCBI gene ids

        Keyword Args:
            include_annotation_type ([V1Fasta]): Select additional types of annotation to include in the data package.  If unset, no annotation is provided.. [optional]
            fasta_filter ([str]): Limit the FASTA sequences in the datasets package to these transcript and protein accessions. [optional]
            filename (str): Output file name.. [optional] if omitted the server will use the default value of "ncbi_dataset.zip"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            file_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['gene_ids'] = \
            gene_ids
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.download_gene_package_endpoint.call_with_http_info(**kwargs)

    def download_gene_package_post(
        self,
        v1_gene_dataset_request,
        **kwargs
    ):
        """Get a gene dataset by POST  # noqa: E501

        Get a gene dataset including gene, transcript and protein fasta sequence, annotation and metadata by POST.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.download_gene_package_post(v1_gene_dataset_request, async_req=True)
        >>> result = thread.get()

        Args:
            v1_gene_dataset_request (V1GeneDatasetRequest):

        Keyword Args:
            filename (str): Output file name.. [optional] if omitted the server will use the default value of "ncbi_dataset.zip"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            file_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['v1_gene_dataset_request'] = \
            v1_gene_dataset_request
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.download_gene_package_post_endpoint.call_with_http_info(**kwargs)

    def gene_download_summary_by_accession(
        self,
        accessions,
        **kwargs
    ):
        """Get gene download summary by RefSeq Accession  # noqa: E501

        Get gene download summary by RefSeq Accession in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gene_download_summary_by_accession(accessions, async_req=True)
        >>> result = thread.get()

        Args:
            accessions ([str]): RNA or Protein accessions.

        Keyword Args:
            fasta_filter ([str]): Limit the FASTA sequences in the datasets package to these transcript and protein accessions. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1DownloadSummary
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['accessions'] = \
            accessions
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.gene_download_summary_by_accession_endpoint.call_with_http_info(**kwargs)

    def gene_download_summary_by_id(
        self,
        gene_ids,
        **kwargs
    ):
        """Get gene download summary by GeneID  # noqa: E501

        Get a download summary by GeneID in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gene_download_summary_by_id(gene_ids, async_req=True)
        >>> result = thread.get()

        Args:
            gene_ids ([int]): NCBI gene ids

        Keyword Args:
            fasta_filter ([str]): Limit the FASTA sequences in the datasets package to these transcript and protein accessions. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1DownloadSummary
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['gene_ids'] = \
            gene_ids
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.gene_download_summary_by_id_endpoint.call_with_http_info(**kwargs)

    def gene_download_summary_by_post(
        self,
        v1_gene_dataset_request,
        **kwargs
    ):
        """Get gene download summary  # noqa: E501

        Get gene download summary in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gene_download_summary_by_post(v1_gene_dataset_request, async_req=True)
        >>> result = thread.get()

        Args:
            v1_gene_dataset_request (V1GeneDatasetRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1DownloadSummary
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['v1_gene_dataset_request'] = \
            v1_gene_dataset_request
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.gene_download_summary_by_post_endpoint.call_with_http_info(**kwargs)

    def gene_download_summary_by_tax_and_symbol(
        self,
        symbols,
        taxon,
        **kwargs
    ):
        """Get gene download summary by gene symbol  # noqa: E501

        Get gene download summary by gene symbol in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gene_download_summary_by_tax_and_symbol(symbols, taxon, async_req=True)
        >>> result = thread.get()

        Args:
            symbols ([str]): Gene symbol
            taxon (str): Taxon for provided gene symbol

        Keyword Args:
            fasta_filter ([str]): Limit the FASTA sequences in the datasets package to these transcript and protein accessions. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1DownloadSummary
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['symbols'] = \
            symbols
        kwargs['taxon'] = \
            taxon
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.gene_download_summary_by_tax_and_symbol_endpoint.call_with_http_info(**kwargs)

    def gene_metadata_by_accession(
        self,
        accessions,
        **kwargs
    ):
        """Get gene metadata by RefSeq Accession  # noqa: E501

        Get detailed gene metadata by RefSeq Accession in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gene_metadata_by_accession(accessions, async_req=True)
        >>> result = thread.get()

        Args:
            accessions ([str]): RNA or Protein accessions.

        Keyword Args:
            returned_content (V1GeneDatasetRequestContentType): Return either gene-ids, or entire gene metadata. [optional]
            sort_schema_field (V1GeneDatasetRequestSortField): Select a field to sort on.. [optional]
            sort_schema_direction (V1SortDirection): Select a direction for the sort.. [optional]
            limit (str): Limit the number of returned results (\"all\", \"none\", otherwise an integer value). [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1GeneMetadata
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['accessions'] = \
            accessions
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.gene_metadata_by_accession_endpoint.call_with_http_info(**kwargs)

    def gene_metadata_by_id(
        self,
        gene_ids,
        **kwargs
    ):
        """Get gene metadata by GeneID  # noqa: E501

        Get detailed gene metadata by GeneID in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gene_metadata_by_id(gene_ids, async_req=True)
        >>> result = thread.get()

        Args:
            gene_ids ([int]): NCBI gene ids

        Keyword Args:
            returned_content (V1GeneDatasetRequestContentType): Return either gene-ids, or entire gene metadata. [optional]
            sort_schema_field (V1GeneDatasetRequestSortField): Select a field to sort on.. [optional]
            sort_schema_direction (V1SortDirection): Select a direction for the sort.. [optional]
            limit (str): Limit the number of returned results (\"all\", \"none\", otherwise an integer value). [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1GeneMetadata
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['gene_ids'] = \
            gene_ids
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.gene_metadata_by_id_endpoint.call_with_http_info(**kwargs)

    def gene_metadata_by_post(
        self,
        v1_gene_dataset_request,
        **kwargs
    ):
        """Get gene metadata as JSON  # noqa: E501

        Get detailed gene metadata in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gene_metadata_by_post(v1_gene_dataset_request, async_req=True)
        >>> result = thread.get()

        Args:
            v1_gene_dataset_request (V1GeneDatasetRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1GeneMetadata
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['v1_gene_dataset_request'] = \
            v1_gene_dataset_request
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.gene_metadata_by_post_endpoint.call_with_http_info(**kwargs)

    def gene_metadata_by_tax_and_symbol(
        self,
        symbols,
        taxon,
        **kwargs
    ):
        """Get gene metadata by gene symbol  # noqa: E501

        Get detailed gene metadata by gene symbol in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gene_metadata_by_tax_and_symbol(symbols, taxon, async_req=True)
        >>> result = thread.get()

        Args:
            symbols ([str]): Gene symbol
            taxon (str): Taxon for provided gene symbol

        Keyword Args:
            accessions ([str]): RNA or Protein accessions.. [optional]
            returned_content (V1GeneDatasetRequestContentType): Return either gene-ids, or entire gene metadata. [optional]
            sort_schema_field (V1GeneDatasetRequestSortField): Select a field to sort on.. [optional]
            sort_schema_direction (V1SortDirection): Select a direction for the sort.. [optional]
            limit (str): Limit the number of returned results (\"all\", \"none\", otherwise an integer value). [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1GeneMetadata
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['symbols'] = \
            symbols
        kwargs['taxon'] = \
            taxon
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.gene_metadata_by_tax_and_symbol_endpoint.call_with_http_info(**kwargs)

    def gene_metadata_stream_by_post(
        self,
        v1_gene_dataset_request,
        **kwargs
    ):
        """Get gene metadata  # noqa: E501

        Get detailed gene metadata in a streaming, JSON-lines output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gene_metadata_stream_by_post(v1_gene_dataset_request, async_req=True)
        >>> result = thread.get()

        Args:
            v1_gene_dataset_request (V1GeneDatasetRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1GeneMatch
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['v1_gene_dataset_request'] = \
            v1_gene_dataset_request
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.gene_metadata_stream_by_post_endpoint.call_with_http_info(**kwargs)

    def gene_orthologs_by_id(
        self,
        gene_id,
        **kwargs
    ):
        """Get gene orthologs by gene ID  # noqa: E501

        Get detailed gene metadata for an ortholog set by gene ID in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gene_orthologs_by_id(gene_id, async_req=True)
        >>> result = thread.get()

        Args:
            gene_id (int):

        Keyword Args:
            returned_content (V1OrthologRequestContentType): Return either gene-ids, or entire gene metadata. [optional]
            taxon_filter ([str]): Filter genes by taxa. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1OrthologSet
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['gene_id'] = \
            gene_id
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.gene_orthologs_by_id_endpoint.call_with_http_info(**kwargs)

    def gene_tax_name_query(
        self,
        taxon_query,
        **kwargs
    ):
        """Get a list of taxonomy names and IDs found in the gene dataset given a partial taxonomic name  # noqa: E501

        This endpoint retrieves a list of taxonomy names and IDs found in the gene dataset given a partial taxonomic name of any rank.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gene_tax_name_query(taxon_query, async_req=True)
        >>> result = thread.get()

        Args:
            taxon_query (str): NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank

        Keyword Args:
            tax_rank_filter (V1OrganismQueryRequestTaxRankFilter): Set the scope of searched tax ranks. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1SciNameAndIds
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['taxon_query'] = \
            taxon_query
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.gene_tax_name_query_endpoint.call_with_http_info(**kwargs)

    def gene_tax_tree(
        self,
        taxon,
        **kwargs
    ):
        """Get a taxonomic subtree by taxonomic identifier  # noqa: E501

        Using an NCBI Taxonomy ID or name (common or scientific) at any rank, get a subtree filtered for species with assembled genomes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gene_tax_tree(taxon, async_req=True)
        >>> result = thread.get()

        Args:
            taxon (str): NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank

        Keyword Args:
            children_only (bool): Only report the children of the requested taxon and not their descendants. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1Organism
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['taxon'] = \
            taxon
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.gene_tax_tree_endpoint.call_with_http_info(**kwargs)

