# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import IO, Optional, TYPE_CHECKING, Union, overload

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .. import models as _models
from .._serialization import Serializer
from .._vendor import _convert_request, _format_url_section

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, List, Optional, TypeVar
    T = TypeVar('T')
    ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False
# fmt: off

def build_list_customers_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    page_size = kwargs.pop('page_size', _params.pop('pageSize', 100))  # type: int
    continuation_token_parameter = kwargs.pop('continuation_token_parameter', _params.pop('continuationToken', None))  # type: Optional[str]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/customers")

    # Construct parameters
    if page_size is not None:
        _params['pageSize'] = _SERIALIZER.query("page_size", page_size, 'int')
    if continuation_token_parameter is not None:
        _params['continuationToken'] = _SERIALIZER.query("continuation_token_parameter", continuation_token_parameter, 'str')

    # Construct headers
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        params=_params,
        headers=_headers,
        **kwargs
    )


def build_create_customer_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/customers")

    # Construct headers
    if content_type is not None:
        _headers['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_get_customer_request(
    id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/customers/{id}")
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_update_customer_request(
    id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/customers/{id}")
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_list_customer_tenants_request(
    id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/customers/{id}/tenants")
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_create_tenant_request(
    id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/customers/{id}/tenants")
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_update_tenant_request(
    id,  # type: str
    tenant_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/customers/{id}/tenants/{tenantId}")
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, 'str'),
        "tenantId": _SERIALIZER.url("tenant_id", tenant_id, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_get_cdf_config_request(
    id,  # type: str
    tenant_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/customers/{id}/tenants/{tenantId}/config")
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, 'str'),
        "tenantId": _SERIALIZER.url("tenant_id", tenant_id, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_update_cdf_config_request(
    id,  # type: str
    tenant_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/customers/{id}/tenants/{tenantId}/config")
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, 'str'),
        "tenantId": _SERIALIZER.url("tenant_id", tenant_id, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_list_customer_apps_request(
    id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/customers/{id}/apps")
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_add_customer_app_request(
    id,  # type: str
    app_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    # Construct URL
    _url = kwargs.pop("template_url", "/customers/{id}/apps/{appId}")
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, 'str'),
        "appId": _SERIALIZER.url("app_id", app_id, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    return HttpRequest(
        method="POST",
        url=_url,
        **kwargs
    )


def build_remove_customer_app_request(
    id,  # type: str
    app_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    # Construct URL
    _url = kwargs.pop("template_url", "/customers/{id}/apps/{appId}")
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, 'str'),
        "appId": _SERIALIZER.url("app_id", app_id, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    return HttpRequest(
        method="DELETE",
        url=_url,
        **kwargs
    )


def build_list_tenant_keys_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/customers/tenantkeys")

    # Construct headers
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        headers=_headers,
        **kwargs
    )

# fmt: on
class CustomersOperations(object):
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.IgnosInternalApi`'s
        :attr:`customers` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")


    @distributed_trace
    def list_customers(
        self,
        page_size=100,  # type: int
        continuation_token_parameter=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> List[_models.IgnosCustomerDto]
        """Internal Ignos api for listing customers.

        Internal Ignos api for listing customers.

        :param page_size: Default value is 100.
        :type page_size: int
        :param continuation_token_parameter: Default value is None.
        :type continuation_token_parameter: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of IgnosCustomerDto or the result of cls(response)
        :rtype: list[~ignos.internal.api.client.models.IgnosCustomerDto]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[List[_models.IgnosCustomerDto]]

        
        request = build_list_customers_request(
            page_size=page_size,
            continuation_token_parameter=continuation_token_parameter,
            template_url=self.list_customers.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize('[IgnosCustomerDto]', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_customers.metadata = {'url': "/customers"}  # type: ignore


    @overload
    def create_customer(
        self,
        body=None,  # type: Optional[_models.CreateIgnosCustomer]
        **kwargs  # type: Any
    ):
        # type: (...) -> _models.IgnosCustomerDto
        """Internal Ignos api for creating a customer.

        Internal Ignos api for creating a customer.

        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.CreateIgnosCustomer
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IgnosCustomerDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.IgnosCustomerDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def create_customer(
        self,
        body=None,  # type: Optional[IO]
        **kwargs  # type: Any
    ):
        # type: (...) -> _models.IgnosCustomerDto
        """Internal Ignos api for creating a customer.

        Internal Ignos api for creating a customer.

        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IgnosCustomerDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.IgnosCustomerDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """


    @distributed_trace
    def create_customer(
        self,
        body=None,  # type: Optional[Union[_models.CreateIgnosCustomer, IO]]
        **kwargs  # type: Any
    ):
        # type: (...) -> _models.IgnosCustomerDto
        """Internal Ignos api for creating a customer.

        Internal Ignos api for creating a customer.

        :param body: Is either a model type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.CreateIgnosCustomer or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IgnosCustomerDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.IgnosCustomerDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.IgnosCustomerDto]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, 'CreateIgnosCustomer')
            else:
                _json = None

        request = build_create_customer_request(
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_customer.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize('IgnosCustomerDto', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_customer.metadata = {'url': "/customers"}  # type: ignore


    @distributed_trace
    def get_customer(
        self,
        id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> _models.IgnosCustomerDto
        """Internal Ignos api for getting a customer.

        Internal Ignos api for getting a customer.

        :param id: Required.
        :type id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IgnosCustomerDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.IgnosCustomerDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[_models.IgnosCustomerDto]

        
        request = build_get_customer_request(
            id=id,
            template_url=self.get_customer.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize('IgnosCustomerDto', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_customer.metadata = {'url': "/customers/{id}"}  # type: ignore


    @overload
    def update_customer(
        self,
        id,  # type: str
        body=None,  # type: Optional[_models.UpdateCustomerRequest]
        **kwargs  # type: Any
    ):
        # type: (...) -> _models.IgnosCustomerDto
        """Internal Ignos api for updating a customer.

        Internal Ignos api for updating a customer.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateCustomerRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IgnosCustomerDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.IgnosCustomerDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def update_customer(
        self,
        id,  # type: str
        body=None,  # type: Optional[IO]
        **kwargs  # type: Any
    ):
        # type: (...) -> _models.IgnosCustomerDto
        """Internal Ignos api for updating a customer.

        Internal Ignos api for updating a customer.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IgnosCustomerDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.IgnosCustomerDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """


    @distributed_trace
    def update_customer(
        self,
        id,  # type: str
        body=None,  # type: Optional[Union[_models.UpdateCustomerRequest, IO]]
        **kwargs  # type: Any
    ):
        # type: (...) -> _models.IgnosCustomerDto
        """Internal Ignos api for updating a customer.

        Internal Ignos api for updating a customer.

        :param id: Required.
        :type id: str
        :param body: Is either a model type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateCustomerRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IgnosCustomerDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.IgnosCustomerDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.IgnosCustomerDto]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, 'UpdateCustomerRequest')
            else:
                _json = None

        request = build_update_customer_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_customer.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize('IgnosCustomerDto', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_customer.metadata = {'url': "/customers/{id}"}  # type: ignore


    @distributed_trace
    def list_customer_tenants(
        self,
        id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> List[_models.TenantDto]
        """Internal Ignos api for a customer's tenants.

        Internal Ignos api for a customer's tenants.

        :param id: Required.
        :type id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of TenantDto or the result of cls(response)
        :rtype: list[~ignos.internal.api.client.models.TenantDto]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[List[_models.TenantDto]]

        
        request = build_list_customer_tenants_request(
            id=id,
            template_url=self.list_customer_tenants.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize('[TenantDto]', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_customer_tenants.metadata = {'url': "/customers/{id}/tenants"}  # type: ignore


    @overload
    def create_tenant(
        self,
        id,  # type: str
        body=None,  # type: Optional[_models.CreateTenantRequest]
        **kwargs  # type: Any
    ):
        # type: (...) -> _models.TenantDto
        """Internal Ignos api for creating a customer tenant.

        Internal Ignos api for creating a customer tenant.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.CreateTenantRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: TenantDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.TenantDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def create_tenant(
        self,
        id,  # type: str
        body=None,  # type: Optional[IO]
        **kwargs  # type: Any
    ):
        # type: (...) -> _models.TenantDto
        """Internal Ignos api for creating a customer tenant.

        Internal Ignos api for creating a customer tenant.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: TenantDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.TenantDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """


    @distributed_trace
    def create_tenant(
        self,
        id,  # type: str
        body=None,  # type: Optional[Union[_models.CreateTenantRequest, IO]]
        **kwargs  # type: Any
    ):
        # type: (...) -> _models.TenantDto
        """Internal Ignos api for creating a customer tenant.

        Internal Ignos api for creating a customer tenant.

        :param id: Required.
        :type id: str
        :param body: Is either a model type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.CreateTenantRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: TenantDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.TenantDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.TenantDto]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, 'CreateTenantRequest')
            else:
                _json = None

        request = build_create_tenant_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_tenant.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize('TenantDto', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_tenant.metadata = {'url': "/customers/{id}/tenants"}  # type: ignore


    @overload
    def update_tenant(
        self,
        id,  # type: str
        tenant_id,  # type: str
        body=None,  # type: Optional[_models.UpdateTenantRequest]
        **kwargs  # type: Any
    ):
        # type: (...) -> _models.TenantDto
        """Internal Ignos api for updating a customer tenant.

        Internal Ignos api for updating a customer tenant.

        :param id: Required.
        :type id: str
        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateTenantRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: TenantDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.TenantDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def update_tenant(
        self,
        id,  # type: str
        tenant_id,  # type: str
        body=None,  # type: Optional[IO]
        **kwargs  # type: Any
    ):
        # type: (...) -> _models.TenantDto
        """Internal Ignos api for updating a customer tenant.

        Internal Ignos api for updating a customer tenant.

        :param id: Required.
        :type id: str
        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: TenantDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.TenantDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """


    @distributed_trace
    def update_tenant(
        self,
        id,  # type: str
        tenant_id,  # type: str
        body=None,  # type: Optional[Union[_models.UpdateTenantRequest, IO]]
        **kwargs  # type: Any
    ):
        # type: (...) -> _models.TenantDto
        """Internal Ignos api for updating a customer tenant.

        Internal Ignos api for updating a customer tenant.

        :param id: Required.
        :type id: str
        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Is either a model type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateTenantRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: TenantDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.TenantDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.TenantDto]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, 'UpdateTenantRequest')
            else:
                _json = None

        request = build_update_tenant_request(
            id=id,
            tenant_id=tenant_id,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_tenant.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize('TenantDto', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_tenant.metadata = {'url': "/customers/{id}/tenants/{tenantId}"}  # type: ignore


    @distributed_trace
    def get_cdf_config(
        self,
        id,  # type: str
        tenant_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> _models.CdfConfigDto
        """Internal Ignos api for checking CDF config.

        Internal Ignos api for checking CDF config.

        :param id: Customer id. Required.
        :type id: str
        :param tenant_id: Tenant id. Required.
        :type tenant_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CdfConfigDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.CdfConfigDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[_models.CdfConfigDto]

        
        request = build_get_cdf_config_request(
            id=id,
            tenant_id=tenant_id,
            template_url=self.get_cdf_config.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize('CdfConfigDto', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_cdf_config.metadata = {'url': "/customers/{id}/tenants/{tenantId}/config"}  # type: ignore


    @overload
    def update_cdf_config(
        self,
        id,  # type: str
        tenant_id,  # type: str
        body=None,  # type: Optional[_models.UpdateTenantCdfConfigRequest]
        **kwargs  # type: Any
    ):
        # type: (...) -> _models.CdfConfigDto
        """Internal Ignos api for updating CDF config.

        Internal Ignos api for updating CDF config.

        :param id: Customer id. Required.
        :type id: str
        :param tenant_id: Tenant id. Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateTenantCdfConfigRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CdfConfigDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.CdfConfigDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def update_cdf_config(
        self,
        id,  # type: str
        tenant_id,  # type: str
        body=None,  # type: Optional[IO]
        **kwargs  # type: Any
    ):
        # type: (...) -> _models.CdfConfigDto
        """Internal Ignos api for updating CDF config.

        Internal Ignos api for updating CDF config.

        :param id: Customer id. Required.
        :type id: str
        :param tenant_id: Tenant id. Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CdfConfigDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.CdfConfigDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """


    @distributed_trace
    def update_cdf_config(
        self,
        id,  # type: str
        tenant_id,  # type: str
        body=None,  # type: Optional[Union[_models.UpdateTenantCdfConfigRequest, IO]]
        **kwargs  # type: Any
    ):
        # type: (...) -> _models.CdfConfigDto
        """Internal Ignos api for updating CDF config.

        Internal Ignos api for updating CDF config.

        :param id: Customer id. Required.
        :type id: str
        :param tenant_id: Tenant id. Required.
        :type tenant_id: str
        :param body: Is either a model type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateTenantCdfConfigRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CdfConfigDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.CdfConfigDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.CdfConfigDto]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, 'UpdateTenantCdfConfigRequest')
            else:
                _json = None

        request = build_update_cdf_config_request(
            id=id,
            tenant_id=tenant_id,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_cdf_config.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize('CdfConfigDto', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_cdf_config.metadata = {'url': "/customers/{id}/tenants/{tenantId}/config"}  # type: ignore


    @distributed_trace
    def list_customer_apps(
        self,
        id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> List[_models.CustomerAppDto]
        """Internal Ignos api for listing customer apps.

        Internal Ignos api for listing customer apps.

        :param id: Required.
        :type id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of CustomerAppDto or the result of cls(response)
        :rtype: list[~ignos.internal.api.client.models.CustomerAppDto]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[List[_models.CustomerAppDto]]

        
        request = build_list_customer_apps_request(
            id=id,
            template_url=self.list_customer_apps.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize('[CustomerAppDto]', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_customer_apps.metadata = {'url': "/customers/{id}/apps"}  # type: ignore


    @distributed_trace
    def add_customer_app(  # pylint: disable=inconsistent-return-statements
        self,
        id,  # type: str
        app_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Internal Ignos api for adding an app to a customer.

        Internal Ignos api for adding an app to a customer.

        :param id: Required.
        :type id: str
        :param app_id: Required.
        :type app_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        
        request = build_add_customer_app_request(
            id=id,
            app_id=app_id,
            template_url=self.add_customer_app.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    add_customer_app.metadata = {'url': "/customers/{id}/apps/{appId}"}  # type: ignore


    @distributed_trace
    def remove_customer_app(  # pylint: disable=inconsistent-return-statements
        self,
        id,  # type: str
        app_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Internal Ignos api for removing an app from a customer.

        Internal Ignos api for removing an app from a customer.

        :param id: Required.
        :type id: str
        :param app_id: Required.
        :type app_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        
        request = build_remove_customer_app_request(
            id=id,
            app_id=app_id,
            template_url=self.remove_customer_app.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    remove_customer_app.metadata = {'url': "/customers/{id}/apps/{appId}"}  # type: ignore


    @distributed_trace
    def list_tenant_keys(
        self,
        **kwargs  # type: Any
    ):
        # type: (...) -> List[_models.TenantKeyDto]
        """list_tenant_keys.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of TenantKeyDto or the result of cls(response)
        :rtype: list[~ignos.internal.api.client.models.TenantKeyDto]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[List[_models.TenantKeyDto]]

        
        request = build_list_tenant_keys_request(
            template_url=self.list_tenant_keys.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize('[TenantKeyDto]', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_tenant_keys.metadata = {'url': "/customers/tenantkeys"}  # type: ignore

