# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import IO, Optional, TYPE_CHECKING, Union, overload

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .. import models as _models
from .._serialization import Serializer
from .._vendor import _convert_request, _format_url_section

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, List, Optional, TypeVar
    T = TypeVar('T')
    ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False
# fmt: off

def build_list_cdf_clusters_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/cdfclusters")

    # Construct headers
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_create_cdf_cluster_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/cdfclusters")

    # Construct headers
    if content_type is not None:
        _headers['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_update_cdf_cluster_request(
    id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/cdfclusters/{id}")
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=_url,
        headers=_headers,
        **kwargs
    )

# fmt: on
class CdfClustersOperations(object):
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.IgnosInternalApi`'s
        :attr:`cdf_clusters` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")


    @distributed_trace
    def list_cdf_clusters(
        self,
        **kwargs  # type: Any
    ):
        # type: (...) -> List[_models.CdfClusterDto]
        """list_cdf_clusters.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of CdfClusterDto or the result of cls(response)
        :rtype: list[~ignos.internal.api.client.models.CdfClusterDto]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[List[_models.CdfClusterDto]]

        
        request = build_list_cdf_clusters_request(
            template_url=self.list_cdf_clusters.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize('[CdfClusterDto]', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_cdf_clusters.metadata = {'url': "/cdfclusters"}  # type: ignore


    @overload
    def create_cdf_cluster(
        self,
        body=None,  # type: Optional[_models.CreateCdfCluster]
        **kwargs  # type: Any
    ):
        # type: (...) -> _models.CdfClusterDto
        """create_cdf_cluster.

        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.CreateCdfCluster
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CdfClusterDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.CdfClusterDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def create_cdf_cluster(
        self,
        body=None,  # type: Optional[IO]
        **kwargs  # type: Any
    ):
        # type: (...) -> _models.CdfClusterDto
        """create_cdf_cluster.

        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CdfClusterDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.CdfClusterDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """


    @distributed_trace
    def create_cdf_cluster(
        self,
        body=None,  # type: Optional[Union[_models.CreateCdfCluster, IO]]
        **kwargs  # type: Any
    ):
        # type: (...) -> _models.CdfClusterDto
        """create_cdf_cluster.

        :param body: Is either a model type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.CreateCdfCluster or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CdfClusterDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.CdfClusterDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.CdfClusterDto]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, 'CreateCdfCluster')
            else:
                _json = None

        request = build_create_cdf_cluster_request(
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_cdf_cluster.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize('CdfClusterDto', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_cdf_cluster.metadata = {'url': "/cdfclusters"}  # type: ignore


    @overload
    def update_cdf_cluster(
        self,
        id,  # type: str
        body=None,  # type: Optional[_models.UpdateCdfClusterRequest]
        **kwargs  # type: Any
    ):
        # type: (...) -> _models.CdfClusterDto
        """update_cdf_cluster.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateCdfClusterRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CdfClusterDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.CdfClusterDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def update_cdf_cluster(
        self,
        id,  # type: str
        body=None,  # type: Optional[IO]
        **kwargs  # type: Any
    ):
        # type: (...) -> _models.CdfClusterDto
        """update_cdf_cluster.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CdfClusterDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.CdfClusterDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """


    @distributed_trace
    def update_cdf_cluster(
        self,
        id,  # type: str
        body=None,  # type: Optional[Union[_models.UpdateCdfClusterRequest, IO]]
        **kwargs  # type: Any
    ):
        # type: (...) -> _models.CdfClusterDto
        """update_cdf_cluster.

        :param id: Required.
        :type id: str
        :param body: Is either a model type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateCdfClusterRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CdfClusterDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.CdfClusterDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.CdfClusterDto]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, 'UpdateCdfClusterRequest')
            else:
                _json = None

        request = build_update_cdf_cluster_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_cdf_cluster.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize('CdfClusterDto', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_cdf_cluster.metadata = {'url': "/cdfclusters/{id}"}  # type: ignore

