# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import IO, Optional, TYPE_CHECKING, Union, overload

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .. import models as _models
from .._serialization import Serializer
from .._vendor import _convert_request, _format_url_section

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, List, Optional, TypeVar
    T = TypeVar('T')
    ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False
# fmt: off

def build_list_apps_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/apps")

    # Construct headers
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_create_app_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/apps")

    # Construct headers
    if content_type is not None:
        _headers['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_update_app_request(
    id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
    accept = _headers.pop('Accept', "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/apps/{id}")
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=_url,
        headers=_headers,
        **kwargs
    )

# fmt: on
class AppsOperations(object):
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.IgnosInternalApi`'s
        :attr:`apps` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")


    @distributed_trace
    def list_apps(
        self,
        **kwargs  # type: Any
    ):
        # type: (...) -> List[_models.AppDto]
        """Internal Ignos api for listing apps.

        Internal Ignos api for listing apps.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of AppDto or the result of cls(response)
        :rtype: list[~ignos.internal.api.client.models.AppDto]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[List[_models.AppDto]]

        
        request = build_list_apps_request(
            template_url=self.list_apps.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize('[AppDto]', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_apps.metadata = {'url': "/apps"}  # type: ignore


    @overload
    def create_app(
        self,
        body=None,  # type: Optional[_models.CreateApp]
        **kwargs  # type: Any
    ):
        # type: (...) -> _models.AppDto
        """Internal Ignos api for creating a new app.

        Internal Ignos api for creating a new app.

        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.CreateApp
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AppDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.AppDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def create_app(
        self,
        body=None,  # type: Optional[IO]
        **kwargs  # type: Any
    ):
        # type: (...) -> _models.AppDto
        """Internal Ignos api for creating a new app.

        Internal Ignos api for creating a new app.

        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AppDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.AppDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """


    @distributed_trace
    def create_app(
        self,
        body=None,  # type: Optional[Union[_models.CreateApp, IO]]
        **kwargs  # type: Any
    ):
        # type: (...) -> _models.AppDto
        """Internal Ignos api for creating a new app.

        Internal Ignos api for creating a new app.

        :param body: Is either a model type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.CreateApp or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AppDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.AppDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.AppDto]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, 'CreateApp')
            else:
                _json = None

        request = build_create_app_request(
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_app.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize('AppDto', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_app.metadata = {'url': "/apps"}  # type: ignore


    @overload
    def update_app(
        self,
        id,  # type: str
        body=None,  # type: Optional[_models.UpdateAppRequest]
        **kwargs  # type: Any
    ):
        # type: (...) -> _models.AppDto
        """Internal Ignos api for updating an app.

        Internal Ignos api for updating an app.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateAppRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AppDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.AppDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def update_app(
        self,
        id,  # type: str
        body=None,  # type: Optional[IO]
        **kwargs  # type: Any
    ):
        # type: (...) -> _models.AppDto
        """Internal Ignos api for updating an app.

        Internal Ignos api for updating an app.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AppDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.AppDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """


    @distributed_trace
    def update_app(
        self,
        id,  # type: str
        body=None,  # type: Optional[Union[_models.UpdateAppRequest, IO]]
        **kwargs  # type: Any
    ):
        # type: (...) -> _models.AppDto
        """Internal Ignos api for updating an app.

        Internal Ignos api for updating an app.

        :param id: Required.
        :type id: str
        :param body: Is either a model type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateAppRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AppDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.AppDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.AppDto]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, 'UpdateAppRequest')
            else:
                _json = None

        request = build_update_app_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_app.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize('AppDto', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_app.metadata = {'url': "/apps/{id}"}  # type: ignore

