# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from .. import _serialization


class AppDto(_serialization.Model):
    """AppDto.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required.
    :vartype id: str
    :ivar key: Required.
    :vartype key: str
    :ivar name: Required.
    :vartype name: str
    :ivar description: Required.
    :vartype description: str
    :ivar private_app: Required.
    :vartype private_app: bool
    :ivar accessible_by_suppliers: Required.
    :vartype accessible_by_suppliers: bool
    """

    _validation = {
        'id': {'required': True},
        'key': {'required': True},
        'name': {'required': True},
        'description': {'required': True},
        'private_app': {'required': True},
        'accessible_by_suppliers': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "private_app": {"key": "privateApp", "type": "bool"},
        "accessible_by_suppliers": {"key": "accessibleBySuppliers", "type": "bool"},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword id: Required.
        :paramtype id: str
        :keyword key: Required.
        :paramtype key: str
        :keyword name: Required.
        :paramtype name: str
        :keyword description: Required.
        :paramtype description: str
        :keyword private_app: Required.
        :paramtype private_app: bool
        :keyword accessible_by_suppliers: Required.
        :paramtype accessible_by_suppliers: bool
        """
        super(AppDto, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.key = kwargs['key']
        self.name = kwargs['name']
        self.description = kwargs['description']
        self.private_app = kwargs['private_app']
        self.accessible_by_suppliers = kwargs['accessible_by_suppliers']


class AzureRegionDto(_serialization.Model):
    """AzureRegionDto.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: Required.
    :vartype display_name: str
    :ivar name: Required.
    :vartype name: str
    :ivar region_display_name: Required.
    :vartype region_display_name: str
    """

    _validation = {
        'display_name': {'required': True},
        'name': {'required': True},
        'region_display_name': {'required': True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "region_display_name": {"key": "regionDisplayName", "type": "str"},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword display_name: Required.
        :paramtype display_name: str
        :keyword name: Required.
        :paramtype name: str
        :keyword region_display_name: Required.
        :paramtype region_display_name: str
        """
        super(AzureRegionDto, self).__init__(**kwargs)
        self.display_name = kwargs['display_name']
        self.name = kwargs['name']
        self.region_display_name = kwargs['region_display_name']


class CdfClusterDto(_serialization.Model):
    """CdfClusterDto.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required.
    :vartype id: str
    :ivar name: Required.
    :vartype name: str
    :ivar base_url: Required.
    :vartype base_url: str
    :ivar scope: Required.
    :vartype scope: str
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
        'base_url': {'required': True},
        'scope': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "base_url": {"key": "baseUrl", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword id: Required.
        :paramtype id: str
        :keyword name: Required.
        :paramtype name: str
        :keyword base_url: Required.
        :paramtype base_url: str
        :keyword scope: Required.
        :paramtype scope: str
        """
        super(CdfClusterDto, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.name = kwargs['name']
        self.base_url = kwargs['base_url']
        self.scope = kwargs['scope']


class CdfConfigDto(_serialization.Model):
    """CdfConfigDto.

    :ivar tenant_id:
    :vartype tenant_id: str
    :ivar client_id:
    :vartype client_id: str
    :ivar client_secret_exists:
    :vartype client_secret_exists: bool
    """

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
        "client_secret_exists": {"key": "clientSecretExists", "type": "bool"},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword tenant_id:
        :paramtype tenant_id: str
        :keyword client_id:
        :paramtype client_id: str
        :keyword client_secret_exists:
        :paramtype client_secret_exists: bool
        """
        super(CdfConfigDto, self).__init__(**kwargs)
        self.tenant_id = kwargs.get('tenant_id', None)
        self.client_id = kwargs.get('client_id', None)
        self.client_secret_exists = kwargs.get('client_secret_exists', None)


class CdfDetailsDto(_serialization.Model):
    """CdfDetailsDto.

    All required parameters must be populated in order to send to Azure.

    :ivar project: Required.
    :vartype project: str
    :ivar base_url: Required.
    :vartype base_url: str
    :ivar client_id: Required.
    :vartype client_id: str
    :ivar client_secret_exists: Required.
    :vartype client_secret_exists: bool
    :ivar token_scopes: Required.
    :vartype token_scopes: str
    :ivar token_url: Required.
    :vartype token_url: str
    :ivar customer_managed_cdf: Required.
    :vartype customer_managed_cdf: bool
    """

    _validation = {
        'project': {'required': True},
        'base_url': {'required': True},
        'client_id': {'required': True},
        'client_secret_exists': {'required': True},
        'token_scopes': {'required': True},
        'token_url': {'required': True},
        'customer_managed_cdf': {'required': True},
    }

    _attribute_map = {
        "project": {"key": "project", "type": "str"},
        "base_url": {"key": "baseUrl", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
        "client_secret_exists": {"key": "clientSecretExists", "type": "bool"},
        "token_scopes": {"key": "tokenScopes", "type": "str"},
        "token_url": {"key": "tokenUrl", "type": "str"},
        "customer_managed_cdf": {"key": "customerManagedCdf", "type": "bool"},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword project: Required.
        :paramtype project: str
        :keyword base_url: Required.
        :paramtype base_url: str
        :keyword client_id: Required.
        :paramtype client_id: str
        :keyword client_secret_exists: Required.
        :paramtype client_secret_exists: bool
        :keyword token_scopes: Required.
        :paramtype token_scopes: str
        :keyword token_url: Required.
        :paramtype token_url: str
        :keyword customer_managed_cdf: Required.
        :paramtype customer_managed_cdf: bool
        """
        super(CdfDetailsDto, self).__init__(**kwargs)
        self.project = kwargs['project']
        self.base_url = kwargs['base_url']
        self.client_id = kwargs['client_id']
        self.client_secret_exists = kwargs['client_secret_exists']
        self.token_scopes = kwargs['token_scopes']
        self.token_url = kwargs['token_url']
        self.customer_managed_cdf = kwargs['customer_managed_cdf']


class ContactPersonDto(_serialization.Model):
    """ContactPersonDto.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required.
    :vartype name: str
    :ivar phone: Required.
    :vartype phone: str
    :ivar email: Required.
    :vartype email: str
    """

    _validation = {
        'name': {'required': True},
        'phone': {'required': True},
        'email': {'required': True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "phone": {"key": "phone", "type": "str"},
        "email": {"key": "email", "type": "str"},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required.
        :paramtype name: str
        :keyword phone: Required.
        :paramtype phone: str
        :keyword email: Required.
        :paramtype email: str
        """
        super(ContactPersonDto, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.phone = kwargs['phone']
        self.email = kwargs['email']


class CountryDto(_serialization.Model):
    """CountryDto.

    All required parameters must be populated in order to send to Azure.

    :ivar two_letter_iso_region_name: Required.
    :vartype two_letter_iso_region_name: str
    :ivar three_letter_iso_region_name: Required.
    :vartype three_letter_iso_region_name: str
    :ivar name: Required.
    :vartype name: str
    """

    _validation = {
        'two_letter_iso_region_name': {'required': True},
        'three_letter_iso_region_name': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        "two_letter_iso_region_name": {"key": "twoLetterISORegionName", "type": "str"},
        "three_letter_iso_region_name": {"key": "threeLetterISORegionName", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword two_letter_iso_region_name: Required.
        :paramtype two_letter_iso_region_name: str
        :keyword three_letter_iso_region_name: Required.
        :paramtype three_letter_iso_region_name: str
        :keyword name: Required.
        :paramtype name: str
        """
        super(CountryDto, self).__init__(**kwargs)
        self.two_letter_iso_region_name = kwargs['two_letter_iso_region_name']
        self.three_letter_iso_region_name = kwargs['three_letter_iso_region_name']
        self.name = kwargs['name']


class CreateApp(_serialization.Model):
    """CreateApp.

    All required parameters must be populated in order to send to Azure.

    :ivar key: Required.
    :vartype key: str
    :ivar name: Required.
    :vartype name: str
    :ivar description: Required.
    :vartype description: str
    :ivar private_app: Required.
    :vartype private_app: bool
    :ivar accessible_by_suppliers: Required.
    :vartype accessible_by_suppliers: bool
    """

    _validation = {
        'key': {'required': True},
        'name': {'required': True},
        'description': {'required': True},
        'private_app': {'required': True},
        'accessible_by_suppliers': {'required': True},
    }

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "private_app": {"key": "privateApp", "type": "bool"},
        "accessible_by_suppliers": {"key": "accessibleBySuppliers", "type": "bool"},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword key: Required.
        :paramtype key: str
        :keyword name: Required.
        :paramtype name: str
        :keyword description: Required.
        :paramtype description: str
        :keyword private_app: Required.
        :paramtype private_app: bool
        :keyword accessible_by_suppliers: Required.
        :paramtype accessible_by_suppliers: bool
        """
        super(CreateApp, self).__init__(**kwargs)
        self.key = kwargs['key']
        self.name = kwargs['name']
        self.description = kwargs['description']
        self.private_app = kwargs['private_app']
        self.accessible_by_suppliers = kwargs['accessible_by_suppliers']


class CreateCdfCluster(_serialization.Model):
    """CreateCdfCluster.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required.
    :vartype name: str
    :ivar base_url: Required.
    :vartype base_url: str
    :ivar scope: Required.
    :vartype scope: str
    """

    _validation = {
        'name': {'required': True},
        'base_url': {'required': True},
        'scope': {'required': True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "base_url": {"key": "baseUrl", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required.
        :paramtype name: str
        :keyword base_url: Required.
        :paramtype base_url: str
        :keyword scope: Required.
        :paramtype scope: str
        """
        super(CreateCdfCluster, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.base_url = kwargs['base_url']
        self.scope = kwargs['scope']


class CreateIgnosCustomer(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """CreateIgnosCustomer.

    All required parameters must be populated in order to send to Azure.

    :ivar short_name: Required.
    :vartype short_name: str
    :ivar name: Required.
    :vartype name: str
    :ivar azure_region_id: Required.
    :vartype azure_region_id: str
    :ivar azure_ad_tenant_id:
    :vartype azure_ad_tenant_id: str
    :ivar contact_person: Required.
    :vartype contact_person: ~ignos.internal.api.client.models.ContactPersonDto
    :ivar external_reference:
    :vartype external_reference: str
    :ivar three_letter_iso_country: Required.
    :vartype three_letter_iso_country: str
    :ivar logo_url:
    :vartype logo_url: str
    :ivar company_url:
    :vartype company_url: str
    :ivar domain:
    :vartype domain: str
    :ivar customer_managed_cdf: Required.
    :vartype customer_managed_cdf: bool
    """

    _validation = {
        'short_name': {'required': True},
        'name': {'required': True},
        'azure_region_id': {'required': True},
        'contact_person': {'required': True},
        'three_letter_iso_country': {'required': True},
        'customer_managed_cdf': {'required': True},
    }

    _attribute_map = {
        "short_name": {"key": "shortName", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "azure_region_id": {"key": "azureRegionId", "type": "str"},
        "azure_ad_tenant_id": {"key": "azureAdTenantId", "type": "str"},
        "contact_person": {"key": "contactPerson", "type": "ContactPersonDto"},
        "external_reference": {"key": "externalReference", "type": "str"},
        "three_letter_iso_country": {"key": "threeLetterIsoCountry", "type": "str"},
        "logo_url": {"key": "logoUrl", "type": "str"},
        "company_url": {"key": "companyUrl", "type": "str"},
        "domain": {"key": "domain", "type": "str"},
        "customer_managed_cdf": {"key": "customerManagedCdf", "type": "bool"},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword short_name: Required.
        :paramtype short_name: str
        :keyword name: Required.
        :paramtype name: str
        :keyword azure_region_id: Required.
        :paramtype azure_region_id: str
        :keyword azure_ad_tenant_id:
        :paramtype azure_ad_tenant_id: str
        :keyword contact_person: Required.
        :paramtype contact_person: ~ignos.internal.api.client.models.ContactPersonDto
        :keyword external_reference:
        :paramtype external_reference: str
        :keyword three_letter_iso_country: Required.
        :paramtype three_letter_iso_country: str
        :keyword logo_url:
        :paramtype logo_url: str
        :keyword company_url:
        :paramtype company_url: str
        :keyword domain:
        :paramtype domain: str
        :keyword customer_managed_cdf: Required.
        :paramtype customer_managed_cdf: bool
        """
        super(CreateIgnosCustomer, self).__init__(**kwargs)
        self.short_name = kwargs['short_name']
        self.name = kwargs['name']
        self.azure_region_id = kwargs['azure_region_id']
        self.azure_ad_tenant_id = kwargs.get('azure_ad_tenant_id', None)
        self.contact_person = kwargs['contact_person']
        self.external_reference = kwargs.get('external_reference', None)
        self.three_letter_iso_country = kwargs['three_letter_iso_country']
        self.logo_url = kwargs.get('logo_url', None)
        self.company_url = kwargs.get('company_url', None)
        self.domain = kwargs.get('domain', None)
        self.customer_managed_cdf = kwargs['customer_managed_cdf']


class CreatePowerRegion(_serialization.Model):
    """CreatePowerRegion.

    All required parameters must be populated in order to send to Azure.

    :ivar country: Required.
    :vartype country: str
    :ivar region: Required.
    :vartype region: str
    :ivar description: Required.
    :vartype description: str
    :ivar initial_co2_per_kwh_date:
    :vartype initial_co2_per_kwh_date: ~datetime.datetime
    :ivar co2_per_kwh:
    :vartype co2_per_kwh: int
    """

    _validation = {
        'country': {'required': True},
        'region': {'required': True},
        'description': {'required': True},
    }

    _attribute_map = {
        "country": {"key": "country", "type": "str"},
        "region": {"key": "region", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "initial_co2_per_kwh_date": {"key": "initialCo2PerKwhDate", "type": "iso-8601"},
        "co2_per_kwh": {"key": "co2PerKwh", "type": "int"},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword country: Required.
        :paramtype country: str
        :keyword region: Required.
        :paramtype region: str
        :keyword description: Required.
        :paramtype description: str
        :keyword initial_co2_per_kwh_date:
        :paramtype initial_co2_per_kwh_date: ~datetime.datetime
        :keyword co2_per_kwh:
        :paramtype co2_per_kwh: int
        """
        super(CreatePowerRegion, self).__init__(**kwargs)
        self.country = kwargs['country']
        self.region = kwargs['region']
        self.description = kwargs['description']
        self.initial_co2_per_kwh_date = kwargs.get('initial_co2_per_kwh_date', None)
        self.co2_per_kwh = kwargs.get('co2_per_kwh', None)


class CreateTenantRequest(_serialization.Model):
    """CreateTenantRequest.

    All required parameters must be populated in order to send to Azure.

    :ivar description:
    :vartype description: str
    :ivar azure_region_id: Required.
    :vartype azure_region_id: str
    :ivar contact_person:
    :vartype contact_person: ~ignos.internal.api.client.models.ContactPersonDto
    :ivar environment: Required. Known values are: "Prod", "QA", "Test", and "Dev".
    :vartype environment: str or ~ignos.internal.api.client.models.TenantEnvironment
    :ivar cdf_tenant:
    :vartype cdf_tenant: str
    :ivar cdf_cluster_id: Required.
    :vartype cdf_cluster_id: str
    """

    _validation = {
        'azure_region_id': {'required': True},
        'environment': {'required': True},
        'cdf_cluster_id': {'required': True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "azure_region_id": {"key": "azureRegionId", "type": "str"},
        "contact_person": {"key": "contactPerson", "type": "ContactPersonDto"},
        "environment": {"key": "environment", "type": "str"},
        "cdf_tenant": {"key": "cdfTenant", "type": "str"},
        "cdf_cluster_id": {"key": "cdfClusterId", "type": "str"},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description:
        :paramtype description: str
        :keyword azure_region_id: Required.
        :paramtype azure_region_id: str
        :keyword contact_person:
        :paramtype contact_person: ~ignos.internal.api.client.models.ContactPersonDto
        :keyword environment: Required. Known values are: "Prod", "QA", "Test", and "Dev".
        :paramtype environment: str or ~ignos.internal.api.client.models.TenantEnvironment
        :keyword cdf_tenant:
        :paramtype cdf_tenant: str
        :keyword cdf_cluster_id: Required.
        :paramtype cdf_cluster_id: str
        """
        super(CreateTenantRequest, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.azure_region_id = kwargs['azure_region_id']
        self.contact_person = kwargs.get('contact_person', None)
        self.environment = kwargs['environment']
        self.cdf_tenant = kwargs.get('cdf_tenant', None)
        self.cdf_cluster_id = kwargs['cdf_cluster_id']


class CustomerAppDto(_serialization.Model):
    """CustomerAppDto.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required.
    :vartype id: str
    :ivar key: Required.
    :vartype key: str
    :ivar name: Required.
    :vartype name: str
    :ivar description: Required.
    :vartype description: str
    :ivar private_app: Required.
    :vartype private_app: bool
    """

    _validation = {
        'id': {'required': True},
        'key': {'required': True},
        'name': {'required': True},
        'description': {'required': True},
        'private_app': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "private_app": {"key": "privateApp", "type": "bool"},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword id: Required.
        :paramtype id: str
        :keyword key: Required.
        :paramtype key: str
        :keyword name: Required.
        :paramtype name: str
        :keyword description: Required.
        :paramtype description: str
        :keyword private_app: Required.
        :paramtype private_app: bool
        """
        super(CustomerAppDto, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.key = kwargs['key']
        self.name = kwargs['name']
        self.description = kwargs['description']
        self.private_app = kwargs['private_app']


class IgnosCustomerDto(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """IgnosCustomerDto.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required.
    :vartype id: str
    :ivar short_name: Required.
    :vartype short_name: str
    :ivar name: Required.
    :vartype name: str
    :ivar azure_region_id: Required.
    :vartype azure_region_id: str
    :ivar azure_region_name: Required.
    :vartype azure_region_name: str
    :ivar azure_ad_tenant_id:
    :vartype azure_ad_tenant_id: str
    :ivar contact_person: Required.
    :vartype contact_person: ~ignos.internal.api.client.models.ContactPersonDto
    :ivar number_of_tenants: Required.
    :vartype number_of_tenants: int
    :ivar external_reference:
    :vartype external_reference: str
    :ivar status: Required. Known values are: "Draft", "Active", and "Deactivated".
    :vartype status: str or ~ignos.internal.api.client.models.CustomerStatusDto
    :ivar three_letter_iso_country: Required.
    :vartype three_letter_iso_country: str
    :ivar country: Required.
    :vartype country: str
    :ivar logo_url:
    :vartype logo_url: str
    :ivar company_url:
    :vartype company_url: str
    :ivar domain:
    :vartype domain: str
    :ivar customer_managed_cdf: Required.
    :vartype customer_managed_cdf: bool
    """

    _validation = {
        'id': {'required': True},
        'short_name': {'required': True},
        'name': {'required': True},
        'azure_region_id': {'required': True},
        'azure_region_name': {'required': True},
        'contact_person': {'required': True},
        'number_of_tenants': {'required': True},
        'status': {'required': True},
        'three_letter_iso_country': {'required': True},
        'country': {'required': True},
        'customer_managed_cdf': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "short_name": {"key": "shortName", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "azure_region_id": {"key": "azureRegionId", "type": "str"},
        "azure_region_name": {"key": "azureRegionName", "type": "str"},
        "azure_ad_tenant_id": {"key": "azureAdTenantId", "type": "str"},
        "contact_person": {"key": "contactPerson", "type": "ContactPersonDto"},
        "number_of_tenants": {"key": "numberOfTenants", "type": "int"},
        "external_reference": {"key": "externalReference", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "three_letter_iso_country": {"key": "threeLetterIsoCountry", "type": "str"},
        "country": {"key": "country", "type": "str"},
        "logo_url": {"key": "logoUrl", "type": "str"},
        "company_url": {"key": "companyUrl", "type": "str"},
        "domain": {"key": "domain", "type": "str"},
        "customer_managed_cdf": {"key": "customerManagedCdf", "type": "bool"},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword id: Required.
        :paramtype id: str
        :keyword short_name: Required.
        :paramtype short_name: str
        :keyword name: Required.
        :paramtype name: str
        :keyword azure_region_id: Required.
        :paramtype azure_region_id: str
        :keyword azure_region_name: Required.
        :paramtype azure_region_name: str
        :keyword azure_ad_tenant_id:
        :paramtype azure_ad_tenant_id: str
        :keyword contact_person: Required.
        :paramtype contact_person: ~ignos.internal.api.client.models.ContactPersonDto
        :keyword number_of_tenants: Required.
        :paramtype number_of_tenants: int
        :keyword external_reference:
        :paramtype external_reference: str
        :keyword status: Required. Known values are: "Draft", "Active", and "Deactivated".
        :paramtype status: str or ~ignos.internal.api.client.models.CustomerStatusDto
        :keyword three_letter_iso_country: Required.
        :paramtype three_letter_iso_country: str
        :keyword country: Required.
        :paramtype country: str
        :keyword logo_url:
        :paramtype logo_url: str
        :keyword company_url:
        :paramtype company_url: str
        :keyword domain:
        :paramtype domain: str
        :keyword customer_managed_cdf: Required.
        :paramtype customer_managed_cdf: bool
        """
        super(IgnosCustomerDto, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.short_name = kwargs['short_name']
        self.name = kwargs['name']
        self.azure_region_id = kwargs['azure_region_id']
        self.azure_region_name = kwargs['azure_region_name']
        self.azure_ad_tenant_id = kwargs.get('azure_ad_tenant_id', None)
        self.contact_person = kwargs['contact_person']
        self.number_of_tenants = kwargs['number_of_tenants']
        self.external_reference = kwargs.get('external_reference', None)
        self.status = kwargs['status']
        self.three_letter_iso_country = kwargs['three_letter_iso_country']
        self.country = kwargs['country']
        self.logo_url = kwargs.get('logo_url', None)
        self.company_url = kwargs.get('company_url', None)
        self.domain = kwargs.get('domain', None)
        self.customer_managed_cdf = kwargs['customer_managed_cdf']


class PowerRegionDto(_serialization.Model):
    """PowerRegionDto.

    :ivar id:
    :vartype id: str
    :ivar country:
    :vartype country: str
    :ivar region:
    :vartype region: str
    :ivar description:
    :vartype description: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "country": {"key": "country", "type": "str"},
        "region": {"key": "region", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword id:
        :paramtype id: str
        :keyword country:
        :paramtype country: str
        :keyword region:
        :paramtype region: str
        :keyword description:
        :paramtype description: str
        """
        super(PowerRegionDto, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.country = kwargs.get('country', None)
        self.region = kwargs.get('region', None)
        self.description = kwargs.get('description', None)


class TenantDetailDto(_serialization.Model):
    """TenantDetailDto.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: Required.
    :vartype tenant_id: str
    :ivar apps: Required.
    :vartype apps: list[~ignos.internal.api.client.models.CustomerAppDto]
    :ivar cdf:
    :vartype cdf: ~ignos.internal.api.client.models.CdfDetailsDto
    """

    _validation = {
        'tenant_id': {'required': True},
        'apps': {'required': True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "apps": {"key": "apps", "type": "[CustomerAppDto]"},
        "cdf": {"key": "cdf", "type": "CdfDetailsDto"},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword tenant_id: Required.
        :paramtype tenant_id: str
        :keyword apps: Required.
        :paramtype apps: list[~ignos.internal.api.client.models.CustomerAppDto]
        :keyword cdf:
        :paramtype cdf: ~ignos.internal.api.client.models.CdfDetailsDto
        """
        super(TenantDetailDto, self).__init__(**kwargs)
        self.tenant_id = kwargs['tenant_id']
        self.apps = kwargs['apps']
        self.cdf = kwargs.get('cdf', None)


class TenantDto(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """TenantDto.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: Required.
    :vartype tenant_id: str
    :ivar name: Required.
    :vartype name: str
    :ivar environment: Required. Known values are: "Prod", "QA", "Test", and "Dev".
    :vartype environment: str or ~ignos.internal.api.client.models.TenantEnvironment
    :ivar environment_name: Required.
    :vartype environment_name: str
    :ivar description:
    :vartype description: str
    :ivar customer_id: Required.
    :vartype customer_id: str
    :ivar customer_short_name: Required.
    :vartype customer_short_name: str
    :ivar customer_name: Required.
    :vartype customer_name: str
    :ivar azure_region_id: Required.
    :vartype azure_region_id: str
    :ivar azure_region_name: Required.
    :vartype azure_region_name: str
    :ivar azure_ad_tenant_id: Required.
    :vartype azure_ad_tenant_id: str
    :ivar cosmos_database:
    :vartype cosmos_database: str
    :ivar contact_person: Required.
    :vartype contact_person: ~ignos.internal.api.client.models.ContactPersonDto
    :ivar external_reference:
    :vartype external_reference: str
    :ivar three_letter_iso_country: Required.
    :vartype three_letter_iso_country: str
    :ivar country: Required.
    :vartype country: str
    :ivar status: Required.
    :vartype status: int
    :ivar logo_url:
    :vartype logo_url: str
    :ivar company_url:
    :vartype company_url: str
    :ivar domain:
    :vartype domain: str
    :ivar infrastructure_status: Required. Known values are: 0, 1, 2, and 9.
    :vartype infrastructure_status: int or
     ~ignos.internal.api.client.models.TenantInfrastructureStatus
    :ivar cdf_tenant:
    :vartype cdf_tenant: str
    :ivar cdf_tenant_client_id:
    :vartype cdf_tenant_client_id: str
    :ivar tenant_key:
    :vartype tenant_key: str
    :ivar customer_managed_cdf: Required.
    :vartype customer_managed_cdf: bool
    """

    _validation = {
        'tenant_id': {'required': True},
        'name': {'required': True},
        'environment': {'required': True},
        'environment_name': {'required': True},
        'customer_id': {'required': True},
        'customer_short_name': {'required': True},
        'customer_name': {'required': True},
        'azure_region_id': {'required': True},
        'azure_region_name': {'required': True},
        'azure_ad_tenant_id': {'required': True},
        'contact_person': {'required': True},
        'three_letter_iso_country': {'required': True},
        'country': {'required': True},
        'status': {'required': True},
        'infrastructure_status': {'required': True},
        'customer_managed_cdf': {'required': True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "environment": {"key": "environment", "type": "str"},
        "environment_name": {"key": "environmentName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "customer_id": {"key": "customerId", "type": "str"},
        "customer_short_name": {"key": "customerShortName", "type": "str"},
        "customer_name": {"key": "customerName", "type": "str"},
        "azure_region_id": {"key": "azureRegionId", "type": "str"},
        "azure_region_name": {"key": "azureRegionName", "type": "str"},
        "azure_ad_tenant_id": {"key": "azureAdTenantId", "type": "str"},
        "cosmos_database": {"key": "cosmosDatabase", "type": "str"},
        "contact_person": {"key": "contactPerson", "type": "ContactPersonDto"},
        "external_reference": {"key": "externalReference", "type": "str"},
        "three_letter_iso_country": {"key": "threeLetterIsoCountry", "type": "str"},
        "country": {"key": "country", "type": "str"},
        "status": {"key": "status", "type": "int"},
        "logo_url": {"key": "logoUrl", "type": "str"},
        "company_url": {"key": "companyUrl", "type": "str"},
        "domain": {"key": "domain", "type": "str"},
        "infrastructure_status": {"key": "infrastructureStatus", "type": "int"},
        "cdf_tenant": {"key": "cdfTenant", "type": "str"},
        "cdf_tenant_client_id": {"key": "cdfTenantClientId", "type": "str"},
        "tenant_key": {"key": "tenantKey", "type": "str"},
        "customer_managed_cdf": {"key": "customerManagedCdf", "type": "bool"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        **kwargs
    ):
        """
        :keyword tenant_id: Required.
        :paramtype tenant_id: str
        :keyword name: Required.
        :paramtype name: str
        :keyword environment: Required. Known values are: "Prod", "QA", "Test", and "Dev".
        :paramtype environment: str or ~ignos.internal.api.client.models.TenantEnvironment
        :keyword environment_name: Required.
        :paramtype environment_name: str
        :keyword description:
        :paramtype description: str
        :keyword customer_id: Required.
        :paramtype customer_id: str
        :keyword customer_short_name: Required.
        :paramtype customer_short_name: str
        :keyword customer_name: Required.
        :paramtype customer_name: str
        :keyword azure_region_id: Required.
        :paramtype azure_region_id: str
        :keyword azure_region_name: Required.
        :paramtype azure_region_name: str
        :keyword azure_ad_tenant_id: Required.
        :paramtype azure_ad_tenant_id: str
        :keyword cosmos_database:
        :paramtype cosmos_database: str
        :keyword contact_person: Required.
        :paramtype contact_person: ~ignos.internal.api.client.models.ContactPersonDto
        :keyword external_reference:
        :paramtype external_reference: str
        :keyword three_letter_iso_country: Required.
        :paramtype three_letter_iso_country: str
        :keyword country: Required.
        :paramtype country: str
        :keyword status: Required.
        :paramtype status: int
        :keyword logo_url:
        :paramtype logo_url: str
        :keyword company_url:
        :paramtype company_url: str
        :keyword domain:
        :paramtype domain: str
        :keyword infrastructure_status: Required. Known values are: 0, 1, 2, and 9.
        :paramtype infrastructure_status: int or
         ~ignos.internal.api.client.models.TenantInfrastructureStatus
        :keyword cdf_tenant:
        :paramtype cdf_tenant: str
        :keyword cdf_tenant_client_id:
        :paramtype cdf_tenant_client_id: str
        :keyword tenant_key:
        :paramtype tenant_key: str
        :keyword customer_managed_cdf: Required.
        :paramtype customer_managed_cdf: bool
        """
        super(TenantDto, self).__init__(**kwargs)
        self.tenant_id = kwargs['tenant_id']
        self.name = kwargs['name']
        self.environment = kwargs['environment']
        self.environment_name = kwargs['environment_name']
        self.description = kwargs.get('description', None)
        self.customer_id = kwargs['customer_id']
        self.customer_short_name = kwargs['customer_short_name']
        self.customer_name = kwargs['customer_name']
        self.azure_region_id = kwargs['azure_region_id']
        self.azure_region_name = kwargs['azure_region_name']
        self.azure_ad_tenant_id = kwargs['azure_ad_tenant_id']
        self.cosmos_database = kwargs.get('cosmos_database', None)
        self.contact_person = kwargs['contact_person']
        self.external_reference = kwargs.get('external_reference', None)
        self.three_letter_iso_country = kwargs['three_letter_iso_country']
        self.country = kwargs['country']
        self.status = kwargs['status']
        self.logo_url = kwargs.get('logo_url', None)
        self.company_url = kwargs.get('company_url', None)
        self.domain = kwargs.get('domain', None)
        self.infrastructure_status = kwargs['infrastructure_status']
        self.cdf_tenant = kwargs.get('cdf_tenant', None)
        self.cdf_tenant_client_id = kwargs.get('cdf_tenant_client_id', None)
        self.tenant_key = kwargs.get('tenant_key', None)
        self.customer_managed_cdf = kwargs['customer_managed_cdf']


class TenantKeyDto(_serialization.Model):
    """TenantKeyDto.

    :ivar key:
    :vartype key: str
    :ivar tenant_id:
    :vartype tenant_id: str
    :ivar tenant_row_key:
    :vartype tenant_row_key: str
    :ivar customer_short_name:
    :vartype customer_short_name: str
    :ivar customer_row_key:
    :vartype customer_row_key: str
    :ivar cdf_tenant:
    :vartype cdf_tenant: str
    """

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "tenant_row_key": {"key": "tenantRowKey", "type": "str"},
        "customer_short_name": {"key": "customerShortName", "type": "str"},
        "customer_row_key": {"key": "customerRowKey", "type": "str"},
        "cdf_tenant": {"key": "cdfTenant", "type": "str"},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword key:
        :paramtype key: str
        :keyword tenant_id:
        :paramtype tenant_id: str
        :keyword tenant_row_key:
        :paramtype tenant_row_key: str
        :keyword customer_short_name:
        :paramtype customer_short_name: str
        :keyword customer_row_key:
        :paramtype customer_row_key: str
        :keyword cdf_tenant:
        :paramtype cdf_tenant: str
        """
        super(TenantKeyDto, self).__init__(**kwargs)
        self.key = kwargs.get('key', None)
        self.tenant_id = kwargs.get('tenant_id', None)
        self.tenant_row_key = kwargs.get('tenant_row_key', None)
        self.customer_short_name = kwargs.get('customer_short_name', None)
        self.customer_row_key = kwargs.get('customer_row_key', None)
        self.cdf_tenant = kwargs.get('cdf_tenant', None)


class UpdateAppRequest(_serialization.Model):
    """UpdateAppRequest.

    All required parameters must be populated in order to send to Azure.

    :ivar description: Required.
    :vartype description: str
    :ivar private_app: Required.
    :vartype private_app: bool
    :ivar accessible_by_suppliers: Required.
    :vartype accessible_by_suppliers: bool
    """

    _validation = {
        'description': {'required': True},
        'private_app': {'required': True},
        'accessible_by_suppliers': {'required': True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "private_app": {"key": "privateApp", "type": "bool"},
        "accessible_by_suppliers": {"key": "accessibleBySuppliers", "type": "bool"},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: Required.
        :paramtype description: str
        :keyword private_app: Required.
        :paramtype private_app: bool
        :keyword accessible_by_suppliers: Required.
        :paramtype accessible_by_suppliers: bool
        """
        super(UpdateAppRequest, self).__init__(**kwargs)
        self.description = kwargs['description']
        self.private_app = kwargs['private_app']
        self.accessible_by_suppliers = kwargs['accessible_by_suppliers']


class UpdateCdfClusterRequest(_serialization.Model):
    """UpdateCdfClusterRequest.

    All required parameters must be populated in order to send to Azure.

    :ivar base_url: Required.
    :vartype base_url: str
    :ivar scope: Required.
    :vartype scope: str
    """

    _validation = {
        'base_url': {'required': True},
        'scope': {'required': True},
    }

    _attribute_map = {
        "base_url": {"key": "baseUrl", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword base_url: Required.
        :paramtype base_url: str
        :keyword scope: Required.
        :paramtype scope: str
        """
        super(UpdateCdfClusterRequest, self).__init__(**kwargs)
        self.base_url = kwargs['base_url']
        self.scope = kwargs['scope']


class UpdateCustomerRequest(_serialization.Model):
    """UpdateCustomerRequest.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required.
    :vartype name: str
    :ivar azure_ad_tenant_id:
    :vartype azure_ad_tenant_id: str
    :ivar contact_person: Required.
    :vartype contact_person: ~ignos.internal.api.client.models.ContactPersonDto
    :ivar external_reference:
    :vartype external_reference: str
    :ivar three_letter_iso_country: Required.
    :vartype three_letter_iso_country: str
    :ivar logo_url:
    :vartype logo_url: str
    :ivar company_url:
    :vartype company_url: str
    :ivar domain:
    :vartype domain: str
    :ivar customer_managed_cdf: Required.
    :vartype customer_managed_cdf: bool
    """

    _validation = {
        'name': {'required': True},
        'contact_person': {'required': True},
        'three_letter_iso_country': {'required': True},
        'customer_managed_cdf': {'required': True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "azure_ad_tenant_id": {"key": "azureAdTenantId", "type": "str"},
        "contact_person": {"key": "contactPerson", "type": "ContactPersonDto"},
        "external_reference": {"key": "externalReference", "type": "str"},
        "three_letter_iso_country": {"key": "threeLetterIsoCountry", "type": "str"},
        "logo_url": {"key": "logoUrl", "type": "str"},
        "company_url": {"key": "companyUrl", "type": "str"},
        "domain": {"key": "domain", "type": "str"},
        "customer_managed_cdf": {"key": "customerManagedCdf", "type": "bool"},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required.
        :paramtype name: str
        :keyword azure_ad_tenant_id:
        :paramtype azure_ad_tenant_id: str
        :keyword contact_person: Required.
        :paramtype contact_person: ~ignos.internal.api.client.models.ContactPersonDto
        :keyword external_reference:
        :paramtype external_reference: str
        :keyword three_letter_iso_country: Required.
        :paramtype three_letter_iso_country: str
        :keyword logo_url:
        :paramtype logo_url: str
        :keyword company_url:
        :paramtype company_url: str
        :keyword domain:
        :paramtype domain: str
        :keyword customer_managed_cdf: Required.
        :paramtype customer_managed_cdf: bool
        """
        super(UpdateCustomerRequest, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.azure_ad_tenant_id = kwargs.get('azure_ad_tenant_id', None)
        self.contact_person = kwargs['contact_person']
        self.external_reference = kwargs.get('external_reference', None)
        self.three_letter_iso_country = kwargs['three_letter_iso_country']
        self.logo_url = kwargs.get('logo_url', None)
        self.company_url = kwargs.get('company_url', None)
        self.domain = kwargs.get('domain', None)
        self.customer_managed_cdf = kwargs['customer_managed_cdf']


class UpdateTenantCdfConfigRequest(_serialization.Model):
    """UpdateTenantCdfConfigRequest.

    All required parameters must be populated in order to send to Azure.

    :ivar client_id: Required.
    :vartype client_id: str
    :ivar client_secret:
    :vartype client_secret: str
    """

    _validation = {
        'client_id': {'required': True},
    }

    _attribute_map = {
        "client_id": {"key": "clientId", "type": "str"},
        "client_secret": {"key": "clientSecret", "type": "str"},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword client_id: Required.
        :paramtype client_id: str
        :keyword client_secret:
        :paramtype client_secret: str
        """
        super(UpdateTenantCdfConfigRequest, self).__init__(**kwargs)
        self.client_id = kwargs['client_id']
        self.client_secret = kwargs.get('client_secret', None)


class UpdateTenantRequest(_serialization.Model):
    """UpdateTenantRequest.

    :ivar description:
    :vartype description: str
    :ivar contact_person:
    :vartype contact_person: ~ignos.internal.api.client.models.ContactPersonDto
    :ivar cdf_tenant:
    :vartype cdf_tenant: str
    """

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "contact_person": {"key": "contactPerson", "type": "ContactPersonDto"},
        "cdf_tenant": {"key": "cdfTenant", "type": "str"},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description:
        :paramtype description: str
        :keyword contact_person:
        :paramtype contact_person: ~ignos.internal.api.client.models.ContactPersonDto
        :keyword cdf_tenant:
        :paramtype cdf_tenant: str
        """
        super(UpdateTenantRequest, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.contact_person = kwargs.get('contact_person', None)
        self.cdf_tenant = kwargs.get('cdf_tenant', None)


class UserDetailsDto(_serialization.Model):
    """UserDetailsDto.

    :ivar id:
    :vartype id: str
    :ivar full_name:
    :vartype full_name: str
    :ivar upn:
    :vartype upn: str
    :ivar roles:
    :vartype roles: list[str]
    :ivar given_name:
    :vartype given_name: str
    :ivar sur_name:
    :vartype sur_name: str
    :ivar tenant_id:
    :vartype tenant_id: str
    :ivar customer_id:
    :vartype customer_id: str
    :ivar is_external_user:
    :vartype is_external_user: bool
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "full_name": {"key": "fullName", "type": "str"},
        "upn": {"key": "upn", "type": "str"},
        "roles": {"key": "roles", "type": "[str]"},
        "given_name": {"key": "givenName", "type": "str"},
        "sur_name": {"key": "surName", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "customer_id": {"key": "customerId", "type": "str"},
        "is_external_user": {"key": "isExternalUser", "type": "bool"},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword id:
        :paramtype id: str
        :keyword full_name:
        :paramtype full_name: str
        :keyword upn:
        :paramtype upn: str
        :keyword roles:
        :paramtype roles: list[str]
        :keyword given_name:
        :paramtype given_name: str
        :keyword sur_name:
        :paramtype sur_name: str
        :keyword tenant_id:
        :paramtype tenant_id: str
        :keyword customer_id:
        :paramtype customer_id: str
        :keyword is_external_user:
        :paramtype is_external_user: bool
        """
        super(UserDetailsDto, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.full_name = kwargs.get('full_name', None)
        self.upn = kwargs.get('upn', None)
        self.roles = kwargs.get('roles', None)
        self.given_name = kwargs.get('given_name', None)
        self.sur_name = kwargs.get('sur_name', None)
        self.tenant_id = kwargs.get('tenant_id', None)
        self.customer_id = kwargs.get('customer_id', None)
        self.is_external_user = kwargs.get('is_external_user', None)
