# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, Callable, Dict, IO, List, Optional, TypeVar, Union, overload

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._customers_operations import build_add_customer_app_request, build_create_customer_request, build_create_tenant_request, build_get_cdf_config_request, build_get_customer_request, build_list_customer_apps_request, build_list_customer_tenants_request, build_list_customers_request, build_list_tenant_keys_request, build_remove_customer_app_request, build_update_cdf_config_request, build_update_customer_request, build_update_tenant_request
T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class CustomersOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.aio.IgnosInternalApi`'s
        :attr:`customers` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")


    @distributed_trace_async
    async def list_customers(
        self,
        page_size: int = 100,
        continuation_token_parameter: Optional[str] = None,
        **kwargs: Any
    ) -> List[_models.IgnosCustomerDto]:
        """Internal Ignos api for listing customers.

        Internal Ignos api for listing customers.

        :param page_size: Default value is 100.
        :type page_size: int
        :param continuation_token_parameter: Default value is None.
        :type continuation_token_parameter: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of IgnosCustomerDto or the result of cls(response)
        :rtype: list[~ignos.internal.api.client.models.IgnosCustomerDto]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[List[_models.IgnosCustomerDto]]

        
        request = build_list_customers_request(
            page_size=page_size,
            continuation_token_parameter=continuation_token_parameter,
            template_url=self.list_customers.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize('[IgnosCustomerDto]', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_customers.metadata = {'url': "/customers"}  # type: ignore


    @overload
    async def create_customer(
        self,
        body: Optional[_models.CreateIgnosCustomer] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.IgnosCustomerDto:
        """Internal Ignos api for creating a customer.

        Internal Ignos api for creating a customer.

        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.CreateIgnosCustomer
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IgnosCustomerDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.IgnosCustomerDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_customer(
        self,
        body: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.IgnosCustomerDto:
        """Internal Ignos api for creating a customer.

        Internal Ignos api for creating a customer.

        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IgnosCustomerDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.IgnosCustomerDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """


    @distributed_trace_async
    async def create_customer(
        self,
        body: Optional[Union[_models.CreateIgnosCustomer, IO]] = None,
        **kwargs: Any
    ) -> _models.IgnosCustomerDto:
        """Internal Ignos api for creating a customer.

        Internal Ignos api for creating a customer.

        :param body: Is either a model type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.CreateIgnosCustomer or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IgnosCustomerDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.IgnosCustomerDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.IgnosCustomerDto]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, 'CreateIgnosCustomer')
            else:
                _json = None

        request = build_create_customer_request(
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_customer.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize('IgnosCustomerDto', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_customer.metadata = {'url': "/customers"}  # type: ignore


    @distributed_trace_async
    async def get_customer(
        self,
        id: str,
        **kwargs: Any
    ) -> _models.IgnosCustomerDto:
        """Internal Ignos api for getting a customer.

        Internal Ignos api for getting a customer.

        :param id: Required.
        :type id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IgnosCustomerDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.IgnosCustomerDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[_models.IgnosCustomerDto]

        
        request = build_get_customer_request(
            id=id,
            template_url=self.get_customer.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize('IgnosCustomerDto', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_customer.metadata = {'url': "/customers/{id}"}  # type: ignore


    @overload
    async def update_customer(
        self,
        id: str,
        body: Optional[_models.UpdateCustomerRequest] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.IgnosCustomerDto:
        """Internal Ignos api for updating a customer.

        Internal Ignos api for updating a customer.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateCustomerRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IgnosCustomerDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.IgnosCustomerDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_customer(
        self,
        id: str,
        body: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.IgnosCustomerDto:
        """Internal Ignos api for updating a customer.

        Internal Ignos api for updating a customer.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IgnosCustomerDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.IgnosCustomerDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """


    @distributed_trace_async
    async def update_customer(
        self,
        id: str,
        body: Optional[Union[_models.UpdateCustomerRequest, IO]] = None,
        **kwargs: Any
    ) -> _models.IgnosCustomerDto:
        """Internal Ignos api for updating a customer.

        Internal Ignos api for updating a customer.

        :param id: Required.
        :type id: str
        :param body: Is either a model type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateCustomerRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IgnosCustomerDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.IgnosCustomerDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.IgnosCustomerDto]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, 'UpdateCustomerRequest')
            else:
                _json = None

        request = build_update_customer_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_customer.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize('IgnosCustomerDto', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_customer.metadata = {'url': "/customers/{id}"}  # type: ignore


    @distributed_trace_async
    async def list_customer_tenants(
        self,
        id: str,
        **kwargs: Any
    ) -> List[_models.TenantDto]:
        """Internal Ignos api for a customer's tenants.

        Internal Ignos api for a customer's tenants.

        :param id: Required.
        :type id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of TenantDto or the result of cls(response)
        :rtype: list[~ignos.internal.api.client.models.TenantDto]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[List[_models.TenantDto]]

        
        request = build_list_customer_tenants_request(
            id=id,
            template_url=self.list_customer_tenants.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize('[TenantDto]', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_customer_tenants.metadata = {'url': "/customers/{id}/tenants"}  # type: ignore


    @overload
    async def create_tenant(
        self,
        id: str,
        body: Optional[_models.CreateTenantRequest] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.TenantDto:
        """Internal Ignos api for creating a customer tenant.

        Internal Ignos api for creating a customer tenant.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.CreateTenantRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: TenantDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.TenantDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_tenant(
        self,
        id: str,
        body: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.TenantDto:
        """Internal Ignos api for creating a customer tenant.

        Internal Ignos api for creating a customer tenant.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: TenantDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.TenantDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """


    @distributed_trace_async
    async def create_tenant(
        self,
        id: str,
        body: Optional[Union[_models.CreateTenantRequest, IO]] = None,
        **kwargs: Any
    ) -> _models.TenantDto:
        """Internal Ignos api for creating a customer tenant.

        Internal Ignos api for creating a customer tenant.

        :param id: Required.
        :type id: str
        :param body: Is either a model type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.CreateTenantRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: TenantDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.TenantDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.TenantDto]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, 'CreateTenantRequest')
            else:
                _json = None

        request = build_create_tenant_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_tenant.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize('TenantDto', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_tenant.metadata = {'url': "/customers/{id}/tenants"}  # type: ignore


    @overload
    async def update_tenant(
        self,
        id: str,
        tenant_id: str,
        body: Optional[_models.UpdateTenantRequest] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.TenantDto:
        """Internal Ignos api for updating a customer tenant.

        Internal Ignos api for updating a customer tenant.

        :param id: Required.
        :type id: str
        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateTenantRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: TenantDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.TenantDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_tenant(
        self,
        id: str,
        tenant_id: str,
        body: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.TenantDto:
        """Internal Ignos api for updating a customer tenant.

        Internal Ignos api for updating a customer tenant.

        :param id: Required.
        :type id: str
        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: TenantDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.TenantDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """


    @distributed_trace_async
    async def update_tenant(
        self,
        id: str,
        tenant_id: str,
        body: Optional[Union[_models.UpdateTenantRequest, IO]] = None,
        **kwargs: Any
    ) -> _models.TenantDto:
        """Internal Ignos api for updating a customer tenant.

        Internal Ignos api for updating a customer tenant.

        :param id: Required.
        :type id: str
        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Is either a model type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateTenantRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: TenantDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.TenantDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.TenantDto]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, 'UpdateTenantRequest')
            else:
                _json = None

        request = build_update_tenant_request(
            id=id,
            tenant_id=tenant_id,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_tenant.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize('TenantDto', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_tenant.metadata = {'url': "/customers/{id}/tenants/{tenantId}"}  # type: ignore


    @distributed_trace_async
    async def get_cdf_config(
        self,
        id: str,
        tenant_id: str,
        **kwargs: Any
    ) -> _models.CdfConfigDto:
        """Internal Ignos api for checking CDF config.

        Internal Ignos api for checking CDF config.

        :param id: Customer id. Required.
        :type id: str
        :param tenant_id: Tenant id. Required.
        :type tenant_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CdfConfigDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.CdfConfigDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[_models.CdfConfigDto]

        
        request = build_get_cdf_config_request(
            id=id,
            tenant_id=tenant_id,
            template_url=self.get_cdf_config.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize('CdfConfigDto', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_cdf_config.metadata = {'url': "/customers/{id}/tenants/{tenantId}/config"}  # type: ignore


    @overload
    async def update_cdf_config(
        self,
        id: str,
        tenant_id: str,
        body: Optional[_models.UpdateTenantCdfConfigRequest] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CdfConfigDto:
        """Internal Ignos api for updating CDF config.

        Internal Ignos api for updating CDF config.

        :param id: Customer id. Required.
        :type id: str
        :param tenant_id: Tenant id. Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateTenantCdfConfigRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CdfConfigDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.CdfConfigDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_cdf_config(
        self,
        id: str,
        tenant_id: str,
        body: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CdfConfigDto:
        """Internal Ignos api for updating CDF config.

        Internal Ignos api for updating CDF config.

        :param id: Customer id. Required.
        :type id: str
        :param tenant_id: Tenant id. Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CdfConfigDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.CdfConfigDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """


    @distributed_trace_async
    async def update_cdf_config(
        self,
        id: str,
        tenant_id: str,
        body: Optional[Union[_models.UpdateTenantCdfConfigRequest, IO]] = None,
        **kwargs: Any
    ) -> _models.CdfConfigDto:
        """Internal Ignos api for updating CDF config.

        Internal Ignos api for updating CDF config.

        :param id: Customer id. Required.
        :type id: str
        :param tenant_id: Tenant id. Required.
        :type tenant_id: str
        :param body: Is either a model type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateTenantCdfConfigRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CdfConfigDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.CdfConfigDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.CdfConfigDto]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, 'UpdateTenantCdfConfigRequest')
            else:
                _json = None

        request = build_update_cdf_config_request(
            id=id,
            tenant_id=tenant_id,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_cdf_config.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize('CdfConfigDto', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_cdf_config.metadata = {'url': "/customers/{id}/tenants/{tenantId}/config"}  # type: ignore


    @distributed_trace_async
    async def list_customer_apps(
        self,
        id: str,
        **kwargs: Any
    ) -> List[_models.CustomerAppDto]:
        """Internal Ignos api for listing customer apps.

        Internal Ignos api for listing customer apps.

        :param id: Required.
        :type id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of CustomerAppDto or the result of cls(response)
        :rtype: list[~ignos.internal.api.client.models.CustomerAppDto]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[List[_models.CustomerAppDto]]

        
        request = build_list_customer_apps_request(
            id=id,
            template_url=self.list_customer_apps.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize('[CustomerAppDto]', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_customer_apps.metadata = {'url': "/customers/{id}/apps"}  # type: ignore


    @distributed_trace_async
    async def add_customer_app(  # pylint: disable=inconsistent-return-statements
        self,
        id: str,
        app_id: str,
        **kwargs: Any
    ) -> None:
        """Internal Ignos api for adding an app to a customer.

        Internal Ignos api for adding an app to a customer.

        :param id: Required.
        :type id: str
        :param app_id: Required.
        :type app_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        
        request = build_add_customer_app_request(
            id=id,
            app_id=app_id,
            template_url=self.add_customer_app.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    add_customer_app.metadata = {'url': "/customers/{id}/apps/{appId}"}  # type: ignore


    @distributed_trace_async
    async def remove_customer_app(  # pylint: disable=inconsistent-return-statements
        self,
        id: str,
        app_id: str,
        **kwargs: Any
    ) -> None:
        """Internal Ignos api for removing an app from a customer.

        Internal Ignos api for removing an app from a customer.

        :param id: Required.
        :type id: str
        :param app_id: Required.
        :type app_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        
        request = build_remove_customer_app_request(
            id=id,
            app_id=app_id,
            template_url=self.remove_customer_app.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    remove_customer_app.metadata = {'url': "/customers/{id}/apps/{appId}"}  # type: ignore


    @distributed_trace_async
    async def list_tenant_keys(
        self,
        **kwargs: Any
    ) -> List[_models.TenantKeyDto]:
        """list_tenant_keys.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of TenantKeyDto or the result of cls(response)
        :rtype: list[~ignos.internal.api.client.models.TenantKeyDto]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[List[_models.TenantKeyDto]]

        
        request = build_list_tenant_keys_request(
            template_url=self.list_tenant_keys.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize('[TenantKeyDto]', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_tenant_keys.metadata = {'url': "/customers/tenantkeys"}  # type: ignore

