# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, Callable, Dict, IO, List, Optional, TypeVar, Union, overload

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._apps_operations import build_create_app_request, build_list_apps_request, build_update_app_request
T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class AppsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.aio.IgnosInternalApi`'s
        :attr:`apps` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")


    @distributed_trace_async
    async def list_apps(
        self,
        **kwargs: Any
    ) -> List[_models.AppDto]:
        """Internal Ignos api for listing apps.

        Internal Ignos api for listing apps.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of AppDto or the result of cls(response)
        :rtype: list[~ignos.internal.api.client.models.AppDto]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[List[_models.AppDto]]

        
        request = build_list_apps_request(
            template_url=self.list_apps.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize('[AppDto]', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_apps.metadata = {'url': "/apps"}  # type: ignore


    @overload
    async def create_app(
        self,
        body: Optional[_models.CreateApp] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AppDto:
        """Internal Ignos api for creating a new app.

        Internal Ignos api for creating a new app.

        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.CreateApp
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AppDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.AppDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_app(
        self,
        body: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AppDto:
        """Internal Ignos api for creating a new app.

        Internal Ignos api for creating a new app.

        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AppDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.AppDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """


    @distributed_trace_async
    async def create_app(
        self,
        body: Optional[Union[_models.CreateApp, IO]] = None,
        **kwargs: Any
    ) -> _models.AppDto:
        """Internal Ignos api for creating a new app.

        Internal Ignos api for creating a new app.

        :param body: Is either a model type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.CreateApp or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AppDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.AppDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.AppDto]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, 'CreateApp')
            else:
                _json = None

        request = build_create_app_request(
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_app.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize('AppDto', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_app.metadata = {'url': "/apps"}  # type: ignore


    @overload
    async def update_app(
        self,
        id: str,
        body: Optional[_models.UpdateAppRequest] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AppDto:
        """Internal Ignos api for updating an app.

        Internal Ignos api for updating an app.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateAppRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AppDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.AppDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_app(
        self,
        id: str,
        body: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AppDto:
        """Internal Ignos api for updating an app.

        Internal Ignos api for updating an app.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AppDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.AppDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """


    @distributed_trace_async
    async def update_app(
        self,
        id: str,
        body: Optional[Union[_models.UpdateAppRequest, IO]] = None,
        **kwargs: Any
    ) -> _models.AppDto:
        """Internal Ignos api for updating an app.

        Internal Ignos api for updating an app.

        :param id: Required.
        :type id: str
        :param body: Is either a model type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateAppRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AppDto or the result of cls(response)
        :rtype: ~ignos.internal.api.client.models.AppDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.AppDto]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, 'UpdateAppRequest')
            else:
                _json = None

        request = build_update_app_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_app.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize('AppDto', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_app.metadata = {'url': "/apps/{id}"}  # type: ignore

