# nomad-pilot-cli
This is the API descriptor for the Nomad Pilot API, responsible for shipping and logistics processing.<br><br> Developed by <a href=\"https://samarkand.global\">Samarkand Global</a> in partnership with <a href=\"https://www.sf-express.com/cn/sc/\">SF Express</a><br><br> Install for node with <br>`npm install nomad_pilot_cli`<br><br> Install for python with <br>`pip install nomad-pilot-cli`<br>

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.21.0
- Package version: 1.21.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import nomad_pilot_cli
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import nomad_pilot_cli
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import nomad_pilot_cli
from nomad_pilot_cli.rest import ApiException
from pprint import pprint

configuration = nomad_pilot_cli.Configuration()
# Configure API key authorization: ca_key
configuration.api_key['x-ca-key'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['x-ca-key'] = 'Bearer'

# Defining host is optional and default to https://nomad.samarkand-global.cn/pilot
configuration.host = "https://nomad.samarkand-global.cn/pilot"
# Enter a context with an instance of the API client
with nomad_pilot_cli.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = nomad_pilot_cli.ShipApi(api_client)
    carrier = 'carrier_example' # str | String name of carrier
order_ref = 'order_ref_example' # str | String name of order ref (by Odoo)

    try:
        # cancelShip
        api_response = api_instance.cancel_ship(carrier, order_ref)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ShipApi->cancel_ship: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://nomad.samarkand-global.cn/pilot*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ShipApi* | [**cancel_ship**](docs/ShipApi.md#cancel_ship) | **DELETE** /ship/{carrier}/order/{order_ref} | cancelShip
*ShipApi* | [**query_ship**](docs/ShipApi.md#query_ship) | **GET** /ship/{carrier}/order/{order_ref} | queryShip
*ShipApi* | [**ship**](docs/ShipApi.md#ship) | **POST** /ship/{carrier} | ship


## Documentation For Models

 - [Address](docs/Address.md)
 - [ApiResponse](docs/ApiResponse.md)
 - [ApiResponseConnectorResponse](docs/ApiResponseConnectorResponse.md)
 - [ApiResponseData](docs/ApiResponseData.md)
 - [Dimension](docs/Dimension.md)
 - [Goldjet](docs/Goldjet.md)
 - [Package](docs/Package.md)
 - [PackageItem](docs/PackageItem.md)


## Documentation For Authorization


## ca_key

- **Type**: API key
- **API key parameter name**: x-ca-key
- **Location**: HTTP header


## ca_stage

- **Type**: API key
- **API key parameter name**: x-ca-stage
- **Location**: HTTP header


## Author

paul@samarkand.global


