import * as cdk from '@aws-cdk/core';
/**
 * Properties for defining a `AWS::SageMaker::CodeRepository`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html
 */
export interface CfnCodeRepositoryProps {
    /**
     * `AWS::SageMaker::CodeRepository.GitConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-gitconfig
     */
    readonly gitConfig: CfnCodeRepository.GitConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::CodeRepository.CodeRepositoryName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-coderepositoryname
     */
    readonly codeRepositoryName?: string;
}
/**
 * A CloudFormation `AWS::SageMaker::CodeRepository`
 *
 * @cloudformationResource AWS::SageMaker::CodeRepository
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html
 */
export declare class CfnCodeRepository extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::CodeRepository";
    /**
     * @cloudformationAttribute CodeRepositoryName
     */
    readonly attrCodeRepositoryName: string;
    /**
     * `AWS::SageMaker::CodeRepository.GitConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-gitconfig
     */
    gitConfig: CfnCodeRepository.GitConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::CodeRepository.CodeRepositoryName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-coderepositoryname
     */
    codeRepositoryName: string | undefined;
    /**
     * Create a new `AWS::SageMaker::CodeRepository`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCodeRepositoryProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnCodeRepository {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html
     */
    interface GitConfigProperty {
        /**
         * `CfnCodeRepository.GitConfigProperty.Branch`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html#cfn-sagemaker-coderepository-gitconfig-branch
         */
        readonly branch?: string;
        /**
         * `CfnCodeRepository.GitConfigProperty.RepositoryUrl`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html#cfn-sagemaker-coderepository-gitconfig-repositoryurl
         */
        readonly repositoryUrl: string;
        /**
         * `CfnCodeRepository.GitConfigProperty.SecretArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html#cfn-sagemaker-coderepository-gitconfig-secretarn
         */
        readonly secretArn?: string;
    }
}
/**
 * Properties for defining a `AWS::SageMaker::Endpoint`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html
 */
export interface CfnEndpointProps {
    /**
     * `AWS::SageMaker::Endpoint.EndpointConfigName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointconfigname
     */
    readonly endpointConfigName: string;
    /**
     * `AWS::SageMaker::Endpoint.EndpointName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointname
     */
    readonly endpointName?: string;
    /**
     * `AWS::SageMaker::Endpoint.ExcludeRetainedVariantProperties`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-excluderetainedvariantproperties
     */
    readonly excludeRetainedVariantProperties?: Array<CfnEndpoint.VariantPropertyProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Endpoint.RetainAllVariantProperties`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-retainallvariantproperties
     */
    readonly retainAllVariantProperties?: boolean | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Endpoint.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::Endpoint`
 *
 * @cloudformationResource AWS::SageMaker::Endpoint
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html
 */
export declare class CfnEndpoint extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::Endpoint";
    /**
     * @cloudformationAttribute EndpointName
     */
    readonly attrEndpointName: string;
    /**
     * `AWS::SageMaker::Endpoint.EndpointConfigName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointconfigname
     */
    endpointConfigName: string;
    /**
     * `AWS::SageMaker::Endpoint.EndpointName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointname
     */
    endpointName: string | undefined;
    /**
     * `AWS::SageMaker::Endpoint.ExcludeRetainedVariantProperties`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-excluderetainedvariantproperties
     */
    excludeRetainedVariantProperties: Array<CfnEndpoint.VariantPropertyProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Endpoint.RetainAllVariantProperties`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-retainallvariantproperties
     */
    retainAllVariantProperties: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Endpoint.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::Endpoint`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEndpointProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnEndpoint {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html
     */
    interface VariantPropertyProperty {
        /**
         * `CfnEndpoint.VariantPropertyProperty.VariantPropertyType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html#cfn-sagemaker-endpoint-variantproperty-variantpropertytype
         */
        readonly variantPropertyType?: string;
    }
}
/**
 * Properties for defining a `AWS::SageMaker::EndpointConfig`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
 */
export interface CfnEndpointConfigProps {
    /**
     * `AWS::SageMaker::EndpointConfig.ProductionVariants`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-productionvariants
     */
    readonly productionVariants: Array<CfnEndpointConfig.ProductionVariantProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SageMaker::EndpointConfig.DataCaptureConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig
     */
    readonly dataCaptureConfig?: CfnEndpointConfig.DataCaptureConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::EndpointConfig.EndpointConfigName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-endpointconfigname
     */
    readonly endpointConfigName?: string;
    /**
     * `AWS::SageMaker::EndpointConfig.KmsKeyId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-kmskeyid
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::SageMaker::EndpointConfig.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::EndpointConfig`
 *
 * @cloudformationResource AWS::SageMaker::EndpointConfig
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
 */
export declare class CfnEndpointConfig extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::EndpointConfig";
    /**
     * @cloudformationAttribute EndpointConfigName
     */
    readonly attrEndpointConfigName: string;
    /**
     * `AWS::SageMaker::EndpointConfig.ProductionVariants`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-productionvariants
     */
    productionVariants: Array<CfnEndpointConfig.ProductionVariantProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SageMaker::EndpointConfig.DataCaptureConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig
     */
    dataCaptureConfig: CfnEndpointConfig.DataCaptureConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::EndpointConfig.EndpointConfigName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-endpointconfigname
     */
    endpointConfigName: string | undefined;
    /**
     * `AWS::SageMaker::EndpointConfig.KmsKeyId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-kmskeyid
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::SageMaker::EndpointConfig.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::EndpointConfig`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEndpointConfigProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnEndpointConfig {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader.html
     */
    interface CaptureContentTypeHeaderProperty {
        /**
         * `CfnEndpointConfig.CaptureContentTypeHeaderProperty.CsvContentTypes`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader.html#cfn-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader-csvcontenttypes
         */
        readonly csvContentTypes?: string[];
        /**
         * `CfnEndpointConfig.CaptureContentTypeHeaderProperty.JsonContentTypes`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader.html#cfn-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader-jsoncontenttypes
         */
        readonly jsonContentTypes?: string[];
    }
}
export declare namespace CfnEndpointConfig {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-captureoption.html
     */
    interface CaptureOptionProperty {
        /**
         * `CfnEndpointConfig.CaptureOptionProperty.CaptureMode`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-captureoption.html#cfn-sagemaker-endpointconfig-captureoption-capturemode
         */
        readonly captureMode: string;
    }
}
export declare namespace CfnEndpointConfig {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html
     */
    interface DataCaptureConfigProperty {
        /**
         * `CfnEndpointConfig.DataCaptureConfigProperty.CaptureContentTypeHeader`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader
         */
        readonly captureContentTypeHeader?: CfnEndpointConfig.CaptureContentTypeHeaderProperty | cdk.IResolvable;
        /**
         * `CfnEndpointConfig.DataCaptureConfigProperty.CaptureOptions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-captureoptions
         */
        readonly captureOptions: Array<CfnEndpointConfig.CaptureOptionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnEndpointConfig.DataCaptureConfigProperty.DestinationS3Uri`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-destinations3uri
         */
        readonly destinationS3Uri: string;
        /**
         * `CfnEndpointConfig.DataCaptureConfigProperty.EnableCapture`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-enablecapture
         */
        readonly enableCapture?: boolean | cdk.IResolvable;
        /**
         * `CfnEndpointConfig.DataCaptureConfigProperty.InitialSamplingPercentage`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-initialsamplingpercentage
         */
        readonly initialSamplingPercentage: number;
        /**
         * `CfnEndpointConfig.DataCaptureConfigProperty.KmsKeyId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-kmskeyid
         */
        readonly kmsKeyId?: string;
    }
}
export declare namespace CfnEndpointConfig {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html
     */
    interface ProductionVariantProperty {
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.AcceleratorType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-acceleratortype
         */
        readonly acceleratorType?: string;
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.InitialInstanceCount`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialinstancecount
         */
        readonly initialInstanceCount: number;
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.InitialVariantWeight`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialvariantweight
         */
        readonly initialVariantWeight: number;
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.InstanceType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-instancetype
         */
        readonly instanceType: string;
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.ModelName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-modelname
         */
        readonly modelName: string;
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.VariantName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-variantname
         */
        readonly variantName: string;
    }
}
/**
 * Properties for defining a `AWS::SageMaker::Model`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html
 */
export interface CfnModelProps {
    /**
     * `AWS::SageMaker::Model.ExecutionRoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-executionrolearn
     */
    readonly executionRoleArn: string;
    /**
     * `AWS::SageMaker::Model.Containers`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-containers
     */
    readonly containers?: Array<CfnModel.ContainerDefinitionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Model.EnableNetworkIsolation`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-enablenetworkisolation
     */
    readonly enableNetworkIsolation?: boolean | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Model.ModelName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-modelname
     */
    readonly modelName?: string;
    /**
     * `AWS::SageMaker::Model.PrimaryContainer`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-primarycontainer
     */
    readonly primaryContainer?: CfnModel.ContainerDefinitionProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Model.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::SageMaker::Model.VpcConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-vpcconfig
     */
    readonly vpcConfig?: CfnModel.VpcConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::SageMaker::Model`
 *
 * @cloudformationResource AWS::SageMaker::Model
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html
 */
export declare class CfnModel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::Model";
    /**
     * @cloudformationAttribute ModelName
     */
    readonly attrModelName: string;
    /**
     * `AWS::SageMaker::Model.ExecutionRoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-executionrolearn
     */
    executionRoleArn: string;
    /**
     * `AWS::SageMaker::Model.Containers`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-containers
     */
    containers: Array<CfnModel.ContainerDefinitionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Model.EnableNetworkIsolation`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-enablenetworkisolation
     */
    enableNetworkIsolation: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Model.ModelName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-modelname
     */
    modelName: string | undefined;
    /**
     * `AWS::SageMaker::Model.PrimaryContainer`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-primarycontainer
     */
    primaryContainer: CfnModel.ContainerDefinitionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Model.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::SageMaker::Model.VpcConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-vpcconfig
     */
    vpcConfig: CfnModel.VpcConfigProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::SageMaker::Model`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnModelProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnModel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html
     */
    interface ContainerDefinitionProperty {
        /**
         * `CfnModel.ContainerDefinitionProperty.ContainerHostname`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-containerhostname
         */
        readonly containerHostname?: string;
        /**
         * `CfnModel.ContainerDefinitionProperty.Environment`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-environment
         */
        readonly environment?: any | cdk.IResolvable;
        /**
         * `CfnModel.ContainerDefinitionProperty.Image`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-image
         */
        readonly image?: string;
        /**
         * `CfnModel.ContainerDefinitionProperty.Mode`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-mode
         */
        readonly mode?: string;
        /**
         * `CfnModel.ContainerDefinitionProperty.ModelDataUrl`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-modeldataurl
         */
        readonly modelDataUrl?: string;
        /**
         * `CfnModel.ContainerDefinitionProperty.ModelPackageName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-modelpackagename
         */
        readonly modelPackageName?: string;
    }
}
export declare namespace CfnModel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html
     */
    interface VpcConfigProperty {
        /**
         * `CfnModel.VpcConfigProperty.SecurityGroupIds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html#cfn-sagemaker-model-vpcconfig-securitygroupids
         */
        readonly securityGroupIds: string[];
        /**
         * `CfnModel.VpcConfigProperty.Subnets`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html#cfn-sagemaker-model-vpcconfig-subnets
         */
        readonly subnets: string[];
    }
}
/**
 * Properties for defining a `AWS::SageMaker::MonitoringSchedule`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 */
export interface CfnMonitoringScheduleProps {
    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig
     */
    readonly monitoringScheduleConfig: CfnMonitoringSchedule.MonitoringScheduleConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulename
     */
    readonly monitoringScheduleName: string;
    /**
     * `AWS::SageMaker::MonitoringSchedule.CreationTime`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-creationtime
     */
    readonly creationTime?: string;
    /**
     * `AWS::SageMaker::MonitoringSchedule.EndpointName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-endpointname
     */
    readonly endpointName?: string;
    /**
     * `AWS::SageMaker::MonitoringSchedule.FailureReason`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-failurereason
     */
    readonly failureReason?: string;
    /**
     * `AWS::SageMaker::MonitoringSchedule.LastModifiedTime`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-lastmodifiedtime
     */
    readonly lastModifiedTime?: string;
    /**
     * `AWS::SageMaker::MonitoringSchedule.LastMonitoringExecutionSummary`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-lastmonitoringexecutionsummary
     */
    readonly lastMonitoringExecutionSummary?: CfnMonitoringSchedule.MonitoringExecutionSummaryProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulearn
     */
    readonly monitoringScheduleArn?: string;
    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleStatus`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulestatus
     */
    readonly monitoringScheduleStatus?: string;
    /**
     * `AWS::SageMaker::MonitoringSchedule.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`
 *
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 */
export declare class CfnMonitoringSchedule extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::MonitoringSchedule";
    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig
     */
    monitoringScheduleConfig: CfnMonitoringSchedule.MonitoringScheduleConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulename
     */
    monitoringScheduleName: string;
    /**
     * `AWS::SageMaker::MonitoringSchedule.CreationTime`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-creationtime
     */
    creationTime: string | undefined;
    /**
     * `AWS::SageMaker::MonitoringSchedule.EndpointName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-endpointname
     */
    endpointName: string | undefined;
    /**
     * `AWS::SageMaker::MonitoringSchedule.FailureReason`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-failurereason
     */
    failureReason: string | undefined;
    /**
     * `AWS::SageMaker::MonitoringSchedule.LastModifiedTime`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-lastmodifiedtime
     */
    lastModifiedTime: string | undefined;
    /**
     * `AWS::SageMaker::MonitoringSchedule.LastMonitoringExecutionSummary`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-lastmonitoringexecutionsummary
     */
    lastMonitoringExecutionSummary: CfnMonitoringSchedule.MonitoringExecutionSummaryProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulearn
     */
    monitoringScheduleArn: string | undefined;
    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleStatus`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulestatus
     */
    monitoringScheduleStatus: string | undefined;
    /**
     * `AWS::SageMaker::MonitoringSchedule.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::MonitoringSchedule`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnMonitoringScheduleProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnMonitoringSchedule {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-baselineconfig.html
     */
    interface BaselineConfigProperty {
        /**
         * `CfnMonitoringSchedule.BaselineConfigProperty.ConstraintsResource`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-baselineconfig.html#cfn-sagemaker-monitoringschedule-baselineconfig-constraintsresource
         */
        readonly constraintsResource?: CfnMonitoringSchedule.ConstraintsResourceProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.BaselineConfigProperty.StatisticsResource`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-baselineconfig.html#cfn-sagemaker-monitoringschedule-baselineconfig-statisticsresource
         */
        readonly statisticsResource?: CfnMonitoringSchedule.StatisticsResourceProperty | cdk.IResolvable;
    }
}
export declare namespace CfnMonitoringSchedule {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html
     */
    interface ClusterConfigProperty {
        /**
         * `CfnMonitoringSchedule.ClusterConfigProperty.InstanceCount`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html#cfn-sagemaker-monitoringschedule-clusterconfig-instancecount
         */
        readonly instanceCount: number;
        /**
         * `CfnMonitoringSchedule.ClusterConfigProperty.InstanceType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html#cfn-sagemaker-monitoringschedule-clusterconfig-instancetype
         */
        readonly instanceType: string;
        /**
         * `CfnMonitoringSchedule.ClusterConfigProperty.VolumeKmsKeyId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html#cfn-sagemaker-monitoringschedule-clusterconfig-volumekmskeyid
         */
        readonly volumeKmsKeyId?: string;
        /**
         * `CfnMonitoringSchedule.ClusterConfigProperty.VolumeSizeInGB`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html#cfn-sagemaker-monitoringschedule-clusterconfig-volumesizeingb
         */
        readonly volumeSizeInGb: number;
    }
}
export declare namespace CfnMonitoringSchedule {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-constraintsresource.html
     */
    interface ConstraintsResourceProperty {
        /**
         * `CfnMonitoringSchedule.ConstraintsResourceProperty.S3Uri`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-constraintsresource.html#cfn-sagemaker-monitoringschedule-constraintsresource-s3uri
         */
        readonly s3Uri?: string;
    }
}
export declare namespace CfnMonitoringSchedule {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html
     */
    interface EndpointInputProperty {
        /**
         * `CfnMonitoringSchedule.EndpointInputProperty.EndpointName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html#cfn-sagemaker-monitoringschedule-endpointinput-endpointname
         */
        readonly endpointName: string;
        /**
         * `CfnMonitoringSchedule.EndpointInputProperty.LocalPath`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html#cfn-sagemaker-monitoringschedule-endpointinput-localpath
         */
        readonly localPath: string;
        /**
         * `CfnMonitoringSchedule.EndpointInputProperty.S3DataDistributionType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html#cfn-sagemaker-monitoringschedule-endpointinput-s3datadistributiontype
         */
        readonly s3DataDistributionType?: string;
        /**
         * `CfnMonitoringSchedule.EndpointInputProperty.S3InputMode`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html#cfn-sagemaker-monitoringschedule-endpointinput-s3inputmode
         */
        readonly s3InputMode?: string;
    }
}
export declare namespace CfnMonitoringSchedule {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-environment.html
     */
    interface EnvironmentProperty {
    }
}
export declare namespace CfnMonitoringSchedule {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html
     */
    interface MonitoringAppSpecificationProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringAppSpecificationProperty.ContainerArguments`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-containerarguments
         */
        readonly containerArguments?: string[];
        /**
         * `CfnMonitoringSchedule.MonitoringAppSpecificationProperty.ContainerEntrypoint`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-containerentrypoint
         */
        readonly containerEntrypoint?: string[];
        /**
         * `CfnMonitoringSchedule.MonitoringAppSpecificationProperty.ImageUri`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-imageuri
         */
        readonly imageUri: string;
        /**
         * `CfnMonitoringSchedule.MonitoringAppSpecificationProperty.PostAnalyticsProcessorSourceUri`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-postanalyticsprocessorsourceuri
         */
        readonly postAnalyticsProcessorSourceUri?: string;
        /**
         * `CfnMonitoringSchedule.MonitoringAppSpecificationProperty.RecordPreprocessorSourceUri`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-recordpreprocessorsourceuri
         */
        readonly recordPreprocessorSourceUri?: string;
    }
}
export declare namespace CfnMonitoringSchedule {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html
     */
    interface MonitoringExecutionSummaryProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.CreationTime`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-creationtime
         */
        readonly creationTime: string;
        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.EndpointName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-endpointname
         */
        readonly endpointName?: string;
        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.FailureReason`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-failurereason
         */
        readonly failureReason?: string;
        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.LastModifiedTime`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-lastmodifiedtime
         */
        readonly lastModifiedTime: string;
        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.MonitoringExecutionStatus`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-monitoringexecutionstatus
         */
        readonly monitoringExecutionStatus: string;
        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.MonitoringScheduleName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-monitoringschedulename
         */
        readonly monitoringScheduleName: string;
        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.ProcessingJobArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-processingjobarn
         */
        readonly processingJobArn?: string;
        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.ScheduledTime`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-scheduledtime
         */
        readonly scheduledTime: string;
    }
}
export declare namespace CfnMonitoringSchedule {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringinput.html
     */
    interface MonitoringInputProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringInputProperty.EndpointInput`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringinput.html#cfn-sagemaker-monitoringschedule-monitoringinput-endpointinput
         */
        readonly endpointInput: CfnMonitoringSchedule.EndpointInputProperty | cdk.IResolvable;
    }
}
export declare namespace CfnMonitoringSchedule {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringinputs.html
     */
    interface MonitoringInputsProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringInputsProperty.MonitoringInputs`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringinputs.html#cfn-sagemaker-monitoringschedule-monitoringinputs-monitoringinputs
         */
        readonly monitoringInputs?: Array<CfnMonitoringSchedule.MonitoringInputProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnMonitoringSchedule {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html
     */
    interface MonitoringJobDefinitionProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.BaselineConfig`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-baselineconfig
         */
        readonly baselineConfig?: CfnMonitoringSchedule.BaselineConfigProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.Environment`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-environment
         */
        readonly environment?: CfnMonitoringSchedule.EnvironmentProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.MonitoringAppSpecification`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-monitoringappspecification
         */
        readonly monitoringAppSpecification: CfnMonitoringSchedule.MonitoringAppSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.MonitoringInputs`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-monitoringinputs
         */
        readonly monitoringInputs: CfnMonitoringSchedule.MonitoringInputsProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.MonitoringOutputConfig`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-monitoringoutputconfig
         */
        readonly monitoringOutputConfig: CfnMonitoringSchedule.MonitoringOutputConfigProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.MonitoringResources`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-monitoringresources
         */
        readonly monitoringResources: CfnMonitoringSchedule.MonitoringResourcesProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.NetworkConfig`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-networkconfig
         */
        readonly networkConfig?: CfnMonitoringSchedule.NetworkConfigProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.RoleArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-rolearn
         */
        readonly roleArn: string;
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.StoppingCondition`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-stoppingcondition
         */
        readonly stoppingCondition?: CfnMonitoringSchedule.StoppingConditionProperty | cdk.IResolvable;
    }
}
export declare namespace CfnMonitoringSchedule {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutput.html
     */
    interface MonitoringOutputProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringOutputProperty.S3Output`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutput.html#cfn-sagemaker-monitoringschedule-monitoringoutput-s3output
         */
        readonly s3Output: CfnMonitoringSchedule.S3OutputProperty | cdk.IResolvable;
    }
}
export declare namespace CfnMonitoringSchedule {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutputconfig.html
     */
    interface MonitoringOutputConfigProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringOutputConfigProperty.KmsKeyId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutputconfig.html#cfn-sagemaker-monitoringschedule-monitoringoutputconfig-kmskeyid
         */
        readonly kmsKeyId?: string;
        /**
         * `CfnMonitoringSchedule.MonitoringOutputConfigProperty.MonitoringOutputs`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutputconfig.html#cfn-sagemaker-monitoringschedule-monitoringoutputconfig-monitoringoutputs
         */
        readonly monitoringOutputs: Array<CfnMonitoringSchedule.MonitoringOutputProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnMonitoringSchedule {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringresources.html
     */
    interface MonitoringResourcesProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringResourcesProperty.ClusterConfig`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringresources.html#cfn-sagemaker-monitoringschedule-monitoringresources-clusterconfig
         */
        readonly clusterConfig: CfnMonitoringSchedule.ClusterConfigProperty | cdk.IResolvable;
    }
}
export declare namespace CfnMonitoringSchedule {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringscheduleconfig.html
     */
    interface MonitoringScheduleConfigProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringScheduleConfigProperty.MonitoringJobDefinition`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringscheduleconfig.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig-monitoringjobdefinition
         */
        readonly monitoringJobDefinition: CfnMonitoringSchedule.MonitoringJobDefinitionProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.MonitoringScheduleConfigProperty.ScheduleConfig`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringscheduleconfig.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig-scheduleconfig
         */
        readonly scheduleConfig?: CfnMonitoringSchedule.ScheduleConfigProperty | cdk.IResolvable;
    }
}
export declare namespace CfnMonitoringSchedule {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-networkconfig.html
     */
    interface NetworkConfigProperty {
        /**
         * `CfnMonitoringSchedule.NetworkConfigProperty.EnableInterContainerTrafficEncryption`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-networkconfig.html#cfn-sagemaker-monitoringschedule-networkconfig-enableintercontainertrafficencryption
         */
        readonly enableInterContainerTrafficEncryption?: boolean | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.NetworkConfigProperty.EnableNetworkIsolation`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-networkconfig.html#cfn-sagemaker-monitoringschedule-networkconfig-enablenetworkisolation
         */
        readonly enableNetworkIsolation?: boolean | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.NetworkConfigProperty.VpcConfig`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-networkconfig.html#cfn-sagemaker-monitoringschedule-networkconfig-vpcconfig
         */
        readonly vpcConfig?: CfnMonitoringSchedule.VpcConfigProperty | cdk.IResolvable;
    }
}
export declare namespace CfnMonitoringSchedule {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-s3output.html
     */
    interface S3OutputProperty {
        /**
         * `CfnMonitoringSchedule.S3OutputProperty.LocalPath`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-s3output.html#cfn-sagemaker-monitoringschedule-s3output-localpath
         */
        readonly localPath: string;
        /**
         * `CfnMonitoringSchedule.S3OutputProperty.S3UploadMode`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-s3output.html#cfn-sagemaker-monitoringschedule-s3output-s3uploadmode
         */
        readonly s3UploadMode?: string;
        /**
         * `CfnMonitoringSchedule.S3OutputProperty.S3Uri`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-s3output.html#cfn-sagemaker-monitoringschedule-s3output-s3uri
         */
        readonly s3Uri: string;
    }
}
export declare namespace CfnMonitoringSchedule {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-scheduleconfig.html
     */
    interface ScheduleConfigProperty {
        /**
         * `CfnMonitoringSchedule.ScheduleConfigProperty.ScheduleExpression`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-scheduleconfig.html#cfn-sagemaker-monitoringschedule-scheduleconfig-scheduleexpression
         */
        readonly scheduleExpression: string;
    }
}
export declare namespace CfnMonitoringSchedule {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-statisticsresource.html
     */
    interface StatisticsResourceProperty {
        /**
         * `CfnMonitoringSchedule.StatisticsResourceProperty.S3Uri`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-statisticsresource.html#cfn-sagemaker-monitoringschedule-statisticsresource-s3uri
         */
        readonly s3Uri?: string;
    }
}
export declare namespace CfnMonitoringSchedule {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-stoppingcondition.html
     */
    interface StoppingConditionProperty {
        /**
         * `CfnMonitoringSchedule.StoppingConditionProperty.MaxRuntimeInSeconds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-stoppingcondition.html#cfn-sagemaker-monitoringschedule-stoppingcondition-maxruntimeinseconds
         */
        readonly maxRuntimeInSeconds: number;
    }
}
export declare namespace CfnMonitoringSchedule {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-vpcconfig.html
     */
    interface VpcConfigProperty {
        /**
         * `CfnMonitoringSchedule.VpcConfigProperty.SecurityGroupIds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-vpcconfig.html#cfn-sagemaker-monitoringschedule-vpcconfig-securitygroupids
         */
        readonly securityGroupIds: string[];
        /**
         * `CfnMonitoringSchedule.VpcConfigProperty.Subnets`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-vpcconfig.html#cfn-sagemaker-monitoringschedule-vpcconfig-subnets
         */
        readonly subnets: string[];
    }
}
/**
 * Properties for defining a `AWS::SageMaker::NotebookInstance`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html
 */
export interface CfnNotebookInstanceProps {
    /**
     * `AWS::SageMaker::NotebookInstance.InstanceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-instancetype
     */
    readonly instanceType: string;
    /**
     * `AWS::SageMaker::NotebookInstance.RoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-rolearn
     */
    readonly roleArn: string;
    /**
     * `AWS::SageMaker::NotebookInstance.AcceleratorTypes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-acceleratortypes
     */
    readonly acceleratorTypes?: string[];
    /**
     * `AWS::SageMaker::NotebookInstance.AdditionalCodeRepositories`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-additionalcoderepositories
     */
    readonly additionalCodeRepositories?: string[];
    /**
     * `AWS::SageMaker::NotebookInstance.DefaultCodeRepository`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-defaultcoderepository
     */
    readonly defaultCodeRepository?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.DirectInternetAccess`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-directinternetaccess
     */
    readonly directInternetAccess?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.KmsKeyId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-kmskeyid
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.LifecycleConfigName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-lifecycleconfigname
     */
    readonly lifecycleConfigName?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.NotebookInstanceName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-notebookinstancename
     */
    readonly notebookInstanceName?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.RootAccess`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-rootaccess
     */
    readonly rootAccess?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.SecurityGroupIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-securitygroupids
     */
    readonly securityGroupIds?: string[];
    /**
     * `AWS::SageMaker::NotebookInstance.SubnetId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-subnetid
     */
    readonly subnetId?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::SageMaker::NotebookInstance.VolumeSizeInGB`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-volumesizeingb
     */
    readonly volumeSizeInGb?: number;
}
/**
 * A CloudFormation `AWS::SageMaker::NotebookInstance`
 *
 * @cloudformationResource AWS::SageMaker::NotebookInstance
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html
 */
export declare class CfnNotebookInstance extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::NotebookInstance";
    /**
     * @cloudformationAttribute NotebookInstanceName
     */
    readonly attrNotebookInstanceName: string;
    /**
     * `AWS::SageMaker::NotebookInstance.InstanceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-instancetype
     */
    instanceType: string;
    /**
     * `AWS::SageMaker::NotebookInstance.RoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-rolearn
     */
    roleArn: string;
    /**
     * `AWS::SageMaker::NotebookInstance.AcceleratorTypes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-acceleratortypes
     */
    acceleratorTypes: string[] | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.AdditionalCodeRepositories`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-additionalcoderepositories
     */
    additionalCodeRepositories: string[] | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.DefaultCodeRepository`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-defaultcoderepository
     */
    defaultCodeRepository: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.DirectInternetAccess`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-directinternetaccess
     */
    directInternetAccess: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.KmsKeyId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-kmskeyid
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.LifecycleConfigName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-lifecycleconfigname
     */
    lifecycleConfigName: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.NotebookInstanceName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-notebookinstancename
     */
    notebookInstanceName: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.RootAccess`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-rootaccess
     */
    rootAccess: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.SecurityGroupIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-securitygroupids
     */
    securityGroupIds: string[] | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.SubnetId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-subnetid
     */
    subnetId: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::SageMaker::NotebookInstance.VolumeSizeInGB`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-volumesizeingb
     */
    volumeSizeInGb: number | undefined;
    /**
     * Create a new `AWS::SageMaker::NotebookInstance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNotebookInstanceProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::SageMaker::NotebookInstanceLifecycleConfig`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html
 */
export interface CfnNotebookInstanceLifecycleConfigProps {
    /**
     * `AWS::SageMaker::NotebookInstanceLifecycleConfig.NotebookInstanceLifecycleConfigName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html#cfn-sagemaker-notebookinstancelifecycleconfig-notebookinstancelifecycleconfigname
     */
    readonly notebookInstanceLifecycleConfigName?: string;
    /**
     * `AWS::SageMaker::NotebookInstanceLifecycleConfig.OnCreate`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html#cfn-sagemaker-notebookinstancelifecycleconfig-oncreate
     */
    readonly onCreate?: Array<CfnNotebookInstanceLifecycleConfig.NotebookInstanceLifecycleHookProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SageMaker::NotebookInstanceLifecycleConfig.OnStart`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html#cfn-sagemaker-notebookinstancelifecycleconfig-onstart
     */
    readonly onStart?: Array<CfnNotebookInstanceLifecycleConfig.NotebookInstanceLifecycleHookProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::SageMaker::NotebookInstanceLifecycleConfig`
 *
 * @cloudformationResource AWS::SageMaker::NotebookInstanceLifecycleConfig
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html
 */
export declare class CfnNotebookInstanceLifecycleConfig extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::NotebookInstanceLifecycleConfig";
    /**
     * @cloudformationAttribute NotebookInstanceLifecycleConfigName
     */
    readonly attrNotebookInstanceLifecycleConfigName: string;
    /**
     * `AWS::SageMaker::NotebookInstanceLifecycleConfig.NotebookInstanceLifecycleConfigName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html#cfn-sagemaker-notebookinstancelifecycleconfig-notebookinstancelifecycleconfigname
     */
    notebookInstanceLifecycleConfigName: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstanceLifecycleConfig.OnCreate`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html#cfn-sagemaker-notebookinstancelifecycleconfig-oncreate
     */
    onCreate: Array<CfnNotebookInstanceLifecycleConfig.NotebookInstanceLifecycleHookProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::NotebookInstanceLifecycleConfig.OnStart`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html#cfn-sagemaker-notebookinstancelifecycleconfig-onstart
     */
    onStart: Array<CfnNotebookInstanceLifecycleConfig.NotebookInstanceLifecycleHookProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::SageMaker::NotebookInstanceLifecycleConfig`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnNotebookInstanceLifecycleConfigProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnNotebookInstanceLifecycleConfig {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-notebookinstancelifecycleconfig-notebookinstancelifecyclehook.html
     */
    interface NotebookInstanceLifecycleHookProperty {
        /**
         * `CfnNotebookInstanceLifecycleConfig.NotebookInstanceLifecycleHookProperty.Content`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-notebookinstancelifecycleconfig-notebookinstancelifecyclehook.html#cfn-sagemaker-notebookinstancelifecycleconfig-notebookinstancelifecyclehook-content
         */
        readonly content?: string;
    }
}
/**
 * Properties for defining a `AWS::SageMaker::Workteam`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html
 */
export interface CfnWorkteamProps {
    /**
     * `AWS::SageMaker::Workteam.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-description
     */
    readonly description?: string;
    /**
     * `AWS::SageMaker::Workteam.MemberDefinitions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-memberdefinitions
     */
    readonly memberDefinitions?: Array<CfnWorkteam.MemberDefinitionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Workteam.NotificationConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-notificationconfiguration
     */
    readonly notificationConfiguration?: CfnWorkteam.NotificationConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Workteam.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::SageMaker::Workteam.WorkteamName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-workteamname
     */
    readonly workteamName?: string;
}
/**
 * A CloudFormation `AWS::SageMaker::Workteam`
 *
 * @cloudformationResource AWS::SageMaker::Workteam
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html
 */
export declare class CfnWorkteam extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::Workteam";
    /**
     * @cloudformationAttribute WorkteamName
     */
    readonly attrWorkteamName: string;
    /**
     * `AWS::SageMaker::Workteam.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-description
     */
    description: string | undefined;
    /**
     * `AWS::SageMaker::Workteam.MemberDefinitions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-memberdefinitions
     */
    memberDefinitions: Array<CfnWorkteam.MemberDefinitionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Workteam.NotificationConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-notificationconfiguration
     */
    notificationConfiguration: CfnWorkteam.NotificationConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Workteam.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::SageMaker::Workteam.WorkteamName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-workteamname
     */
    workteamName: string | undefined;
    /**
     * Create a new `AWS::SageMaker::Workteam`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnWorkteamProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnWorkteam {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-cognitomemberdefinition.html
     */
    interface CognitoMemberDefinitionProperty {
        /**
         * `CfnWorkteam.CognitoMemberDefinitionProperty.CognitoClientId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-cognitomemberdefinition.html#cfn-sagemaker-workteam-cognitomemberdefinition-cognitoclientid
         */
        readonly cognitoClientId: string;
        /**
         * `CfnWorkteam.CognitoMemberDefinitionProperty.CognitoUserGroup`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-cognitomemberdefinition.html#cfn-sagemaker-workteam-cognitomemberdefinition-cognitousergroup
         */
        readonly cognitoUserGroup: string;
        /**
         * `CfnWorkteam.CognitoMemberDefinitionProperty.CognitoUserPool`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-cognitomemberdefinition.html#cfn-sagemaker-workteam-cognitomemberdefinition-cognitouserpool
         */
        readonly cognitoUserPool: string;
    }
}
export declare namespace CfnWorkteam {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-memberdefinition.html
     */
    interface MemberDefinitionProperty {
        /**
         * `CfnWorkteam.MemberDefinitionProperty.CognitoMemberDefinition`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-memberdefinition.html#cfn-sagemaker-workteam-memberdefinition-cognitomemberdefinition
         */
        readonly cognitoMemberDefinition: CfnWorkteam.CognitoMemberDefinitionProperty | cdk.IResolvable;
    }
}
export declare namespace CfnWorkteam {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-notificationconfiguration.html
     */
    interface NotificationConfigurationProperty {
        /**
         * `CfnWorkteam.NotificationConfigurationProperty.NotificationTopicArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-notificationconfiguration.html#cfn-sagemaker-workteam-notificationconfiguration-notificationtopicarn
         */
        readonly notificationTopicArn: string;
    }
}
