# lusid-workflows-sdk
FINBOURNE Technology

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.25
- Package version: 0.1.25
- Build package: org.openapitools.codegen.languages.PythonLegacyClientCodegen
For more information, please visit [https://www.finbourne.com](https://www.finbourne.com)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import lusid_workflows
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import lusid_workflows
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import lusid_workflows
from lusid_workflows.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://fbn-ci.lusid.com/workflows
# See configuration.py for a list of all supported configuration parameters.
configuration = lusid_workflows.Configuration(
    host = "https://fbn-ci.lusid.com/workflows"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure OAuth2 access token for authorization: oauth2
configuration = lusid_workflows.Configuration(
    host = "https://fbn-ci.lusid.com/workflows"
)
configuration.access_token = 'YOUR_ACCESS_TOKEN'


# Enter a context with an instance of the API client
with lusid_workflows.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = lusid_workflows.WorkflowsApi(api_client)
    workflow_code = 'workflow_code_example' # str | Workflow Code
execute_workflow_request = {"context":{"comments":"Issue Workflow created","totalIssues":"100","by":"Joe Root","at":"01/01/2021 10:00:00"}} # ExecuteWorkflowRequest | Data associated with execute request
correlation_id = 'correlation_id_example' # str | Optional. This id can be used to correlate a workflow instance with any entity (e.g. a custom entity or other workflow instance) and also to retrieve and transit workflow instances (optional)

    try:
        # [EXPERIMENTAL] Execute workflow
        api_response = api_instance.execute_workflow(workflow_code, execute_workflow_request, correlation_id=correlation_id)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling WorkflowsApi->execute_workflow: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://fbn-ci.lusid.com/workflows*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*WorkflowsApi* | [**execute_workflow**](docs/WorkflowsApi.md#execute_workflow) | **POST** /api/v1/workflows/{workflowCode} | [EXPERIMENTAL] Execute workflow
*WorkflowsApi* | [**get_workflow_instance**](docs/WorkflowsApi.md#get_workflow_instance) | **GET** /api/v1/workflows/instances/{workflowInstanceId} | [EXPERIMENTAL] Get workflow instance
*WorkflowsApi* | [**get_workflow_instance_by_correlation_id**](docs/WorkflowsApi.md#get_workflow_instance_by_correlation_id) | **GET** /api/v1/workflows/instance/{correlationId} | [EXPERIMENTAL] Get workflow instance
*WorkflowsApi* | [**list_workflow_instances**](docs/WorkflowsApi.md#list_workflow_instances) | **GET** /api/v1/workflows/instances | [EXPERIMENTAL] Get workflow instances
*WorkflowsApi* | [**list_workflows**](docs/WorkflowsApi.md#list_workflows) | **GET** /api/v1/workflows | [EXPERIMENTAL] Get all available workflows
*WorkflowsApi* | [**transit_workflow**](docs/WorkflowsApi.md#transit_workflow) | **POST** /api/v1/workflows/instances/{workflowInstanceId} | [EXPERIMENTAL] Transit workflow
*WorkflowsApi* | [**transit_workflow_by_correlation_id**](docs/WorkflowsApi.md#transit_workflow_by_correlation_id) | **POST** /api/v1/workflows/instance/{correlationId} | [EXPERIMENTAL] Transit workflow


## Documentation For Models

 - [ExecuteWorkflowRequest](docs/ExecuteWorkflowRequest.md)
 - [Link](docs/Link.md)
 - [LusidProblemDetails](docs/LusidProblemDetails.md)
 - [LusidValidationProblemDetails](docs/LusidValidationProblemDetails.md)
 - [ResourceListOfWorkflow](docs/ResourceListOfWorkflow.md)
 - [ResourceListOfWorkflowInstance](docs/ResourceListOfWorkflowInstance.md)
 - [TransitWorkflowRequest](docs/TransitWorkflowRequest.md)
 - [Workflow](docs/Workflow.md)
 - [WorkflowActivitySummary](docs/WorkflowActivitySummary.md)
 - [WorkflowInstance](docs/WorkflowInstance.md)


## Documentation For Authorization


## oauth2

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: https://lusid.okta.com/oauth2/default/v1/authorize
- **Scopes**: N/A


## Author

info@finbourne.com


