/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.asm.tree;

import java.util.ArrayList;
import java.util.List;
import scala.tools.asm.AnnotationVisitor;

public class AnnotationNode
extends AnnotationVisitor {
    public String desc;
    public List<Object> values;

    public AnnotationNode(String desc) {
        this(327680, desc);
        if (this.getClass() != AnnotationNode.class) {
            throw new IllegalStateException();
        }
    }

    public AnnotationNode(int api2, String desc) {
        super(api2);
        this.desc = desc;
    }

    AnnotationNode(List<Object> values2) {
        super(327680);
        this.values = values2;
    }

    @Override
    public void visit(String name, Object value2) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name);
        }
        if (value2 instanceof byte[]) {
            byte[] v = (byte[])value2;
            ArrayList<Byte> l = new ArrayList<Byte>(v.length);
            for (byte b : v) {
                l.add(b);
            }
            this.values.add(l);
        } else if (value2 instanceof boolean[]) {
            boolean[] v = (boolean[])value2;
            ArrayList<Boolean> l = new ArrayList<Boolean>(v.length);
            for (boolean b : v) {
                l.add(b);
            }
            this.values.add(l);
        } else if (value2 instanceof short[]) {
            short[] v = (short[])value2;
            ArrayList<Short> l = new ArrayList<Short>(v.length);
            for (short s2 : v) {
                l.add(s2);
            }
            this.values.add(l);
        } else if (value2 instanceof char[]) {
            char[] v = (char[])value2;
            ArrayList<Character> l = new ArrayList<Character>(v.length);
            for (char c : v) {
                l.add(Character.valueOf(c));
            }
            this.values.add(l);
        } else if (value2 instanceof int[]) {
            int[] v = (int[])value2;
            ArrayList<Integer> l = new ArrayList<Integer>(v.length);
            for (int i : v) {
                l.add(i);
            }
            this.values.add(l);
        } else if (value2 instanceof long[]) {
            long[] v = (long[])value2;
            ArrayList<Long> l = new ArrayList<Long>(v.length);
            for (long lng : v) {
                l.add(lng);
            }
            this.values.add(l);
        } else if (value2 instanceof float[]) {
            float[] v = (float[])value2;
            ArrayList<Float> l = new ArrayList<Float>(v.length);
            for (float f2 : v) {
                l.add(Float.valueOf(f2));
            }
            this.values.add(l);
        } else if (value2 instanceof double[]) {
            double[] v = (double[])value2;
            ArrayList<Double> l = new ArrayList<Double>(v.length);
            for (double d : v) {
                l.add(d);
            }
            this.values.add(l);
        } else {
            this.values.add(value2);
        }
    }

    @Override
    public void visitEnum(String name, String desc, String value2) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name);
        }
        this.values.add(new String[]{desc, value2});
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name, String desc) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name);
        }
        AnnotationNode annotation2 = new AnnotationNode(desc);
        this.values.add(annotation2);
        return annotation2;
    }

    @Override
    public AnnotationVisitor visitArray(String name) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name);
        }
        ArrayList<Object> array = new ArrayList<Object>();
        this.values.add(array);
        return new AnnotationNode(array);
    }

    @Override
    public void visitEnd() {
    }

    public void check(int api2) {
    }

    public void accept(AnnotationVisitor av) {
        if (av != null) {
            if (this.values != null) {
                for (int i = 0; i < this.values.size(); i += 2) {
                    String name = (String)this.values.get(i);
                    Object value2 = this.values.get(i + 1);
                    AnnotationNode.accept(av, name, value2);
                }
            }
            av.visitEnd();
        }
    }

    static void accept(AnnotationVisitor av, String name, Object value2) {
        if (av != null) {
            if (value2 instanceof String[]) {
                String[] typeconst = (String[])value2;
                av.visitEnum(name, typeconst[0], typeconst[1]);
            } else if (value2 instanceof AnnotationNode) {
                AnnotationNode an = (AnnotationNode)value2;
                an.accept(av.visitAnnotation(name, an.desc));
            } else if (value2 instanceof List) {
                AnnotationVisitor v = av.visitArray(name);
                if (v != null) {
                    List array = (List)value2;
                    for (int j = 0; j < array.size(); ++j) {
                        AnnotationNode.accept(v, null, array.get(j));
                    }
                    v.visitEnd();
                }
            } else {
                av.visit(name, value2);
            }
        }
    }
}

