/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import redis.clients.jedis.BinaryShardedJedis;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ListPosition;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.ShardedJedisPool;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.StreamEntry;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.StreamPendingEntry;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.commands.JedisCommands;
import redis.clients.jedis.params.GeoRadiusParam;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.params.ZIncrByParams;
import redis.clients.jedis.util.Hashing;

public class ShardedJedis
extends BinaryShardedJedis
implements JedisCommands,
Closeable {
    protected ShardedJedisPool dataSource = null;

    public ShardedJedis(List<JedisShardInfo> shards) {
        super(shards);
    }

    public ShardedJedis(List<JedisShardInfo> shards, Hashing algo) {
        super(shards, algo);
    }

    public ShardedJedis(List<JedisShardInfo> shards, Pattern keyTagPattern) {
        super(shards, keyTagPattern);
    }

    public ShardedJedis(List<JedisShardInfo> shards, Hashing algo, Pattern keyTagPattern) {
        super(shards, algo, keyTagPattern);
    }

    @Override
    public String set(String key, String value2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.set(key, value2);
    }

    @Override
    public String set(String key, String value2, SetParams params2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.set(key, value2, params2);
    }

    @Override
    public String get(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.get(key);
    }

    @Override
    public String echo(String string2) {
        Jedis j = (Jedis)this.getShard(string2);
        return j.echo(string2);
    }

    @Override
    public Boolean exists(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.exists(key);
    }

    @Override
    public String type(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.type(key);
    }

    @Override
    public byte[] dump(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.dump(key);
    }

    @Override
    public String restore(String key, int ttl, byte[] serializedValue) {
        Jedis j = (Jedis)this.getShard(key);
        return j.restore(key, ttl, serializedValue);
    }

    @Override
    public String restoreReplace(String key, int ttl, byte[] serializedValue) {
        Jedis j = (Jedis)this.getShard(key);
        return j.restoreReplace(key, ttl, serializedValue);
    }

    @Override
    public Long expire(String key, int seconds) {
        Jedis j = (Jedis)this.getShard(key);
        return j.expire(key, seconds);
    }

    @Override
    public Long pexpire(String key, long milliseconds) {
        Jedis j = (Jedis)this.getShard(key);
        return j.pexpire(key, milliseconds);
    }

    @Override
    public Long expireAt(String key, long unixTime) {
        Jedis j = (Jedis)this.getShard(key);
        return j.expireAt(key, unixTime);
    }

    @Override
    public Long pexpireAt(String key, long millisecondsTimestamp) {
        Jedis j = (Jedis)this.getShard(key);
        return j.pexpireAt(key, millisecondsTimestamp);
    }

    @Override
    public Long ttl(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.ttl(key);
    }

    @Override
    public Long pttl(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.pttl(key);
    }

    @Override
    public Boolean setbit(String key, long offset, boolean value2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.setbit(key, offset, value2);
    }

    @Override
    public Boolean setbit(String key, long offset, String value2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.setbit(key, offset, value2);
    }

    @Override
    public Boolean getbit(String key, long offset) {
        Jedis j = (Jedis)this.getShard(key);
        return j.getbit(key, offset);
    }

    @Override
    public Long setrange(String key, long offset, String value2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.setrange(key, offset, value2);
    }

    @Override
    public String getrange(String key, long startOffset, long endOffset) {
        Jedis j = (Jedis)this.getShard(key);
        return j.getrange(key, startOffset, endOffset);
    }

    @Override
    public String getSet(String key, String value2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.getSet(key, value2);
    }

    @Override
    public Long setnx(String key, String value2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.setnx(key, value2);
    }

    @Override
    public String setex(String key, int seconds, String value2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.setex(key, seconds, value2);
    }

    @Override
    public String psetex(String key, long milliseconds, String value2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.psetex(key, milliseconds, value2);
    }

    public List<String> blpop(String arg) {
        Jedis j = (Jedis)this.getShard(arg);
        return j.blpop(arg);
    }

    @Override
    public List<String> blpop(int timeout, String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.blpop(timeout, key);
    }

    public List<String> brpop(String arg) {
        Jedis j = (Jedis)this.getShard(arg);
        return j.brpop(arg);
    }

    @Override
    public List<String> brpop(int timeout, String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.brpop(timeout, key);
    }

    @Override
    public Long decrBy(String key, long decrement) {
        Jedis j = (Jedis)this.getShard(key);
        return j.decrBy(key, decrement);
    }

    @Override
    public Long decr(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.decr(key);
    }

    @Override
    public Long incrBy(String key, long increment) {
        Jedis j = (Jedis)this.getShard(key);
        return j.incrBy(key, increment);
    }

    @Override
    public Double incrByFloat(String key, double increment) {
        Jedis j = (Jedis)this.getShard(key);
        return j.incrByFloat(key, increment);
    }

    @Override
    public Long incr(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.incr(key);
    }

    @Override
    public Long append(String key, String value2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.append(key, value2);
    }

    @Override
    public String substr(String key, int start2, int end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.substr(key, start2, end);
    }

    @Override
    public Long hset(String key, String field2, String value2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hset(key, field2, value2);
    }

    @Override
    public Long hset(String key, Map<String, String> hash) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hset(key, hash);
    }

    @Override
    public String hget(String key, String field2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hget(key, field2);
    }

    @Override
    public Long hsetnx(String key, String field2, String value2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hsetnx(key, field2, value2);
    }

    @Override
    public String hmset(String key, Map<String, String> hash) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hmset(key, hash);
    }

    @Override
    public List<String> hmget(String key, String ... fields) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hmget(key, fields);
    }

    @Override
    public Long hincrBy(String key, String field2, long value2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hincrBy(key, field2, value2);
    }

    @Override
    public Double hincrByFloat(String key, String field2, double value2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hincrByFloat(key, field2, value2);
    }

    @Override
    public Boolean hexists(String key, String field2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hexists(key, field2);
    }

    @Override
    public Long del(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.del(key);
    }

    @Override
    public Long unlink(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.unlink(key);
    }

    @Override
    public Long hdel(String key, String ... fields) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hdel(key, fields);
    }

    @Override
    public Long hlen(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hlen(key);
    }

    @Override
    public Set<String> hkeys(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hkeys(key);
    }

    @Override
    public List<String> hvals(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hvals(key);
    }

    @Override
    public Map<String, String> hgetAll(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hgetAll(key);
    }

    @Override
    public Long rpush(String key, String ... strings) {
        Jedis j = (Jedis)this.getShard(key);
        return j.rpush(key, strings);
    }

    @Override
    public Long lpush(String key, String ... strings) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lpush(key, strings);
    }

    @Override
    public Long lpushx(String key, String ... string2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lpushx(key, string2);
    }

    @Override
    public Long strlen(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.strlen(key);
    }

    @Override
    public Long move(String key, int dbIndex) {
        Jedis j = (Jedis)this.getShard(key);
        return j.move(key, dbIndex);
    }

    @Override
    public Long rpushx(String key, String ... string2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.rpushx(key, string2);
    }

    @Override
    public Long persist(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.persist(key);
    }

    @Override
    public Long llen(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.llen(key);
    }

    @Override
    public List<String> lrange(String key, long start2, long stop) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lrange(key, start2, stop);
    }

    @Override
    public String ltrim(String key, long start2, long stop) {
        Jedis j = (Jedis)this.getShard(key);
        return j.ltrim(key, start2, stop);
    }

    @Override
    public String lindex(String key, long index2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lindex(key, index2);
    }

    @Override
    public String lset(String key, long index2, String value2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lset(key, index2, value2);
    }

    @Override
    public Long lrem(String key, long count2, String value2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lrem(key, count2, value2);
    }

    @Override
    public String lpop(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lpop(key);
    }

    @Override
    public String rpop(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.rpop(key);
    }

    @Override
    public Long sadd(String key, String ... members2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sadd(key, members2);
    }

    @Override
    public Set<String> smembers(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.smembers(key);
    }

    @Override
    public Long srem(String key, String ... members2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.srem(key, members2);
    }

    @Override
    public String spop(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.spop(key);
    }

    @Override
    public Set<String> spop(String key, long count2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.spop(key, count2);
    }

    @Override
    public Long scard(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.scard(key);
    }

    @Override
    public Boolean sismember(String key, String member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sismember(key, member);
    }

    @Override
    public String srandmember(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.srandmember(key);
    }

    @Override
    public List<String> srandmember(String key, int count2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.srandmember(key, count2);
    }

    @Override
    public Long zadd(String key, double score, String member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zadd(key, score, member);
    }

    @Override
    public Long zadd(String key, double score, String member, ZAddParams params2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zadd(key, score, member, params2);
    }

    @Override
    public Long zadd(String key, Map<String, Double> scoreMembers) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zadd(key, scoreMembers);
    }

    @Override
    public Long zadd(String key, Map<String, Double> scoreMembers, ZAddParams params2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zadd(key, scoreMembers, params2);
    }

    @Override
    public Set<String> zrange(String key, long start2, long stop) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrange(key, start2, stop);
    }

    @Override
    public Long zrem(String key, String ... members2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrem(key, members2);
    }

    @Override
    public Double zincrby(String key, double increment, String member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zincrby(key, increment, member);
    }

    @Override
    public Double zincrby(String key, double increment, String member, ZIncrByParams params2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zincrby(key, increment, member, params2);
    }

    @Override
    public Long zrank(String key, String member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrank(key, member);
    }

    @Override
    public Long zrevrank(String key, String member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrank(key, member);
    }

    @Override
    public Set<String> zrevrange(String key, long start2, long stop) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrange(key, start2, stop);
    }

    @Override
    public Set<Tuple> zrangeWithScores(String key, long start2, long stop) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeWithScores(key, start2, stop);
    }

    @Override
    public Set<Tuple> zrevrangeWithScores(String key, long start2, long stop) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeWithScores(key, start2, stop);
    }

    @Override
    public Long zcard(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zcard(key);
    }

    @Override
    public Double zscore(String key, String member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zscore(key, member);
    }

    @Override
    public List<String> sort(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sort(key);
    }

    @Override
    public List<String> sort(String key, SortingParams sortingParameters) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sort(key, sortingParameters);
    }

    @Override
    public Long zcount(String key, double min2, double max2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zcount(key, min2, max2);
    }

    @Override
    public Long zcount(String key, String min2, String max2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zcount(key, min2, max2);
    }

    @Override
    public Set<String> zrangeByScore(String key, double min2, double max2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScore(key, min2, max2);
    }

    @Override
    public Set<String> zrevrangeByScore(String key, double max2, double min2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScore(key, max2, min2);
    }

    @Override
    public Set<String> zrangeByScore(String key, double min2, double max2, int offset, int count2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScore(key, min2, max2, offset, count2);
    }

    @Override
    public Set<String> zrevrangeByScore(String key, double max2, double min2, int offset, int count2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScore(key, max2, min2, offset, count2);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, double min2, double max2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScoreWithScores(key, min2, max2);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max2, double min2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScoreWithScores(key, max2, min2);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, double min2, double max2, int offset, int count2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScoreWithScores(key, min2, max2, offset, count2);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max2, double min2, int offset, int count2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScoreWithScores(key, max2, min2, offset, count2);
    }

    @Override
    public Set<String> zrangeByScore(String key, String min2, String max2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScore(key, min2, max2);
    }

    @Override
    public Set<String> zrevrangeByScore(String key, String max2, String min2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScore(key, max2, min2);
    }

    @Override
    public Set<String> zrangeByScore(String key, String min2, String max2, int offset, int count2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScore(key, min2, max2, offset, count2);
    }

    @Override
    public Set<String> zrevrangeByScore(String key, String max2, String min2, int offset, int count2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScore(key, max2, min2, offset, count2);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, String min2, String max2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScoreWithScores(key, min2, max2);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max2, String min2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScoreWithScores(key, max2, min2);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, String min2, String max2, int offset, int count2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScoreWithScores(key, min2, max2, offset, count2);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max2, String min2, int offset, int count2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScoreWithScores(key, max2, min2, offset, count2);
    }

    @Override
    public Long zremrangeByRank(String key, long start2, long stop) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zremrangeByRank(key, start2, stop);
    }

    @Override
    public Long zremrangeByScore(String key, double min2, double max2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zremrangeByScore(key, min2, max2);
    }

    @Override
    public Long zremrangeByScore(String key, String min2, String max2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zremrangeByScore(key, min2, max2);
    }

    @Override
    public Long zlexcount(String key, String min2, String max2) {
        return ((Jedis)this.getShard(key)).zlexcount(key, min2, max2);
    }

    @Override
    public Set<String> zrangeByLex(String key, String min2, String max2) {
        return ((Jedis)this.getShard(key)).zrangeByLex(key, min2, max2);
    }

    @Override
    public Set<String> zrangeByLex(String key, String min2, String max2, int offset, int count2) {
        return ((Jedis)this.getShard(key)).zrangeByLex(key, min2, max2, offset, count2);
    }

    @Override
    public Set<String> zrevrangeByLex(String key, String max2, String min2) {
        return ((Jedis)this.getShard(key)).zrevrangeByLex(key, max2, min2);
    }

    @Override
    public Set<String> zrevrangeByLex(String key, String max2, String min2, int offset, int count2) {
        return ((Jedis)this.getShard(key)).zrevrangeByLex(key, max2, min2, offset, count2);
    }

    @Override
    public Long zremrangeByLex(String key, String min2, String max2) {
        return ((Jedis)this.getShard(key)).zremrangeByLex(key, min2, max2);
    }

    @Override
    public Long linsert(String key, ListPosition where, String pivot, String value2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.linsert(key, where, pivot, value2);
    }

    @Override
    public Long bitcount(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.bitcount(key);
    }

    @Override
    public Long bitcount(String key, long start2, long end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.bitcount(key, start2, end);
    }

    @Override
    public Long bitpos(String key, boolean value2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.bitpos(key, value2);
    }

    @Override
    public Long bitpos(String key, boolean value2, BitPosParams params2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.bitpos(key, value2, params2);
    }

    @Override
    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hscan(key, cursor);
    }

    @Override
    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor, ScanParams params2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hscan(key, cursor, params2);
    }

    @Override
    public ScanResult<String> sscan(String key, String cursor) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sscan(key, cursor);
    }

    @Override
    public ScanResult<Tuple> zscan(String key, String cursor) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zscan(key, cursor);
    }

    @Override
    public ScanResult<Tuple> zscan(String key, String cursor, ScanParams params2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zscan(key, cursor, params2);
    }

    @Override
    public ScanResult<String> sscan(String key, String cursor, ScanParams params2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sscan(key, cursor, params2);
    }

    @Override
    public void close() {
        if (this.dataSource != null) {
            boolean broken = false;
            for (Jedis jedis : this.getAllShards()) {
                if (!jedis.getClient().isBroken()) continue;
                broken = true;
                break;
            }
            if (broken) {
                this.dataSource.returnBrokenResource(this);
            } else {
                this.dataSource.returnResource(this);
            }
            this.dataSource = null;
        } else {
            this.disconnect();
        }
    }

    public void setDataSource(ShardedJedisPool shardedJedisPool) {
        this.dataSource = shardedJedisPool;
    }

    public void resetState() {
        for (Jedis jedis : this.getAllShards()) {
            jedis.resetState();
        }
    }

    @Override
    public Long pfadd(String key, String ... elements2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.pfadd(key, elements2);
    }

    @Override
    public long pfcount(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.pfcount(key);
    }

    @Override
    public Long touch(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.touch(key);
    }

    @Override
    public Long geoadd(String key, double longitude, double latitude, String member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.geoadd(key, longitude, latitude, member);
    }

    @Override
    public Long geoadd(String key, Map<String, GeoCoordinate> memberCoordinateMap) {
        Jedis j = (Jedis)this.getShard(key);
        return j.geoadd(key, memberCoordinateMap);
    }

    @Override
    public Double geodist(String key, String member1, String member2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.geodist(key, member1, member2);
    }

    @Override
    public Double geodist(String key, String member1, String member2, GeoUnit unit2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.geodist(key, member1, member2, unit2);
    }

    @Override
    public List<String> geohash(String key, String ... members2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.geohash(key, members2);
    }

    @Override
    public List<GeoCoordinate> geopos(String key, String ... members2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.geopos(key, members2);
    }

    @Override
    public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.georadius(key, longitude, latitude, radius, unit2);
    }

    @Override
    public List<GeoRadiusResponse> georadiusReadonly(String key, double longitude, double latitude, double radius, GeoUnit unit2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.georadiusReadonly(key, longitude, latitude, radius, unit2);
    }

    @Override
    public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit2, GeoRadiusParam param2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.georadius(key, longitude, latitude, radius, unit2, param2);
    }

    @Override
    public List<GeoRadiusResponse> georadiusReadonly(String key, double longitude, double latitude, double radius, GeoUnit unit2, GeoRadiusParam param2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.georadiusReadonly(key, longitude, latitude, radius, unit2, param2);
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(String key, String member, double radius, GeoUnit unit2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.georadiusByMember(key, member, radius, unit2);
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMemberReadonly(String key, String member, double radius, GeoUnit unit2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.georadiusByMemberReadonly(key, member, radius, unit2);
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(String key, String member, double radius, GeoUnit unit2, GeoRadiusParam param2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.georadiusByMember(key, member, radius, unit2, param2);
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMemberReadonly(String key, String member, double radius, GeoUnit unit2, GeoRadiusParam param2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.georadiusByMemberReadonly(key, member, radius, unit2, param2);
    }

    @Override
    public List<Long> bitfield(String key, String ... arguments) {
        Jedis j = (Jedis)this.getShard(key);
        return j.bitfield(key, arguments);
    }

    @Override
    public Long hstrlen(String key, String field2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hstrlen(key, field2);
    }

    @Override
    public StreamEntryID xadd(String key, StreamEntryID id, Map<String, String> hash) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xadd(key, id, hash);
    }

    @Override
    public StreamEntryID xadd(String key, StreamEntryID id, Map<String, String> hash, long maxLen, boolean approximateLength) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xadd(key, id, hash, maxLen, approximateLength);
    }

    @Override
    public Long xlen(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xlen(key);
    }

    @Override
    public List<StreamEntry> xrange(String key, StreamEntryID start2, StreamEntryID end, int count2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xrange(key, start2, end, count2);
    }

    @Override
    public long xack(String key, String group2, StreamEntryID ... ids) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xack(key, group2, ids);
    }

    @Override
    public String xgroupCreate(String key, String consumer, StreamEntryID id, boolean makeStream) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xgroupCreate(key, consumer, id, makeStream);
    }

    @Override
    public String xgroupSetID(String key, String groupname, StreamEntryID id) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xgroupSetID(key, groupname, id);
    }

    @Override
    public long xgroupDestroy(String key, String groupname) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xgroupDestroy(key, groupname);
    }

    @Override
    public String xgroupDelConsumer(String key, String groupname, String consumername) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xgroupDelConsumer(key, groupname, consumername);
    }

    @Override
    public long xdel(String key, StreamEntryID ... ids) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xdel(key, ids);
    }

    @Override
    public long xtrim(String key, long maxLen, boolean approximateLength) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xtrim(key, maxLen, approximateLength);
    }

    @Override
    public List<StreamEntry> xrevrange(String key, StreamEntryID end, StreamEntryID start2, int count2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xrevrange(key, end, start2, count2);
    }

    @Override
    public List<StreamPendingEntry> xpending(String key, String groupname, StreamEntryID start2, StreamEntryID end, int count2, String consumername) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xpending(key, groupname, start2, end, count2, consumername);
    }

    @Override
    public List<StreamEntry> xclaim(String key, String group2, String consumername, long minIdleTime, long newIdleTime, int retries, boolean force, StreamEntryID ... ids) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xclaim(key, group2, consumername, minIdleTime, newIdleTime, retries, force, ids);
    }
}

