/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.util.SafeEncoder;

public class ScanParams {
    private final Map<Protocol.Keyword, ByteBuffer> params = new EnumMap<Protocol.Keyword, ByteBuffer>(Protocol.Keyword.class);
    public static final String SCAN_POINTER_START = String.valueOf(0);
    public static final byte[] SCAN_POINTER_START_BINARY = SafeEncoder.encode(SCAN_POINTER_START);

    public ScanParams match(byte[] pattern) {
        this.params.put(Protocol.Keyword.MATCH, ByteBuffer.wrap(pattern));
        return this;
    }

    public ScanParams match(String pattern) {
        this.params.put(Protocol.Keyword.MATCH, ByteBuffer.wrap(SafeEncoder.encode(pattern)));
        return this;
    }

    public ScanParams count(Integer count2) {
        this.params.put(Protocol.Keyword.COUNT, ByteBuffer.wrap(Protocol.toByteArray(count2)));
        return this;
    }

    public Collection<byte[]> getParams() {
        ArrayList<byte[]> paramsList = new ArrayList<byte[]>(this.params.size());
        for (Map.Entry<Protocol.Keyword, ByteBuffer> param2 : this.params.entrySet()) {
            paramsList.add(param2.getKey().raw);
            paramsList.add(param2.getValue().array());
        }
        return Collections.unmodifiableCollection(paramsList);
    }

    byte[] binaryMatch() {
        if (this.params.containsKey((Object)Protocol.Keyword.MATCH)) {
            return this.params.get((Object)Protocol.Keyword.MATCH).array();
        }
        return null;
    }

    String match() {
        if (this.params.containsKey((Object)Protocol.Keyword.MATCH)) {
            return new String(this.params.get((Object)Protocol.Keyword.MATCH).array());
        }
        return null;
    }

    Integer count() {
        if (this.params.containsKey((Object)Protocol.Keyword.COUNT)) {
            return this.params.get((Object)Protocol.Keyword.COUNT).getInt();
        }
        return null;
    }
}

