/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.ClusterReset;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisPoolAbstract;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ListPosition;
import redis.clients.jedis.Module;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.StreamEntry;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.StreamPendingEntry;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.ZParams;
import redis.clients.jedis.commands.AdvancedJedisCommands;
import redis.clients.jedis.commands.BasicCommands;
import redis.clients.jedis.commands.ClusterCommands;
import redis.clients.jedis.commands.JedisCommands;
import redis.clients.jedis.commands.ModuleCommands;
import redis.clients.jedis.commands.MultiKeyCommands;
import redis.clients.jedis.commands.ScriptingCommands;
import redis.clients.jedis.commands.SentinelCommands;
import redis.clients.jedis.params.GeoRadiusParam;
import redis.clients.jedis.params.MigrateParams;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.params.ZIncrByParams;
import redis.clients.jedis.util.SafeEncoder;
import redis.clients.jedis.util.Slowlog;

public class Jedis
extends BinaryJedis
implements JedisCommands,
MultiKeyCommands,
AdvancedJedisCommands,
ScriptingCommands,
BasicCommands,
ClusterCommands,
SentinelCommands,
ModuleCommands {
    protected JedisPoolAbstract dataSource = null;

    public Jedis() {
    }

    public Jedis(String host) {
        super(host);
    }

    public Jedis(HostAndPort hp) {
        super(hp);
    }

    public Jedis(String host, int port) {
        super(host, port);
    }

    public Jedis(String host, int port, boolean ssl) {
        super(host, port, ssl);
    }

    public Jedis(String host, int port, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        super(host, port, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public Jedis(String host, int port, int timeout) {
        super(host, port, timeout);
    }

    public Jedis(String host, int port, int timeout, boolean ssl) {
        super(host, port, timeout, ssl);
    }

    public Jedis(String host, int port, int timeout, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        super(host, port, timeout, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public Jedis(String host, int port, int connectionTimeout, int soTimeout) {
        super(host, port, connectionTimeout, soTimeout);
    }

    public Jedis(String host, int port, int connectionTimeout, int soTimeout, boolean ssl) {
        super(host, port, connectionTimeout, soTimeout, ssl);
    }

    public Jedis(String host, int port, int connectionTimeout, int soTimeout, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        super(host, port, connectionTimeout, soTimeout, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public Jedis(JedisShardInfo shardInfo) {
        super(shardInfo);
    }

    public Jedis(URI uri) {
        super(uri);
    }

    public Jedis(URI uri, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        super(uri, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public Jedis(URI uri, int timeout) {
        super(uri, timeout);
    }

    public Jedis(URI uri, int timeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        super(uri, timeout, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public Jedis(URI uri, int connectionTimeout, int soTimeout) {
        super(uri, connectionTimeout, soTimeout);
    }

    public Jedis(URI uri, int connectionTimeout, int soTimeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        super(uri, connectionTimeout, soTimeout, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public String ping(String message) {
        this.checkIsInMultiOrPipeline();
        this.client.ping(message);
        return this.client.getBulkReply();
    }

    @Override
    public String set(String key, String value2) {
        this.checkIsInMultiOrPipeline();
        this.client.set(key, value2);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String set(String key, String value2, SetParams params2) {
        this.checkIsInMultiOrPipeline();
        this.client.set(key, value2, params2);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String get(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.get(key);
        return this.client.getBulkReply();
    }

    @Override
    public Long exists(String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.exists(keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Boolean exists(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.exists(key);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Long del(String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.del(keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Long del(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.del(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long unlink(String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.unlink(keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Long unlink(String key) {
        this.client.unlink(key);
        return this.client.getIntegerReply();
    }

    @Override
    public String type(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.type(key);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Set<String> keys(String pattern) {
        this.checkIsInMultiOrPipeline();
        this.client.keys(pattern);
        return BuilderFactory.STRING_SET.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public String randomKey() {
        this.checkIsInMultiOrPipeline();
        this.client.randomKey();
        return this.client.getBulkReply();
    }

    @Override
    public String rename(String oldkey, String newkey) {
        this.checkIsInMultiOrPipeline();
        this.client.rename(oldkey, newkey);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long renamenx(String oldkey, String newkey) {
        this.checkIsInMultiOrPipeline();
        this.client.renamenx(oldkey, newkey);
        return this.client.getIntegerReply();
    }

    @Override
    public Long expire(String key, int seconds) {
        this.checkIsInMultiOrPipeline();
        this.client.expire(key, seconds);
        return this.client.getIntegerReply();
    }

    @Override
    public Long expireAt(String key, long unixTime) {
        this.checkIsInMultiOrPipeline();
        this.client.expireAt(key, unixTime);
        return this.client.getIntegerReply();
    }

    @Override
    public Long ttl(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.ttl(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long touch(String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.touch(keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Long touch(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.touch(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long move(String key, int dbIndex) {
        this.checkIsInMultiOrPipeline();
        this.client.move(key, dbIndex);
        return this.client.getIntegerReply();
    }

    @Override
    public String getSet(String key, String value2) {
        this.checkIsInMultiOrPipeline();
        this.client.getSet(key, value2);
        return this.client.getBulkReply();
    }

    @Override
    public List<String> mget(String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.mget(keys);
        return this.client.getMultiBulkReply();
    }

    @Override
    public Long setnx(String key, String value2) {
        this.checkIsInMultiOrPipeline();
        this.client.setnx(key, value2);
        return this.client.getIntegerReply();
    }

    @Override
    public String setex(String key, int seconds, String value2) {
        this.checkIsInMultiOrPipeline();
        this.client.setex(key, seconds, value2);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String mset(String ... keysvalues) {
        this.checkIsInMultiOrPipeline();
        this.client.mset(keysvalues);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long msetnx(String ... keysvalues) {
        this.checkIsInMultiOrPipeline();
        this.client.msetnx(keysvalues);
        return this.client.getIntegerReply();
    }

    @Override
    public Long decrBy(String key, long decrement) {
        this.checkIsInMultiOrPipeline();
        this.client.decrBy(key, decrement);
        return this.client.getIntegerReply();
    }

    @Override
    public Long decr(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.decr(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long incrBy(String key, long increment) {
        this.checkIsInMultiOrPipeline();
        this.client.incrBy(key, increment);
        return this.client.getIntegerReply();
    }

    @Override
    public Double incrByFloat(String key, double increment) {
        this.checkIsInMultiOrPipeline();
        this.client.incrByFloat(key, increment);
        String dval = this.client.getBulkReply();
        return dval != null ? new Double(dval) : null;
    }

    @Override
    public Long incr(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.incr(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long append(String key, String value2) {
        this.checkIsInMultiOrPipeline();
        this.client.append(key, value2);
        return this.client.getIntegerReply();
    }

    @Override
    public String substr(String key, int start2, int end) {
        this.checkIsInMultiOrPipeline();
        this.client.substr(key, start2, end);
        return this.client.getBulkReply();
    }

    @Override
    public Long hset(String key, String field2, String value2) {
        this.checkIsInMultiOrPipeline();
        this.client.hset(key, field2, value2);
        return this.client.getIntegerReply();
    }

    @Override
    public Long hset(String key, Map<String, String> hash) {
        this.checkIsInMultiOrPipeline();
        this.client.hset(key, hash);
        return this.client.getIntegerReply();
    }

    @Override
    public String hget(String key, String field2) {
        this.checkIsInMultiOrPipeline();
        this.client.hget(key, field2);
        return this.client.getBulkReply();
    }

    @Override
    public Long hsetnx(String key, String field2, String value2) {
        this.checkIsInMultiOrPipeline();
        this.client.hsetnx(key, field2, value2);
        return this.client.getIntegerReply();
    }

    @Override
    public String hmset(String key, Map<String, String> hash) {
        this.checkIsInMultiOrPipeline();
        this.client.hmset(key, hash);
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<String> hmget(String key, String ... fields) {
        this.checkIsInMultiOrPipeline();
        this.client.hmget(key, fields);
        return this.client.getMultiBulkReply();
    }

    @Override
    public Long hincrBy(String key, String field2, long value2) {
        this.checkIsInMultiOrPipeline();
        this.client.hincrBy(key, field2, value2);
        return this.client.getIntegerReply();
    }

    @Override
    public Double hincrByFloat(String key, String field2, double value2) {
        this.checkIsInMultiOrPipeline();
        this.client.hincrByFloat(key, field2, value2);
        String dval = this.client.getBulkReply();
        return dval != null ? new Double(dval) : null;
    }

    @Override
    public Boolean hexists(String key, String field2) {
        this.checkIsInMultiOrPipeline();
        this.client.hexists(key, field2);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Long hdel(String key, String ... fields) {
        this.checkIsInMultiOrPipeline();
        this.client.hdel(key, fields);
        return this.client.getIntegerReply();
    }

    @Override
    public Long hlen(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.hlen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> hkeys(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.hkeys(key);
        return BuilderFactory.STRING_SET.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public List<String> hvals(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.hvals(key);
        List<String> lresult = this.client.getMultiBulkReply();
        return lresult;
    }

    @Override
    public Map<String, String> hgetAll(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.hgetAll(key);
        return BuilderFactory.STRING_MAP.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Long rpush(String key, String ... strings) {
        this.checkIsInMultiOrPipeline();
        this.client.rpush(key, strings);
        return this.client.getIntegerReply();
    }

    @Override
    public Long lpush(String key, String ... strings) {
        this.checkIsInMultiOrPipeline();
        this.client.lpush(key, strings);
        return this.client.getIntegerReply();
    }

    @Override
    public Long llen(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.llen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public List<String> lrange(String key, long start2, long stop) {
        this.checkIsInMultiOrPipeline();
        this.client.lrange(key, start2, stop);
        return this.client.getMultiBulkReply();
    }

    @Override
    public String ltrim(String key, long start2, long stop) {
        this.checkIsInMultiOrPipeline();
        this.client.ltrim(key, start2, stop);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String lindex(String key, long index2) {
        this.checkIsInMultiOrPipeline();
        this.client.lindex(key, index2);
        return this.client.getBulkReply();
    }

    @Override
    public String lset(String key, long index2, String value2) {
        this.checkIsInMultiOrPipeline();
        this.client.lset(key, index2, value2);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long lrem(String key, long count2, String value2) {
        this.checkIsInMultiOrPipeline();
        this.client.lrem(key, count2, value2);
        return this.client.getIntegerReply();
    }

    @Override
    public String lpop(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.lpop(key);
        return this.client.getBulkReply();
    }

    @Override
    public String rpop(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.rpop(key);
        return this.client.getBulkReply();
    }

    @Override
    public String rpoplpush(String srckey, String dstkey) {
        this.checkIsInMultiOrPipeline();
        this.client.rpoplpush(srckey, dstkey);
        return this.client.getBulkReply();
    }

    @Override
    public Long sadd(String key, String ... members2) {
        this.checkIsInMultiOrPipeline();
        this.client.sadd(key, members2);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> smembers(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.smembers(key);
        List<String> members2 = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members2);
    }

    @Override
    public Long srem(String key, String ... members2) {
        this.checkIsInMultiOrPipeline();
        this.client.srem(key, members2);
        return this.client.getIntegerReply();
    }

    @Override
    public String spop(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.spop(key);
        return this.client.getBulkReply();
    }

    @Override
    public Set<String> spop(String key, long count2) {
        this.checkIsInMultiOrPipeline();
        this.client.spop(key, count2);
        List<String> members2 = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members2);
    }

    @Override
    public Long smove(String srckey, String dstkey, String member) {
        this.checkIsInMultiOrPipeline();
        this.client.smove(srckey, dstkey, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long scard(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.scard(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Boolean sismember(String key, String member) {
        this.checkIsInMultiOrPipeline();
        this.client.sismember(key, member);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Set<String> sinter(String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sinter(keys);
        List<String> members2 = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members2);
    }

    @Override
    public Long sinterstore(String dstkey, String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sinterstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> sunion(String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sunion(keys);
        List<String> members2 = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members2);
    }

    @Override
    public Long sunionstore(String dstkey, String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sunionstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> sdiff(String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sdiff(keys);
        return BuilderFactory.STRING_SET.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Long sdiffstore(String dstkey, String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sdiffstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    @Override
    public String srandmember(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.srandmember(key);
        return this.client.getBulkReply();
    }

    @Override
    public List<String> srandmember(String key, int count2) {
        this.checkIsInMultiOrPipeline();
        this.client.srandmember(key, count2);
        return this.client.getMultiBulkReply();
    }

    @Override
    public Long zadd(String key, double score, String member) {
        this.checkIsInMultiOrPipeline();
        this.client.zadd(key, score, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zadd(String key, double score, String member, ZAddParams params2) {
        this.checkIsInMultiOrPipeline();
        this.client.zadd(key, score, member, params2);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zadd(String key, Map<String, Double> scoreMembers) {
        this.checkIsInMultiOrPipeline();
        this.client.zadd(key, scoreMembers);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zadd(String key, Map<String, Double> scoreMembers, ZAddParams params2) {
        this.checkIsInMultiOrPipeline();
        this.client.zadd(key, scoreMembers, params2);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> zrange(String key, long start2, long stop) {
        this.checkIsInMultiOrPipeline();
        this.client.zrange(key, start2, stop);
        List<String> members2 = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members2);
    }

    @Override
    public Long zrem(String key, String ... members2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrem(key, members2);
        return this.client.getIntegerReply();
    }

    @Override
    public Double zincrby(String key, double increment, String member) {
        this.checkIsInMultiOrPipeline();
        this.client.zincrby(key, increment, member);
        return BuilderFactory.DOUBLE.build(this.client.getOne());
    }

    @Override
    public Double zincrby(String key, double increment, String member, ZIncrByParams params2) {
        this.checkIsInMultiOrPipeline();
        this.client.zincrby(key, increment, member, params2);
        return BuilderFactory.DOUBLE.build(this.client.getOne());
    }

    @Override
    public Long zrank(String key, String member) {
        this.checkIsInMultiOrPipeline();
        this.client.zrank(key, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zrevrank(String key, String member) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrank(key, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> zrevrange(String key, long start2, long stop) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrange(key, start2, stop);
        List<String> members2 = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members2);
    }

    @Override
    public Set<Tuple> zrangeWithScores(String key, long start2, long stop) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeWithScores(key, start2, stop);
        return this.getTupledSet();
    }

    @Override
    public Set<Tuple> zrevrangeWithScores(String key, long start2, long stop) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeWithScores(key, start2, stop);
        return this.getTupledSet();
    }

    @Override
    public Long zcard(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.zcard(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Double zscore(String key, String member) {
        this.checkIsInMultiOrPipeline();
        this.client.zscore(key, member);
        return BuilderFactory.DOUBLE.build(this.client.getOne());
    }

    @Override
    public String watch(String ... keys) {
        this.client.watch(keys);
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<String> sort(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.sort(key);
        return this.client.getMultiBulkReply();
    }

    @Override
    public List<String> sort(String key, SortingParams sortingParameters) {
        this.checkIsInMultiOrPipeline();
        this.client.sort(key, sortingParameters);
        return this.client.getMultiBulkReply();
    }

    @Override
    public List<String> blpop(int timeout, String ... keys) {
        return this.blpop(this.getArgsAddTimeout(timeout, keys));
    }

    private String[] getArgsAddTimeout(int timeout, String[] keys) {
        int keyCount = keys.length;
        String[] args2 = new String[keyCount + 1];
        for (int at = 0; at != keyCount; ++at) {
            args2[at] = keys[at];
        }
        args2[keyCount] = String.valueOf(timeout);
        return args2;
    }

    @Override
    public List<String> blpop(String ... args2) {
        this.checkIsInMultiOrPipeline();
        this.client.blpop(args2);
        this.client.setTimeoutInfinite();
        try {
            List<String> list2 = this.client.getMultiBulkReply();
            return list2;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public List<String> brpop(String ... args2) {
        this.checkIsInMultiOrPipeline();
        this.client.brpop(args2);
        this.client.setTimeoutInfinite();
        try {
            List<String> list2 = this.client.getMultiBulkReply();
            return list2;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public Long sort(String key, SortingParams sortingParameters, String dstkey) {
        this.checkIsInMultiOrPipeline();
        this.client.sort(key, sortingParameters, dstkey);
        return this.client.getIntegerReply();
    }

    @Override
    public Long sort(String key, String dstkey) {
        this.checkIsInMultiOrPipeline();
        this.client.sort(key, dstkey);
        return this.client.getIntegerReply();
    }

    @Override
    public List<String> brpop(int timeout, String ... keys) {
        return this.brpop(this.getArgsAddTimeout(timeout, keys));
    }

    @Override
    public Long zcount(String key, double min2, double max2) {
        this.checkIsInMultiOrPipeline();
        this.client.zcount(key, min2, max2);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zcount(String key, String min2, String max2) {
        this.checkIsInMultiOrPipeline();
        this.client.zcount(key, min2, max2);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> zrangeByScore(String key, double min2, double max2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScore(key, min2, max2);
        List<String> members2 = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members2);
    }

    @Override
    public Set<String> zrangeByScore(String key, String min2, String max2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScore(key, min2, max2);
        List<String> members2 = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members2);
    }

    @Override
    public Set<String> zrangeByScore(String key, double min2, double max2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScore(key, min2, max2, offset, count2);
        List<String> members2 = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members2);
    }

    @Override
    public Set<String> zrangeByScore(String key, String min2, String max2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScore(key, min2, max2, offset, count2);
        List<String> members2 = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members2);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, double min2, double max2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScoreWithScores(key, min2, max2);
        return this.getTupledSet();
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, String min2, String max2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScoreWithScores(key, min2, max2);
        return this.getTupledSet();
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, double min2, double max2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScoreWithScores(key, min2, max2, offset, count2);
        return this.getTupledSet();
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, String min2, String max2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScoreWithScores(key, min2, max2, offset, count2);
        return this.getTupledSet();
    }

    @Override
    public Set<String> zrevrangeByScore(String key, double max2, double min2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScore(key, max2, min2);
        List<String> members2 = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members2);
    }

    @Override
    public Set<String> zrevrangeByScore(String key, String max2, String min2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScore(key, max2, min2);
        List<String> members2 = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members2);
    }

    @Override
    public Set<String> zrevrangeByScore(String key, double max2, double min2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScore(key, max2, min2, offset, count2);
        List<String> members2 = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members2);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max2, double min2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScoreWithScores(key, max2, min2);
        return this.getTupledSet();
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max2, double min2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScoreWithScores(key, max2, min2, offset, count2);
        return this.getTupledSet();
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max2, String min2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScoreWithScores(key, max2, min2, offset, count2);
        return this.getTupledSet();
    }

    @Override
    public Set<String> zrevrangeByScore(String key, String max2, String min2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScore(key, max2, min2, offset, count2);
        List<String> members2 = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members2);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max2, String min2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScoreWithScores(key, max2, min2);
        return this.getTupledSet();
    }

    @Override
    public Long zremrangeByRank(String key, long start2, long stop) {
        this.checkIsInMultiOrPipeline();
        this.client.zremrangeByRank(key, start2, stop);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zremrangeByScore(String key, double min2, double max2) {
        this.checkIsInMultiOrPipeline();
        this.client.zremrangeByScore(key, min2, max2);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zremrangeByScore(String key, String min2, String max2) {
        this.checkIsInMultiOrPipeline();
        this.client.zremrangeByScore(key, min2, max2);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zunionstore(String dstkey, String ... sets) {
        this.checkIsInMultiOrPipeline();
        this.client.zunionstore(dstkey, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zunionstore(String dstkey, ZParams params2, String ... sets) {
        this.checkIsInMultiOrPipeline();
        this.client.zunionstore(dstkey, params2, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zinterstore(String dstkey, String ... sets) {
        this.checkIsInMultiOrPipeline();
        this.client.zinterstore(dstkey, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zinterstore(String dstkey, ZParams params2, String ... sets) {
        this.checkIsInMultiOrPipeline();
        this.client.zinterstore(dstkey, params2, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zlexcount(String key, String min2, String max2) {
        this.checkIsInMultiOrPipeline();
        this.client.zlexcount(key, min2, max2);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> zrangeByLex(String key, String min2, String max2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByLex(key, min2, max2);
        List<String> members2 = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members2);
    }

    @Override
    public Set<String> zrangeByLex(String key, String min2, String max2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByLex(key, min2, max2, offset, count2);
        List<String> members2 = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members2);
    }

    @Override
    public Set<String> zrevrangeByLex(String key, String max2, String min2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByLex(key, max2, min2);
        List<String> members2 = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members2);
    }

    @Override
    public Set<String> zrevrangeByLex(String key, String max2, String min2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByLex(key, max2, min2, offset, count2);
        List<String> members2 = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members2);
    }

    @Override
    public Long zremrangeByLex(String key, String min2, String max2) {
        this.checkIsInMultiOrPipeline();
        this.client.zremrangeByLex(key, min2, max2);
        return this.client.getIntegerReply();
    }

    @Override
    public Long strlen(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.strlen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long lpushx(String key, String ... string2) {
        this.checkIsInMultiOrPipeline();
        this.client.lpushx(key, string2);
        return this.client.getIntegerReply();
    }

    @Override
    public Long persist(String key) {
        this.client.persist(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long rpushx(String key, String ... string2) {
        this.checkIsInMultiOrPipeline();
        this.client.rpushx(key, string2);
        return this.client.getIntegerReply();
    }

    @Override
    public String echo(String string2) {
        this.checkIsInMultiOrPipeline();
        this.client.echo(string2);
        return this.client.getBulkReply();
    }

    @Override
    public Long linsert(String key, ListPosition where, String pivot, String value2) {
        this.checkIsInMultiOrPipeline();
        this.client.linsert(key, where, pivot, value2);
        return this.client.getIntegerReply();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String brpoplpush(String source, String destination, int timeout) {
        this.client.brpoplpush(source, destination, timeout);
        this.client.setTimeoutInfinite();
        try {
            String string2 = this.client.getBulkReply();
            return string2;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public Boolean setbit(String key, long offset, boolean value2) {
        this.checkIsInMultiOrPipeline();
        this.client.setbit(key, offset, value2);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Boolean setbit(String key, long offset, String value2) {
        this.checkIsInMultiOrPipeline();
        this.client.setbit(key, offset, value2);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Boolean getbit(String key, long offset) {
        this.checkIsInMultiOrPipeline();
        this.client.getbit(key, offset);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Long setrange(String key, long offset, String value2) {
        this.checkIsInMultiOrPipeline();
        this.client.setrange(key, offset, value2);
        return this.client.getIntegerReply();
    }

    @Override
    public String getrange(String key, long startOffset, long endOffset) {
        this.checkIsInMultiOrPipeline();
        this.client.getrange(key, startOffset, endOffset);
        return this.client.getBulkReply();
    }

    @Override
    public Long bitpos(String key, boolean value2) {
        return this.bitpos(key, value2, new BitPosParams());
    }

    @Override
    public Long bitpos(String key, boolean value2, BitPosParams params2) {
        this.checkIsInMultiOrPipeline();
        this.client.bitpos(key, value2, params2);
        return this.client.getIntegerReply();
    }

    @Override
    public List<String> configGet(String pattern) {
        this.client.configGet(pattern);
        return this.client.getMultiBulkReply();
    }

    @Override
    public String configSet(String parameter, String value2) {
        this.client.configSet(parameter, value2);
        return this.client.getStatusCodeReply();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object eval(String script, int keyCount, String ... params2) {
        this.client.setTimeoutInfinite();
        try {
            this.client.eval(script, keyCount, params2);
            Object object = this.getEvalResult();
            return object;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        this.client.setTimeoutInfinite();
        try {
            jedisPubSub.proceed(this.client, channels);
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public Long publish(String channel, String message) {
        this.checkIsInMultiOrPipeline();
        this.connect();
        this.client.publish(channel, message);
        return this.client.getIntegerReply();
    }

    @Override
    public void psubscribe(JedisPubSub jedisPubSub, String ... patterns2) {
        this.checkIsInMultiOrPipeline();
        this.client.setTimeoutInfinite();
        try {
            jedisPubSub.proceedWithPatterns(this.client, patterns2);
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    protected static String[] getParams(List<String> keys, List<String> args2) {
        int i;
        int keyCount = keys.size();
        int argCount = args2.size();
        String[] params2 = new String[keyCount + args2.size()];
        for (i = 0; i < keyCount; ++i) {
            params2[i] = keys.get(i);
        }
        for (i = 0; i < argCount; ++i) {
            params2[keyCount + i] = args2.get(i);
        }
        return params2;
    }

    @Override
    public Object eval(String script, List<String> keys, List<String> args2) {
        return this.eval(script, keys.size(), Jedis.getParams(keys, args2));
    }

    @Override
    public Object eval(String script) {
        return this.eval(script, 0, new String[0]);
    }

    @Override
    public Object evalsha(String sha1) {
        return this.evalsha(sha1, 0, new String[0]);
    }

    private Object getEvalResult() {
        return this.evalResult(this.client.getOne());
    }

    private Object evalResult(Object result2) {
        if (result2 instanceof byte[]) {
            return SafeEncoder.encode((byte[])result2);
        }
        if (result2 instanceof List) {
            List list2 = (List)result2;
            ArrayList<Object> listResult = new ArrayList<Object>(list2.size());
            for (Object bin : list2) {
                listResult.add(this.evalResult(bin));
            }
            return listResult;
        }
        return result2;
    }

    @Override
    public Object evalsha(String sha1, List<String> keys, List<String> args2) {
        return this.evalsha(sha1, keys.size(), Jedis.getParams(keys, args2));
    }

    @Override
    public Object evalsha(String sha1, int keyCount, String ... params2) {
        this.checkIsInMultiOrPipeline();
        this.client.evalsha(sha1, keyCount, params2);
        return this.getEvalResult();
    }

    @Override
    public Boolean scriptExists(String sha1) {
        String[] a = new String[]{sha1};
        return this.scriptExists(a).get(0);
    }

    @Override
    public List<Boolean> scriptExists(String ... sha1) {
        this.client.scriptExists(sha1);
        List<Long> result2 = this.client.getIntegerMultiBulkReply();
        ArrayList<Boolean> exists2 = new ArrayList<Boolean>();
        for (Long value2 : result2) {
            exists2.add(value2 == 1L);
        }
        return exists2;
    }

    @Override
    public String scriptLoad(String script) {
        this.client.scriptLoad(script);
        return this.client.getBulkReply();
    }

    @Override
    public List<Slowlog> slowlogGet() {
        this.client.slowlogGet();
        return Slowlog.from(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<Slowlog> slowlogGet(long entries) {
        this.client.slowlogGet(entries);
        return Slowlog.from(this.client.getObjectMultiBulkReply());
    }

    @Override
    public Long objectRefcount(String key) {
        this.client.objectRefcount(key);
        return this.client.getIntegerReply();
    }

    @Override
    public String objectEncoding(String key) {
        this.client.objectEncoding(key);
        return this.client.getBulkReply();
    }

    @Override
    public Long objectIdletime(String key) {
        this.client.objectIdletime(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long bitcount(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.bitcount(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long bitcount(String key, long start2, long end) {
        this.checkIsInMultiOrPipeline();
        this.client.bitcount(key, start2, end);
        return this.client.getIntegerReply();
    }

    @Override
    public Long bitop(BitOP op, String destKey, String ... srcKeys) {
        this.checkIsInMultiOrPipeline();
        this.client.bitop(op, destKey, srcKeys);
        return this.client.getIntegerReply();
    }

    @Override
    public List<Map<String, String>> sentinelMasters() {
        this.client.sentinel("masters");
        List<Object> reply = this.client.getObjectMultiBulkReply();
        ArrayList<Map<String, String>> masters = new ArrayList<Map<String, String>>();
        for (Object obj : reply) {
            masters.add(BuilderFactory.STRING_MAP.build((List)obj));
        }
        return masters;
    }

    @Override
    public List<String> sentinelGetMasterAddrByName(String masterName) {
        this.client.sentinel("get-master-addr-by-name", masterName);
        List<Object> reply = this.client.getObjectMultiBulkReply();
        return BuilderFactory.STRING_LIST.build(reply);
    }

    @Override
    public Long sentinelReset(String pattern) {
        this.client.sentinel("reset", pattern);
        return this.client.getIntegerReply();
    }

    @Override
    public List<Map<String, String>> sentinelSlaves(String masterName) {
        this.client.sentinel("slaves", masterName);
        List<Object> reply = this.client.getObjectMultiBulkReply();
        ArrayList<Map<String, String>> slaves = new ArrayList<Map<String, String>>();
        for (Object obj : reply) {
            slaves.add(BuilderFactory.STRING_MAP.build((List)obj));
        }
        return slaves;
    }

    @Override
    public String sentinelFailover(String masterName) {
        this.client.sentinel("failover", masterName);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String sentinelMonitor(String masterName, String ip, int port, int quorum) {
        this.client.sentinel("monitor", masterName, ip, String.valueOf(port), String.valueOf(quorum));
        return this.client.getStatusCodeReply();
    }

    @Override
    public String sentinelRemove(String masterName) {
        this.client.sentinel("remove", masterName);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String sentinelSet(String masterName, Map<String, String> parameterMap) {
        int index2 = 0;
        int paramsLength = parameterMap.size() * 2 + 2;
        String[] params2 = new String[paramsLength];
        params2[index2++] = "set";
        params2[index2++] = masterName;
        for (Map.Entry<String, String> entry2 : parameterMap.entrySet()) {
            params2[index2++] = entry2.getKey();
            params2[index2++] = entry2.getValue();
        }
        this.client.sentinel(params2);
        return this.client.getStatusCodeReply();
    }

    @Override
    public byte[] dump(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.dump(key);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public String restore(String key, int ttl, byte[] serializedValue) {
        this.checkIsInMultiOrPipeline();
        this.client.restore(key, ttl, serializedValue);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String restoreReplace(String key, int ttl, byte[] serializedValue) {
        this.checkIsInMultiOrPipeline();
        this.client.restoreReplace(key, ttl, serializedValue);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long pexpire(String key, long milliseconds) {
        this.checkIsInMultiOrPipeline();
        this.client.pexpire(key, milliseconds);
        return this.client.getIntegerReply();
    }

    @Override
    public Long pexpireAt(String key, long millisecondsTimestamp) {
        this.checkIsInMultiOrPipeline();
        this.client.pexpireAt(key, millisecondsTimestamp);
        return this.client.getIntegerReply();
    }

    @Override
    public Long pttl(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.pttl(key);
        return this.client.getIntegerReply();
    }

    @Override
    public String psetex(String key, long milliseconds, String value2) {
        this.checkIsInMultiOrPipeline();
        this.client.psetex(key, milliseconds, value2);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clientKill(String ipPort) {
        this.checkIsInMultiOrPipeline();
        this.client.clientKill(ipPort);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clientGetname() {
        this.checkIsInMultiOrPipeline();
        this.client.clientGetname();
        return this.client.getBulkReply();
    }

    @Override
    public String clientList() {
        this.checkIsInMultiOrPipeline();
        this.client.clientList();
        return this.client.getBulkReply();
    }

    @Override
    public String clientSetname(String name) {
        this.checkIsInMultiOrPipeline();
        this.client.clientSetname(name);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String migrate(String host, int port, String key, int destinationDb, int timeout) {
        this.checkIsInMultiOrPipeline();
        this.client.migrate(host, port, key, destinationDb, timeout);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String migrate(String host, int port, int destinationDB, int timeout, MigrateParams params2, String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.migrate(host, port, destinationDB, timeout, params2, keys);
        return this.client.getStatusCodeReply();
    }

    @Override
    public ScanResult<String> scan(String cursor) {
        return this.scan(cursor, new ScanParams());
    }

    @Override
    public ScanResult<String> scan(String cursor, ScanParams params2) {
        this.checkIsInMultiOrPipeline();
        this.client.scan(cursor, params2);
        List<Object> result2 = this.client.getObjectMultiBulkReply();
        String newcursor = new String((byte[])result2.get(0));
        ArrayList<String> results = new ArrayList<String>();
        List rawResults = (List)result2.get(1);
        for (byte[] bs : rawResults) {
            results.add(SafeEncoder.encode(bs));
        }
        return new ScanResult<String>(newcursor, results);
    }

    @Override
    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor) {
        return this.hscan(key, cursor, new ScanParams());
    }

    @Override
    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor, ScanParams params2) {
        this.checkIsInMultiOrPipeline();
        this.client.hscan(key, cursor, params2);
        List<Object> result2 = this.client.getObjectMultiBulkReply();
        String newcursor = new String((byte[])result2.get(0));
        ArrayList<AbstractMap.SimpleEntry<String, String>> results = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
        List rawResults = (List)result2.get(1);
        Iterator iterator2 = rawResults.iterator();
        while (iterator2.hasNext()) {
            results.add(new AbstractMap.SimpleEntry<String, String>(SafeEncoder.encode((byte[])iterator2.next()), SafeEncoder.encode((byte[])iterator2.next())));
        }
        return new ScanResult<Map.Entry<String, String>>(newcursor, results);
    }

    @Override
    public ScanResult<String> sscan(String key, String cursor) {
        return this.sscan(key, cursor, new ScanParams());
    }

    @Override
    public ScanResult<String> sscan(String key, String cursor, ScanParams params2) {
        this.checkIsInMultiOrPipeline();
        this.client.sscan(key, cursor, params2);
        List<Object> result2 = this.client.getObjectMultiBulkReply();
        String newcursor = new String((byte[])result2.get(0));
        ArrayList<String> results = new ArrayList<String>();
        List rawResults = (List)result2.get(1);
        for (byte[] bs : rawResults) {
            results.add(SafeEncoder.encode(bs));
        }
        return new ScanResult<String>(newcursor, results);
    }

    @Override
    public ScanResult<Tuple> zscan(String key, String cursor) {
        return this.zscan(key, cursor, new ScanParams());
    }

    @Override
    public ScanResult<Tuple> zscan(String key, String cursor, ScanParams params2) {
        this.checkIsInMultiOrPipeline();
        this.client.zscan(key, cursor, params2);
        List<Object> result2 = this.client.getObjectMultiBulkReply();
        String newcursor = new String((byte[])result2.get(0));
        ArrayList<Tuple> results = new ArrayList<Tuple>();
        List rawResults = (List)result2.get(1);
        Iterator iterator2 = rawResults.iterator();
        while (iterator2.hasNext()) {
            results.add(new Tuple((byte[])iterator2.next(), BuilderFactory.DOUBLE.build(iterator2.next())));
        }
        return new ScanResult<Tuple>(newcursor, results);
    }

    @Override
    public String clusterNodes() {
        this.checkIsInMultiOrPipeline();
        this.client.clusterNodes();
        return this.client.getBulkReply();
    }

    @Override
    public String readonly() {
        this.client.readonly();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterMeet(String ip, int port) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterMeet(ip, port);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterReset(ClusterReset resetType) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterReset(resetType);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterAddSlots(int ... slots) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterAddSlots(slots);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterDelSlots(int ... slots) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterDelSlots(slots);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterInfo() {
        this.checkIsInMultiOrPipeline();
        this.client.clusterInfo();
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<String> clusterGetKeysInSlot(int slot, int count2) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterGetKeysInSlot(slot, count2);
        return this.client.getMultiBulkReply();
    }

    @Override
    public String clusterSetSlotNode(int slot, String nodeId) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterSetSlotNode(slot, nodeId);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterSetSlotMigrating(int slot, String nodeId) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterSetSlotMigrating(slot, nodeId);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterSetSlotImporting(int slot, String nodeId) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterSetSlotImporting(slot, nodeId);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterSetSlotStable(int slot) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterSetSlotStable(slot);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterForget(String nodeId) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterForget(nodeId);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterFlushSlots() {
        this.checkIsInMultiOrPipeline();
        this.client.clusterFlushSlots();
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long clusterKeySlot(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterKeySlot(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long clusterCountKeysInSlot(int slot) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterCountKeysInSlot(slot);
        return this.client.getIntegerReply();
    }

    @Override
    public String clusterSaveConfig() {
        this.checkIsInMultiOrPipeline();
        this.client.clusterSaveConfig();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterReplicate(String nodeId) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterReplicate(nodeId);
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<String> clusterSlaves(String nodeId) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterSlaves(nodeId);
        return this.client.getMultiBulkReply();
    }

    @Override
    public String clusterFailover() {
        this.checkIsInMultiOrPipeline();
        this.client.clusterFailover();
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<Object> clusterSlots() {
        this.checkIsInMultiOrPipeline();
        this.client.clusterSlots();
        return this.client.getObjectMultiBulkReply();
    }

    public String asking() {
        this.checkIsInMultiOrPipeline();
        this.client.asking();
        return this.client.getStatusCodeReply();
    }

    public List<String> pubsubChannels(String pattern) {
        this.checkIsInMultiOrPipeline();
        this.client.pubsubChannels(pattern);
        return this.client.getMultiBulkReply();
    }

    public Long pubsubNumPat() {
        this.checkIsInMultiOrPipeline();
        this.client.pubsubNumPat();
        return this.client.getIntegerReply();
    }

    public Map<String, String> pubsubNumSub(String ... channels) {
        this.checkIsInMultiOrPipeline();
        this.client.pubsubNumSub(channels);
        return BuilderFactory.PUBSUB_NUMSUB_MAP.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public void close() {
        if (this.dataSource != null) {
            JedisPoolAbstract pool = this.dataSource;
            this.dataSource = null;
            if (this.client.isBroken()) {
                pool.returnBrokenResource(this);
            } else {
                pool.returnResource(this);
            }
        } else {
            super.close();
        }
    }

    public void setDataSource(JedisPoolAbstract jedisPool) {
        this.dataSource = jedisPool;
    }

    @Override
    public Long pfadd(String key, String ... elements2) {
        this.checkIsInMultiOrPipeline();
        this.client.pfadd(key, elements2);
        return this.client.getIntegerReply();
    }

    @Override
    public long pfcount(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.pfcount(key);
        return this.client.getIntegerReply();
    }

    @Override
    public long pfcount(String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.pfcount(keys);
        return this.client.getIntegerReply();
    }

    @Override
    public String pfmerge(String destkey, String ... sourcekeys) {
        this.checkIsInMultiOrPipeline();
        this.client.pfmerge(destkey, sourcekeys);
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<String> blpop(int timeout, String key) {
        return this.blpop(key, String.valueOf(timeout));
    }

    @Override
    public List<String> brpop(int timeout, String key) {
        return this.brpop(key, String.valueOf(timeout));
    }

    @Override
    public Long geoadd(String key, double longitude, double latitude, String member) {
        this.checkIsInMultiOrPipeline();
        this.client.geoadd(key, longitude, latitude, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long geoadd(String key, Map<String, GeoCoordinate> memberCoordinateMap) {
        this.checkIsInMultiOrPipeline();
        this.client.geoadd(key, memberCoordinateMap);
        return this.client.getIntegerReply();
    }

    @Override
    public Double geodist(String key, String member1, String member2) {
        this.checkIsInMultiOrPipeline();
        this.client.geodist(key, member1, member2);
        String dval = this.client.getBulkReply();
        return dval != null ? new Double(dval) : null;
    }

    @Override
    public Double geodist(String key, String member1, String member2, GeoUnit unit2) {
        this.checkIsInMultiOrPipeline();
        this.client.geodist(key, member1, member2, unit2);
        String dval = this.client.getBulkReply();
        return dval != null ? new Double(dval) : null;
    }

    @Override
    public List<String> geohash(String key, String ... members2) {
        this.checkIsInMultiOrPipeline();
        this.client.geohash(key, members2);
        return this.client.getMultiBulkReply();
    }

    @Override
    public List<GeoCoordinate> geopos(String key, String ... members2) {
        this.checkIsInMultiOrPipeline();
        this.client.geopos(key, members2);
        return BuilderFactory.GEO_COORDINATE_LIST.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit2) {
        this.checkIsInMultiOrPipeline();
        this.client.georadius(key, longitude, latitude, radius, unit2);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadiusReadonly(String key, double longitude, double latitude, double radius, GeoUnit unit2) {
        this.checkIsInMultiOrPipeline();
        this.client.georadiusReadonly(key, longitude, latitude, radius, unit2);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit2, GeoRadiusParam param2) {
        this.checkIsInMultiOrPipeline();
        this.client.georadius(key, longitude, latitude, radius, unit2, param2);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadiusReadonly(String key, double longitude, double latitude, double radius, GeoUnit unit2, GeoRadiusParam param2) {
        this.checkIsInMultiOrPipeline();
        this.client.georadiusReadonly(key, longitude, latitude, radius, unit2, param2);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(String key, String member, double radius, GeoUnit unit2) {
        this.checkIsInMultiOrPipeline();
        this.client.georadiusByMember(key, member, radius, unit2);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMemberReadonly(String key, String member, double radius, GeoUnit unit2) {
        this.checkIsInMultiOrPipeline();
        this.client.georadiusByMemberReadonly(key, member, radius, unit2);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(String key, String member, double radius, GeoUnit unit2, GeoRadiusParam param2) {
        this.checkIsInMultiOrPipeline();
        this.client.georadiusByMember(key, member, radius, unit2, param2);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMemberReadonly(String key, String member, double radius, GeoUnit unit2, GeoRadiusParam param2) {
        this.checkIsInMultiOrPipeline();
        this.client.georadiusByMemberReadonly(key, member, radius, unit2, param2);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public String moduleLoad(String path2) {
        this.client.moduleLoad(path2);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String moduleUnload(String name) {
        this.client.moduleUnload(name);
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<Module> moduleList() {
        this.client.moduleList();
        return BuilderFactory.MODULE_LIST.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<Long> bitfield(String key, String ... arguments) {
        this.checkIsInMultiOrPipeline();
        this.client.bitfield(key, arguments);
        return this.client.getIntegerMultiBulkReply();
    }

    @Override
    public Long hstrlen(String key, String field2) {
        this.checkIsInMultiOrPipeline();
        this.client.hstrlen(key, field2);
        return this.client.getIntegerReply();
    }

    @Override
    public StreamEntryID xadd(String key, StreamEntryID id, Map<String, String> hash) {
        return this.xadd(key, id, hash, Long.MAX_VALUE, false);
    }

    @Override
    public StreamEntryID xadd(String key, StreamEntryID id, Map<String, String> hash, long maxLen, boolean approximateLength) {
        this.checkIsInMultiOrPipeline();
        this.client.xadd(key, id, hash, maxLen, approximateLength);
        String result2 = this.client.getBulkReply();
        return new StreamEntryID(result2);
    }

    @Override
    public Long xlen(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.xlen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public List<StreamEntry> xrange(String key, StreamEntryID start2, StreamEntryID end, int count2) {
        this.checkIsInMultiOrPipeline();
        this.client.xrange(key, start2, end, (long)count2);
        return BuilderFactory.STREAM_ENTRY_LIST.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<StreamEntry> xrevrange(String key, StreamEntryID end, StreamEntryID start2, int count2) {
        this.checkIsInMultiOrPipeline();
        this.client.xrevrange(key, end, start2, count2);
        return BuilderFactory.STREAM_ENTRY_LIST.build(this.client.getObjectMultiBulkReply());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map.Entry<String, List<StreamEntry>>> xread(int count2, long block, Map.Entry<String, StreamEntryID> ... streams) {
        this.checkIsInMultiOrPipeline();
        this.client.xread(count2, block, streams);
        this.client.setTimeoutInfinite();
        try {
            List<Object> streamsEntries = this.client.getObjectMultiBulkReply();
            if (streamsEntries == null) {
                ArrayList<Map.Entry<String, List<StreamEntry>>> arrayList = new ArrayList<Map.Entry<String, List<StreamEntry>>>();
                return arrayList;
            }
            ArrayList<AbstractMap.SimpleEntry<String, List<StreamEntry>>> result2 = new ArrayList<AbstractMap.SimpleEntry<String, List<StreamEntry>>>(streamsEntries.size());
            for (Object streamObj : streamsEntries) {
                List stream = (List)streamObj;
                String streamId = SafeEncoder.encode((byte[])stream.get(0));
                List<StreamEntry> streamEntries = BuilderFactory.STREAM_ENTRY_LIST.build(stream.get(1));
                result2.add(new AbstractMap.SimpleEntry<String, List<StreamEntry>>(streamId, streamEntries));
            }
            ArrayList<AbstractMap.SimpleEntry<String, List<StreamEntry>>> arrayList = result2;
            return arrayList;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public long xack(String key, String group2, StreamEntryID ... ids) {
        this.checkIsInMultiOrPipeline();
        this.client.xack(key, group2, ids);
        return this.client.getIntegerReply();
    }

    @Override
    public String xgroupCreate(String key, String groupname, StreamEntryID id, boolean makeStream) {
        this.checkIsInMultiOrPipeline();
        this.client.xgroupCreate(key, groupname, id, makeStream);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String xgroupSetID(String key, String groupname, StreamEntryID id) {
        this.checkIsInMultiOrPipeline();
        this.client.xgroupSetID(key, groupname, id);
        return this.client.getStatusCodeReply();
    }

    @Override
    public long xgroupDestroy(String key, String groupname) {
        this.checkIsInMultiOrPipeline();
        this.client.xgroupDestroy(key, groupname);
        return this.client.getIntegerReply();
    }

    @Override
    public String xgroupDelConsumer(String key, String groupname, String consumerName) {
        this.checkIsInMultiOrPipeline();
        this.client.xgroupDelConsumer(key, groupname, consumerName);
        return this.client.getStatusCodeReply();
    }

    @Override
    public long xdel(String key, StreamEntryID ... ids) {
        this.checkIsInMultiOrPipeline();
        this.client.xdel(key, ids);
        return this.client.getIntegerReply();
    }

    @Override
    public long xtrim(String key, long maxLen, boolean approximateLength) {
        this.checkIsInMultiOrPipeline();
        this.client.xtrim(key, maxLen, approximateLength);
        return this.client.getIntegerReply();
    }

    @Override
    public List<Map.Entry<String, List<StreamEntry>>> xreadGroup(String groupname, String consumer, int count2, long block, boolean noAck, Map.Entry<String, StreamEntryID> ... streams) {
        this.checkIsInMultiOrPipeline();
        this.client.xreadGroup(groupname, consumer, count2, block, noAck, streams);
        List<Object> streamsEntries = this.client.getObjectMultiBulkReply();
        if (streamsEntries == null) {
            return null;
        }
        ArrayList<Map.Entry<String, List<StreamEntry>>> result2 = new ArrayList<Map.Entry<String, List<StreamEntry>>>(streamsEntries.size());
        for (Object streamObj : streamsEntries) {
            List stream = (List)streamObj;
            String streamId = SafeEncoder.encode((byte[])stream.get(0));
            List<StreamEntry> streamEntries = BuilderFactory.STREAM_ENTRY_LIST.build(stream.get(1));
            result2.add(new AbstractMap.SimpleEntry<String, List<StreamEntry>>(streamId, streamEntries));
        }
        return result2;
    }

    @Override
    public List<StreamPendingEntry> xpending(String key, String groupname, StreamEntryID start2, StreamEntryID end, int count2, String consumername) {
        this.checkIsInMultiOrPipeline();
        this.client.xpending(key, groupname, start2, end, count2, consumername);
        return BuilderFactory.STREAM_PENDING_ENTRY_LIST.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<StreamEntry> xclaim(String key, String group2, String consumername, long minIdleTime, long newIdleTime, int retries, boolean force, StreamEntryID ... ids) {
        this.checkIsInMultiOrPipeline();
        this.client.xclaim(key, group2, consumername, minIdleTime, newIdleTime, retries, force, ids);
        return BuilderFactory.STREAM_ENTRY_LIST.build(this.client.getObjectMultiBulkReply());
    }
}

