/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.ClusterReset;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.ListPosition;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.ZParams;
import redis.clients.jedis.commands.Commands;
import redis.clients.jedis.params.GeoRadiusParam;
import redis.clients.jedis.params.MigrateParams;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.params.ZIncrByParams;
import redis.clients.jedis.util.SafeEncoder;

public class Client
extends BinaryClient
implements Commands {
    public Client() {
    }

    public Client(String host) {
        super(host);
    }

    public Client(String host, int port) {
        super(host, port);
    }

    public Client(String host, int port, boolean ssl) {
        super(host, port, ssl);
    }

    public Client(String host, int port, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        super(host, port, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    @Override
    public void ping(String message) {
        this.ping(SafeEncoder.encode(message));
    }

    @Override
    public void set(String key, String value2) {
        this.set(SafeEncoder.encode(key), SafeEncoder.encode(value2));
    }

    @Override
    public void set(String key, String value2, SetParams params2) {
        this.set(SafeEncoder.encode(key), SafeEncoder.encode(value2), params2);
    }

    @Override
    public void get(String key) {
        this.get(SafeEncoder.encode(key));
    }

    @Override
    public void exists(String ... keys) {
        this.exists(SafeEncoder.encodeMany(keys));
    }

    @Override
    public void del(String ... keys) {
        this.del(SafeEncoder.encodeMany(keys));
    }

    @Override
    public void unlink(String ... keys) {
        this.unlink(SafeEncoder.encodeMany(keys));
    }

    @Override
    public void type(String key) {
        this.type(SafeEncoder.encode(key));
    }

    @Override
    public void keys(String pattern) {
        this.keys(SafeEncoder.encode(pattern));
    }

    @Override
    public void rename(String oldkey, String newkey) {
        this.rename(SafeEncoder.encode(oldkey), SafeEncoder.encode(newkey));
    }

    @Override
    public void renamenx(String oldkey, String newkey) {
        this.renamenx(SafeEncoder.encode(oldkey), SafeEncoder.encode(newkey));
    }

    @Override
    public void expire(String key, int seconds) {
        this.expire(SafeEncoder.encode(key), seconds);
    }

    @Override
    public void expireAt(String key, long unixTime) {
        this.expireAt(SafeEncoder.encode(key), unixTime);
    }

    @Override
    public void ttl(String key) {
        this.ttl(SafeEncoder.encode(key));
    }

    @Override
    public void touch(String ... keys) {
        this.touch(SafeEncoder.encodeMany(keys));
    }

    @Override
    public void move(String key, int dbIndex) {
        this.move(SafeEncoder.encode(key), dbIndex);
    }

    @Override
    public void getSet(String key, String value2) {
        this.getSet(SafeEncoder.encode(key), SafeEncoder.encode(value2));
    }

    @Override
    public void mget(String ... keys) {
        this.mget(SafeEncoder.encodeMany(keys));
    }

    @Override
    public void setnx(String key, String value2) {
        this.setnx(SafeEncoder.encode(key), SafeEncoder.encode(value2));
    }

    @Override
    public void setex(String key, int seconds, String value2) {
        this.setex(SafeEncoder.encode(key), seconds, SafeEncoder.encode(value2));
    }

    @Override
    public void mset(String ... keysvalues) {
        this.mset(SafeEncoder.encodeMany(keysvalues));
    }

    @Override
    public void msetnx(String ... keysvalues) {
        this.msetnx(SafeEncoder.encodeMany(keysvalues));
    }

    @Override
    public void decrBy(String key, long decrement) {
        this.decrBy(SafeEncoder.encode(key), decrement);
    }

    @Override
    public void decr(String key) {
        this.decr(SafeEncoder.encode(key));
    }

    @Override
    public void incrBy(String key, long increment) {
        this.incrBy(SafeEncoder.encode(key), increment);
    }

    @Override
    public void incr(String key) {
        this.incr(SafeEncoder.encode(key));
    }

    @Override
    public void append(String key, String value2) {
        this.append(SafeEncoder.encode(key), SafeEncoder.encode(value2));
    }

    @Override
    public void substr(String key, int start2, int end) {
        this.substr(SafeEncoder.encode(key), start2, end);
    }

    @Override
    public void hset(String key, String field2, String value2) {
        this.hset(SafeEncoder.encode(key), SafeEncoder.encode(field2), SafeEncoder.encode(value2));
    }

    @Override
    public void hset(String key, Map<String, String> hash) {
        HashMap<byte[], byte[]> bhash = new HashMap<byte[], byte[]>(hash.size());
        for (Map.Entry<String, String> entry2 : hash.entrySet()) {
            bhash.put(SafeEncoder.encode(entry2.getKey()), SafeEncoder.encode(entry2.getValue()));
        }
        this.hset(SafeEncoder.encode(key), bhash);
    }

    @Override
    public void hget(String key, String field2) {
        this.hget(SafeEncoder.encode(key), SafeEncoder.encode(field2));
    }

    @Override
    public void hsetnx(String key, String field2, String value2) {
        this.hsetnx(SafeEncoder.encode(key), SafeEncoder.encode(field2), SafeEncoder.encode(value2));
    }

    @Override
    public void hmset(String key, Map<String, String> hash) {
        HashMap<byte[], byte[]> bhash = new HashMap<byte[], byte[]>(hash.size());
        for (Map.Entry<String, String> entry2 : hash.entrySet()) {
            bhash.put(SafeEncoder.encode(entry2.getKey()), SafeEncoder.encode(entry2.getValue()));
        }
        this.hmset(SafeEncoder.encode(key), bhash);
    }

    @Override
    public void hmget(String key, String ... fields) {
        this.hmget(SafeEncoder.encode(key), SafeEncoder.encodeMany(fields));
    }

    @Override
    public void hincrBy(String key, String field2, long value2) {
        this.hincrBy(SafeEncoder.encode(key), SafeEncoder.encode(field2), value2);
    }

    @Override
    public void hexists(String key, String field2) {
        this.hexists(SafeEncoder.encode(key), SafeEncoder.encode(field2));
    }

    @Override
    public void hdel(String key, String ... fields) {
        this.hdel(SafeEncoder.encode(key), SafeEncoder.encodeMany(fields));
    }

    @Override
    public void hlen(String key) {
        this.hlen(SafeEncoder.encode(key));
    }

    @Override
    public void hkeys(String key) {
        this.hkeys(SafeEncoder.encode(key));
    }

    @Override
    public void hvals(String key) {
        this.hvals(SafeEncoder.encode(key));
    }

    @Override
    public void hgetAll(String key) {
        this.hgetAll(SafeEncoder.encode(key));
    }

    @Override
    public void rpush(String key, String ... string2) {
        this.rpush(SafeEncoder.encode(key), SafeEncoder.encodeMany(string2));
    }

    @Override
    public void lpush(String key, String ... string2) {
        this.lpush(SafeEncoder.encode(key), SafeEncoder.encodeMany(string2));
    }

    @Override
    public void llen(String key) {
        this.llen(SafeEncoder.encode(key));
    }

    @Override
    public void lrange(String key, long start2, long stop) {
        this.lrange(SafeEncoder.encode(key), start2, stop);
    }

    @Override
    public void ltrim(String key, long start2, long stop) {
        this.ltrim(SafeEncoder.encode(key), start2, stop);
    }

    @Override
    public void lindex(String key, long index2) {
        this.lindex(SafeEncoder.encode(key), index2);
    }

    @Override
    public void lset(String key, long index2, String value2) {
        this.lset(SafeEncoder.encode(key), index2, SafeEncoder.encode(value2));
    }

    @Override
    public void lrem(String key, long count2, String value2) {
        this.lrem(SafeEncoder.encode(key), count2, SafeEncoder.encode(value2));
    }

    @Override
    public void lpop(String key) {
        this.lpop(SafeEncoder.encode(key));
    }

    @Override
    public void rpop(String key) {
        this.rpop(SafeEncoder.encode(key));
    }

    @Override
    public void rpoplpush(String srckey, String dstkey) {
        this.rpoplpush(SafeEncoder.encode(srckey), SafeEncoder.encode(dstkey));
    }

    @Override
    public void sadd(String key, String ... members2) {
        this.sadd(SafeEncoder.encode(key), SafeEncoder.encodeMany(members2));
    }

    @Override
    public void smembers(String key) {
        this.smembers(SafeEncoder.encode(key));
    }

    @Override
    public void srem(String key, String ... members2) {
        this.srem(SafeEncoder.encode(key), SafeEncoder.encodeMany(members2));
    }

    @Override
    public void spop(String key) {
        this.spop(SafeEncoder.encode(key));
    }

    @Override
    public void spop(String key, long count2) {
        this.spop(SafeEncoder.encode(key), count2);
    }

    @Override
    public void smove(String srckey, String dstkey, String member) {
        this.smove(SafeEncoder.encode(srckey), SafeEncoder.encode(dstkey), SafeEncoder.encode(member));
    }

    @Override
    public void scard(String key) {
        this.scard(SafeEncoder.encode(key));
    }

    @Override
    public void sismember(String key, String member) {
        this.sismember(SafeEncoder.encode(key), SafeEncoder.encode(member));
    }

    @Override
    public void sinter(String ... keys) {
        this.sinter(SafeEncoder.encodeMany(keys));
    }

    @Override
    public void sinterstore(String dstkey, String ... keys) {
        this.sinterstore(SafeEncoder.encode(dstkey), SafeEncoder.encodeMany(keys));
    }

    @Override
    public void sunion(String ... keys) {
        this.sunion(SafeEncoder.encodeMany(keys));
    }

    @Override
    public void sunionstore(String dstkey, String ... keys) {
        this.sunionstore(SafeEncoder.encode(dstkey), SafeEncoder.encodeMany(keys));
    }

    @Override
    public void sdiff(String ... keys) {
        this.sdiff(SafeEncoder.encodeMany(keys));
    }

    @Override
    public void sdiffstore(String dstkey, String ... keys) {
        this.sdiffstore(SafeEncoder.encode(dstkey), SafeEncoder.encodeMany(keys));
    }

    @Override
    public void srandmember(String key) {
        this.srandmember(SafeEncoder.encode(key));
    }

    @Override
    public void zadd(String key, double score, String member) {
        this.zadd(SafeEncoder.encode(key), score, SafeEncoder.encode(member));
    }

    @Override
    public void zadd(String key, double score, String member, ZAddParams params2) {
        this.zadd(SafeEncoder.encode(key), score, SafeEncoder.encode(member), params2);
    }

    @Override
    public void zadd(String key, Map<String, Double> scoreMembers) {
        HashMap<byte[], Double> binaryScoreMembers = this.convertScoreMembersToBinary(scoreMembers);
        this.zadd(SafeEncoder.encode(key), binaryScoreMembers);
    }

    @Override
    public void zadd(String key, Map<String, Double> scoreMembers, ZAddParams params2) {
        HashMap<byte[], Double> binaryScoreMembers = this.convertScoreMembersToBinary(scoreMembers);
        this.zadd(SafeEncoder.encode(key), binaryScoreMembers, params2);
    }

    @Override
    public void zrange(String key, long start2, long stop) {
        this.zrange(SafeEncoder.encode(key), start2, stop);
    }

    @Override
    public void zrem(String key, String ... members2) {
        this.zrem(SafeEncoder.encode(key), SafeEncoder.encodeMany(members2));
    }

    @Override
    public void zincrby(String key, double increment, String member) {
        this.zincrby(SafeEncoder.encode(key), increment, SafeEncoder.encode(member));
    }

    @Override
    public void zincrby(String key, double increment, String member, ZIncrByParams params2) {
        this.zincrby(SafeEncoder.encode(key), increment, SafeEncoder.encode(member), params2);
    }

    @Override
    public void zrank(String key, String member) {
        this.zrank(SafeEncoder.encode(key), SafeEncoder.encode(member));
    }

    @Override
    public void zrevrank(String key, String member) {
        this.zrevrank(SafeEncoder.encode(key), SafeEncoder.encode(member));
    }

    @Override
    public void zrevrange(String key, long start2, long stop) {
        this.zrevrange(SafeEncoder.encode(key), start2, stop);
    }

    @Override
    public void zrangeWithScores(String key, long start2, long stop) {
        this.zrangeWithScores(SafeEncoder.encode(key), start2, stop);
    }

    @Override
    public void zrevrangeWithScores(String key, long start2, long stop) {
        this.zrevrangeWithScores(SafeEncoder.encode(key), start2, stop);
    }

    @Override
    public void zcard(String key) {
        this.zcard(SafeEncoder.encode(key));
    }

    @Override
    public void zscore(String key, String member) {
        this.zscore(SafeEncoder.encode(key), SafeEncoder.encode(member));
    }

    @Override
    public void watch(String ... keys) {
        this.watch(SafeEncoder.encodeMany(keys));
    }

    @Override
    public void sort(String key) {
        this.sort(SafeEncoder.encode(key));
    }

    @Override
    public void sort(String key, SortingParams sortingParameters) {
        this.sort(SafeEncoder.encode(key), sortingParameters);
    }

    @Override
    public void blpop(String[] args2) {
        this.blpop(SafeEncoder.encodeMany(args2));
    }

    public void blpop(int timeout, String ... keys) {
        int size2 = keys.length + 1;
        ArrayList<String> args2 = new ArrayList<String>(size2);
        for (String arg : keys) {
            args2.add(arg);
        }
        args2.add(String.valueOf(timeout));
        this.blpop(args2.toArray(new String[size2]));
    }

    @Override
    public void sort(String key, SortingParams sortingParameters, String dstkey) {
        this.sort(SafeEncoder.encode(key), sortingParameters, SafeEncoder.encode(dstkey));
    }

    @Override
    public void sort(String key, String dstkey) {
        this.sort(SafeEncoder.encode(key), SafeEncoder.encode(dstkey));
    }

    @Override
    public void brpop(String[] args2) {
        this.brpop(SafeEncoder.encodeMany(args2));
    }

    public void brpop(int timeout, String ... keys) {
        int size2 = keys.length + 1;
        ArrayList<String> args2 = new ArrayList<String>(size2);
        for (String arg : keys) {
            args2.add(arg);
        }
        args2.add(String.valueOf(timeout));
        this.brpop(args2.toArray(new String[size2]));
    }

    @Override
    public void zcount(String key, double min2, double max2) {
        this.zcount(SafeEncoder.encode(key), Protocol.toByteArray(min2), Protocol.toByteArray(max2));
    }

    @Override
    public void zcount(String key, String min2, String max2) {
        this.zcount(SafeEncoder.encode(key), SafeEncoder.encode(min2), SafeEncoder.encode(max2));
    }

    @Override
    public void zrangeByScore(String key, double min2, double max2) {
        this.zrangeByScore(SafeEncoder.encode(key), Protocol.toByteArray(min2), Protocol.toByteArray(max2));
    }

    @Override
    public void zrangeByScore(String key, String min2, String max2) {
        this.zrangeByScore(SafeEncoder.encode(key), SafeEncoder.encode(min2), SafeEncoder.encode(max2));
    }

    @Override
    public void zrangeByScore(String key, double min2, double max2, int offset, int count2) {
        this.zrangeByScore(SafeEncoder.encode(key), Protocol.toByteArray(min2), Protocol.toByteArray(max2), offset, count2);
    }

    @Override
    public void zrangeByScoreWithScores(String key, double min2, double max2) {
        this.zrangeByScoreWithScores(SafeEncoder.encode(key), Protocol.toByteArray(min2), Protocol.toByteArray(max2));
    }

    @Override
    public void zrangeByScoreWithScores(String key, double min2, double max2, int offset, int count2) {
        this.zrangeByScoreWithScores(SafeEncoder.encode(key), Protocol.toByteArray(min2), Protocol.toByteArray(max2), offset, count2);
    }

    @Override
    public void zrevrangeByScore(String key, double max2, double min2) {
        this.zrevrangeByScore(SafeEncoder.encode(key), Protocol.toByteArray(max2), Protocol.toByteArray(min2));
    }

    @Override
    public void zrangeByScore(String key, String min2, String max2, int offset, int count2) {
        this.zrangeByScore(SafeEncoder.encode(key), SafeEncoder.encode(min2), SafeEncoder.encode(max2), offset, count2);
    }

    @Override
    public void zrangeByScoreWithScores(String key, String min2, String max2) {
        this.zrangeByScoreWithScores(SafeEncoder.encode(key), SafeEncoder.encode(min2), SafeEncoder.encode(max2));
    }

    @Override
    public void zrangeByScoreWithScores(String key, String min2, String max2, int offset, int count2) {
        this.zrangeByScoreWithScores(SafeEncoder.encode(key), SafeEncoder.encode(min2), SafeEncoder.encode(max2), offset, count2);
    }

    @Override
    public void zrevrangeByScore(String key, String max2, String min2) {
        this.zrevrangeByScore(SafeEncoder.encode(key), SafeEncoder.encode(max2), SafeEncoder.encode(min2));
    }

    @Override
    public void zrevrangeByScore(String key, double max2, double min2, int offset, int count2) {
        this.zrevrangeByScore(SafeEncoder.encode(key), Protocol.toByteArray(max2), Protocol.toByteArray(min2), offset, count2);
    }

    @Override
    public void zrevrangeByScore(String key, String max2, String min2, int offset, int count2) {
        this.zrevrangeByScore(SafeEncoder.encode(key), SafeEncoder.encode(max2), SafeEncoder.encode(min2), offset, count2);
    }

    @Override
    public void zrevrangeByScoreWithScores(String key, double max2, double min2) {
        this.zrevrangeByScoreWithScores(SafeEncoder.encode(key), Protocol.toByteArray(max2), Protocol.toByteArray(min2));
    }

    @Override
    public void zrevrangeByScoreWithScores(String key, String max2, String min2) {
        this.zrevrangeByScoreWithScores(SafeEncoder.encode(key), SafeEncoder.encode(max2), SafeEncoder.encode(min2));
    }

    @Override
    public void zrevrangeByScoreWithScores(String key, double max2, double min2, int offset, int count2) {
        this.zrevrangeByScoreWithScores(SafeEncoder.encode(key), Protocol.toByteArray(max2), Protocol.toByteArray(min2), offset, count2);
    }

    @Override
    public void zrevrangeByScoreWithScores(String key, String max2, String min2, int offset, int count2) {
        this.zrevrangeByScoreWithScores(SafeEncoder.encode(key), SafeEncoder.encode(max2), SafeEncoder.encode(min2), offset, count2);
    }

    @Override
    public void zremrangeByRank(String key, long start2, long stop) {
        this.zremrangeByRank(SafeEncoder.encode(key), start2, stop);
    }

    @Override
    public void zremrangeByScore(String key, double min2, double max2) {
        this.zremrangeByScore(SafeEncoder.encode(key), Protocol.toByteArray(min2), Protocol.toByteArray(max2));
    }

    @Override
    public void zremrangeByScore(String key, String min2, String max2) {
        this.zremrangeByScore(SafeEncoder.encode(key), SafeEncoder.encode(min2), SafeEncoder.encode(max2));
    }

    @Override
    public void zunionstore(String dstkey, String ... sets) {
        this.zunionstore(SafeEncoder.encode(dstkey), SafeEncoder.encodeMany(sets));
    }

    @Override
    public void zunionstore(String dstkey, ZParams params2, String ... sets) {
        this.zunionstore(SafeEncoder.encode(dstkey), params2, SafeEncoder.encodeMany(sets));
    }

    @Override
    public void zinterstore(String dstkey, String ... sets) {
        this.zinterstore(SafeEncoder.encode(dstkey), SafeEncoder.encodeMany(sets));
    }

    @Override
    public void zinterstore(String dstkey, ZParams params2, String ... sets) {
        this.zinterstore(SafeEncoder.encode(dstkey), params2, SafeEncoder.encodeMany(sets));
    }

    public void zlexcount(String key, String min2, String max2) {
        this.zlexcount(SafeEncoder.encode(key), SafeEncoder.encode(min2), SafeEncoder.encode(max2));
    }

    public void zrangeByLex(String key, String min2, String max2) {
        this.zrangeByLex(SafeEncoder.encode(key), SafeEncoder.encode(min2), SafeEncoder.encode(max2));
    }

    public void zrangeByLex(String key, String min2, String max2, int offset, int count2) {
        this.zrangeByLex(SafeEncoder.encode(key), SafeEncoder.encode(min2), SafeEncoder.encode(max2), offset, count2);
    }

    public void zrevrangeByLex(String key, String max2, String min2) {
        this.zrevrangeByLex(SafeEncoder.encode(key), SafeEncoder.encode(max2), SafeEncoder.encode(min2));
    }

    public void zrevrangeByLex(String key, String max2, String min2, int offset, int count2) {
        this.zrevrangeByLex(SafeEncoder.encode(key), SafeEncoder.encode(max2), SafeEncoder.encode(min2), offset, count2);
    }

    public void zremrangeByLex(String key, String min2, String max2) {
        this.zremrangeByLex(SafeEncoder.encode(key), SafeEncoder.encode(min2), SafeEncoder.encode(max2));
    }

    @Override
    public void strlen(String key) {
        this.strlen(SafeEncoder.encode(key));
    }

    @Override
    public void lpushx(String key, String ... string2) {
        this.lpushx(SafeEncoder.encode(key), SafeEncoder.encodeMany(string2));
    }

    @Override
    public void persist(String key) {
        this.persist(SafeEncoder.encode(key));
    }

    @Override
    public void rpushx(String key, String ... string2) {
        this.rpushx(SafeEncoder.encode(key), SafeEncoder.encodeMany(string2));
    }

    @Override
    public void echo(String string2) {
        this.echo(SafeEncoder.encode(string2));
    }

    @Override
    public void linsert(String key, ListPosition where, String pivot, String value2) {
        this.linsert(SafeEncoder.encode(key), where, SafeEncoder.encode(pivot), SafeEncoder.encode(value2));
    }

    @Override
    public void brpoplpush(String source, String destination, int timeout) {
        this.brpoplpush(SafeEncoder.encode(source), SafeEncoder.encode(destination), timeout);
    }

    @Override
    public void setbit(String key, long offset, boolean value2) {
        this.setbit(SafeEncoder.encode(key), offset, value2);
    }

    @Override
    public void setbit(String key, long offset, String value2) {
        this.setbit(SafeEncoder.encode(key), offset, SafeEncoder.encode(value2));
    }

    @Override
    public void getbit(String key, long offset) {
        this.getbit(SafeEncoder.encode(key), offset);
    }

    public void bitpos(String key, boolean value2, BitPosParams params2) {
        this.bitpos(SafeEncoder.encode(key), value2, params2);
    }

    @Override
    public void setrange(String key, long offset, String value2) {
        this.setrange(SafeEncoder.encode(key), offset, SafeEncoder.encode(value2));
    }

    @Override
    public void getrange(String key, long startOffset, long endOffset) {
        this.getrange(SafeEncoder.encode(key), startOffset, endOffset);
    }

    public void publish(String channel, String message) {
        this.publish(SafeEncoder.encode(channel), SafeEncoder.encode(message));
    }

    public void unsubscribe(String ... channels) {
        this.unsubscribe(SafeEncoder.encodeMany(channels));
    }

    public void psubscribe(String ... patterns2) {
        this.psubscribe(SafeEncoder.encodeMany(patterns2));
    }

    public void punsubscribe(String ... patterns2) {
        this.punsubscribe(SafeEncoder.encodeMany(patterns2));
    }

    public void subscribe(String ... channels) {
        this.subscribe(SafeEncoder.encodeMany(channels));
    }

    public void pubsubChannels(String pattern) {
        this.pubsub("channels", pattern);
    }

    public void pubsubNumPat() {
        this.pubsub("numpat", new String[0]);
    }

    public void pubsubNumSub(String ... channels) {
        this.pubsub("numsub", channels);
    }

    @Override
    public void configSet(String parameter, String value2) {
        this.configSet(SafeEncoder.encode(parameter), SafeEncoder.encode(value2));
    }

    @Override
    public void configGet(String pattern) {
        this.configGet(SafeEncoder.encode(pattern));
    }

    public void eval(String script, int keyCount, String ... params2) {
        this.eval(SafeEncoder.encode(script), Protocol.toByteArray(keyCount), SafeEncoder.encodeMany(params2));
    }

    public void evalsha(String sha1, int keyCount, String ... params2) {
        this.evalsha(SafeEncoder.encode(sha1), Protocol.toByteArray(keyCount), SafeEncoder.encodeMany(params2));
    }

    public void scriptExists(String ... sha1) {
        this.scriptExists(SafeEncoder.encodeMany(sha1));
    }

    public void scriptLoad(String script) {
        this.scriptLoad(SafeEncoder.encode(script));
    }

    @Override
    public void objectRefcount(String key) {
        this.objectRefcount(SafeEncoder.encode(key));
    }

    @Override
    public void objectIdletime(String key) {
        this.objectIdletime(SafeEncoder.encode(key));
    }

    @Override
    public void objectEncoding(String key) {
        this.objectEncoding(SafeEncoder.encode(key));
    }

    @Override
    public void bitcount(String key) {
        this.bitcount(SafeEncoder.encode(key));
    }

    @Override
    public void bitcount(String key, long start2, long end) {
        this.bitcount(SafeEncoder.encode(key), start2, end);
    }

    @Override
    public void bitop(BitOP op, String destKey, String ... srcKeys) {
        this.bitop(op, SafeEncoder.encode(destKey), SafeEncoder.encodeMany(srcKeys));
    }

    public void sentinel(String ... args2) {
        this.sentinel(SafeEncoder.encodeMany(args2));
    }

    @Override
    public void dump(String key) {
        this.dump(SafeEncoder.encode(key));
    }

    @Override
    public void restore(String key, int ttl, byte[] serializedValue) {
        this.restore(SafeEncoder.encode(key), ttl, serializedValue);
    }

    @Override
    public void restoreReplace(String key, int ttl, byte[] serializedValue) {
        this.restoreReplace(SafeEncoder.encode(key), ttl, serializedValue);
    }

    public void pexpire(String key, long milliseconds) {
        this.pexpire(SafeEncoder.encode(key), milliseconds);
    }

    public void pexpireAt(String key, long millisecondsTimestamp) {
        this.pexpireAt(SafeEncoder.encode(key), millisecondsTimestamp);
    }

    @Override
    public void pttl(String key) {
        this.pttl(SafeEncoder.encode(key));
    }

    @Override
    public void incrByFloat(String key, double increment) {
        this.incrByFloat(SafeEncoder.encode(key), increment);
    }

    public void psetex(String key, long milliseconds, String value2) {
        this.psetex(SafeEncoder.encode(key), milliseconds, SafeEncoder.encode(value2));
    }

    public void srandmember(String key, int count2) {
        this.srandmember(SafeEncoder.encode(key), count2);
    }

    @Override
    public void clientKill(String ipPort) {
        this.clientKill(SafeEncoder.encode(ipPort));
    }

    @Override
    public void clientSetname(String name) {
        this.clientSetname(SafeEncoder.encode(name));
    }

    @Override
    public void migrate(String host, int port, String key, int destinationDb, int timeout) {
        this.migrate(host, port, SafeEncoder.encode(key), destinationDb, timeout);
    }

    @Override
    public void migrate(String host, int port, int destinationDB, int timeout, MigrateParams params2, String ... keys) {
        this.migrate(host, port, destinationDB, timeout, params2, SafeEncoder.encodeMany(keys));
    }

    @Override
    public void hincrByFloat(String key, String field2, double increment) {
        this.hincrByFloat(SafeEncoder.encode(key), SafeEncoder.encode(field2), increment);
    }

    @Override
    public void scan(String cursor, ScanParams params2) {
        this.scan(SafeEncoder.encode(cursor), params2);
    }

    @Override
    public void hscan(String key, String cursor, ScanParams params2) {
        this.hscan(SafeEncoder.encode(key), SafeEncoder.encode(cursor), params2);
    }

    @Override
    public void sscan(String key, String cursor, ScanParams params2) {
        this.sscan(SafeEncoder.encode(key), SafeEncoder.encode(cursor), params2);
    }

    @Override
    public void zscan(String key, String cursor, ScanParams params2) {
        this.zscan(SafeEncoder.encode(key), SafeEncoder.encode(cursor), params2);
    }

    public void cluster(String subcommand, int ... args2) {
        byte[][] arg = new byte[args2.length + 1][];
        for (int i = 1; i < arg.length; ++i) {
            arg[i] = Protocol.toByteArray(args2[i - 1]);
        }
        arg[0] = SafeEncoder.encode(subcommand);
        this.cluster(arg);
    }

    public void pubsub(String subcommand, String ... args2) {
        byte[][] arg = new byte[args2.length + 1][];
        for (int i = 1; i < arg.length; ++i) {
            arg[i] = SafeEncoder.encode(args2[i - 1]);
        }
        arg[0] = SafeEncoder.encode(subcommand);
        this.pubsub(arg);
    }

    public void cluster(String subcommand, String ... args2) {
        byte[][] arg = new byte[args2.length + 1][];
        for (int i = 1; i < arg.length; ++i) {
            arg[i] = SafeEncoder.encode(args2[i - 1]);
        }
        arg[0] = SafeEncoder.encode(subcommand);
        this.cluster(arg);
    }

    public void cluster(String subcommand) {
        byte[][] arg = new byte[][]{SafeEncoder.encode(subcommand)};
        this.cluster(arg);
    }

    public void clusterNodes() {
        this.cluster("nodes");
    }

    public void clusterMeet(String ip, int port) {
        this.cluster("meet", ip, String.valueOf(port));
    }

    public void clusterReset(ClusterReset resetType) {
        this.cluster("reset", resetType.name());
    }

    public void clusterAddSlots(int ... slots) {
        this.cluster("addslots", slots);
    }

    public void clusterDelSlots(int ... slots) {
        this.cluster("delslots", slots);
    }

    public void clusterInfo() {
        this.cluster("info");
    }

    public void clusterGetKeysInSlot(int slot, int count2) {
        int[] args2 = new int[]{slot, count2};
        this.cluster("getkeysinslot", args2);
    }

    public void clusterSetSlotNode(int slot, String nodeId) {
        this.cluster("setslot", String.valueOf(slot), "node", nodeId);
    }

    public void clusterSetSlotMigrating(int slot, String nodeId) {
        this.cluster("setslot", String.valueOf(slot), "migrating", nodeId);
    }

    public void clusterSetSlotImporting(int slot, String nodeId) {
        this.cluster("setslot", String.valueOf(slot), "importing", nodeId);
    }

    public void pfadd(String key, String ... elements2) {
        this.pfadd(SafeEncoder.encode(key), SafeEncoder.encodeMany(elements2));
    }

    public void pfcount(String key) {
        this.pfcount(SafeEncoder.encode(key));
    }

    public void pfcount(String ... keys) {
        this.pfcount(SafeEncoder.encodeMany(keys));
    }

    public void pfmerge(String destkey, String ... sourcekeys) {
        this.pfmerge(SafeEncoder.encode(destkey), SafeEncoder.encodeMany(sourcekeys));
    }

    public void clusterSetSlotStable(int slot) {
        this.cluster("setslot", String.valueOf(slot), "stable");
    }

    public void clusterForget(String nodeId) {
        this.cluster("forget", nodeId);
    }

    public void clusterFlushSlots() {
        this.cluster("flushslots");
    }

    public void clusterKeySlot(String key) {
        this.cluster("keyslot", key);
    }

    public void clusterCountKeysInSlot(int slot) {
        this.cluster("countkeysinslot", String.valueOf(slot));
    }

    public void clusterSaveConfig() {
        this.cluster("saveconfig");
    }

    public void clusterReplicate(String nodeId) {
        this.cluster("replicate", nodeId);
    }

    public void clusterSlaves(String nodeId) {
        this.cluster("slaves", nodeId);
    }

    public void clusterFailover() {
        this.cluster("failover");
    }

    public void clusterSlots() {
        this.cluster("slots");
    }

    public void geoadd(String key, double longitude, double latitude, String member) {
        this.geoadd(SafeEncoder.encode(key), longitude, latitude, SafeEncoder.encode(member));
    }

    public void geoadd(String key, Map<String, GeoCoordinate> memberCoordinateMap) {
        this.geoadd(SafeEncoder.encode(key), this.convertMemberCoordinateMapToBinary(memberCoordinateMap));
    }

    public void geodist(String key, String member1, String member2) {
        this.geodist(SafeEncoder.encode(key), SafeEncoder.encode(member1), SafeEncoder.encode(member2));
    }

    public void geodist(String key, String member1, String member2, GeoUnit unit2) {
        this.geodist(SafeEncoder.encode(key), SafeEncoder.encode(member1), SafeEncoder.encode(member2), unit2);
    }

    public void geohash(String key, String ... members2) {
        this.geohash(SafeEncoder.encode(key), SafeEncoder.encodeMany(members2));
    }

    public void geopos(String key, String[] members2) {
        this.geopos(SafeEncoder.encode(key), SafeEncoder.encodeMany(members2));
    }

    public void georadius(String key, double longitude, double latitude, double radius, GeoUnit unit2) {
        this.georadius(SafeEncoder.encode(key), longitude, latitude, radius, unit2);
    }

    public void georadiusReadonly(String key, double longitude, double latitude, double radius, GeoUnit unit2) {
        this.georadiusReadonly(SafeEncoder.encode(key), longitude, latitude, radius, unit2);
    }

    public void georadius(String key, double longitude, double latitude, double radius, GeoUnit unit2, GeoRadiusParam param2) {
        this.georadius(SafeEncoder.encode(key), longitude, latitude, radius, unit2, param2);
    }

    public void georadiusReadonly(String key, double longitude, double latitude, double radius, GeoUnit unit2, GeoRadiusParam param2) {
        this.georadiusReadonly(SafeEncoder.encode(key), longitude, latitude, radius, unit2, param2);
    }

    public void georadiusByMember(String key, String member, double radius, GeoUnit unit2) {
        this.georadiusByMember(SafeEncoder.encode(key), SafeEncoder.encode(member), radius, unit2);
    }

    public void georadiusByMemberReadonly(String key, String member, double radius, GeoUnit unit2) {
        this.georadiusByMemberReadonly(SafeEncoder.encode(key), SafeEncoder.encode(member), radius, unit2);
    }

    public void georadiusByMember(String key, String member, double radius, GeoUnit unit2, GeoRadiusParam param2) {
        this.georadiusByMember(SafeEncoder.encode(key), SafeEncoder.encode(member), radius, unit2, param2);
    }

    public void georadiusByMemberReadonly(String key, String member, double radius, GeoUnit unit2, GeoRadiusParam param2) {
        this.georadiusByMemberReadonly(SafeEncoder.encode(key), SafeEncoder.encode(member), radius, unit2, param2);
    }

    public void moduleLoad(String path2) {
        this.moduleLoad(SafeEncoder.encode(path2));
    }

    public void moduleUnload(String name) {
        this.moduleUnload(SafeEncoder.encode(name));
    }

    private HashMap<byte[], Double> convertScoreMembersToBinary(Map<String, Double> scoreMembers) {
        HashMap<byte[], Double> binaryScoreMembers = new HashMap<byte[], Double>();
        for (Map.Entry<String, Double> entry2 : scoreMembers.entrySet()) {
            binaryScoreMembers.put(SafeEncoder.encode(entry2.getKey()), entry2.getValue());
        }
        return binaryScoreMembers;
    }

    private HashMap<byte[], GeoCoordinate> convertMemberCoordinateMapToBinary(Map<String, GeoCoordinate> memberCoordinateMap) {
        HashMap<byte[], GeoCoordinate> binaryMemberCoordinateMap = new HashMap<byte[], GeoCoordinate>();
        for (Map.Entry<String, GeoCoordinate> entry2 : memberCoordinateMap.entrySet()) {
            binaryMemberCoordinateMap.put(SafeEncoder.encode(entry2.getKey()), entry2.getValue());
        }
        return binaryMemberCoordinateMap;
    }

    @Override
    public void bitfield(String key, String ... arguments) {
        this.bitfield(SafeEncoder.encode(key), SafeEncoder.encodeMany(arguments));
    }

    @Override
    public void hstrlen(String key, String field2) {
        this.hstrlen(SafeEncoder.encode(key), SafeEncoder.encode(field2));
    }

    @Override
    public void xadd(String key, StreamEntryID id, Map<String, String> hash, long maxLen, boolean approximateLength) {
        HashMap<byte[], byte[]> bhash = new HashMap<byte[], byte[]>(hash.size());
        for (Map.Entry<String, String> entry2 : hash.entrySet()) {
            bhash.put(SafeEncoder.encode(entry2.getKey()), SafeEncoder.encode(entry2.getValue()));
        }
        this.xadd(SafeEncoder.encode(key), SafeEncoder.encode(id == null ? "*" : id.toString()), bhash, maxLen, approximateLength);
    }

    @Override
    public void xlen(String key) {
        this.xlen(SafeEncoder.encode(key));
    }

    @Override
    public void xrange(String key, StreamEntryID start2, StreamEntryID end, long count2) {
        this.xrange(SafeEncoder.encode(key), SafeEncoder.encode(start2 == null ? "-" : start2.toString()), SafeEncoder.encode(end == null ? "+" : end.toString()), count2);
    }

    @Override
    public void xrevrange(String key, StreamEntryID end, StreamEntryID start2, int count2) {
        this.xrevrange(SafeEncoder.encode(key), SafeEncoder.encode(end == null ? "+" : end.toString()), SafeEncoder.encode(start2 == null ? "-" : start2.toString()), count2);
    }

    @Override
    public void xread(int count2, long block, Map.Entry<String, StreamEntryID> ... streams) {
        HashMap<byte[], byte[]> bhash = new HashMap<byte[], byte[]>(streams.length);
        for (Map.Entry<String, StreamEntryID> entry2 : streams) {
            bhash.put(SafeEncoder.encode(entry2.getKey()), SafeEncoder.encode(entry2.getValue() == null ? "0-0" : entry2.getValue().toString()));
        }
        this.xread(count2, block, bhash);
    }

    @Override
    public void xack(String key, String group2, StreamEntryID ... ids) {
        byte[][] bids = new byte[ids.length][];
        for (int i = 0; i < ids.length; ++i) {
            StreamEntryID id = ids[i];
            bids[i] = SafeEncoder.encode(id == null ? "0-0" : id.toString());
        }
        this.xack(SafeEncoder.encode(key), SafeEncoder.encode(group2), bids);
    }

    @Override
    public void xgroupCreate(String key, String groupname, StreamEntryID id, boolean makeStream) {
        this.xgroupCreate(SafeEncoder.encode(key), SafeEncoder.encode(groupname), SafeEncoder.encode(id == null ? "0-0" : id.toString()), makeStream);
    }

    @Override
    public void xgroupSetID(String key, String groupname, StreamEntryID id) {
        this.xgroupSetID(SafeEncoder.encode(key), SafeEncoder.encode(groupname), SafeEncoder.encode(id == null ? "0-0" : id.toString()));
    }

    @Override
    public void xgroupDestroy(String key, String groupname) {
        this.xgroupDestroy(SafeEncoder.encode(key), SafeEncoder.encode(groupname));
    }

    @Override
    public void xgroupDelConsumer(String key, String groupname, String consumerName) {
        this.xgroupDelConsumer(SafeEncoder.encode(key), SafeEncoder.encode(groupname), SafeEncoder.encode(consumerName));
    }

    @Override
    public void xdel(String key, StreamEntryID ... ids) {
        byte[][] bids = new byte[ids.length][];
        for (int i = 0; i < ids.length; ++i) {
            StreamEntryID id = ids[i];
            bids[i] = SafeEncoder.encode(id == null ? "0-0" : id.toString());
        }
        this.xdel(SafeEncoder.encode(key), bids);
    }

    @Override
    public void xtrim(String key, long maxLen, boolean approximateLength) {
        this.xtrim(SafeEncoder.encode(key), maxLen, approximateLength);
    }

    @Override
    public void xreadGroup(String groupname, String consumer, int count2, long block, boolean noAck, Map.Entry<String, StreamEntryID> ... streams) {
        HashMap<byte[], byte[]> bhash = new HashMap<byte[], byte[]>(streams.length);
        for (Map.Entry<String, StreamEntryID> entry2 : streams) {
            bhash.put(SafeEncoder.encode(entry2.getKey()), SafeEncoder.encode(entry2.getValue() == null ? ">" : entry2.getValue().toString()));
        }
        this.xreadGroup(SafeEncoder.encode(groupname), SafeEncoder.encode(consumer), count2, block, noAck, bhash);
    }

    @Override
    public void xpending(String key, String groupname, StreamEntryID start2, StreamEntryID end, int count2, String consumername) {
        this.xpending(SafeEncoder.encode(key), SafeEncoder.encode(groupname), SafeEncoder.encode(start2 == null ? "-" : start2.toString()), SafeEncoder.encode(end == null ? "+" : end.toString()), count2, consumername == null ? null : SafeEncoder.encode(consumername));
    }

    @Override
    public void xclaim(String key, String group2, String consumername, long minIdleTime, long newIdleTime, int retries, boolean force, StreamEntryID ... ids) {
        byte[][] bids = new byte[ids.length][];
        for (int i = 0; i < ids.length; ++i) {
            bids[i] = SafeEncoder.encode(ids[i].toString());
        }
        this.xclaim(SafeEncoder.encode(key), SafeEncoder.encode(group2), SafeEncoder.encode(consumername), minIdleTime, newIdleTime, retries, force, bids);
    }
}

