/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.Closeable;
import java.io.Serializable;
import java.net.URI;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import redis.clients.jedis.BinaryJedisPubSub;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Client;
import redis.clients.jedis.DebugParams;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisMonitor;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ListPosition;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.ZParams;
import redis.clients.jedis.commands.AdvancedBinaryJedisCommands;
import redis.clients.jedis.commands.BasicCommands;
import redis.clients.jedis.commands.BinaryJedisCommands;
import redis.clients.jedis.commands.BinaryScriptingCommands;
import redis.clients.jedis.commands.MultiKeyBinaryCommands;
import redis.clients.jedis.exceptions.InvalidURIException;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.params.ClientKillParams;
import redis.clients.jedis.params.GeoRadiusParam;
import redis.clients.jedis.params.MigrateParams;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.params.ZIncrByParams;
import redis.clients.jedis.util.JedisByteHashMap;
import redis.clients.jedis.util.JedisURIHelper;

public class BinaryJedis
implements BasicCommands,
BinaryJedisCommands,
MultiKeyBinaryCommands,
AdvancedBinaryJedisCommands,
BinaryScriptingCommands,
Closeable {
    protected Client client = null;
    protected Transaction transaction = null;
    protected Pipeline pipeline = null;

    public BinaryJedis() {
        this.client = new Client();
    }

    public BinaryJedis(String host) {
        URI uri = URI.create(host);
        if (JedisURIHelper.isValid(uri)) {
            this.initializeClientFromURI(uri);
        } else {
            this.client = new Client(host);
        }
    }

    public BinaryJedis(HostAndPort hp) {
        this(hp.getHost(), hp.getPort());
    }

    public BinaryJedis(String host, int port) {
        this.client = new Client(host, port);
    }

    public BinaryJedis(String host, int port, boolean ssl) {
        this.client = new Client(host, port, ssl);
    }

    public BinaryJedis(String host, int port, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this.client = new Client(host, port, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public BinaryJedis(String host, int port, int timeout) {
        this(host, port, timeout, timeout);
    }

    public BinaryJedis(String host, int port, int timeout, boolean ssl) {
        this(host, port, timeout, timeout, ssl);
    }

    public BinaryJedis(String host, int port, int timeout, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(host, port, timeout, timeout, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public BinaryJedis(String host, int port, int connectionTimeout, int soTimeout) {
        this.client = new Client(host, port);
        this.client.setConnectionTimeout(connectionTimeout);
        this.client.setSoTimeout(soTimeout);
    }

    public BinaryJedis(String host, int port, int connectionTimeout, int soTimeout, boolean ssl) {
        this.client = new Client(host, port, ssl);
        this.client.setConnectionTimeout(connectionTimeout);
        this.client.setSoTimeout(soTimeout);
    }

    public BinaryJedis(String host, int port, int connectionTimeout, int soTimeout, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this.client = new Client(host, port, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
        this.client.setConnectionTimeout(connectionTimeout);
        this.client.setSoTimeout(soTimeout);
    }

    public BinaryJedis(JedisShardInfo shardInfo) {
        this.client = new Client(shardInfo.getHost(), shardInfo.getPort(), shardInfo.getSsl(), shardInfo.getSslSocketFactory(), shardInfo.getSslParameters(), shardInfo.getHostnameVerifier());
        this.client.setConnectionTimeout(shardInfo.getConnectionTimeout());
        this.client.setSoTimeout(shardInfo.getSoTimeout());
        this.client.setPassword(shardInfo.getPassword());
        this.client.setDb(shardInfo.getDb());
    }

    public BinaryJedis(URI uri) {
        this.initializeClientFromURI(uri);
    }

    public BinaryJedis(URI uri, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this.initializeClientFromURI(uri, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public BinaryJedis(URI uri, int timeout) {
        this(uri, timeout, timeout);
    }

    public BinaryJedis(URI uri, int timeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(uri, timeout, timeout, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public BinaryJedis(URI uri, int connectionTimeout, int soTimeout) {
        this.initializeClientFromURI(uri);
        this.client.setConnectionTimeout(connectionTimeout);
        this.client.setSoTimeout(soTimeout);
    }

    public BinaryJedis(URI uri, int connectionTimeout, int soTimeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this.initializeClientFromURI(uri, sslSocketFactory, sslParameters, hostnameVerifier);
        this.client.setConnectionTimeout(connectionTimeout);
        this.client.setSoTimeout(soTimeout);
    }

    private void initializeClientFromURI(URI uri) {
        this.initializeClientFromURI(uri, null, null, null);
    }

    private void initializeClientFromURI(URI uri, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        int dbIndex;
        if (!JedisURIHelper.isValid(uri)) {
            throw new InvalidURIException(String.format("Cannot open Redis connection due invalid URI. %s", uri.toString()));
        }
        this.client = new Client(uri.getHost(), uri.getPort(), JedisURIHelper.isRedisSSLScheme(uri), sslSocketFactory, sslParameters, hostnameVerifier);
        String password = JedisURIHelper.getPassword(uri);
        if (password != null) {
            this.client.auth(password);
            this.client.getStatusCodeReply();
        }
        if ((dbIndex = JedisURIHelper.getDBIndex(uri)) > 0) {
            this.client.select(dbIndex);
            this.client.getStatusCodeReply();
            this.client.setDb(dbIndex);
        }
    }

    @Override
    public String ping() {
        this.checkIsInMultiOrPipeline();
        this.client.ping();
        return this.client.getStatusCodeReply();
    }

    public byte[] ping(byte[] message) {
        this.checkIsInMultiOrPipeline();
        this.client.ping(message);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public String set(byte[] key, byte[] value2) {
        this.checkIsInMultiOrPipeline();
        this.client.set(key, value2);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String set(byte[] key, byte[] value2, SetParams params2) {
        this.checkIsInMultiOrPipeline();
        this.client.set(key, value2, params2);
        return this.client.getStatusCodeReply();
    }

    @Override
    public byte[] get(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.get(key);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public String quit() {
        this.checkIsInMultiOrPipeline();
        this.client.quit();
        String quitReturn = this.client.getStatusCodeReply();
        this.client.disconnect();
        return quitReturn;
    }

    @Override
    public Long exists(byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.exists(keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Boolean exists(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.exists(new byte[][]{key});
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Long del(byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.del(keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Long del(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.del(new byte[][]{key});
        return this.client.getIntegerReply();
    }

    @Override
    public Long unlink(byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.unlink(keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Long unlink(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.unlink(new byte[][]{key});
        return this.client.getIntegerReply();
    }

    @Override
    public String type(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.type(key);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String flushDB() {
        this.checkIsInMultiOrPipeline();
        this.client.flushDB();
        return this.client.getStatusCodeReply();
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        this.checkIsInMultiOrPipeline();
        this.client.keys(pattern);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public byte[] randomBinaryKey() {
        this.checkIsInMultiOrPipeline();
        this.client.randomKey();
        return this.client.getBinaryBulkReply();
    }

    @Override
    public String rename(byte[] oldkey, byte[] newkey) {
        this.checkIsInMultiOrPipeline();
        this.client.rename(oldkey, newkey);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long renamenx(byte[] oldkey, byte[] newkey) {
        this.checkIsInMultiOrPipeline();
        this.client.renamenx(oldkey, newkey);
        return this.client.getIntegerReply();
    }

    @Override
    public Long dbSize() {
        this.checkIsInMultiOrPipeline();
        this.client.dbSize();
        return this.client.getIntegerReply();
    }

    @Override
    public Long expire(byte[] key, int seconds) {
        this.checkIsInMultiOrPipeline();
        this.client.expire(key, seconds);
        return this.client.getIntegerReply();
    }

    @Override
    public Long expireAt(byte[] key, long unixTime) {
        this.checkIsInMultiOrPipeline();
        this.client.expireAt(key, unixTime);
        return this.client.getIntegerReply();
    }

    @Override
    public Long ttl(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.ttl(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long touch(byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.touch(keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Long touch(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.touch(new byte[][]{key});
        return this.client.getIntegerReply();
    }

    @Override
    public String select(int index2) {
        this.checkIsInMultiOrPipeline();
        this.client.select(index2);
        String statusCodeReply = this.client.getStatusCodeReply();
        this.client.setDb(index2);
        return statusCodeReply;
    }

    @Override
    public String swapDB(int index1, int index2) {
        this.checkIsInMultiOrPipeline();
        this.client.swapDB(index1, index2);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long move(byte[] key, int dbIndex) {
        this.checkIsInMultiOrPipeline();
        this.client.move(key, dbIndex);
        return this.client.getIntegerReply();
    }

    @Override
    public String flushAll() {
        this.checkIsInMultiOrPipeline();
        this.client.flushAll();
        return this.client.getStatusCodeReply();
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value2) {
        this.checkIsInMultiOrPipeline();
        this.client.getSet(key, value2);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public List<byte[]> mget(byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.mget(keys);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public Long setnx(byte[] key, byte[] value2) {
        this.checkIsInMultiOrPipeline();
        this.client.setnx(key, value2);
        return this.client.getIntegerReply();
    }

    @Override
    public String setex(byte[] key, int seconds, byte[] value2) {
        this.checkIsInMultiOrPipeline();
        this.client.setex(key, seconds, value2);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String mset(byte[] ... keysvalues) {
        this.checkIsInMultiOrPipeline();
        this.client.mset(keysvalues);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long msetnx(byte[] ... keysvalues) {
        this.checkIsInMultiOrPipeline();
        this.client.msetnx(keysvalues);
        return this.client.getIntegerReply();
    }

    @Override
    public Long decrBy(byte[] key, long decrement) {
        this.checkIsInMultiOrPipeline();
        this.client.decrBy(key, decrement);
        return this.client.getIntegerReply();
    }

    @Override
    public Long decr(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.decr(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long incrBy(byte[] key, long increment) {
        this.checkIsInMultiOrPipeline();
        this.client.incrBy(key, increment);
        return this.client.getIntegerReply();
    }

    @Override
    public Double incrByFloat(byte[] key, double increment) {
        this.checkIsInMultiOrPipeline();
        this.client.incrByFloat(key, increment);
        String dval = this.client.getBulkReply();
        return dval != null ? new Double(dval) : null;
    }

    @Override
    public Long incr(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.incr(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long append(byte[] key, byte[] value2) {
        this.checkIsInMultiOrPipeline();
        this.client.append(key, value2);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] substr(byte[] key, int start2, int end) {
        this.checkIsInMultiOrPipeline();
        this.client.substr(key, start2, end);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long hset(byte[] key, byte[] field2, byte[] value2) {
        this.checkIsInMultiOrPipeline();
        this.client.hset(key, field2, value2);
        return this.client.getIntegerReply();
    }

    @Override
    public Long hset(byte[] key, Map<byte[], byte[]> hash) {
        this.checkIsInMultiOrPipeline();
        this.client.hset(key, hash);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] hget(byte[] key, byte[] field2) {
        this.checkIsInMultiOrPipeline();
        this.client.hget(key, field2);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long hsetnx(byte[] key, byte[] field2, byte[] value2) {
        this.checkIsInMultiOrPipeline();
        this.client.hsetnx(key, field2, value2);
        return this.client.getIntegerReply();
    }

    @Override
    public String hmset(byte[] key, Map<byte[], byte[]> hash) {
        this.checkIsInMultiOrPipeline();
        this.client.hmset(key, hash);
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<byte[]> hmget(byte[] key, byte[] ... fields) {
        this.checkIsInMultiOrPipeline();
        this.client.hmget(key, fields);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public Long hincrBy(byte[] key, byte[] field2, long value2) {
        this.checkIsInMultiOrPipeline();
        this.client.hincrBy(key, field2, value2);
        return this.client.getIntegerReply();
    }

    @Override
    public Double hincrByFloat(byte[] key, byte[] field2, double value2) {
        this.checkIsInMultiOrPipeline();
        this.client.hincrByFloat(key, field2, value2);
        String dval = this.client.getBulkReply();
        return dval != null ? new Double(dval) : null;
    }

    @Override
    public Boolean hexists(byte[] key, byte[] field2) {
        this.checkIsInMultiOrPipeline();
        this.client.hexists(key, field2);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Long hdel(byte[] key, byte[] ... fields) {
        this.checkIsInMultiOrPipeline();
        this.client.hdel(key, fields);
        return this.client.getIntegerReply();
    }

    @Override
    public Long hlen(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.hlen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> hkeys(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.hkeys(key);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    public List<byte[]> hvals(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.hvals(key);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public Map<byte[], byte[]> hgetAll(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.hgetAll(key);
        List<byte[]> flatHash = this.client.getBinaryMultiBulkReply();
        JedisByteHashMap hash = new JedisByteHashMap();
        Iterator<byte[]> iterator2 = flatHash.iterator();
        while (iterator2.hasNext()) {
            hash.put(iterator2.next(), iterator2.next());
        }
        return hash;
    }

    @Override
    public Long rpush(byte[] key, byte[] ... strings) {
        this.checkIsInMultiOrPipeline();
        this.client.rpush(key, strings);
        return this.client.getIntegerReply();
    }

    @Override
    public Long lpush(byte[] key, byte[] ... strings) {
        this.checkIsInMultiOrPipeline();
        this.client.lpush(key, strings);
        return this.client.getIntegerReply();
    }

    @Override
    public Long llen(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.llen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public List<byte[]> lrange(byte[] key, long start2, long stop) {
        this.checkIsInMultiOrPipeline();
        this.client.lrange(key, start2, stop);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public String ltrim(byte[] key, long start2, long stop) {
        this.checkIsInMultiOrPipeline();
        this.client.ltrim(key, start2, stop);
        return this.client.getStatusCodeReply();
    }

    @Override
    public byte[] lindex(byte[] key, long index2) {
        this.checkIsInMultiOrPipeline();
        this.client.lindex(key, index2);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public String lset(byte[] key, long index2, byte[] value2) {
        this.checkIsInMultiOrPipeline();
        this.client.lset(key, index2, value2);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long lrem(byte[] key, long count2, byte[] value2) {
        this.checkIsInMultiOrPipeline();
        this.client.lrem(key, count2, value2);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] lpop(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.lpop(key);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public byte[] rpop(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.rpop(key);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public byte[] rpoplpush(byte[] srckey, byte[] dstkey) {
        this.checkIsInMultiOrPipeline();
        this.client.rpoplpush(srckey, dstkey);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long sadd(byte[] key, byte[] ... members2) {
        this.checkIsInMultiOrPipeline();
        this.client.sadd(key, members2);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> smembers(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.smembers(key);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Long srem(byte[] key, byte[] ... member) {
        this.checkIsInMultiOrPipeline();
        this.client.srem(key, member);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] spop(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.spop(key);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Set<byte[]> spop(byte[] key, long count2) {
        this.checkIsInMultiOrPipeline();
        this.client.spop(key, count2);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Long smove(byte[] srckey, byte[] dstkey, byte[] member) {
        this.checkIsInMultiOrPipeline();
        this.client.smove(srckey, dstkey, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long scard(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.scard(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Boolean sismember(byte[] key, byte[] member) {
        this.checkIsInMultiOrPipeline();
        this.client.sismember(key, member);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Set<byte[]> sinter(byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sinter(keys);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Long sinterstore(byte[] dstkey, byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sinterstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> sunion(byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sunion(keys);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Long sunionstore(byte[] dstkey, byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sunionstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> sdiff(byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sdiff(keys);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Long sdiffstore(byte[] dstkey, byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sdiffstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] srandmember(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.srandmember(key);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public List<byte[]> srandmember(byte[] key, int count2) {
        this.checkIsInMultiOrPipeline();
        this.client.srandmember(key, count2);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public Long zadd(byte[] key, double score, byte[] member) {
        this.checkIsInMultiOrPipeline();
        this.client.zadd(key, score, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zadd(byte[] key, double score, byte[] member, ZAddParams params2) {
        this.checkIsInMultiOrPipeline();
        this.client.zadd(key, score, member, params2);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zadd(byte[] key, Map<byte[], Double> scoreMembers) {
        this.checkIsInMultiOrPipeline();
        this.client.zadd(key, scoreMembers);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zadd(byte[] key, Map<byte[], Double> scoreMembers, ZAddParams params2) {
        this.checkIsInMultiOrPipeline();
        this.client.zadd(key, scoreMembers, params2);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> zrange(byte[] key, long start2, long stop) {
        this.checkIsInMultiOrPipeline();
        this.client.zrange(key, start2, stop);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Long zrem(byte[] key, byte[] ... members2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrem(key, members2);
        return this.client.getIntegerReply();
    }

    @Override
    public Double zincrby(byte[] key, double increment, byte[] member) {
        this.checkIsInMultiOrPipeline();
        this.client.zincrby(key, increment, member);
        return BuilderFactory.DOUBLE.build(this.client.getOne());
    }

    @Override
    public Double zincrby(byte[] key, double increment, byte[] member, ZIncrByParams params2) {
        this.checkIsInMultiOrPipeline();
        this.client.zincrby(key, increment, member, params2);
        return BuilderFactory.DOUBLE.build(this.client.getOne());
    }

    @Override
    public Long zrank(byte[] key, byte[] member) {
        this.checkIsInMultiOrPipeline();
        this.client.zrank(key, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zrevrank(byte[] key, byte[] member) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrank(key, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> zrevrange(byte[] key, long start2, long stop) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrange(key, start2, stop);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<Tuple> zrangeWithScores(byte[] key, long start2, long stop) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeWithScores(key, start2, stop);
        return this.getTupledSet();
    }

    @Override
    public Set<Tuple> zrevrangeWithScores(byte[] key, long start2, long stop) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeWithScores(key, start2, stop);
        return this.getTupledSet();
    }

    @Override
    public Long zcard(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.zcard(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Double zscore(byte[] key, byte[] member) {
        this.checkIsInMultiOrPipeline();
        this.client.zscore(key, member);
        String score = this.client.getBulkReply();
        return score != null ? new Double(score) : null;
    }

    public Transaction multi() {
        this.client.multi();
        this.client.getOne();
        this.transaction = new Transaction(this.client);
        return this.transaction;
    }

    protected void checkIsInMultiOrPipeline() {
        if (this.client.isInMulti()) {
            throw new JedisDataException("Cannot use Jedis when in Multi. Please use Transaction or reset jedis state.");
        }
        if (this.pipeline != null && this.pipeline.hasPipelinedResponse()) {
            throw new JedisDataException("Cannot use Jedis when in Pipeline. Please use Pipeline or reset jedis state .");
        }
    }

    public void connect() {
        this.client.connect();
    }

    public void disconnect() {
        this.client.disconnect();
    }

    public void resetState() {
        if (this.client.isConnected()) {
            if (this.transaction != null) {
                this.transaction.close();
            }
            if (this.pipeline != null) {
                this.pipeline.close();
            }
            this.client.resetState();
        }
        this.transaction = null;
        this.pipeline = null;
    }

    @Override
    public String watch(byte[] ... keys) {
        this.client.watch(keys);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String unwatch() {
        this.client.unwatch();
        return this.client.getStatusCodeReply();
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public List<byte[]> sort(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.sort(key);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public List<byte[]> sort(byte[] key, SortingParams sortingParameters) {
        this.checkIsInMultiOrPipeline();
        this.client.sort(key, sortingParameters);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public List<byte[]> blpop(int timeout, byte[] ... keys) {
        return this.blpop(this.getArgsAddTimeout(timeout, keys));
    }

    private byte[][] getArgsAddTimeout(int timeout, byte[][] keys) {
        int size2 = keys.length;
        byte[][] args2 = new byte[size2 + 1][];
        for (int at = 0; at != size2; ++at) {
            args2[at] = keys[at];
        }
        args2[size2] = Protocol.toByteArray(timeout);
        return args2;
    }

    @Override
    public Long sort(byte[] key, SortingParams sortingParameters, byte[] dstkey) {
        this.checkIsInMultiOrPipeline();
        this.client.sort(key, sortingParameters, dstkey);
        return this.client.getIntegerReply();
    }

    @Override
    public Long sort(byte[] key, byte[] dstkey) {
        this.checkIsInMultiOrPipeline();
        this.client.sort(key, dstkey);
        return this.client.getIntegerReply();
    }

    @Override
    public List<byte[]> brpop(int timeout, byte[] ... keys) {
        return this.brpop(this.getArgsAddTimeout(timeout, keys));
    }

    @Override
    public List<byte[]> blpop(byte[] ... args2) {
        this.checkIsInMultiOrPipeline();
        this.client.blpop(args2);
        this.client.setTimeoutInfinite();
        try {
            List<byte[]> list2 = this.client.getBinaryMultiBulkReply();
            return list2;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public List<byte[]> brpop(byte[] ... args2) {
        this.checkIsInMultiOrPipeline();
        this.client.brpop(args2);
        this.client.setTimeoutInfinite();
        try {
            List<byte[]> list2 = this.client.getBinaryMultiBulkReply();
            return list2;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public String auth(String password) {
        this.checkIsInMultiOrPipeline();
        this.client.auth(password);
        return this.client.getStatusCodeReply();
    }

    public Pipeline pipelined() {
        this.pipeline = new Pipeline();
        this.pipeline.setClient(this.client);
        return this.pipeline;
    }

    @Override
    public Long zcount(byte[] key, double min2, double max2) {
        this.checkIsInMultiOrPipeline();
        this.client.zcount(key, min2, max2);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zcount(byte[] key, byte[] min2, byte[] max2) {
        this.checkIsInMultiOrPipeline();
        this.client.zcount(key, min2, max2);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, double min2, double max2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScore(key, min2, max2);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, byte[] min2, byte[] max2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScore(key, min2, max2);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, double min2, double max2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScore(key, min2, max2, offset, count2);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, byte[] min2, byte[] max2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScore(key, min2, max2, offset, count2);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min2, double max2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScoreWithScores(key, min2, max2);
        return this.getTupledSet();
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min2, byte[] max2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScoreWithScores(key, min2, max2);
        return this.getTupledSet();
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min2, double max2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScoreWithScores(key, min2, max2, offset, count2);
        return this.getTupledSet();
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min2, byte[] max2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScoreWithScores(key, min2, max2, offset, count2);
        return this.getTupledSet();
    }

    protected Set<Tuple> getTupledSet() {
        List<byte[]> membersWithScores = this.client.getBinaryMultiBulkReply();
        if (membersWithScores.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<Tuple> set2 = new LinkedHashSet<Tuple>(membersWithScores.size() / 2, 1.0f);
        Iterator<byte[]> iterator2 = membersWithScores.iterator();
        while (iterator2.hasNext()) {
            set2.add(new Tuple(iterator2.next(), BuilderFactory.DOUBLE.build(iterator2.next())));
        }
        return set2;
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, double max2, double min2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScore(key, max2, min2);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max2, byte[] min2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScore(key, max2, min2);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, double max2, double min2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScore(key, max2, min2, offset, count2);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max2, byte[] min2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScore(key, max2, min2, offset, count2);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max2, double min2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScoreWithScores(key, max2, min2);
        return this.getTupledSet();
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max2, double min2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScoreWithScores(key, max2, min2, offset, count2);
        return this.getTupledSet();
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max2, byte[] min2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScoreWithScores(key, max2, min2);
        return this.getTupledSet();
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max2, byte[] min2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScoreWithScores(key, max2, min2, offset, count2);
        return this.getTupledSet();
    }

    @Override
    public Long zremrangeByRank(byte[] key, long start2, long stop) {
        this.checkIsInMultiOrPipeline();
        this.client.zremrangeByRank(key, start2, stop);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zremrangeByScore(byte[] key, double min2, double max2) {
        this.checkIsInMultiOrPipeline();
        this.client.zremrangeByScore(key, min2, max2);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zremrangeByScore(byte[] key, byte[] min2, byte[] max2) {
        this.checkIsInMultiOrPipeline();
        this.client.zremrangeByScore(key, min2, max2);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zunionstore(byte[] dstkey, byte[] ... sets) {
        this.checkIsInMultiOrPipeline();
        this.client.zunionstore(dstkey, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zunionstore(byte[] dstkey, ZParams params2, byte[] ... sets) {
        this.checkIsInMultiOrPipeline();
        this.client.zunionstore(dstkey, params2, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zinterstore(byte[] dstkey, byte[] ... sets) {
        this.checkIsInMultiOrPipeline();
        this.client.zinterstore(dstkey, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zinterstore(byte[] dstkey, ZParams params2, byte[] ... sets) {
        this.checkIsInMultiOrPipeline();
        this.client.zinterstore(dstkey, params2, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zlexcount(byte[] key, byte[] min2, byte[] max2) {
        this.checkIsInMultiOrPipeline();
        this.client.zlexcount(key, min2, max2);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<byte[]> zrangeByLex(byte[] key, byte[] min2, byte[] max2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByLex(key, min2, max2);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<byte[]> zrangeByLex(byte[] key, byte[] min2, byte[] max2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByLex(key, min2, max2, offset, count2);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<byte[]> zrevrangeByLex(byte[] key, byte[] max2, byte[] min2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByLex(key, max2, min2);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<byte[]> zrevrangeByLex(byte[] key, byte[] max2, byte[] min2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByLex(key, max2, min2, offset, count2);
        return SetFromList.of(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Long zremrangeByLex(byte[] key, byte[] min2, byte[] max2) {
        this.checkIsInMultiOrPipeline();
        this.client.zremrangeByLex(key, min2, max2);
        return this.client.getIntegerReply();
    }

    @Override
    public String save() {
        this.client.save();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String bgsave() {
        this.client.bgsave();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String bgrewriteaof() {
        this.client.bgrewriteaof();
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long lastsave() {
        this.client.lastsave();
        return this.client.getIntegerReply();
    }

    @Override
    public String shutdown() {
        String status;
        this.client.shutdown();
        try {
            status = this.client.getStatusCodeReply();
        }
        catch (JedisException ex) {
            status = null;
        }
        return status;
    }

    @Override
    public String info() {
        this.client.info();
        return this.client.getBulkReply();
    }

    @Override
    public String info(String section) {
        this.client.info(section);
        return this.client.getBulkReply();
    }

    public void monitor(JedisMonitor jedisMonitor) {
        this.client.monitor();
        this.client.getStatusCodeReply();
        jedisMonitor.proceed(this.client);
    }

    @Override
    public String slaveof(String host, int port) {
        this.client.slaveof(host, port);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String slaveofNoOne() {
        this.client.slaveofNoOne();
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<byte[]> configGet(byte[] pattern) {
        this.checkIsInMultiOrPipeline();
        this.client.configGet(pattern);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public String configResetStat() {
        this.checkIsInMultiOrPipeline();
        this.client.configResetStat();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String configRewrite() {
        this.checkIsInMultiOrPipeline();
        this.client.configRewrite();
        return this.client.getStatusCodeReply();
    }

    @Override
    public byte[] configSet(byte[] parameter, byte[] value2) {
        this.checkIsInMultiOrPipeline();
        this.client.configSet(parameter, value2);
        return this.client.getBinaryBulkReply();
    }

    public boolean isConnected() {
        return this.client.isConnected();
    }

    @Override
    public Long strlen(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.strlen(key);
        return this.client.getIntegerReply();
    }

    public void sync() {
        this.client.sync();
    }

    @Override
    public Long lpushx(byte[] key, byte[] ... string2) {
        this.checkIsInMultiOrPipeline();
        this.client.lpushx(key, string2);
        return this.client.getIntegerReply();
    }

    @Override
    public Long persist(byte[] key) {
        this.client.persist(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long rpushx(byte[] key, byte[] ... string2) {
        this.checkIsInMultiOrPipeline();
        this.client.rpushx(key, string2);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] echo(byte[] string2) {
        this.checkIsInMultiOrPipeline();
        this.client.echo(string2);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long linsert(byte[] key, ListPosition where, byte[] pivot, byte[] value2) {
        this.checkIsInMultiOrPipeline();
        this.client.linsert(key, where, pivot, value2);
        return this.client.getIntegerReply();
    }

    @Override
    public String debug(DebugParams params2) {
        this.client.debug(params2);
        return this.client.getStatusCodeReply();
    }

    public Client getClient() {
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] brpoplpush(byte[] source, byte[] destination, int timeout) {
        this.client.brpoplpush(source, destination, timeout);
        this.client.setTimeoutInfinite();
        try {
            byte[] byArray = this.client.getBinaryBulkReply();
            return byArray;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public Boolean setbit(byte[] key, long offset, boolean value2) {
        this.checkIsInMultiOrPipeline();
        this.client.setbit(key, offset, value2);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Boolean setbit(byte[] key, long offset, byte[] value2) {
        this.checkIsInMultiOrPipeline();
        this.client.setbit(key, offset, value2);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Boolean getbit(byte[] key, long offset) {
        this.checkIsInMultiOrPipeline();
        this.client.getbit(key, offset);
        return this.client.getIntegerReply() == 1L;
    }

    public Long bitpos(byte[] key, boolean value2) {
        return this.bitpos(key, value2, new BitPosParams());
    }

    public Long bitpos(byte[] key, boolean value2, BitPosParams params2) {
        this.checkIsInMultiOrPipeline();
        this.client.bitpos(key, value2, params2);
        return this.client.getIntegerReply();
    }

    @Override
    public Long setrange(byte[] key, long offset, byte[] value2) {
        this.checkIsInMultiOrPipeline();
        this.client.setrange(key, offset, value2);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] getrange(byte[] key, long startOffset, long endOffset) {
        this.checkIsInMultiOrPipeline();
        this.client.getrange(key, startOffset, endOffset);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long publish(byte[] channel, byte[] message) {
        this.checkIsInMultiOrPipeline();
        this.client.publish(channel, message);
        return this.client.getIntegerReply();
    }

    @Override
    public void subscribe(BinaryJedisPubSub jedisPubSub, byte[] ... channels) {
        this.client.setTimeoutInfinite();
        try {
            jedisPubSub.proceed(this.client, channels);
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public void psubscribe(BinaryJedisPubSub jedisPubSub, byte[] ... patterns2) {
        this.client.setTimeoutInfinite();
        try {
            jedisPubSub.proceedWithPatterns(this.client, patterns2);
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public int getDB() {
        return this.client.getDB();
    }

    @Override
    public Object eval(byte[] script, List<byte[]> keys, List<byte[]> args2) {
        return this.eval(script, Protocol.toByteArray(keys.size()), BinaryJedis.getParamsWithBinary(keys, args2));
    }

    protected static byte[][] getParamsWithBinary(List<byte[]> keys, List<byte[]> args2) {
        int i;
        int keyCount = keys.size();
        int argCount = args2.size();
        byte[][] params2 = new byte[keyCount + argCount][];
        for (i = 0; i < keyCount; ++i) {
            params2[i] = keys.get(i);
        }
        for (i = 0; i < argCount; ++i) {
            params2[keyCount + i] = args2.get(i);
        }
        return params2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object eval(byte[] script, byte[] keyCount, byte[] ... params2) {
        this.client.setTimeoutInfinite();
        try {
            this.client.eval(script, keyCount, params2);
            Object object = this.client.getOne();
            return object;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public Object eval(byte[] script, int keyCount, byte[] ... params2) {
        return this.eval(script, Protocol.toByteArray(keyCount), params2);
    }

    @Override
    public Object eval(byte[] script) {
        return this.eval(script, 0, (byte[][])new byte[0][]);
    }

    @Override
    public Object evalsha(byte[] sha1) {
        return this.evalsha(sha1, 0, new byte[0][]);
    }

    @Override
    public Object evalsha(byte[] sha1, List<byte[]> keys, List<byte[]> args2) {
        return this.evalsha(sha1, keys.size(), BinaryJedis.getParamsWithBinary(keys, args2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evalsha(byte[] sha1, int keyCount, byte[] ... params2) {
        this.client.setTimeoutInfinite();
        try {
            this.client.evalsha(sha1, keyCount, params2);
            Object object = this.client.getOne();
            return object;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public String scriptFlush() {
        this.client.scriptFlush();
        return this.client.getStatusCodeReply();
    }

    public Long scriptExists(byte[] sha1) {
        byte[][] a = new byte[][]{sha1};
        return this.scriptExists(a).get(0);
    }

    @Override
    public List<Long> scriptExists(byte[] ... sha1) {
        this.client.scriptExists(sha1);
        return this.client.getIntegerMultiBulkReply();
    }

    @Override
    public byte[] scriptLoad(byte[] script) {
        this.client.scriptLoad(script);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public String scriptKill() {
        this.client.scriptKill();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String slowlogReset() {
        this.client.slowlogReset();
        return this.client.getBulkReply();
    }

    @Override
    public Long slowlogLen() {
        this.client.slowlogLen();
        return this.client.getIntegerReply();
    }

    @Override
    public List<byte[]> slowlogGetBinary() {
        this.client.slowlogGet();
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public List<byte[]> slowlogGetBinary(long entries) {
        this.client.slowlogGet(entries);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public Long objectRefcount(byte[] key) {
        this.client.objectRefcount(key);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] objectEncoding(byte[] key) {
        this.client.objectEncoding(key);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long objectIdletime(byte[] key) {
        this.client.objectIdletime(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long bitcount(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.bitcount(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long bitcount(byte[] key, long start2, long end) {
        this.checkIsInMultiOrPipeline();
        this.client.bitcount(key, start2, end);
        return this.client.getIntegerReply();
    }

    @Override
    public Long bitop(BitOP op, byte[] destKey, byte[] ... srcKeys) {
        this.checkIsInMultiOrPipeline();
        this.client.bitop(op, destKey, srcKeys);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] dump(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.dump(key);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public String restore(byte[] key, int ttl, byte[] serializedValue) {
        this.checkIsInMultiOrPipeline();
        this.client.restore(key, ttl, serializedValue);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String restoreReplace(byte[] key, int ttl, byte[] serializedValue) {
        this.checkIsInMultiOrPipeline();
        this.client.restoreReplace(key, ttl, serializedValue);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long pexpire(byte[] key, long milliseconds) {
        this.checkIsInMultiOrPipeline();
        this.client.pexpire(key, milliseconds);
        return this.client.getIntegerReply();
    }

    @Override
    public Long pexpireAt(byte[] key, long millisecondsTimestamp) {
        this.checkIsInMultiOrPipeline();
        this.client.pexpireAt(key, millisecondsTimestamp);
        return this.client.getIntegerReply();
    }

    @Override
    public Long pttl(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.pttl(key);
        return this.client.getIntegerReply();
    }

    @Override
    public String psetex(byte[] key, long milliseconds, byte[] value2) {
        this.checkIsInMultiOrPipeline();
        this.client.psetex(key, milliseconds, value2);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clientKill(byte[] ipPort) {
        this.checkIsInMultiOrPipeline();
        this.client.clientKill(ipPort);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clientKill(String ip, int port) {
        this.checkIsInMultiOrPipeline();
        this.client.clientKill(ip, port);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long clientKill(ClientKillParams params2) {
        this.checkIsInMultiOrPipeline();
        this.client.clientKill(params2);
        return this.client.getIntegerReply();
    }

    @Override
    public byte[] clientGetnameBinary() {
        this.checkIsInMultiOrPipeline();
        this.client.clientGetname();
        return this.client.getBinaryBulkReply();
    }

    @Override
    public byte[] clientListBinary() {
        this.checkIsInMultiOrPipeline();
        this.client.clientList();
        return this.client.getBinaryBulkReply();
    }

    @Override
    public String clientSetname(byte[] name) {
        this.checkIsInMultiOrPipeline();
        this.client.clientSetname(name);
        return this.client.getBulkReply();
    }

    public String clientPause(long timeout) {
        this.checkIsInMultiOrPipeline();
        this.client.clientPause(timeout);
        return this.client.getBulkReply();
    }

    public List<String> time() {
        this.checkIsInMultiOrPipeline();
        this.client.time();
        return this.client.getMultiBulkReply();
    }

    @Override
    public String migrate(String host, int port, byte[] key, int destinationDb, int timeout) {
        this.checkIsInMultiOrPipeline();
        this.client.migrate(host, port, key, destinationDb, timeout);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String migrate(String host, int port, int destinationDB, int timeout, MigrateParams params2, byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.migrate(host, port, destinationDB, timeout, params2, keys);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long waitReplicas(int replicas, long timeout) {
        this.checkIsInMultiOrPipeline();
        this.client.waitReplicas(replicas, timeout);
        return this.client.getIntegerReply();
    }

    @Override
    public Long pfadd(byte[] key, byte[] ... elements2) {
        this.checkIsInMultiOrPipeline();
        this.client.pfadd(key, elements2);
        return this.client.getIntegerReply();
    }

    @Override
    public long pfcount(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.pfcount(key);
        return this.client.getIntegerReply();
    }

    @Override
    public String pfmerge(byte[] destkey, byte[] ... sourcekeys) {
        this.checkIsInMultiOrPipeline();
        this.client.pfmerge(destkey, sourcekeys);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long pfcount(byte[] ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.pfcount(keys);
        return this.client.getIntegerReply();
    }

    public ScanResult<byte[]> scan(byte[] cursor) {
        return this.scan(cursor, new ScanParams());
    }

    public ScanResult<byte[]> scan(byte[] cursor, ScanParams params2) {
        this.checkIsInMultiOrPipeline();
        this.client.scan(cursor, params2);
        List<Object> result2 = this.client.getObjectMultiBulkReply();
        byte[] newcursor = (byte[])result2.get(0);
        List rawResults = (List)result2.get(1);
        return new ScanResult<byte[]>(newcursor, rawResults);
    }

    @Override
    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] key, byte[] cursor) {
        return this.hscan(key, cursor, new ScanParams());
    }

    @Override
    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] key, byte[] cursor, ScanParams params2) {
        this.checkIsInMultiOrPipeline();
        this.client.hscan(key, cursor, params2);
        List<Object> result2 = this.client.getObjectMultiBulkReply();
        byte[] newcursor = (byte[])result2.get(0);
        ArrayList results = new ArrayList();
        List rawResults = (List)result2.get(1);
        Iterator iterator2 = rawResults.iterator();
        while (iterator2.hasNext()) {
            results.add(new AbstractMap.SimpleEntry(iterator2.next(), iterator2.next()));
        }
        return new ScanResult<Map.Entry<byte[], byte[]>>(newcursor, results);
    }

    @Override
    public ScanResult<byte[]> sscan(byte[] key, byte[] cursor) {
        return this.sscan(key, cursor, new ScanParams());
    }

    @Override
    public ScanResult<byte[]> sscan(byte[] key, byte[] cursor, ScanParams params2) {
        this.checkIsInMultiOrPipeline();
        this.client.sscan(key, cursor, params2);
        List<Object> result2 = this.client.getObjectMultiBulkReply();
        byte[] newcursor = (byte[])result2.get(0);
        List rawResults = (List)result2.get(1);
        return new ScanResult<byte[]>(newcursor, rawResults);
    }

    @Override
    public ScanResult<Tuple> zscan(byte[] key, byte[] cursor) {
        return this.zscan(key, cursor, new ScanParams());
    }

    @Override
    public ScanResult<Tuple> zscan(byte[] key, byte[] cursor, ScanParams params2) {
        this.checkIsInMultiOrPipeline();
        this.client.zscan(key, cursor, params2);
        List<Object> result2 = this.client.getObjectMultiBulkReply();
        byte[] newcursor = (byte[])result2.get(0);
        ArrayList<Tuple> results = new ArrayList<Tuple>();
        List rawResults = (List)result2.get(1);
        Iterator iterator2 = rawResults.iterator();
        while (iterator2.hasNext()) {
            results.add(new Tuple((byte[])iterator2.next(), BuilderFactory.DOUBLE.build(iterator2.next())));
        }
        return new ScanResult<Tuple>(newcursor, results);
    }

    @Override
    public Long geoadd(byte[] key, double longitude, double latitude, byte[] member) {
        this.checkIsInMultiOrPipeline();
        this.client.geoadd(key, longitude, latitude, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long geoadd(byte[] key, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        this.checkIsInMultiOrPipeline();
        this.client.geoadd(key, memberCoordinateMap);
        return this.client.getIntegerReply();
    }

    @Override
    public Double geodist(byte[] key, byte[] member1, byte[] member2) {
        this.checkIsInMultiOrPipeline();
        this.client.geodist(key, member1, member2);
        String dval = this.client.getBulkReply();
        return dval != null ? new Double(dval) : null;
    }

    @Override
    public Double geodist(byte[] key, byte[] member1, byte[] member2, GeoUnit unit2) {
        this.checkIsInMultiOrPipeline();
        this.client.geodist(key, member1, member2, unit2);
        String dval = this.client.getBulkReply();
        return dval != null ? new Double(dval) : null;
    }

    @Override
    public List<byte[]> geohash(byte[] key, byte[] ... members2) {
        this.checkIsInMultiOrPipeline();
        this.client.geohash(key, members2);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public List<GeoCoordinate> geopos(byte[] key, byte[] ... members2) {
        this.checkIsInMultiOrPipeline();
        this.client.geopos(key, members2);
        return BuilderFactory.GEO_COORDINATE_LIST.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit2) {
        this.checkIsInMultiOrPipeline();
        this.client.georadius(key, longitude, latitude, radius, unit2);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadiusReadonly(byte[] key, double longitude, double latitude, double radius, GeoUnit unit2) {
        this.checkIsInMultiOrPipeline();
        this.client.georadiusReadonly(key, longitude, latitude, radius, unit2);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit2, GeoRadiusParam param2) {
        this.checkIsInMultiOrPipeline();
        this.client.georadius(key, longitude, latitude, radius, unit2, param2);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadiusReadonly(byte[] key, double longitude, double latitude, double radius, GeoUnit unit2, GeoRadiusParam param2) {
        this.checkIsInMultiOrPipeline();
        this.client.georadiusReadonly(key, longitude, latitude, radius, unit2, param2);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit2) {
        this.checkIsInMultiOrPipeline();
        this.client.georadiusByMember(key, member, radius, unit2);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMemberReadonly(byte[] key, byte[] member, double radius, GeoUnit unit2) {
        this.checkIsInMultiOrPipeline();
        this.client.georadiusByMemberReadonly(key, member, radius, unit2);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit2, GeoRadiusParam param2) {
        this.checkIsInMultiOrPipeline();
        this.client.georadiusByMember(key, member, radius, unit2, param2);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMemberReadonly(byte[] key, byte[] member, double radius, GeoUnit unit2, GeoRadiusParam param2) {
        this.checkIsInMultiOrPipeline();
        this.client.georadiusByMemberReadonly(key, member, radius, unit2, param2);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<Long> bitfield(byte[] key, byte[] ... arguments) {
        this.checkIsInMultiOrPipeline();
        this.client.bitfield(key, arguments);
        return this.client.getIntegerMultiBulkReply();
    }

    @Override
    public Long hstrlen(byte[] key, byte[] field2) {
        this.checkIsInMultiOrPipeline();
        this.client.hstrlen(key, field2);
        return this.client.getIntegerReply();
    }

    @Override
    public List<byte[]> xread(int count2, long block, Map<byte[], byte[]> streams) {
        this.checkIsInMultiOrPipeline();
        this.client.xread(count2, block, streams);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public List<byte[]> xreadGroup(byte[] groupname, byte[] consumer, int count2, long block, boolean noAck, Map<byte[], byte[]> streams) {
        this.checkIsInMultiOrPipeline();
        this.client.xreadGroup(groupname, consumer, count2, block, noAck, streams);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public byte[] xadd(byte[] key, byte[] id, Map<byte[], byte[]> hash, long maxLen, boolean approximateLength) {
        this.checkIsInMultiOrPipeline();
        this.client.xadd(key, id, hash, maxLen, approximateLength);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public Long xlen(byte[] key) {
        this.checkIsInMultiOrPipeline();
        this.client.xlen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public List<byte[]> xrange(byte[] key, byte[] start2, byte[] end, long count2) {
        this.checkIsInMultiOrPipeline();
        this.client.xrange(key, start2, end, count2);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public List<byte[]> xrevrange(byte[] key, byte[] end, byte[] start2, int count2) {
        this.checkIsInMultiOrPipeline();
        this.client.xrevrange(key, end, start2, count2);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public Long xack(byte[] key, byte[] group2, byte[] ... ids) {
        this.checkIsInMultiOrPipeline();
        this.client.xack(key, group2, ids);
        return this.client.getIntegerReply();
    }

    @Override
    public String xgroupCreate(byte[] key, byte[] consumer, byte[] id, boolean makeStream) {
        this.checkIsInMultiOrPipeline();
        this.client.xgroupCreate(key, consumer, id, makeStream);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String xgroupSetID(byte[] key, byte[] consumer, byte[] id) {
        this.checkIsInMultiOrPipeline();
        this.client.xgroupSetID(key, consumer, id);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long xgroupDestroy(byte[] key, byte[] consumer) {
        this.checkIsInMultiOrPipeline();
        this.client.xgroupDestroy(key, consumer);
        return this.client.getIntegerReply();
    }

    @Override
    public String xgroupDelConsumer(byte[] key, byte[] consumer, byte[] consumerName) {
        this.checkIsInMultiOrPipeline();
        this.client.xgroupDelConsumer(key, consumer, consumerName);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long xdel(byte[] key, byte[] ... ids) {
        this.checkIsInMultiOrPipeline();
        this.client.xdel(key, ids);
        return this.client.getIntegerReply();
    }

    @Override
    public Long xtrim(byte[] key, long maxLen, boolean approximateLength) {
        this.checkIsInMultiOrPipeline();
        this.client.xtrim(key, maxLen, approximateLength);
        return this.client.getIntegerReply();
    }

    @Override
    public List<byte[]> xpending(byte[] key, byte[] groupname, byte[] start2, byte[] end, int count2, byte[] consumername) {
        this.checkIsInMultiOrPipeline();
        this.client.xpending(key, groupname, start2, end, count2, consumername);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public List<byte[]> xclaim(byte[] key, byte[] groupname, byte[] consumername, long minIdleTime, long newIdleTime, int retries, boolean force, byte[][] ids) {
        this.checkIsInMultiOrPipeline();
        this.client.xclaim(key, groupname, consumername, minIdleTime, newIdleTime, retries, force, ids);
        return this.client.getBinaryMultiBulkReply();
    }

    protected static class SetFromList<E>
    extends AbstractSet<E>
    implements Serializable {
        private static final long serialVersionUID = -2850347066962734052L;
        private final transient List<E> list;

        private SetFromList(List<E> list2) {
            if (list2 == null) {
                throw new NullPointerException("list");
            }
            this.list = list2;
        }

        @Override
        public void clear() {
            this.list.clear();
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.list.contains(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.list.remove(o);
        }

        @Override
        public boolean add(E e) {
            return !this.contains(e) && this.list.add(e);
        }

        @Override
        public Iterator<E> iterator() {
            return this.list.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.list.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.list.toArray(a);
        }

        @Override
        public String toString() {
            return this.list.toString();
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            if (c.size() != this.size()) {
                return false;
            }
            return this.containsAll(c);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.list.containsAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.list.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.list.retainAll(c);
        }

        protected static <E> SetFromList<E> of(List<E> list2) {
            return new SetFromList<E>(list2);
        }
    }
}

