/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.Connection;
import redis.clients.jedis.DebugParams;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.ListPosition;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.ZParams;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.params.ClientKillParams;
import redis.clients.jedis.params.GeoRadiusParam;
import redis.clients.jedis.params.MigrateParams;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.params.ZIncrByParams;
import redis.clients.jedis.util.SafeEncoder;

public class BinaryClient
extends Connection {
    private boolean isInMulti;
    private String password;
    private int db;
    private boolean isInWatch;

    public BinaryClient() {
    }

    public BinaryClient(String host) {
        super(host);
    }

    public BinaryClient(String host, int port) {
        super(host, port);
    }

    public BinaryClient(String host, int port, boolean ssl) {
        super(host, port, ssl);
    }

    public BinaryClient(String host, int port, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        super(host, port, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public boolean isInMulti() {
        return this.isInMulti;
    }

    public boolean isInWatch() {
        return this.isInWatch;
    }

    private byte[][] joinParameters(byte[] first, byte[][] rest2) {
        byte[][] result2 = new byte[rest2.length + 1][];
        result2[0] = first;
        System.arraycopy(rest2, 0, result2, 1, rest2.length);
        return result2;
    }

    private byte[][] joinParameters(byte[] first, byte[] second, byte[][] rest2) {
        byte[][] result2 = new byte[rest2.length + 2][];
        result2[0] = first;
        result2[1] = second;
        System.arraycopy(rest2, 0, result2, 2, rest2.length);
        return result2;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDb(int db) {
        this.db = db;
    }

    @Override
    public void connect() {
        if (!this.isConnected()) {
            super.connect();
            if (this.password != null) {
                this.auth(this.password);
                this.getStatusCodeReply();
            }
            if (this.db > 0) {
                this.select(this.db);
                this.getStatusCodeReply();
            }
        }
    }

    public void ping() {
        this.sendCommand(Protocol.Command.PING);
    }

    public void ping(byte[] message) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PING, new byte[][]{message});
    }

    public void set(byte[] key, byte[] value2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SET, key, value2);
    }

    public void set(byte[] key, byte[] value2, SetParams params2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SET, params2.getByteParams(key, value2));
    }

    public void get(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GET, new byte[][]{key});
    }

    public void quit() {
        this.db = 0;
        this.sendCommand(Protocol.Command.QUIT);
    }

    public void exists(byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.EXISTS, keys);
    }

    public void del(byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.DEL, keys);
    }

    public void unlink(byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.UNLINK, keys);
    }

    public void type(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.TYPE, new byte[][]{key});
    }

    public void flushDB() {
        this.sendCommand(Protocol.Command.FLUSHDB);
    }

    public void keys(byte[] pattern) {
        this.sendCommand((ProtocolCommand)Protocol.Command.KEYS, new byte[][]{pattern});
    }

    public void randomKey() {
        this.sendCommand(Protocol.Command.RANDOMKEY);
    }

    public void rename(byte[] oldkey, byte[] newkey) {
        this.sendCommand((ProtocolCommand)Protocol.Command.RENAME, oldkey, newkey);
    }

    public void renamenx(byte[] oldkey, byte[] newkey) {
        this.sendCommand((ProtocolCommand)Protocol.Command.RENAMENX, oldkey, newkey);
    }

    public void dbSize() {
        this.sendCommand(Protocol.Command.DBSIZE);
    }

    public void expire(byte[] key, int seconds) {
        this.sendCommand((ProtocolCommand)Protocol.Command.EXPIRE, key, Protocol.toByteArray(seconds));
    }

    public void expireAt(byte[] key, long unixTime) {
        this.sendCommand((ProtocolCommand)Protocol.Command.EXPIREAT, key, Protocol.toByteArray(unixTime));
    }

    public void ttl(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.TTL, new byte[][]{key});
    }

    public void touch(byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.TOUCH, keys);
    }

    public void select(int index2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SELECT, new byte[][]{Protocol.toByteArray(index2)});
    }

    public void swapDB(int index1, int index2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SWAPDB, Protocol.toByteArray(index1), Protocol.toByteArray(index2));
    }

    public void move(byte[] key, int dbIndex) {
        this.sendCommand((ProtocolCommand)Protocol.Command.MOVE, key, Protocol.toByteArray(dbIndex));
    }

    public void flushAll() {
        this.sendCommand(Protocol.Command.FLUSHALL);
    }

    public void getSet(byte[] key, byte[] value2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GETSET, key, value2);
    }

    public void mget(byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.MGET, keys);
    }

    public void setnx(byte[] key, byte[] value2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SETNX, key, value2);
    }

    public void setex(byte[] key, int seconds, byte[] value2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SETEX, key, Protocol.toByteArray(seconds), value2);
    }

    public void mset(byte[] ... keysvalues) {
        this.sendCommand((ProtocolCommand)Protocol.Command.MSET, keysvalues);
    }

    public void msetnx(byte[] ... keysvalues) {
        this.sendCommand((ProtocolCommand)Protocol.Command.MSETNX, keysvalues);
    }

    public void decrBy(byte[] key, long decrement) {
        this.sendCommand((ProtocolCommand)Protocol.Command.DECRBY, key, Protocol.toByteArray(decrement));
    }

    public void decr(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.DECR, new byte[][]{key});
    }

    public void incrBy(byte[] key, long increment) {
        this.sendCommand((ProtocolCommand)Protocol.Command.INCRBY, key, Protocol.toByteArray(increment));
    }

    public void incrByFloat(byte[] key, double increment) {
        this.sendCommand((ProtocolCommand)Protocol.Command.INCRBYFLOAT, key, Protocol.toByteArray(increment));
    }

    public void incr(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.INCR, new byte[][]{key});
    }

    public void append(byte[] key, byte[] value2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.APPEND, key, value2);
    }

    public void substr(byte[] key, int start2, int end) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SUBSTR, key, Protocol.toByteArray(start2), Protocol.toByteArray(end));
    }

    public void hset(byte[] key, byte[] field2, byte[] value2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HSET, key, field2, value2);
    }

    public void hset(byte[] key, Map<byte[], byte[]> hash) {
        byte[][] params2 = new byte[1 + hash.size() * 2][];
        int index2 = 0;
        params2[index2++] = key;
        for (Map.Entry<byte[], byte[]> entry2 : hash.entrySet()) {
            params2[index2++] = entry2.getKey();
            params2[index2++] = entry2.getValue();
        }
        this.sendCommand((ProtocolCommand)Protocol.Command.HSET, params2);
    }

    public void hget(byte[] key, byte[] field2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HGET, key, field2);
    }

    public void hsetnx(byte[] key, byte[] field2, byte[] value2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HSETNX, key, field2, value2);
    }

    public void hmset(byte[] key, Map<byte[], byte[]> hash) {
        ArrayList<byte[]> params2 = new ArrayList<byte[]>();
        params2.add(key);
        for (Map.Entry<byte[], byte[]> entry2 : hash.entrySet()) {
            params2.add(entry2.getKey());
            params2.add(entry2.getValue());
        }
        this.sendCommand((ProtocolCommand)Protocol.Command.HMSET, (byte[][])params2.toArray((T[])new byte[params2.size()][]));
    }

    public void hmget(byte[] key, byte[] ... fields) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HMGET, this.joinParameters(key, fields));
    }

    public void hincrBy(byte[] key, byte[] field2, long value2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HINCRBY, key, field2, Protocol.toByteArray(value2));
    }

    public void hexists(byte[] key, byte[] field2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HEXISTS, key, field2);
    }

    public void hdel(byte[] key, byte[] ... fields) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HDEL, this.joinParameters(key, fields));
    }

    public void hlen(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HLEN, new byte[][]{key});
    }

    public void hkeys(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HKEYS, new byte[][]{key});
    }

    public void hvals(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HVALS, new byte[][]{key});
    }

    public void hgetAll(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HGETALL, new byte[][]{key});
    }

    public void rpush(byte[] key, byte[] ... strings) {
        this.sendCommand((ProtocolCommand)Protocol.Command.RPUSH, this.joinParameters(key, strings));
    }

    public void lpush(byte[] key, byte[] ... strings) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LPUSH, this.joinParameters(key, strings));
    }

    public void llen(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LLEN, new byte[][]{key});
    }

    public void lrange(byte[] key, long start2, long stop) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LRANGE, key, Protocol.toByteArray(start2), Protocol.toByteArray(stop));
    }

    public void ltrim(byte[] key, long start2, long stop) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LTRIM, key, Protocol.toByteArray(start2), Protocol.toByteArray(stop));
    }

    public void lindex(byte[] key, long index2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LINDEX, key, Protocol.toByteArray(index2));
    }

    public void lset(byte[] key, long index2, byte[] value2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LSET, key, Protocol.toByteArray(index2), value2);
    }

    public void lrem(byte[] key, long count2, byte[] value2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LREM, key, Protocol.toByteArray(count2), value2);
    }

    public void lpop(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LPOP, new byte[][]{key});
    }

    public void rpop(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.RPOP, new byte[][]{key});
    }

    public void rpoplpush(byte[] srckey, byte[] dstkey) {
        this.sendCommand((ProtocolCommand)Protocol.Command.RPOPLPUSH, srckey, dstkey);
    }

    public void sadd(byte[] key, byte[] ... members2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SADD, this.joinParameters(key, members2));
    }

    public void smembers(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SMEMBERS, new byte[][]{key});
    }

    public void srem(byte[] key, byte[] ... members2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SREM, this.joinParameters(key, members2));
    }

    public void spop(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SPOP, new byte[][]{key});
    }

    public void spop(byte[] key, long count2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SPOP, key, Protocol.toByteArray(count2));
    }

    public void smove(byte[] srckey, byte[] dstkey, byte[] member) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SMOVE, srckey, dstkey, member);
    }

    public void scard(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SCARD, new byte[][]{key});
    }

    public void sismember(byte[] key, byte[] member) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SISMEMBER, key, member);
    }

    public void sinter(byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SINTER, keys);
    }

    public void sinterstore(byte[] dstkey, byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SINTERSTORE, this.joinParameters(dstkey, keys));
    }

    public void sunion(byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SUNION, keys);
    }

    public void sunionstore(byte[] dstkey, byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SUNIONSTORE, this.joinParameters(dstkey, keys));
    }

    public void sdiff(byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SDIFF, keys);
    }

    public void sdiffstore(byte[] dstkey, byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SDIFFSTORE, this.joinParameters(dstkey, keys));
    }

    public void srandmember(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SRANDMEMBER, new byte[][]{key});
    }

    public void zadd(byte[] key, double score, byte[] member) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZADD, key, Protocol.toByteArray(score), member);
    }

    public void zadd(byte[] key, double score, byte[] member, ZAddParams params2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZADD, params2.getByteParams(key, Protocol.toByteArray(score), member));
    }

    public void zadd(byte[] key, Map<byte[], Double> scoreMembers) {
        ArrayList<byte[]> args2 = new ArrayList<byte[]>(scoreMembers.size() * 2 + 1);
        args2.add(key);
        args2.addAll(this.convertScoreMembersToByteArrays(scoreMembers));
        byte[][] argsArray = new byte[args2.size()][];
        args2.toArray((T[])argsArray);
        this.sendCommand((ProtocolCommand)Protocol.Command.ZADD, argsArray);
    }

    public void zadd(byte[] key, Map<byte[], Double> scoreMembers, ZAddParams params2) {
        ArrayList<byte[]> args2 = this.convertScoreMembersToByteArrays(scoreMembers);
        byte[][] argsArray = new byte[args2.size()][];
        args2.toArray((T[])argsArray);
        this.sendCommand((ProtocolCommand)Protocol.Command.ZADD, params2.getByteParams(key, argsArray));
    }

    public void zrange(byte[] key, long start2, long stop) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGE, key, Protocol.toByteArray(start2), Protocol.toByteArray(stop));
    }

    public void zrem(byte[] key, byte[] ... members2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREM, this.joinParameters(key, members2));
    }

    public void zincrby(byte[] key, double increment, byte[] member) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZINCRBY, key, Protocol.toByteArray(increment), member);
    }

    public void zincrby(byte[] key, double increment, byte[] member, ZIncrByParams params2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZADD, params2.getByteParams(key, Protocol.toByteArray(increment), member));
    }

    public void zrank(byte[] key, byte[] member) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANK, key, member);
    }

    public void zrevrank(byte[] key, byte[] member) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANK, key, member);
    }

    public void zrevrange(byte[] key, long start2, long stop) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGE, key, Protocol.toByteArray(start2), Protocol.toByteArray(stop));
    }

    public void zrangeWithScores(byte[] key, long start2, long stop) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGE, key, Protocol.toByteArray(start2), Protocol.toByteArray(stop), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrevrangeWithScores(byte[] key, long start2, long stop) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGE, key, Protocol.toByteArray(start2), Protocol.toByteArray(stop), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zcard(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZCARD, new byte[][]{key});
    }

    public void zscore(byte[] key, byte[] member) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZSCORE, key, member);
    }

    public void multi() {
        this.sendCommand(Protocol.Command.MULTI);
        this.isInMulti = true;
    }

    public void discard() {
        this.sendCommand(Protocol.Command.DISCARD);
        this.isInMulti = false;
        this.isInWatch = false;
    }

    public void exec() {
        this.sendCommand(Protocol.Command.EXEC);
        this.isInMulti = false;
        this.isInWatch = false;
    }

    public void watch(byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.WATCH, keys);
        this.isInWatch = true;
    }

    public void unwatch() {
        this.sendCommand(Protocol.Command.UNWATCH);
        this.isInWatch = false;
    }

    public void sort(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SORT, new byte[][]{key});
    }

    public void sort(byte[] key, SortingParams sortingParameters) {
        ArrayList<byte[]> args2 = new ArrayList<byte[]>();
        args2.add(key);
        args2.addAll(sortingParameters.getParams());
        this.sendCommand((ProtocolCommand)Protocol.Command.SORT, (byte[][])args2.toArray((T[])new byte[args2.size()][]));
    }

    public void blpop(byte[][] args2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.BLPOP, args2);
    }

    public void blpop(int timeout, byte[] ... keys) {
        ArrayList<byte[]> args2 = new ArrayList<byte[]>();
        for (byte[] arg : keys) {
            args2.add(arg);
        }
        args2.add(Protocol.toByteArray(timeout));
        this.blpop((byte[][])args2.toArray((T[])new byte[args2.size()][]));
    }

    public void sort(byte[] key, SortingParams sortingParameters, byte[] dstkey) {
        ArrayList<byte[]> args2 = new ArrayList<byte[]>();
        args2.add(key);
        args2.addAll(sortingParameters.getParams());
        args2.add(Protocol.Keyword.STORE.raw);
        args2.add(dstkey);
        this.sendCommand((ProtocolCommand)Protocol.Command.SORT, (byte[][])args2.toArray((T[])new byte[args2.size()][]));
    }

    public void sort(byte[] key, byte[] dstkey) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SORT, key, Protocol.Keyword.STORE.raw, dstkey);
    }

    public void brpop(byte[][] args2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.BRPOP, args2);
    }

    public void brpop(int timeout, byte[] ... keys) {
        ArrayList<byte[]> args2 = new ArrayList<byte[]>();
        for (byte[] arg : keys) {
            args2.add(arg);
        }
        args2.add(Protocol.toByteArray(timeout));
        this.brpop((byte[][])args2.toArray((T[])new byte[args2.size()][]));
    }

    public void auth(String password) {
        this.setPassword(password);
        this.sendCommand((ProtocolCommand)Protocol.Command.AUTH, password);
    }

    public void subscribe(byte[] ... channels) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SUBSCRIBE, channels);
    }

    public void publish(byte[] channel, byte[] message) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PUBLISH, channel, message);
    }

    public void unsubscribe() {
        this.sendCommand(Protocol.Command.UNSUBSCRIBE);
    }

    public void unsubscribe(byte[] ... channels) {
        this.sendCommand((ProtocolCommand)Protocol.Command.UNSUBSCRIBE, channels);
    }

    public void psubscribe(byte[] ... patterns2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PSUBSCRIBE, patterns2);
    }

    public void punsubscribe() {
        this.sendCommand(Protocol.Command.PUNSUBSCRIBE);
    }

    public void punsubscribe(byte[] ... patterns2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PUNSUBSCRIBE, patterns2);
    }

    public void pubsub(byte[] ... args2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PUBSUB, args2);
    }

    public void zcount(byte[] key, double min2, double max2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZCOUNT, key, Protocol.toByteArray(min2), Protocol.toByteArray(max2));
    }

    public void zcount(byte[] key, byte[] min2, byte[] max2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZCOUNT, key, min2, max2);
    }

    public void zrangeByScore(byte[] key, double min2, double max2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYSCORE, key, Protocol.toByteArray(min2), Protocol.toByteArray(max2));
    }

    public void zrangeByScore(byte[] key, byte[] min2, byte[] max2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYSCORE, key, min2, max2);
    }

    public void zrevrangeByScore(byte[] key, double max2, double min2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYSCORE, key, Protocol.toByteArray(max2), Protocol.toByteArray(min2));
    }

    public void zrevrangeByScore(byte[] key, byte[] max2, byte[] min2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYSCORE, key, max2, min2);
    }

    public void zrangeByScore(byte[] key, double min2, double max2, int offset, int count2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYSCORE, key, Protocol.toByteArray(min2), Protocol.toByteArray(max2), Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count2));
    }

    public void zrevrangeByScore(byte[] key, double max2, double min2, int offset, int count2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYSCORE, key, Protocol.toByteArray(max2), Protocol.toByteArray(min2), Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count2));
    }

    public void zrangeByScoreWithScores(byte[] key, double min2, double max2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYSCORE, key, Protocol.toByteArray(min2), Protocol.toByteArray(max2), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrevrangeByScoreWithScores(byte[] key, double max2, double min2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYSCORE, key, Protocol.toByteArray(max2), Protocol.toByteArray(min2), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrangeByScoreWithScores(byte[] key, double min2, double max2, int offset, int count2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYSCORE, key, Protocol.toByteArray(min2), Protocol.toByteArray(max2), Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count2), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrevrangeByScoreWithScores(byte[] key, double max2, double min2, int offset, int count2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYSCORE, key, Protocol.toByteArray(max2), Protocol.toByteArray(min2), Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count2), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrangeByScore(byte[] key, byte[] min2, byte[] max2, int offset, int count2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYSCORE, key, min2, max2, Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count2));
    }

    public void zrevrangeByScore(byte[] key, byte[] max2, byte[] min2, int offset, int count2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYSCORE, key, max2, min2, Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count2));
    }

    public void zrangeByScoreWithScores(byte[] key, byte[] min2, byte[] max2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYSCORE, key, min2, max2, Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrevrangeByScoreWithScores(byte[] key, byte[] max2, byte[] min2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYSCORE, key, max2, min2, Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrangeByScoreWithScores(byte[] key, byte[] min2, byte[] max2, int offset, int count2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYSCORE, key, min2, max2, Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count2), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zrevrangeByScoreWithScores(byte[] key, byte[] max2, byte[] min2, int offset, int count2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYSCORE, key, max2, min2, Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count2), Protocol.Keyword.WITHSCORES.raw);
    }

    public void zremrangeByRank(byte[] key, long start2, long stop) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREMRANGEBYRANK, key, Protocol.toByteArray(start2), Protocol.toByteArray(stop));
    }

    public void zremrangeByScore(byte[] key, double min2, double max2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREMRANGEBYSCORE, key, Protocol.toByteArray(min2), Protocol.toByteArray(max2));
    }

    public void zremrangeByScore(byte[] key, byte[] min2, byte[] max2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREMRANGEBYSCORE, key, min2, max2);
    }

    public void zunionstore(byte[] dstkey, byte[] ... sets) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZUNIONSTORE, this.joinParameters(dstkey, Protocol.toByteArray(sets.length), sets));
    }

    public void zunionstore(byte[] dstkey, ZParams params2, byte[] ... sets) {
        ArrayList<byte[]> args2 = new ArrayList<byte[]>();
        args2.add(dstkey);
        args2.add(Protocol.toByteArray(sets.length));
        for (byte[] set2 : sets) {
            args2.add(set2);
        }
        args2.addAll(params2.getParams());
        this.sendCommand((ProtocolCommand)Protocol.Command.ZUNIONSTORE, (byte[][])args2.toArray((T[])new byte[args2.size()][]));
    }

    public void zinterstore(byte[] dstkey, byte[] ... sets) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZINTERSTORE, this.joinParameters(dstkey, Protocol.toByteArray(sets.length), sets));
    }

    public void zinterstore(byte[] dstkey, ZParams params2, byte[] ... sets) {
        ArrayList<byte[]> args2 = new ArrayList<byte[]>();
        args2.add(dstkey);
        args2.add(Protocol.toByteArray(sets.length));
        for (byte[] set2 : sets) {
            args2.add(set2);
        }
        args2.addAll(params2.getParams());
        this.sendCommand((ProtocolCommand)Protocol.Command.ZINTERSTORE, (byte[][])args2.toArray((T[])new byte[args2.size()][]));
    }

    public void zlexcount(byte[] key, byte[] min2, byte[] max2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZLEXCOUNT, key, min2, max2);
    }

    public void zrangeByLex(byte[] key, byte[] min2, byte[] max2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYLEX, key, min2, max2);
    }

    public void zrangeByLex(byte[] key, byte[] min2, byte[] max2, int offset, int count2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYLEX, key, min2, max2, Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count2));
    }

    public void zrevrangeByLex(byte[] key, byte[] max2, byte[] min2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYLEX, key, max2, min2);
    }

    public void zrevrangeByLex(byte[] key, byte[] max2, byte[] min2, int offset, int count2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYLEX, key, max2, min2, Protocol.Keyword.LIMIT.raw, Protocol.toByteArray(offset), Protocol.toByteArray(count2));
    }

    public void zremrangeByLex(byte[] key, byte[] min2, byte[] max2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREMRANGEBYLEX, key, min2, max2);
    }

    public void save() {
        this.sendCommand(Protocol.Command.SAVE);
    }

    public void bgsave() {
        this.sendCommand(Protocol.Command.BGSAVE);
    }

    public void bgrewriteaof() {
        this.sendCommand(Protocol.Command.BGREWRITEAOF);
    }

    public void lastsave() {
        this.sendCommand(Protocol.Command.LASTSAVE);
    }

    public void shutdown() {
        this.sendCommand(Protocol.Command.SHUTDOWN);
    }

    public void info() {
        this.sendCommand(Protocol.Command.INFO);
    }

    public void info(String section) {
        this.sendCommand((ProtocolCommand)Protocol.Command.INFO, section);
    }

    public void monitor() {
        this.sendCommand(Protocol.Command.MONITOR);
    }

    public void slaveof(String host, int port) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SLAVEOF, host, String.valueOf(port));
    }

    public void slaveofNoOne() {
        this.sendCommand((ProtocolCommand)Protocol.Command.SLAVEOF, Protocol.Keyword.NO.raw, Protocol.Keyword.ONE.raw);
    }

    public void configGet(byte[] pattern) {
        this.sendCommand((ProtocolCommand)Protocol.Command.CONFIG, Protocol.Keyword.GET.raw, pattern);
    }

    public void configSet(byte[] parameter, byte[] value2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.CONFIG, Protocol.Keyword.SET.raw, parameter, value2);
    }

    public void strlen(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.STRLEN, new byte[][]{key});
    }

    public void sync() {
        this.sendCommand(Protocol.Command.SYNC);
    }

    public void lpushx(byte[] key, byte[] ... string2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LPUSHX, this.joinParameters(key, string2));
    }

    public void persist(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PERSIST, new byte[][]{key});
    }

    public void rpushx(byte[] key, byte[] ... string2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.RPUSHX, this.joinParameters(key, string2));
    }

    public void echo(byte[] string2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ECHO, new byte[][]{string2});
    }

    public void linsert(byte[] key, ListPosition where, byte[] pivot, byte[] value2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LINSERT, key, where.raw, pivot, value2);
    }

    public void debug(DebugParams params2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.DEBUG, params2.getCommand());
    }

    public void brpoplpush(byte[] source, byte[] destination, int timeout) {
        this.sendCommand((ProtocolCommand)Protocol.Command.BRPOPLPUSH, source, destination, Protocol.toByteArray(timeout));
    }

    public void configResetStat() {
        this.sendCommand((ProtocolCommand)Protocol.Command.CONFIG, new byte[][]{Protocol.Keyword.RESETSTAT.raw});
    }

    public void configRewrite() {
        this.sendCommand((ProtocolCommand)Protocol.Command.CONFIG, new byte[][]{Protocol.Keyword.REWRITE.raw});
    }

    public void setbit(byte[] key, long offset, byte[] value2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SETBIT, key, Protocol.toByteArray(offset), value2);
    }

    public void setbit(byte[] key, long offset, boolean value2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SETBIT, key, Protocol.toByteArray(offset), Protocol.toByteArray(value2));
    }

    public void getbit(byte[] key, long offset) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GETBIT, key, Protocol.toByteArray(offset));
    }

    public void bitpos(byte[] key, boolean value2, BitPosParams params2) {
        ArrayList<byte[]> args2 = new ArrayList<byte[]>();
        args2.add(key);
        args2.add(Protocol.toByteArray(value2));
        args2.addAll(params2.getParams());
        this.sendCommand((ProtocolCommand)Protocol.Command.BITPOS, (byte[][])args2.toArray((T[])new byte[args2.size()][]));
    }

    public void setrange(byte[] key, long offset, byte[] value2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SETRANGE, key, Protocol.toByteArray(offset), value2);
    }

    public void getrange(byte[] key, long startOffset, long endOffset) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GETRANGE, key, Protocol.toByteArray(startOffset), Protocol.toByteArray(endOffset));
    }

    public int getDB() {
        return this.db;
    }

    @Override
    public void disconnect() {
        this.db = 0;
        super.disconnect();
    }

    @Override
    public void close() {
        this.db = 0;
        super.close();
    }

    public void resetState() {
        if (this.isInWatch()) {
            this.unwatch();
            this.getStatusCodeReply();
        }
    }

    public void eval(byte[] script, byte[] keyCount, byte[][] params2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.EVAL, this.joinParameters(script, keyCount, params2));
    }

    public void eval(byte[] script, int keyCount, byte[] ... params2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.EVAL, this.joinParameters(script, Protocol.toByteArray(keyCount), params2));
    }

    public void evalsha(byte[] sha1, byte[] keyCount, byte[] ... params2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.EVALSHA, this.joinParameters(sha1, keyCount, params2));
    }

    public void evalsha(byte[] sha1, int keyCount, byte[] ... params2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.EVALSHA, this.joinParameters(sha1, Protocol.toByteArray(keyCount), params2));
    }

    public void scriptFlush() {
        this.sendCommand((ProtocolCommand)Protocol.Command.SCRIPT, new byte[][]{Protocol.Keyword.FLUSH.raw});
    }

    public void scriptExists(byte[] ... sha1) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SCRIPT, this.joinParameters(Protocol.Keyword.EXISTS.raw, sha1));
    }

    public void scriptLoad(byte[] script) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SCRIPT, Protocol.Keyword.LOAD.raw, script);
    }

    public void scriptKill() {
        this.sendCommand((ProtocolCommand)Protocol.Command.SCRIPT, new byte[][]{Protocol.Keyword.KILL.raw});
    }

    public void slowlogGet() {
        this.sendCommand((ProtocolCommand)Protocol.Command.SLOWLOG, new byte[][]{Protocol.Keyword.GET.raw});
    }

    public void slowlogGet(long entries) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SLOWLOG, Protocol.Keyword.GET.raw, Protocol.toByteArray(entries));
    }

    public void slowlogReset() {
        this.sendCommand((ProtocolCommand)Protocol.Command.SLOWLOG, new byte[][]{Protocol.Keyword.RESET.raw});
    }

    public void slowlogLen() {
        this.sendCommand((ProtocolCommand)Protocol.Command.SLOWLOG, new byte[][]{Protocol.Keyword.LEN.raw});
    }

    public void objectRefcount(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.OBJECT, Protocol.Keyword.REFCOUNT.raw, key);
    }

    public void objectIdletime(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.OBJECT, Protocol.Keyword.IDLETIME.raw, key);
    }

    public void objectEncoding(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.OBJECT, Protocol.Keyword.ENCODING.raw, key);
    }

    public void bitcount(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.BITCOUNT, new byte[][]{key});
    }

    public void bitcount(byte[] key, long start2, long end) {
        this.sendCommand((ProtocolCommand)Protocol.Command.BITCOUNT, key, Protocol.toByteArray(start2), Protocol.toByteArray(end));
    }

    public void bitop(BitOP op, byte[] destKey, byte[] ... srcKeys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.BITOP, this.joinParameters(op.raw, destKey, srcKeys));
    }

    public void sentinel(byte[] ... args2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, args2);
    }

    public void dump(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.DUMP, new byte[][]{key});
    }

    public void restore(byte[] key, int ttl, byte[] serializedValue) {
        this.sendCommand((ProtocolCommand)Protocol.Command.RESTORE, key, Protocol.toByteArray(ttl), serializedValue);
    }

    public void restoreReplace(byte[] key, int ttl, byte[] serializedValue) {
        this.sendCommand((ProtocolCommand)Protocol.Command.RESTORE, key, Protocol.toByteArray(ttl), serializedValue, Protocol.Keyword.REPLACE.raw);
    }

    public void pexpire(byte[] key, long milliseconds) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PEXPIRE, key, Protocol.toByteArray(milliseconds));
    }

    public void pexpireAt(byte[] key, long millisecondsTimestamp) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PEXPIREAT, key, Protocol.toByteArray(millisecondsTimestamp));
    }

    public void pttl(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PTTL, new byte[][]{key});
    }

    public void psetex(byte[] key, long milliseconds, byte[] value2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PSETEX, key, Protocol.toByteArray(milliseconds), value2);
    }

    public void srandmember(byte[] key, int count2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SRANDMEMBER, key, Protocol.toByteArray(count2));
    }

    public void clientKill(byte[] ipPort) {
        this.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.KILL.raw, ipPort);
    }

    public void clientKill(String ip, int port) {
        this.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.KILL.name(), ip + ':' + port);
    }

    public void clientKill(ClientKillParams params2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, this.joinParameters(Protocol.Keyword.KILL.raw, params2.getByteParams()));
    }

    public void clientGetname() {
        this.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, new byte[][]{Protocol.Keyword.GETNAME.raw});
    }

    public void clientList() {
        this.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, new byte[][]{Protocol.Keyword.LIST.raw});
    }

    public void clientSetname(byte[] name) {
        this.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.SETNAME.raw, name);
    }

    public void clientPause(long timeout) {
        this.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.PAUSE.raw, Protocol.toByteArray(timeout));
    }

    public void time() {
        this.sendCommand(Protocol.Command.TIME);
    }

    public void migrate(String host, int port, byte[] key, int destinationDb, int timeout) {
        this.sendCommand((ProtocolCommand)Protocol.Command.MIGRATE, SafeEncoder.encode(host), Protocol.toByteArray(port), key, Protocol.toByteArray(destinationDb), Protocol.toByteArray(timeout));
    }

    public void migrate(String host, int port, int destinationDB, int timeout, MigrateParams params2, byte[] ... keys) {
        byte[][] bparams = params2.getByteParams();
        int len = 5 + bparams.length + 1 + keys.length;
        byte[][] args2 = new byte[len][];
        int i = 0;
        args2[i++] = SafeEncoder.encode(host);
        args2[i++] = Protocol.toByteArray(port);
        args2[i++] = new byte[0];
        args2[i++] = Protocol.toByteArray(destinationDB);
        args2[i++] = Protocol.toByteArray(timeout);
        System.arraycopy(bparams, 0, args2, i, bparams.length);
        i += bparams.length;
        args2[i++] = Protocol.Keyword.KEYS.raw;
        System.arraycopy(keys, 0, args2, i, keys.length);
        this.sendCommand((ProtocolCommand)Protocol.Command.MIGRATE, args2);
    }

    public void hincrByFloat(byte[] key, byte[] field2, double increment) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HINCRBYFLOAT, key, field2, Protocol.toByteArray(increment));
    }

    public void scan(byte[] cursor, ScanParams params2) {
        ArrayList<byte[]> args2 = new ArrayList<byte[]>();
        args2.add(cursor);
        args2.addAll(params2.getParams());
        this.sendCommand((ProtocolCommand)Protocol.Command.SCAN, (byte[][])args2.toArray((T[])new byte[args2.size()][]));
    }

    public void hscan(byte[] key, byte[] cursor, ScanParams params2) {
        ArrayList<byte[]> args2 = new ArrayList<byte[]>();
        args2.add(key);
        args2.add(cursor);
        args2.addAll(params2.getParams());
        this.sendCommand((ProtocolCommand)Protocol.Command.HSCAN, (byte[][])args2.toArray((T[])new byte[args2.size()][]));
    }

    public void sscan(byte[] key, byte[] cursor, ScanParams params2) {
        ArrayList<byte[]> args2 = new ArrayList<byte[]>();
        args2.add(key);
        args2.add(cursor);
        args2.addAll(params2.getParams());
        this.sendCommand((ProtocolCommand)Protocol.Command.SSCAN, (byte[][])args2.toArray((T[])new byte[args2.size()][]));
    }

    public void zscan(byte[] key, byte[] cursor, ScanParams params2) {
        ArrayList<byte[]> args2 = new ArrayList<byte[]>();
        args2.add(key);
        args2.add(cursor);
        args2.addAll(params2.getParams());
        this.sendCommand((ProtocolCommand)Protocol.Command.ZSCAN, (byte[][])args2.toArray((T[])new byte[args2.size()][]));
    }

    public void waitReplicas(int replicas, long timeout) {
        this.sendCommand((ProtocolCommand)Protocol.Command.WAIT, Protocol.toByteArray(replicas), Protocol.toByteArray(timeout));
    }

    public void cluster(byte[] ... args2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, args2);
    }

    public void asking() {
        this.sendCommand(Protocol.Command.ASKING);
    }

    public void pfadd(byte[] key, byte[] ... elements2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PFADD, this.joinParameters(key, elements2));
    }

    public void pfcount(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PFCOUNT, new byte[][]{key});
    }

    public void pfcount(byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PFCOUNT, keys);
    }

    public void pfmerge(byte[] destkey, byte[] ... sourcekeys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PFMERGE, this.joinParameters(destkey, sourcekeys));
    }

    public void readonly() {
        this.sendCommand(Protocol.Command.READONLY);
    }

    public void geoadd(byte[] key, double longitude, double latitude, byte[] member) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEOADD, key, Protocol.toByteArray(longitude), Protocol.toByteArray(latitude), member);
    }

    public void geoadd(byte[] key, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        ArrayList<byte[]> args2 = new ArrayList<byte[]>(memberCoordinateMap.size() * 3 + 1);
        args2.add(key);
        args2.addAll(this.convertGeoCoordinateMapToByteArrays(memberCoordinateMap));
        byte[][] argsArray = new byte[args2.size()][];
        args2.toArray((T[])argsArray);
        this.sendCommand((ProtocolCommand)Protocol.Command.GEOADD, argsArray);
    }

    public void geodist(byte[] key, byte[] member1, byte[] member2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEODIST, key, member1, member2);
    }

    public void geodist(byte[] key, byte[] member1, byte[] member2, GeoUnit unit2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEODIST, key, member1, member2, unit2.raw);
    }

    public void geohash(byte[] key, byte[] ... members2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEOHASH, this.joinParameters(key, members2));
    }

    public void geopos(byte[] key, byte[][] members2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEOPOS, this.joinParameters(key, members2));
    }

    public void georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEORADIUS, key, Protocol.toByteArray(longitude), Protocol.toByteArray(latitude), Protocol.toByteArray(radius), unit2.raw);
    }

    public void georadiusReadonly(byte[] key, double longitude, double latitude, double radius, GeoUnit unit2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEORADIUS_RO, key, Protocol.toByteArray(longitude), Protocol.toByteArray(latitude), Protocol.toByteArray(radius), unit2.raw);
    }

    public void georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit2, GeoRadiusParam param2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEORADIUS, param2.getByteParams(key, Protocol.toByteArray(longitude), Protocol.toByteArray(latitude), Protocol.toByteArray(radius), unit2.raw));
    }

    public void georadiusReadonly(byte[] key, double longitude, double latitude, double radius, GeoUnit unit2, GeoRadiusParam param2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEORADIUS_RO, param2.getByteParams(key, Protocol.toByteArray(longitude), Protocol.toByteArray(latitude), Protocol.toByteArray(radius), unit2.raw));
    }

    public void georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEORADIUSBYMEMBER, key, member, Protocol.toByteArray(radius), unit2.raw);
    }

    public void georadiusByMemberReadonly(byte[] key, byte[] member, double radius, GeoUnit unit2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEORADIUSBYMEMBER_RO, key, member, Protocol.toByteArray(radius), unit2.raw);
    }

    public void georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit2, GeoRadiusParam param2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEORADIUSBYMEMBER, param2.getByteParams(key, member, Protocol.toByteArray(radius), unit2.raw));
    }

    public void georadiusByMemberReadonly(byte[] key, byte[] member, double radius, GeoUnit unit2, GeoRadiusParam param2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEORADIUSBYMEMBER_RO, param2.getByteParams(key, member, Protocol.toByteArray(radius), unit2.raw));
    }

    public void moduleLoad(byte[] path2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.MODULE, Protocol.Keyword.LOAD.raw, path2);
    }

    public void moduleList() {
        this.sendCommand((ProtocolCommand)Protocol.Command.MODULE, new byte[][]{Protocol.Keyword.LIST.raw});
    }

    public void moduleUnload(byte[] name) {
        this.sendCommand((ProtocolCommand)Protocol.Command.MODULE, Protocol.Keyword.UNLOAD.raw, name);
    }

    private ArrayList<byte[]> convertScoreMembersToByteArrays(Map<byte[], Double> scoreMembers) {
        ArrayList<byte[]> args2 = new ArrayList<byte[]>(scoreMembers.size() * 2);
        for (Map.Entry<byte[], Double> entry2 : scoreMembers.entrySet()) {
            args2.add(Protocol.toByteArray(entry2.getValue()));
            args2.add(entry2.getKey());
        }
        return args2;
    }

    private List<byte[]> convertGeoCoordinateMapToByteArrays(Map<byte[], GeoCoordinate> memberCoordinateMap) {
        ArrayList<byte[]> args2 = new ArrayList<byte[]>(memberCoordinateMap.size() * 3);
        for (Map.Entry<byte[], GeoCoordinate> entry2 : memberCoordinateMap.entrySet()) {
            GeoCoordinate coordinate = entry2.getValue();
            args2.add(Protocol.toByteArray(coordinate.getLongitude()));
            args2.add(Protocol.toByteArray(coordinate.getLatitude()));
            args2.add(entry2.getKey());
        }
        return args2;
    }

    public void bitfield(byte[] key, byte[] ... value2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.BITFIELD, this.joinParameters(key, value2));
    }

    public void hstrlen(byte[] key, byte[] field2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HSTRLEN, key, field2);
    }

    public void xadd(byte[] key, byte[] id, Map<byte[], byte[]> hash, long maxLen, boolean approximateLength) {
        int maxLexArgs = 0;
        if (maxLen < Long.MAX_VALUE) {
            maxLexArgs = approximateLength ? 3 : 2;
        }
        byte[][] params2 = new byte[2 + maxLexArgs + hash.size() * 2][];
        int index2 = 0;
        params2[index2++] = key;
        if (maxLen < Long.MAX_VALUE) {
            params2[index2++] = Protocol.Keyword.MAXLEN.raw;
            if (approximateLength) {
                params2[index2++] = Protocol.BYTES_TILDE;
            }
            params2[index2++] = Protocol.toByteArray(maxLen);
        }
        params2[index2++] = id;
        for (Map.Entry<byte[], byte[]> entry2 : hash.entrySet()) {
            params2[index2++] = entry2.getKey();
            params2[index2++] = entry2.getValue();
        }
        this.sendCommand((ProtocolCommand)Protocol.Command.XADD, params2);
    }

    public void xlen(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.XLEN, new byte[][]{key});
    }

    public void xrange(byte[] key, byte[] start2, byte[] end, long count2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.XRANGE, key, start2, end, Protocol.Keyword.COUNT.raw, Protocol.toByteArray(count2));
    }

    public void xrevrange(byte[] key, byte[] end, byte[] start2, int count2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.XREVRANGE, key, end, start2, Protocol.Keyword.COUNT.raw, Protocol.toByteArray(count2));
    }

    public void xread(int count2, long block, Map<byte[], byte[]> streams) {
        byte[][] params2 = new byte[3 + streams.size() * 2 + (block > 0L ? 2 : 0)][];
        int streamsIndex = 0;
        params2[streamsIndex++] = Protocol.Keyword.COUNT.raw;
        params2[streamsIndex++] = Protocol.toByteArray(count2);
        if (block > 0L) {
            params2[streamsIndex++] = Protocol.Keyword.BLOCK.raw;
            params2[streamsIndex++] = Protocol.toByteArray(block);
        }
        params2[streamsIndex++] = Protocol.Keyword.STREAMS.raw;
        int idsIndex = streamsIndex + streams.size();
        for (Map.Entry<byte[], byte[]> entry2 : streams.entrySet()) {
            params2[streamsIndex++] = entry2.getKey();
            params2[idsIndex++] = entry2.getValue();
        }
        this.sendCommand((ProtocolCommand)Protocol.Command.XREAD, params2);
    }

    public void xack(byte[] key, byte[] group2, byte[] ... ids) {
        byte[][] params2 = new byte[2 + ids.length][];
        int index2 = 0;
        params2[index2++] = key;
        params2[index2++] = group2;
        for (byte[] id : ids) {
            params2[index2++] = id;
        }
        this.sendCommand((ProtocolCommand)Protocol.Command.XACK, params2);
    }

    public void xgroupCreate(byte[] key, byte[] groupname, byte[] id, boolean makeStream) {
        if (makeStream) {
            this.sendCommand((ProtocolCommand)Protocol.Command.XGROUP, Protocol.Keyword.CREATE.raw, key, groupname, id, Protocol.Keyword.MKSTREAM.raw);
        } else {
            this.sendCommand((ProtocolCommand)Protocol.Command.XGROUP, Protocol.Keyword.CREATE.raw, key, groupname, id);
        }
    }

    public void xgroupSetID(byte[] key, byte[] groupname, byte[] id) {
        this.sendCommand((ProtocolCommand)Protocol.Command.XGROUP, Protocol.Keyword.SETID.raw, key, groupname, id);
    }

    public void xgroupDestroy(byte[] key, byte[] groupname) {
        this.sendCommand((ProtocolCommand)Protocol.Command.XGROUP, Protocol.Keyword.DESTROY.raw, key, groupname);
    }

    public void xgroupDelConsumer(byte[] key, byte[] groupname, byte[] consumerName) {
        this.sendCommand((ProtocolCommand)Protocol.Command.XGROUP, Protocol.Keyword.DELCONSUMER.raw, key, groupname, consumerName);
    }

    public void xdel(byte[] key, byte[] ... ids) {
        byte[][] params2 = new byte[1 + ids.length][];
        int index2 = 0;
        params2[index2++] = key;
        for (byte[] id : ids) {
            params2[index2++] = id;
        }
        this.sendCommand((ProtocolCommand)Protocol.Command.XDEL, params2);
    }

    public void xtrim(byte[] key, long maxLen, boolean approximateLength) {
        if (approximateLength) {
            this.sendCommand((ProtocolCommand)Protocol.Command.XTRIM, key, Protocol.Keyword.MAXLEN.raw, Protocol.BYTES_TILDE, Protocol.toByteArray(maxLen));
        } else {
            this.sendCommand((ProtocolCommand)Protocol.Command.XTRIM, key, Protocol.Keyword.MAXLEN.raw, Protocol.toByteArray(maxLen));
        }
    }

    public void xreadGroup(byte[] groupname, byte[] consumer, int count2, long block, boolean noAck, Map<byte[], byte[]> streams) {
        int optional = 0;
        if (count2 > 0) {
            optional += 2;
        }
        if (block > 0L) {
            optional += 2;
        }
        if (noAck) {
            ++optional;
        }
        byte[][] params2 = new byte[4 + optional + streams.size() * 2][];
        int streamsIndex = 0;
        params2[streamsIndex++] = Protocol.Keyword.GROUP.raw;
        params2[streamsIndex++] = groupname;
        params2[streamsIndex++] = consumer;
        if (count2 > 0) {
            params2[streamsIndex++] = Protocol.Keyword.COUNT.raw;
            params2[streamsIndex++] = Protocol.toByteArray(count2);
        }
        if (block > 0L) {
            params2[streamsIndex++] = Protocol.Keyword.BLOCK.raw;
            params2[streamsIndex++] = Protocol.toByteArray(block);
        }
        if (noAck) {
            params2[streamsIndex++] = Protocol.Keyword.NOACK.raw;
        }
        params2[streamsIndex++] = Protocol.Keyword.STREAMS.raw;
        int idsIndex = streamsIndex + streams.size();
        for (Map.Entry<byte[], byte[]> entry2 : streams.entrySet()) {
            params2[streamsIndex++] = entry2.getKey();
            params2[idsIndex++] = entry2.getValue();
        }
        this.sendCommand((ProtocolCommand)Protocol.Command.XREADGROUP, params2);
    }

    public void xpending(byte[] key, byte[] groupname, byte[] start2, byte[] end, int count2, byte[] consumername) {
        if (consumername == null) {
            this.sendCommand((ProtocolCommand)Protocol.Command.XPENDING, key, groupname, start2, end, Protocol.toByteArray(count2));
        } else {
            this.sendCommand((ProtocolCommand)Protocol.Command.XPENDING, key, groupname, start2, end, Protocol.toByteArray(count2), consumername);
        }
    }

    public void xclaim(byte[] key, byte[] groupname, byte[] consumername, long minIdleTime, long newIdleTime, int retries, boolean force, byte[][] ids) {
        ArrayList<byte[]> arguments = new ArrayList<byte[]>(10 + ids.length);
        arguments.add(key);
        arguments.add(groupname);
        arguments.add(consumername);
        arguments.add(Protocol.toByteArray(minIdleTime));
        for (byte[] id : ids) {
            arguments.add(id);
        }
        if (newIdleTime > 0L) {
            arguments.add(Protocol.Keyword.IDLE.raw);
            arguments.add(Protocol.toByteArray(newIdleTime));
        }
        if (retries > 0) {
            arguments.add(Protocol.Keyword.RETRYCOUNT.raw);
            arguments.add(Protocol.toByteArray(retries));
        }
        if (force) {
            arguments.add(Protocol.Keyword.FORCE.raw);
        }
        this.sendCommand((ProtocolCommand)Protocol.Command.XCLAIM, (byte[][])arguments.toArray((T[])new byte[arguments.size()][]));
    }
}

