/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.redis.stream;

import org.apache.spark.sql.redis.package$;
import org.apache.spark.sql.redis.stream.RedisConsumerConfig;
import org.apache.spark.sql.redis.stream.RedisSourceConfig;
import org.apache.spark.sql.redis.stream.RedisSourceConfig$;
import org.apache.spark.sql.redis.stream.RedisSourceOffset;
import org.apache.spark.sql.redis.stream.RedisSourceOffset$;
import scala.Array$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

public final class RedisSourceConfig$
implements Serializable {
    public static final RedisSourceConfig$ MODULE$;

    static {
        new RedisSourceConfig$();
    }

    public RedisSourceConfig fromMap(Map<String, String> config) {
        String streamKeys = (String)((Object)config.getOrElse(package$.MODULE$.StreamOptionStreamKeys(), new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please specify '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{package$.MODULE$.StreamOptionStreamKeys()})));
            }
        }));
        Option<RedisSourceOffset> start2 = config.get(package$.MODULE$.StreamOptionStreamOffsets()).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final RedisSourceOffset apply(String json) {
                return RedisSourceOffset$.MODULE$.fromJson(json);
            }
        });
        int parallelism = BoxesRunTime.unboxToInt(config.get(package$.MODULE$.StreamOptionParallelism()).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
            }
        }).getOrElse(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 1;
            }
        }));
        String groupName2 = config.getOrElse(package$.MODULE$.StreamOptionGroupName(), new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "spark-source";
            }
        });
        String consumerPrefix = config.getOrElse(package$.MODULE$.StreamOptionConsumerPrefix(), new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "consumer";
            }
        });
        int batchSize = BoxesRunTime.unboxToInt(config.get(package$.MODULE$.StreamOptionReadBatchSize()).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$2) {
                return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
            }
        }).getOrElse(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return package$.MODULE$.StreamOptionReadBatchSizeDefault();
            }
        }));
        int block = BoxesRunTime.unboxToInt(config.get(package$.MODULE$.StreamOptionReadBlock()).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$3) {
                return new StringOps(Predef$.MODULE$.augmentString(x$3)).toInt();
            }
        }).getOrElse(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return package$.MODULE$.StreamOptionReadBlockDefault();
            }
        }));
        RedisConsumerConfig[] consumerConfigs = (RedisConsumerConfig[])Predef$.MODULE$.refArrayOps((Object[])streamKeys.split(",")).flatMap(new Serializable(parallelism, groupName2, consumerPrefix, batchSize, block){
            public static final long serialVersionUID = 0L;
            private final int parallelism$1;
            public final String groupName$1;
            public final String consumerPrefix$1;
            public final int batchSize$1;
            public final int block$1;

            public final IndexedSeq<RedisConsumerConfig> apply(String streamKey) {
                return RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.parallelism$1).map(new Serializable(this, streamKey){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.11 $outer;
                    private final String streamKey$1;

                    public final RedisConsumerConfig apply(int consumerIndex) {
                        return new RedisConsumerConfig(this.streamKey$1, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.groupName$1})), new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.consumerPrefix$1, BoxesRunTime.boxToInteger(consumerIndex)})), this.$outer.batchSize$1, this.$outer.block$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.streamKey$1 = streamKey$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.parallelism$1 = parallelism$1;
                this.groupName$1 = groupName$1;
                this.consumerPrefix$1 = consumerPrefix$1;
                this.batchSize$1 = batchSize$1;
                this.block$1 = block$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RedisConsumerConfig.class)));
        return new RedisSourceConfig(Predef$.MODULE$.wrapRefArray((Object[])consumerConfigs), start2);
    }

    public RedisSourceConfig apply(Seq<RedisConsumerConfig> consumerConfigs, Option<RedisSourceOffset> start2) {
        return new RedisSourceConfig(consumerConfigs, start2);
    }

    public Option<Tuple2<Seq<RedisConsumerConfig>, Option<RedisSourceOffset>>> unapply(RedisSourceConfig x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple2<Seq<RedisConsumerConfig>, Option<RedisSourceOffset>>>(new Tuple2<Seq<RedisConsumerConfig>, Option<RedisSourceOffset>>(x$0.consumerConfigs(), x$0.start()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private RedisSourceConfig$() {
        MODULE$ = this;
    }
}

