/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.pool2.BaseObjectPool;
import org.apache.commons.pool2.PoolUtils;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.LinkedBlockingDeque;
import org.apache.commons.pool2.impl.PooledSoftReference;

public class SoftReferenceObjectPool<T>
extends BaseObjectPool<T> {
    private final PooledObjectFactory<T> factory;
    private final ReferenceQueue<T> refQueue = new ReferenceQueue();
    private int numActive = 0;
    private long destroyCount = 0L;
    private long createCount = 0L;
    private final LinkedBlockingDeque<PooledSoftReference<T>> idleReferences = new LinkedBlockingDeque();
    private final ArrayList<PooledSoftReference<T>> allReferences = new ArrayList();

    public SoftReferenceObjectPool(PooledObjectFactory<T> factory) {
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized T borrowObject() throws Exception {
        this.assertOpen();
        Object obj = null;
        boolean newlyCreated = false;
        PooledSoftReference<Object> ref2 = null;
        while (null == obj) {
            if (this.idleReferences.isEmpty()) {
                if (null == this.factory) {
                    throw new NoSuchElementException();
                }
                newlyCreated = true;
                obj = this.factory.makeObject().getObject();
                ++this.createCount;
                ref2 = new PooledSoftReference<Object>(new SoftReference<Object>(obj));
                this.allReferences.add(ref2);
            } else {
                ref2 = this.idleReferences.pollFirst();
                obj = ref2.getObject();
                ref2.getReference().clear();
                ref2.setReference(new SoftReference<Object>(obj));
            }
            if (null == this.factory || null == obj) continue;
            try {
                this.factory.activateObject(ref2);
                if (this.factory.validateObject(ref2)) continue;
                throw new Exception("ValidateObject failed");
            }
            catch (Throwable t) {
                PoolUtils.checkRethrow(t);
                try {
                    this.destroy(ref2);
                }
                catch (Throwable t2) {
                    PoolUtils.checkRethrow(t2);
                }
                finally {
                    obj = null;
                }
                if (!newlyCreated) continue;
                throw new NoSuchElementException("Could not create a validated object, cause: " + t.getMessage());
            }
        }
        ++this.numActive;
        ref2.allocate();
        return obj;
    }

    @Override
    public synchronized void returnObject(T obj) throws Exception {
        boolean success2 = !this.isClosed();
        PooledSoftReference<T> ref2 = this.findReference(obj);
        if (ref2 == null) {
            throw new IllegalStateException("Returned object not currently part of this pool");
        }
        if (this.factory != null) {
            if (!this.factory.validateObject(ref2)) {
                success2 = false;
            } else {
                try {
                    this.factory.passivateObject(ref2);
                }
                catch (Exception e) {
                    success2 = false;
                }
            }
        }
        boolean shouldDestroy = !success2;
        --this.numActive;
        if (success2) {
            ref2.deallocate();
            this.idleReferences.add(ref2);
        }
        this.notifyAll();
        if (shouldDestroy && this.factory != null) {
            try {
                this.destroy(ref2);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void invalidateObject(T obj) throws Exception {
        PooledSoftReference<T> ref2 = this.findReference(obj);
        if (ref2 == null) {
            throw new IllegalStateException("Object to invalidate is not currently part of this pool");
        }
        if (this.factory != null) {
            this.destroy(ref2);
        }
        --this.numActive;
        this.notifyAll();
    }

    @Override
    public synchronized void addObject() throws Exception {
        boolean shouldDestroy;
        this.assertOpen();
        if (this.factory == null) {
            throw new IllegalStateException("Cannot add objects without a factory.");
        }
        T obj = this.factory.makeObject().getObject();
        ++this.createCount;
        PooledSoftReference<T> ref2 = new PooledSoftReference<T>(new SoftReference<T>(obj, this.refQueue));
        this.allReferences.add(ref2);
        boolean success2 = true;
        if (!this.factory.validateObject(ref2)) {
            success2 = false;
        } else {
            this.factory.passivateObject(ref2);
        }
        boolean bl = shouldDestroy = !success2;
        if (success2) {
            this.idleReferences.add(ref2);
            this.notifyAll();
        }
        if (shouldDestroy) {
            try {
                this.destroy(ref2);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized int getNumIdle() {
        this.pruneClearedReferences();
        return this.idleReferences.size();
    }

    @Override
    public synchronized int getNumActive() {
        return this.numActive;
    }

    @Override
    public synchronized void clear() {
        if (null != this.factory) {
            Iterator<PooledSoftReference<T>> iter2 = this.idleReferences.iterator();
            while (iter2.hasNext()) {
                try {
                    PooledSoftReference<T> ref2 = iter2.next();
                    if (null == ref2.getObject()) continue;
                    this.factory.destroyObject(ref2);
                }
                catch (Exception exception) {}
            }
        }
        this.idleReferences.clear();
        this.pruneClearedReferences();
    }

    @Override
    public void close() {
        super.close();
        this.clear();
    }

    public synchronized PooledObjectFactory<T> getFactory() {
        return this.factory;
    }

    private void pruneClearedReferences() {
        this.removeClearedReferences(this.idleReferences.iterator());
        this.removeClearedReferences(this.allReferences.iterator());
        while (this.refQueue.poll() != null) {
        }
    }

    private PooledSoftReference<T> findReference(T obj) {
        for (PooledSoftReference<T> reference : this.allReferences) {
            if (reference.getObject() == null || !reference.getObject().equals(obj)) continue;
            return reference;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy(PooledSoftReference<T> toDestroy) throws Exception {
        toDestroy.invalidate();
        this.idleReferences.remove(toDestroy);
        this.allReferences.remove(toDestroy);
        try {
            this.factory.destroyObject(toDestroy);
        }
        finally {
            ++this.destroyCount;
            toDestroy.getReference().clear();
        }
    }

    private void removeClearedReferences(Iterator<PooledSoftReference<T>> iterator2) {
        while (iterator2.hasNext()) {
            PooledSoftReference<T> ref2 = iterator2.next();
            if (ref2.getReference() != null && !ref2.getReference().isEnqueued()) continue;
            iterator2.remove();
        }
    }
}

