/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.SliceInput;
import com.facebook.presto.jdbc.internal.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import java.util.Optional;

final class EncoderUtil {
    private EncoderUtil() {
    }

    public static void encodeNullsAsBits(SliceOutput sliceOutput, Block block) {
        boolean mayHaveNull = block.mayHaveNull();
        sliceOutput.writeBoolean(mayHaveNull);
        if (!mayHaveNull) {
            return;
        }
        int positionCount = block.getPositionCount();
        for (int position = 0; position < (positionCount & 0xFFFFFFF8); position += 8) {
            int value = 0;
            value = (byte)(value | (block.isNull(position) ? 128 : 0));
            value = (byte)(value | (block.isNull(position + 1) ? 64 : 0));
            value = (byte)(value | (block.isNull(position + 2) ? 32 : 0));
            value = (byte)(value | (block.isNull(position + 3) ? 16 : 0));
            value = (byte)(value | (block.isNull(position + 4) ? 8 : 0));
            value = (byte)(value | (block.isNull(position + 5) ? 4 : 0));
            value = (byte)(value | (block.isNull(position + 6) ? 2 : 0));
            value = (byte)(value | (block.isNull(position + 7) ? 1 : 0));
            sliceOutput.appendByte(value);
        }
        if ((positionCount & 7) > 0) {
            int value = 0;
            int mask = 128;
            for (int position = positionCount & 0xFFFFFFF8; position < positionCount; ++position) {
                value = (byte)(value | (block.isNull(position) ? mask : 0));
                mask >>>= 1;
            }
            sliceOutput.appendByte(value);
        }
    }

    public static Optional<boolean[]> decodeNullBits(SliceInput sliceInput, int positionCount) {
        if (!sliceInput.readBoolean()) {
            return Optional.empty();
        }
        boolean[] valueIsNull = new boolean[positionCount];
        for (int position = 0; position < (positionCount & 0xFFFFFFF8); position += 8) {
            byte value = sliceInput.readByte();
            valueIsNull[position] = (value & 0x80) != 0;
            valueIsNull[position + 1] = (value & 0x40) != 0;
            valueIsNull[position + 2] = (value & 0x20) != 0;
            valueIsNull[position + 3] = (value & 0x10) != 0;
            valueIsNull[position + 4] = (value & 8) != 0;
            valueIsNull[position + 5] = (value & 4) != 0;
            valueIsNull[position + 6] = (value & 2) != 0;
            valueIsNull[position + 7] = (value & 1) != 0;
        }
        if ((positionCount & 7) > 0) {
            byte value = sliceInput.readByte();
            int mask = 128;
            for (int position = positionCount & 0xFFFFFFF8; position < positionCount; ++position) {
                valueIsNull[position] = (value & mask) != 0;
                mask >>>= 1;
            }
        }
        return Optional.of(valueIsNull);
    }
}

