/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.spi.ConnectorPageSource;
import com.facebook.presto.jdbc.internal.spi.Page;
import com.facebook.presto.jdbc.internal.spi.PageBuilder;
import com.facebook.presto.jdbc.internal.spi.RecordCursor;
import com.facebook.presto.jdbc.internal.spi.RecordSet;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class RecordPageSource
implements ConnectorPageSource {
    private static final int ROWS_PER_REQUEST = 4096;
    private final RecordCursor cursor;
    private final List<Type> types;
    private final PageBuilder pageBuilder;
    private boolean closed;

    public RecordPageSource(RecordSet recordSet) {
        this(Objects.requireNonNull(recordSet, "recordSet is null").getColumnTypes(), recordSet.cursor());
    }

    public RecordPageSource(List<Type> types, RecordCursor cursor) {
        this.cursor = Objects.requireNonNull(cursor, "cursor is null");
        this.types = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(types, "types is null")));
        this.pageBuilder = new PageBuilder(this.types);
    }

    public RecordCursor getCursor() {
        return this.cursor;
    }

    @Override
    public long getCompletedBytes() {
        return this.cursor.getCompletedBytes();
    }

    @Override
    public long getReadTimeNanos() {
        return this.cursor.getReadTimeNanos();
    }

    @Override
    public long getSystemMemoryUsage() {
        return this.cursor.getSystemMemoryUsage() + this.pageBuilder.getSizeInBytes();
    }

    @Override
    public void close() {
        this.closed = true;
        this.cursor.close();
    }

    @Override
    public boolean isFinished() {
        return this.closed && this.pageBuilder.isEmpty();
    }

    @Override
    public Page getNextPage() {
        if (!this.closed) {
            for (int i = 0; i < 4096 && !this.pageBuilder.isFull(); ++i) {
                if (!this.cursor.advanceNextPosition()) {
                    this.closed = true;
                    break;
                }
                this.pageBuilder.declarePosition();
                for (int column = 0; column < this.types.size(); ++column) {
                    BlockBuilder output = this.pageBuilder.getBlockBuilder(column);
                    if (this.cursor.isNull(column)) {
                        output.appendNull();
                        continue;
                    }
                    Type type = this.types.get(column);
                    Class<?> javaType = type.getJavaType();
                    if (javaType == Boolean.TYPE) {
                        type.writeBoolean(output, this.cursor.getBoolean(column));
                        continue;
                    }
                    if (javaType == Long.TYPE) {
                        type.writeLong(output, this.cursor.getLong(column));
                        continue;
                    }
                    if (javaType == Double.TYPE) {
                        type.writeDouble(output, this.cursor.getDouble(column));
                        continue;
                    }
                    if (javaType == Slice.class) {
                        Slice slice = this.cursor.getSlice(column);
                        type.writeSlice(output, slice, 0, slice.length());
                        continue;
                    }
                    type.writeObject(output, this.cursor.getObject(column));
                }
            }
        }
        if (this.pageBuilder.isEmpty() || !this.closed && !this.pageBuilder.isFull()) {
            return null;
        }
        Page page = this.pageBuilder.build();
        this.pageBuilder.reset();
        return page;
    }
}

