/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.spark.connector.ColumnRef;
import com.datastax.spark.connector.SomeColumns;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.Schema$;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.rdd.CassandraRDD;
import com.datastax.spark.connector.rdd.CassandraTableScanRDD;
import com.datastax.spark.connector.rdd.CassandraTableScanRDD$;
import com.datastax.spark.connector.rdd.ReadConf;
import com.datastax.spark.connector.rdd.ValidRDDType$;
import com.datastax.spark.connector.types.ColumnType;
import com.datastax.spark.connector.types.InetType$;
import com.datastax.spark.connector.types.UUIDType$;
import com.datastax.spark.connector.types.VarIntType$;
import com.datastax.spark.connector.util.ConfigParameter;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.util.Logging$class;
import com.datastax.spark.connector.util.Quote$;
import com.datastax.spark.connector.util.ReflectionUtil$;
import com.datastax.spark.connector.writer.SqlRowWriter$Factory$;
import com.datastax.spark.connector.writer.WriteConf;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.UUID;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.cassandra.AnalyzedPredicates;
import org.apache.spark.sql.cassandra.BasicCassandraPredicatePushDown;
import org.apache.spark.sql.cassandra.CassandraPredicateRules;
import org.apache.spark.sql.cassandra.CassandraSQLRow;
import org.apache.spark.sql.cassandra.CassandraSQLRow$;
import org.apache.spark.sql.cassandra.CassandraSQLRow$CassandraSQLRowReader$;
import org.apache.spark.sql.cassandra.CassandraSourceOptions;
import org.apache.spark.sql.cassandra.CassandraSourceRelation$;
import org.apache.spark.sql.cassandra.CassandraSourceRelation$$anonfun$additionalRules$1$;
import org.apache.spark.sql.cassandra.DataTypeConverter$;
import org.apache.spark.sql.cassandra.PredicateOps$FilterOps$;
import org.apache.spark.sql.cassandra.TableRef;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.InsertableRelation;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.PrunedFilteredScan;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeq$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\rUb!B\u0001\u0003\u0001\ta!aF\"bgN\fg\u000e\u001a:b'>,(oY3SK2\fG/[8o\u0015\t\u0019A!A\u0005dCN\u001c\u0018M\u001c3sC*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0014\u000b\u0001i1CF\r\u0011\u00059\tR\"A\b\u000b\u0005A!\u0011aB:pkJ\u001cWm]\u0005\u0003%=\u0011ABQ1tKJ+G.\u0019;j_:\u0004\"A\u0004\u000b\n\u0005Uy!AE%og\u0016\u0014H/\u00192mKJ+G.\u0019;j_:\u0004\"AD\f\n\u0005ay!A\u0005)sk:,GMR5mi\u0016\u0014X\rZ*dC:\u0004\"A\u0007\u0013\u000e\u0003mQ!\u0001H\u000f\u0002\tU$\u0018\u000e\u001c\u0006\u0003=}\t\u0011bY8o]\u0016\u001cGo\u001c:\u000b\u0005\u001d\u0001#BA\u0011#\u0003!!\u0017\r^1ti\u0006D(\"A\u0012\u0002\u0007\r|W.\u0003\u0002&7\t9Aj\\4hS:<\u0007\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\u0002\u0011Q\f'\r\\3SK\u001a\u001c\u0001\u0001\u0005\u0002+W5\t!!\u0003\u0002-\u0005\tAA+\u00192mKJ+g\r\u0003\u0005/\u0001\t\u0005\t\u0015!\u00030\u0003M)8/\u001a:Ta\u0016\u001c\u0017NZ5fIN\u001b\u0007.Z7b!\r\u00014'N\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t1q\n\u001d;j_:\u0004\"AN\u001d\u000e\u0003]R!\u0001\u000f\u0003\u0002\u000bQL\b/Z:\n\u0005i:$AC*ueV\u001cG\u000fV=qK\"AA\b\u0001B\u0001B\u0003%Q(\u0001\bgS2$XM\u001d)vg\"$wn\u001e8\u0011\u0005Ar\u0014BA 2\u0005\u001d\u0011un\u001c7fC:D\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006I!P\u0001\u0010G>tg-\u001b:n)J,hnY1uK\"A1\t\u0001B\u0001B\u0003%A)\u0001\tuC\ndWmU5{K&s')\u001f;fgB\u0019\u0001gM#\u0011\u0005A2\u0015BA$2\u0005\u0011auN\\4\t\u0011y\u0001!\u0011!Q\u0001\n%\u0003\"AS'\u000e\u0003-S!\u0001T\u000f\u0002\u0007\r\fH.\u0003\u0002O\u0017\n\u00112)Y:tC:$'/Y\"p]:,7\r^8s\u0011!\u0001\u0006A!A!\u0002\u0013\t\u0016\u0001\u0003:fC\u0012\u001cuN\u001c4\u0011\u0005I+V\"A*\u000b\u0005Qk\u0012a\u0001:eI&\u0011ak\u0015\u0002\t%\u0016\fGmQ8oM\"A\u0001\f\u0001B\u0001B\u0003%\u0011,A\u0005xe&$XmQ8oMB\u0011!,X\u0007\u00027*\u0011A,H\u0001\u0007oJLG/\u001a:\n\u0005y[&!C,sSR,7i\u001c8g\u0011!\u0001\u0007A!A!\u0002\u0013\t\u0017!C:qCJ\\7i\u001c8g!\t\u00117-D\u0001\u0007\u0013\t!gAA\u0005Ta\u0006\u00148nQ8oM\"Aa\r\u0001BC\u0002\u0013\u0005s-\u0001\u0006tc2\u001cuN\u001c;fqR,\u0012\u0001\u001b\t\u0003S*l\u0011\u0001B\u0005\u0003W\u0012\u0011!bU)M\u0007>tG/\u001a=u\u0011!i\u0007A!A!\u0002\u0013A\u0017aC:rY\u000e{g\u000e^3yi\u0002BQa\u001c\u0001\u0005\u0002A\fa\u0001P5oSRtDcC9sgR,ho\u001e=zun\u0004\"A\u000b\u0001\t\u000b\u001dr\u0007\u0019A\u0015\t\u000b9r\u0007\u0019A\u0018\t\u000bqr\u0007\u0019A\u001f\t\u000b\u0005s\u0007\u0019A\u001f\t\u000b\rs\u0007\u0019\u0001#\t\u000byq\u0007\u0019A%\t\u000bAs\u0007\u0019A)\t\u000bas\u0007\u0019A-\t\u000b\u0001t\u0007\u0019A1\t\u000b\u0019t\u0007\u0019\u00015\t\ru\u0004\u0001\u0015!\u0003\u007f\u0003!!\u0018M\u00197f\t\u00164\u0007C\u0001&\u0000\u0013\r\t\ta\u0013\u0002\t)\u0006\u0014G.\u001a#fM\"9\u0011Q\u0001\u0001\u0005B\u0005\u001d\u0011AB:dQ\u0016l\u0017-F\u00016\u0011\u001d\tY\u0001\u0001C!\u0003\u001b\ta!\u001b8tKJ$HCBA\b\u0003+\ti\u0004E\u00021\u0003#I1!a\u00052\u0005\u0011)f.\u001b;\t\u0011\u0005]\u0011\u0011\u0002a\u0001\u00033\tA\u0001Z1uCB!\u00111DA\u001c\u001d\u0011\ti\"a\r\u000f\t\u0005}\u0011\u0011\u0007\b\u0005\u0003C\tyC\u0004\u0003\u0002$\u00055b\u0002BA\u0013\u0003Wi!!a\n\u000b\u0007\u0005%\u0002&\u0001\u0004=e>|GOP\u0005\u0002\u0017%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0002\u0004\n\u0007\u0005UB!A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\u00121\b\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T1!!\u000e\u0005\u0011\u001d\ty$!\u0003A\u0002u\n\u0011b\u001c<fe^\u0014\u0018\u000e^3\t\u000f\u0005\r\u0003\u0001\"\u0011\u0002F\u0005Y1/\u001b>f\u0013:\u0014\u0015\u0010^3t+\u0005)\u0005\"CA%\u0001\t\u0007I1AA&\u0003I\u0019\u0017m]:b]\u0012\u0014\u0018mQ8o]\u0016\u001cGo\u001c:\u0016\u0003%Cq!a\u0014\u0001A\u0003%\u0011*A\ndCN\u001c\u0018M\u001c3sC\u000e{gN\\3di>\u0014\b\u0005C\u0005\u0002T\u0001\u0011\r\u0011b\u0001\u0002V\u0005A!/Z1eG>tg-F\u0001R\u0011\u001d\tI\u0006\u0001Q\u0001\nE\u000b\u0011B]3bI\u000e|gN\u001a\u0011\t\u0011\u0005u\u0003\u0001)A\u0005\u0003?\nqAY1tKJ#G\rE\u0003S\u0003C\n)'C\u0002\u0002dM\u0013QcQ1tg\u0006tGM]1UC\ndWmU2b]J#E\tE\u0002+\u0003OJ1!!\u001b\u0003\u0005=\u0019\u0015m]:b]\u0012\u0014\u0018mU)M%><\bbBA7\u0001\u0011\u0005\u0011qN\u0001\nEVLG\u000eZ*dC:$\"!!\u001d\u0011\r\u0005M\u0014qOA>\u001b\t\t)H\u0003\u0002U\r%!\u0011\u0011PA;\u0005\r\u0011F\t\u0012\t\u0004S\u0006u\u0014bAA@\t\t\u0019!k\\<\t\u000f\u0005\r\u0005\u0001\"\u0011\u0002\u0006\u0006\u0001RO\u001c5b]\u0012dW\r\u001a$jYR,'o\u001d\u000b\u0005\u0003\u000f\u000b\u0019\nE\u00031\u0003\u0013\u000bi)C\u0002\u0002\fF\u0012Q!\u0011:sCf\u00042ADAH\u0013\r\t\tj\u0004\u0002\u0007\r&dG/\u001a:\t\u0011\u0005U\u0015\u0011\u0011a\u0001\u0003\u000f\u000bqAZ5mi\u0016\u00148\u000f\u0003\u0006\u0002\u001a\u0002A)\u0019!C\u0001\u00037\u000bq\"\u00193eSRLwN\\1m%VdWm]\u000b\u0003\u0003;\u0003b!a(\u0002(\u00065f\u0002BAQ\u0003KsA!!\n\u0002$&\t!'C\u0002\u00026EJA!!+\u0002,\n\u00191+Z9\u000b\u0007\u0005U\u0012\u0007E\u0002+\u0003_K1!!-\u0003\u0005]\u0019\u0015m]:b]\u0012\u0014\u0018\r\u0015:fI&\u001c\u0017\r^3Sk2,7\u000f\u0003\u0006\u00026\u0002A\t\u0011)Q\u0005\u0003;\u000b\u0001#\u00193eSRLwN\\1m%VdWm\u001d\u0011\t\u000f\u0005e\u0006\u0001\"\u0003\u0002<\u0006\t\u0002O]3eS\u000e\fG/\u001a)vg\"$un\u001e8\u0015\t\u0005u\u00161\u0019\t\u0004U\u0005}\u0016bAAa\u0005\t\u0011\u0012I\\1msj,G\r\u0015:fI&\u001c\u0017\r^3t\u0011!\t)*a.A\u0002\u0005\u001d\u0005bBA7\u0001\u0011\u0005\u0013q\u0019\u000b\u0007\u0003c\nI-!8\t\u0011\u0005-\u0017Q\u0019a\u0001\u0003\u001b\fqB]3rk&\u0014X\rZ\"pYVlgn\u001d\t\u0006a\u0005%\u0015q\u001a\t\u0005\u0003#\f9ND\u00021\u0003'L1!!62\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011\\An\u0005\u0019\u0019FO]5oO*\u0019\u0011Q[\u0019\t\u0011\u0005U\u0015Q\u0019a\u0001\u0003\u000f+a!!9\u0001\t\u0005\r(a\u0002*E\tRK\b/\u001a\t\u0006%\u0006\u0015\u0018QM\u0005\u0004\u0003O\u001c&\u0001D\"bgN\fg\u000e\u001a:b%\u0012#\u0005bBAv\u0001\u0011%\u0011Q^\u0001\f[\u0006L(-Z*fY\u0016\u001cG\u000f\u0006\u0004\u0002r\u0005=\u0018Q\u001f\u0005\b)\u0006%\b\u0019AAy!\u0011\t\u00190a8\u000e\u0003\u0001A\u0001\"a3\u0002j\u0002\u0007\u0011Q\u001a\u0005\b\u0003s\u0004A\u0011BA~\u0003Qi\u0017-\u001f2f!V\u001c\b\u000eZ8x]\u001aKG\u000e^3sgR1\u0011\u0011_A\u007f\u0003\u007fDq\u0001VA|\u0001\u0004\t\t\u0010\u0003\u0005\u0002\u0016\u0006]\b\u0019\u0001B\u0001!\u0019\ty*a*\u0002\u000e\"9!Q\u0001\u0001\u0005\n\t\u001d\u0011a\u00054jYR,'\u000fV8Dc2\fe\u000e\u001a,bYV,G\u0003\u0002B\u0005\u0005/\u0001r\u0001\rB\u0006\u0003\u001f\u0014y!C\u0002\u0003\u000eE\u0012a\u0001V;qY\u0016\u0014\u0004CBAP\u0003O\u0013\t\u0002E\u00021\u0005'I1A!\u00062\u0005\r\te.\u001f\u0005\t\u00053\u0011\u0019\u00011\u0001\u0003\u0012\u00051a-\u001b7uKJDqA!\b\u0001\t\u0013\u0011y\"A\u0006u_\u000e\u000bHNV1mk\u0016\u001cHC\u0002B\b\u0005C\u0011)\u0003\u0003\u0005\u0003$\tm\u0001\u0019AAh\u0003)\u0019w\u000e\\;n]:\u000bW.\u001a\u0005\t\u0005O\u0011Y\u00021\u0001\u0003*\u00051a/\u00197vKN\u0004R\u0001MAE\u0005#AqA!\f\u0001\t\u0013\u0011y#\u0001\u0006u_\u000e\u000bHNV1mk\u0016$bA!\u0005\u00032\tM\u0002\u0002\u0003B\u0012\u0005W\u0001\r!a4\t\u0011\tU\"1\u0006a\u0001\u0005#\tQA^1mk\u0016DqA!\u000f\u0001\t\u0013\u0011Y$A\u0006xQ\u0016\u0014Xm\u00117bkN,G\u0003\u0002B\u0005\u0005{A\u0001Ba\u0010\u00038\u0001\u0007!qB\u0001\u0010aV\u001c\b\u000eZ8x]\u001aKG\u000e^3sg\u001e9!1\t\u0002\t\u0002\t\u0015\u0013aF\"bgN\fg\u000e\u001a:b'>,(oY3SK2\fG/[8o!\rQ#q\t\u0004\u0007\u0003\tA\tA!\u0013\u0014\t\t\u001d#1\n\t\u0004a\t5\u0013b\u0001B(c\t1\u0011I\\=SK\u001aDqa\u001cB$\t\u0003\u0011\u0019\u0006\u0006\u0002\u0003F!Q!q\u000bB$\u0005\u0004%\tA!\u0017\u0002!I+g-\u001a:f]\u000e,7+Z2uS>tWC\u0001B.!\u0011\u0011iFa\u001a\u000e\u0005\t}#\u0002\u0002B1\u0005G\nA\u0001\\1oO*\u0011!QM\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002Z\n}\u0003\"\u0003B6\u0005\u000f\u0002\u000b\u0011\u0002B.\u0003E\u0011VMZ3sK:\u001cWmU3di&|g\u000e\t\u0005\u000b\u0005_\u00129E1A\u0005\u0002\tE\u0014!\u0006+bE2,7+\u001b>f\u0013:\u0014\u0015\u0010^3t!\u0006\u0014\u0018-\\\u000b\u0003\u0005g\u0002BA\u0007B;\t&\u0019!qO\u000e\u0003\u001f\r{gNZ5h!\u0006\u0014\u0018-\\3uKJD\u0011Ba\u001f\u0003H\u0001\u0006IAa\u001d\u0002-Q\u000b'\r\\3TSj,\u0017J\u001c\"zi\u0016\u001c\b+\u0019:b[\u0002B!Ba \u0003H\t\u0007I\u0011\u0001BA\u0003\u0015\nE\rZ5uS>t\u0017\r\\\"bgN\fg\u000e\u001a:b!V\u001c\b\u000eR8x]J+H.Z:QCJ\fW.\u0006\u0002\u0003\u0004B)!D!\u001e\u0003\u0006B1\u0011q\u0014BD\u0003[KAA!#\u0002,\n!A*[:u\u0011%\u0011iIa\u0012!\u0002\u0013\u0011\u0019)\u0001\u0014BI\u0012LG/[8oC2\u001c\u0015m]:b]\u0012\u0014\u0018\rU;tQ\u0012{wO\u001c*vY\u0016\u001c\b+\u0019:b[\u0002B!B!%\u0003H\t\u0007I\u0011\u0001BJ\u0003)\u0001&o\u001c9feRLWm]\u000b\u0003\u0005+\u0003bAa&\u0003\u001e\n}UB\u0001BM\u0015\r\u0011Y*M\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAU\u00053\u0003DA!)\u0003(B)!D!\u001e\u0003$B!!Q\u0015BT\u0019\u0001!1B!+\u0001\u0003\u0003\u0005\tQ!\u0001\u0003,\n!q\fN\u001a9#\u0011\u0011iK!0\u0013\u000b\t=FIa-\u0007\r\tE\u0006\u0001\u0001BW\u00051a$/\u001a4j]\u0016lWM\u001c;?!\u0019\u0011)La/\u0002.6\u0011!q\u0017\u0006\u0005\u0005s\u0013I*A\u0005j[6,H/\u00192mK&!!\u0011\u0012B\\%!\u0011yL!1\u0003H\n5gA\u0002BY\u0001\u0001\u0011i\fE\u00021\u0005\u0007L1A!22\u0005\u001d\u0001&o\u001c3vGR\u0004BA!\u0018\u0003J&!!1\u001aB0\u0005\u0019y%M[3diB!!q\u001aBk\u001b\t\u0011\tN\u0003\u0003\u0003T\n\r\u0014AA5p\u0013\u0011\u00119N!5\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0013\tm'q\tQ\u0001\n\tU\u0015a\u0003)s_B,'\u000f^5fg\u0002B!Ba8\u0003H\t\u0007I\u0011\u0001B-\u0003I!WMZ1vYR\u001cE.^:uKJt\u0015-\\3\t\u0013\t\r(q\tQ\u0001\n\tm\u0013a\u00053fM\u0006,H\u000e^\"mkN$XM\u001d(b[\u0016\u0004\u0003\u0002\u0003Bt\u0005\u000f\"\tA!;\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013E\u0014YO!<\u0003p\ne\bBB\u0014\u0003f\u0002\u0007\u0011\u0006\u0003\u0004g\u0005K\u0004\r\u0001\u001b\u0005\u000b\u0005c\u0014)\u000f%AA\u0002\tM\u0018aB8qi&|gn\u001d\t\u0004U\tU\u0018b\u0001B|\u0005\t12)Y:tC:$'/Y*pkJ\u001cWm\u00149uS>t7\u000fC\u0005\u0002\u0006\t\u0015\b\u0013!a\u0001_!A!Q B$\t\u0003\u0011y0\u0001\td_:\u001cx\u000e\\5eCR,7i\u001c8ggRI\u0011m!\u0001\u0004\u0004\r51q\u0002\u0005\u0007A\nm\b\u0019A1\t\u0011\r\u0015!1 a\u0001\u0007\u000f\tqa]9m\u0007>tg\r\u0005\u0005\u0002R\u000e%\u0011qZAh\u0013\u0011\u0019Y!a7\u0003\u00075\u000b\u0007\u000f\u0003\u0004(\u0005w\u0004\r!\u000b\u0005\t\u0007#\u0011Y\u00101\u0001\u0004\b\u0005IA/\u00192mK\u000e{gN\u001a\u0005\u000b\u0007+\u00119%%A\u0005\u0002\r]\u0011aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\re!\u0006\u0002Bz\u00077Y#a!\b\u0011\t\r}1\u0011F\u0007\u0003\u0007CQAaa\t\u0004&\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007O\t\u0014AC1o]>$\u0018\r^5p]&!11FB\u0011\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0007_\u00119%%A\u0005\u0002\rE\u0012aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\rM\"fA\u0018\u0004\u001c\u0001")
public class CassandraSourceRelation
extends BaseRelation
implements InsertableRelation,
PrunedFilteredScan,
Logging {
    private final TableRef tableRef;
    private final Option<StructType> userSpecifiedSchema;
    private final boolean filterPushdown;
    private final boolean confirmTruncate;
    private final Option<Object> tableSizeInBytes;
    private final CassandraConnector connector;
    private final WriteConf writeConf;
    public final SparkConf org$apache$spark$sql$cassandra$CassandraSourceRelation$$sparkConf;
    private final SQLContext sqlContext;
    public final TableDef org$apache$spark$sql$cassandra$CassandraSourceRelation$$tableDef;
    private final CassandraConnector cassandraConnector;
    private final ReadConf readconf;
    private final CassandraTableScanRDD<CassandraSQLRow> baseRdd;
    private Seq<CassandraPredicateRules> additionalRules;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;
    private volatile boolean bitmap$0;

    public static Option<StructType> apply$default$4() {
        return CassandraSourceRelation$.MODULE$.apply$default$4();
    }

    public static CassandraSourceOptions apply$default$3() {
        return CassandraSourceRelation$.MODULE$.apply$default$3();
    }

    public static SparkConf consolidateConfs(SparkConf sparkConf, Map<String, String> map, TableRef tableRef, Map<String, String> map2) {
        return CassandraSourceRelation$.MODULE$.consolidateConfs(sparkConf, map, tableRef, map2);
    }

    public static CassandraSourceRelation apply(TableRef tableRef, SQLContext sQLContext, CassandraSourceOptions cassandraSourceOptions, Option<StructType> option) {
        return CassandraSourceRelation$.MODULE$.apply(tableRef, sQLContext, cassandraSourceOptions, option);
    }

    public static String defaultClusterName() {
        return CassandraSourceRelation$.MODULE$.defaultClusterName();
    }

    public static Seq<ConfigParameter<? extends Product>> Properties() {
        return CassandraSourceRelation$.MODULE$.Properties();
    }

    public static ConfigParameter<List<CassandraPredicateRules>> AdditionalCassandraPushDownRulesParam() {
        return CassandraSourceRelation$.MODULE$.AdditionalCassandraPushDownRulesParam();
    }

    public static ConfigParameter<Option<Object>> TableSizeInBytesParam() {
        return CassandraSourceRelation$.MODULE$.TableSizeInBytesParam();
    }

    public static String ReferenceSection() {
        return CassandraSourceRelation$.MODULE$.ReferenceSection();
    }

    private Seq additionalRules$lzycompute() {
        CassandraSourceRelation cassandraSourceRelation = this;
        synchronized (cassandraSourceRelation) {
            Option option;
            block7: {
                if (!this.bitmap$0) {
                    Seq seq;
                    SparkContext sc = this.sqlContext().sparkContext();
                    Option userClasses = sc.getConf().getOption(CassandraSourceRelation$.MODULE$.AdditionalCassandraPushDownRulesParam().name()).orElse((Function0)new scala.Serializable(this, sc){
                        public static final long serialVersionUID = 0L;
                        private final SparkContext sc$1;

                        public final Option<String> apply() {
                            return Option$.MODULE$.apply((Object)this.sc$1.getLocalProperty(CassandraSourceRelation$.MODULE$.AdditionalCassandraPushDownRulesParam().name()));
                        }
                        {
                            this.sc$1 = sc$1;
                        }
                    });
                    option = userClasses;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String classes = (String)some.x();
                        seq = Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])classes.trim().split("\\s*,\\s*")).map((Function1)new scala.Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final CassandraPredicateRules apply(String objectName) {
                                JavaUniverse $u = package$.MODULE$.universe();
                                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CassandraSourceRelation.class.getClassLoader());
                                public final class Org_apache_spark_sql_cassandra_CassandraSourceRelation$$anonfun$additionalRules$1$$typecreator1$1
                                extends TypeCreator {
                                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                                        Universe $u = $m$untyped.universe();
                                        Mirror<U> $m = $m$untyped;
                                        return $m.staticClass("org.apache.spark.sql.cassandra.CassandraPredicateRules").asType().toTypeConstructor();
                                    }

                                    public Org_apache_spark_sql_cassandra_CassandraSourceRelation$$anonfun$additionalRules$1$$typecreator1$1($anonfun$additionalRules$1 $outer) {
                                    }
                                }
                                return (CassandraPredicateRules)ReflectionUtil$.MODULE$.findGlobalObject(objectName, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_cassandra_CassandraSourceRelation$$anonfun$additionalRules$1$$typecreator1$1(this)));
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(CassandraPredicateRules.class)))).reverse());
                    } else {
                        if (!None$.MODULE$.equals(option)) break block7;
                        seq = (Seq)CassandraSourceRelation$.MODULE$.AdditionalCassandraPushDownRulesParam().default();
                    }
                    this.additionalRules = seq;
                    this.bitmap$0 = true;
                }
                return this.additionalRules;
            }
            throw new MatchError((Object)option);
        }
    }

    @Override
    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    @Override
    @TraitSetter
    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public StructType schema() {
        return (StructType)this.userSpecifiedSchema.getOrElse((Function0)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraSourceRelation $outer;

            public final StructType apply() {
                return StructType$.MODULE$.apply((Seq)this.$outer.org$apache$spark$sql$cassandra$CassandraSourceRelation$$tableDef.columns().map((Function1)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final StructField apply(ColumnDef column) {
                        return DataTypeConverter$.MODULE$.toStructField(column);
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void insert(Dataset<Row> data, boolean overwrite) {
        Object object;
        if (overwrite) {
            if (!this.confirmTruncate) throw new UnsupportedOperationException(new StringOps(Predef$.MODULE$.augmentString("You are attempting to use overwrite mode which will truncate\n          |this table prior to inserting data. If you would merely like\n          |to change data already in the table use the \"Append\" mode.\n          |To actually truncate please pass in true value to the option\n          |\"confirm.truncate\" when saving. ")).stripMargin());
            String keyspace = Quote$.MODULE$.quote(this.tableRef.keyspace());
            String table = Quote$.MODULE$.quote(this.tableRef.table());
            object = this.connector.withSessionDo(new scala.Serializable(this, keyspace, table){
                public static final long serialVersionUID = 0L;
                private final String keyspace$1;
                private final String table$1;

                public final ResultSet apply(Session session) {
                    return session.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TRUNCATE ", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.keyspace$1, this.table$1})));
                }
                {
                    this.keyspace$1 = keyspace$1;
                    this.table$1 = table$1;
                }
            });
        } else {
            object = BoxedUnit.UNIT;
        }
        SqlRowWriter$Factory$ rwf = SqlRowWriter$Factory$.MODULE$;
        SomeColumns columns = new SomeColumns((Seq<ColumnRef>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])data.columns()).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ColumnRef apply(String x) {
                return com.datastax.spark.connector.package$.MODULE$.toNamedColumnRef(x);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ColumnRef.class)))));
        com.datastax.spark.connector.package$.MODULE$.toRDDFunctions(data.rdd()).saveToCassandra(this.tableRef.keyspace(), this.tableRef.table(), columns, this.writeConf, this.cassandraConnector(), rwf);
    }

    public long sizeInBytes() {
        return BoxesRunTime.unboxToLong((Object)this.tableSizeInBytes.getOrElse((Function0)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraSourceRelation $outer;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.$outer.sqlContext().conf().defaultSizeInBytes();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
    }

    public CassandraConnector cassandraConnector() {
        return this.cassandraConnector;
    }

    public ReadConf readconf() {
        return this.readconf;
    }

    public RDD<Row> buildScan() {
        return this.baseRdd;
    }

    public Filter[] unhandledFilters(Filter[] filters) {
        boolean bl;
        block4: {
            Filter[] filterArray;
            block3: {
                block2: {
                    bl = this.filterPushdown;
                    if (!bl) break block2;
                    filterArray = (Filter[])this.predicatePushDown(filters).handledBySpark().toArray(ClassTag$.MODULE$.apply(Filter.class));
                    break block3;
                }
                if (bl) break block4;
                filterArray = filters;
            }
            return filterArray;
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    public Seq<CassandraPredicateRules> additionalRules() {
        return this.bitmap$0 ? this.additionalRules : this.additionalRules$lzycompute();
    }

    private AnalyzedPredicates predicatePushDown(Filter[] filters) {
        this.logInfo((Function0<String>)new scala.Serializable(this, filters){
            public static final long serialVersionUID = 0L;
            private final Filter[] filters$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input Predicates: [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.filters$1).mkString(", ")}));
            }
            {
                this.filters$1 = filters$1;
            }
        });
        ProtocolVersion pv = (ProtocolVersion)((Object)this.connector.withClusterDo(new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ProtocolVersion apply(Cluster x$1) {
                return x$1.getConfiguration().getProtocolOptions().getProtocolVersion();
            }
        }));
        BasicCassandraPredicatePushDown<Filter> bcpp = new BasicCassandraPredicatePushDown<Filter>(Predef$.MODULE$.refArrayOps((Object[])filters).toSet(), this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$tableDef, pv, PredicateOps$FilterOps$.MODULE$);
        AnalyzedPredicates basicPushdown = new AnalyzedPredicates(bcpp.predicatesToPushDown(), bcpp.predicatesToPreserve());
        this.logDebug((Function0<String>)new scala.Serializable(this, basicPushdown){
            public static final long serialVersionUID = 0L;
            private final AnalyzedPredicates basicPushdown$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Basic Rules Applied:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.basicPushdown$1}));
            }
            {
                this.basicPushdown$1 = basicPushdown$1;
            }
        });
        AnalyzedPredicates finalPushdown = (AnalyzedPredicates)this.additionalRules().foldRight((Object)basicPushdown, (Function2)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraSourceRelation $outer;

            /*
             * WARNING - void declaration
             */
            public final AnalyzedPredicates apply(CassandraPredicateRules rules, AnalyzedPredicates pushdowns) {
                void var3_3;
                AnalyzedPredicates pd = rules.apply(pushdowns, this.$outer.org$apache$spark$sql$cassandra$CassandraSourceRelation$$tableDef, this.$outer.org$apache$spark$sql$cassandra$CassandraSourceRelation$$sparkConf);
                this.$outer.logDebug((Function0<String>)new scala.Serializable(this, pd, rules){
                    public static final long serialVersionUID = 0L;
                    private final AnalyzedPredicates pd$1;
                    private final CassandraPredicateRules rules$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Applied ", " Pushdown Filters:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.rules$1.getClass().getSimpleName(), this.pd$1}));
                    }
                    {
                        this.pd$1 = pd$1;
                        this.rules$1 = rules$1;
                    }
                });
                return var3_3;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.logDebug((Function0<String>)new scala.Serializable(this, finalPushdown){
            public static final long serialVersionUID = 0L;
            private final AnalyzedPredicates finalPushdown$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Final Pushdown filters:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.finalPushdown$1}));
            }
            {
                this.finalPushdown$1 = finalPushdown$1;
            }
        });
        return finalPushdown;
    }

    public RDD<Row> buildScan(String[] requiredColumns2, Filter[] filters) {
        CassandraRDD cassandraRDD;
        if (this.filterPushdown) {
            Filter[] pushdownFilters = (Filter[])this.predicatePushDown(filters).handledByCassandra().toArray(ClassTag$.MODULE$.apply(Filter.class));
            cassandraRDD = this.maybePushdownFilters(this.baseRdd, (Seq<Filter>)Predef$.MODULE$.wrapRefArray((Object[])pushdownFilters));
        } else {
            cassandraRDD = this.baseRdd;
        }
        CassandraTableScanRDD<CassandraSQLRow> filteredRdd = cassandraRDD;
        return this.maybeSelect(filteredRdd, requiredColumns2);
    }

    private RDD<Row> maybeSelect(CassandraRDD<CassandraSQLRow> rdd, String[] requiredColumns2) {
        CassandraRDD cassandraRDD;
        if (Predef$.MODULE$.refArrayOps((Object[])requiredColumns2).nonEmpty()) {
            cassandraRDD = rdd.select((Seq<ColumnRef>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])requiredColumns2).map((Function1)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ColumnRef apply(String column) {
                    return com.datastax.spark.connector.package$.MODULE$.toNamedColumnRef(column);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ColumnRef.class)))));
        } else {
            CassandraRDD cassandraRDD2;
            CassandraRDD cassandraRDD3 = rdd;
            if (cassandraRDD3 instanceof CassandraTableScanRDD) {
                CassandraTableScanRDD cassandraTableScanRDD = (CassandraTableScanRDD)cassandraRDD3;
                CassandraTableScanRDD<Object> qual$1 = CassandraTableScanRDD$.MODULE$.countRDD(cassandraTableScanRDD);
                scala.Serializable x$8 = new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterator<CassandraSQLRow> apply(Iterator<Object> x$2) {
                        return x$2.flatMap((Function1)new scala.Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Iterator<CassandraSQLRow> apply(long count) {
                                return scala.package$.MODULE$.Iterator().fill((int)count, (Function0)new scala.Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final CassandraSQLRow apply() {
                                        return CassandraSQLRow$.MODULE$.empty();
                                    }
                                });
                            }
                        });
                    }
                };
                boolean x$9 = qual$1.mapPartitions$default$2();
                cassandraRDD2 = qual$1.mapPartitions((Function1)x$8, x$9, ClassTag$.MODULE$.apply(CassandraSQLRow.class));
            } else {
                cassandraRDD2 = rdd;
            }
            cassandraRDD = cassandraRDD2;
        }
        CassandraRDD prunedRdd = cassandraRDD;
        return prunedRdd;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CassandraRDD<CassandraSQLRow> maybePushdownFilters(CassandraRDD<CassandraSQLRow> rdd, Seq<Filter> filters) {
        Tuple2<String, Seq<Object>> tuple2 = this.whereClause(filters);
        if (tuple2 == null) return rdd;
        String cql2 = (String)tuple2._1();
        Seq values = (Seq)tuple2._2();
        if (!values.nonEmpty()) return rdd;
        return rdd.where(cql2, (Seq<Object>)values);
    }

    public Tuple2<String, Seq<Object>> org$apache$spark$sql$cassandra$CassandraSourceRelation$$filterToCqlAndValue(Object filter) {
        block8: {
            Tuple2 tuple2;
            block3: {
                Object object;
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    object = filter;
                                    if (!(object instanceof EqualTo)) break block2;
                                    EqualTo equalTo = (EqualTo)object;
                                    String attribute = equalTo.attribute();
                                    Object value2 = equalTo.value();
                                    tuple2 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Quote$.MODULE$.quote(attribute)})), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$toCqlValue(attribute, value2)})));
                                    break block3;
                                }
                                if (!(object instanceof LessThan)) break block4;
                                LessThan lessThan = (LessThan)object;
                                String attribute = lessThan.attribute();
                                Object value3 = lessThan.value();
                                tuple2 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " < ?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Quote$.MODULE$.quote(attribute)})), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$toCqlValue(attribute, value3)})));
                                break block3;
                            }
                            if (!(object instanceof LessThanOrEqual)) break block5;
                            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)object;
                            String attribute = lessThanOrEqual.attribute();
                            Object value4 = lessThanOrEqual.value();
                            tuple2 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " <= ?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Quote$.MODULE$.quote(attribute)})), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$toCqlValue(attribute, value4)})));
                            break block3;
                        }
                        if (!(object instanceof GreaterThan)) break block6;
                        GreaterThan greaterThan = (GreaterThan)object;
                        String attribute = greaterThan.attribute();
                        Object value5 = greaterThan.value();
                        tuple2 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " > ?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Quote$.MODULE$.quote(attribute)})), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$toCqlValue(attribute, value5)})));
                        break block3;
                    }
                    if (!(object instanceof GreaterThanOrEqual)) break block7;
                    GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)object;
                    String attribute = greaterThanOrEqual.attribute();
                    Object value6 = greaterThanOrEqual.value();
                    tuple2 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " >= ?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Quote$.MODULE$.quote(attribute)})), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$toCqlValue(attribute, value6)})));
                    break block3;
                }
                if (!(object instanceof In)) break block8;
                In in = (In)object;
                String attribute = in.attribute();
                Object[] values = in.values();
                tuple2 = new Tuple2((Object)new StringBuilder().append((Object)Quote$.MODULE$.quote(attribute)).append((Object)" IN ").append((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps((Object)values).map((Function1)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Object x$3) {
                        return "?";
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("(", ", ", ")")).toString(), this.toCqlValues(attribute, values));
            }
            return tuple2;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"It's not a valid filter ", " to be pushed down, only >, <, >=, <= and In are allowed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filter})));
    }

    private Seq<Object> toCqlValues(String columnName2, Object[] values) {
        return Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps((Object)values).map((Function1)new scala.Serializable(this, columnName2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraSourceRelation $outer;
            private final String columnName$1;

            public final Object apply(Object x$4) {
                return this.$outer.org$apache$spark$sql$cassandra$CassandraSourceRelation$$toCqlValue(this.columnName$1, x$4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.columnName$1 = columnName$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).toSeq();
    }

    public Object org$apache$spark$sql$cassandra$CassandraSourceRelation$$toCqlValue(String columnName2, Object value2) {
        Object object;
        Object object2 = value2;
        if (object2 instanceof Decimal) {
            Decimal decimal = (Decimal)object2;
            ColumnType<?> columnType = ((ColumnDef)this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$tableDef.columnByName().apply((Object)columnName2)).columnType();
            VarIntType$ varIntType$ = VarIntType$.MODULE$;
            boolean isVarIntColumn = !(columnType != null ? !columnType.equals(varIntType$) : varIntType$ != null);
            object = isVarIntColumn ? decimal.toJavaBigDecimal().toBigInteger() : decimal;
        } else if (object2 instanceof UTF8String) {
            Serializable serializable;
            ColumnType<?> columnType;
            UTF8String uTF8String = (UTF8String)object2;
            ColumnType<?> columnType2 = columnType = ((ColumnDef)this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$tableDef.columnByName().apply((Object)columnName2)).columnType();
            InetType$ inetType$ = InetType$.MODULE$;
            if (!(columnType2 != null ? !columnType2.equals(inetType$) : inetType$ != null)) {
                serializable = InetAddress.getByName(uTF8String.toString());
            } else {
                ColumnType<?> columnType3 = columnType;
                UUIDType$ uUIDType$ = UUIDType$.MODULE$;
                serializable = !(columnType3 != null ? !columnType3.equals(uUIDType$) : uUIDType$ != null) ? UUID.fromString(uTF8String.toString()) : uTF8String;
            }
            object = serializable;
        } else {
            object = object2;
        }
        return object;
    }

    private Tuple2<String, Seq<Object>> whereClause(Seq<Object> pushdownFilters) {
        Seq cqlValue = (Seq)pushdownFilters.map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraSourceRelation $outer;

            public final Tuple2<String, Seq<Object>> apply(Object filter) {
                return this.$outer.org$apache$spark$sql$cassandra$CassandraSourceRelation$$filterToCqlAndValue(filter);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        String cql2 = ((TraversableOnce)cqlValue.map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Seq<Object>> x$5) {
                return (String)x$5._1();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(" AND ");
        Seq args = (Seq)cqlValue.flatMap((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Tuple2<String, Seq<Object>> x$6) {
                return (Seq)x$6._2();
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new Tuple2((Object)cql2, (Object)args);
    }

    public CassandraSourceRelation(TableRef tableRef, Option<StructType> userSpecifiedSchema, boolean filterPushdown, boolean confirmTruncate, Option<Object> tableSizeInBytes, CassandraConnector connector, ReadConf readConf, WriteConf writeConf, SparkConf sparkConf, SQLContext sqlContext) {
        this.tableRef = tableRef;
        this.userSpecifiedSchema = userSpecifiedSchema;
        this.filterPushdown = filterPushdown;
        this.confirmTruncate = confirmTruncate;
        this.tableSizeInBytes = tableSizeInBytes;
        this.connector = connector;
        this.writeConf = writeConf;
        this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$sparkConf = sparkConf;
        this.sqlContext = sqlContext;
        Logging$class.$init$(this);
        this.org$apache$spark$sql$cassandra$CassandraSourceRelation$$tableDef = Schema$.MODULE$.tableFromCassandra(connector, tableRef.keyspace(), tableRef.table());
        this.cassandraConnector = connector;
        this.readconf = readConf;
        this.baseRdd = com.datastax.spark.connector.package$.MODULE$.toSparkContextFunctions(sqlContext.sparkContext()).cassandraTable(tableRef.keyspace(), tableRef.table(), this.cassandraConnector(), this.readconf(), ClassTag$.MODULE$.apply(CassandraSQLRow.class), CassandraSQLRow$CassandraSQLRowReader$.MODULE$, ValidRDDType$.MODULE$.javaSerializableAsValidRDDType());
    }
}

